/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.GroupDefnUtil;

public class QueryDefnUtil {
    static void saveBaseQueryDefn(OutputStream outputStream, IBaseQueryDefinition queryDefn) throws DataException {
        try {
            QueryDefnUtil.saveExpressions(outputStream, queryDefn.getResultSetExpressions());
            FilterDefnUtil.saveFilterDefn(outputStream, queryDefn.getFilters());
            GroupDefnUtil.saveGroupDefn(outputStream, queryDefn.getGroups());
            QueryDefnUtil.saveSorts(outputStream, queryDefn.getSorts());
            IOUtil.writeInt((OutputStream)outputStream, (int)queryDefn.getMaxRows());
            IOUtil.writeBool((OutputStream)outputStream, (boolean)queryDefn.usesDetails());
            QueryDefnUtil.saveSubQuery(outputStream, queryDefn.getSubqueries());
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    private static void saveExpressions(OutputStream outputStream, Map exprMap) throws IOException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        if (exprMap == null) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else {
            IOUtil.writeInt((OutputStream)dos, (int)exprMap.size());
            Iterator it = exprMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                IOUtil.writeString((DataOutputStream)dos, (String)((String)entry.getKey()));
                ExprUtil.saveBaseExpr(dos, (IBaseExpression)entry.getValue());
            }
        }
        dos.flush();
    }

    public static void saveSorts(OutputStream outputStream, List sorts) throws IOException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        if (sorts == null) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else {
            IOUtil.writeInt((OutputStream)dos, (int)sorts.size());
            Iterator it = sorts.iterator();
            while (it.hasNext()) {
                ISortDefinition sortDefn = (ISortDefinition)it.next();
                IOUtil.writeString((DataOutputStream)dos, (String)sortDefn.getColumn());
                ExprUtil.saveBaseExpr(dos, sortDefn.getExpression());
                IOUtil.writeInt((OutputStream)dos, (int)sortDefn.getSortDirection());
            }
        }
        dos.flush();
    }

    static void saveSubQuery(OutputStream outputStream, Collection subQuery) throws DataException, IOException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        if (subQuery == null) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else {
            IOUtil.writeInt((OutputStream)dos, (int)subQuery.size());
            Iterator it = subQuery.iterator();
            while (it.hasNext()) {
                ISubqueryDefinition subQueryDefn = (ISubqueryDefinition)it.next();
                IOUtil.writeString((DataOutputStream)dos, (String)subQueryDefn.getName());
                IOUtil.writeBool((OutputStream)outputStream, (boolean)subQueryDefn.applyOnGroup());
                QueryDefnUtil.saveBaseQueryDefn(outputStream, subQueryDefn);
            }
        }
        dos.flush();
    }

    static IQueryDefinition loadQueryDefn(InputStream inputStream) throws DataException {
        QueryDefinition queryDefn = new QueryDefinition();
        QueryDefnUtil.loadBaseQueryDefn(inputStream, queryDefn);
        return queryDefn;
    }

    private static void loadBaseQueryDefn(InputStream inputStream, BaseQueryDefinition queryDefn) throws DataException {
        try {
            queryDefn.getResultSetExpressions().putAll(QueryDefnUtil.loadExprMap(inputStream));
            queryDefn.getFilters().addAll(FilterDefnUtil.loadFilterDefn(inputStream));
            queryDefn.getGroups().addAll(GroupDefnUtil.loadGroupDefn(inputStream));
            queryDefn.getSorts().addAll(QueryDefnUtil.loadSorts(inputStream));
            queryDefn.setMaxRows(IOUtil.readInt((InputStream)inputStream));
            queryDefn.setUsesDetails(IOUtil.readBool((InputStream)inputStream));
            queryDefn.getSubqueries().addAll(QueryDefnUtil.loadSubQuery(inputStream));
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", e);
        }
    }

    private static Map loadExprMap(InputStream inputStream) throws IOException {
        DataInputStream dis = new DataInputStream(inputStream);
        HashMap<String, IBaseExpression> exprMap = new HashMap<String, IBaseExpression>();
        int size = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < size; ++i) {
            String exprName = IOUtil.readString((DataInputStream)dis);
            IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
            exprMap.put(exprName, expr);
        }
        return exprMap;
    }

    public static List loadSorts(InputStream inputStream) throws IOException {
        DataInputStream dis = new DataInputStream(inputStream);
        ArrayList<SortDefinition> sortList = new ArrayList<SortDefinition>();
        int size = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < size; ++i) {
            String sortKeyColumn = IOUtil.readString((DataInputStream)dis);
            IScriptExpression sortKeyExpr = (IScriptExpression)ExprUtil.loadBaseExpr(dis);
            int direction = IOUtil.readInt((InputStream)dis);
            SortDefinition sortDefn = new SortDefinition();
            if (sortKeyColumn != null) {
                sortDefn.setColumn(sortKeyColumn);
            } else {
                sortDefn.setExpression(sortKeyExpr.getText());
            }
            sortDefn.setSortDirection(direction);
            sortList.add(sortDefn);
        }
        return sortList;
    }

    public static Collection loadSubQuery(InputStream inputStream) throws DataException, IOException {
        DataInputStream dis = new DataInputStream(inputStream);
        ArrayList<SubqueryDefinition> subQuerys = new ArrayList<SubqueryDefinition>();
        int size = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < size; ++i) {
            SubqueryDefinition subQueryDefn = new SubqueryDefinition(IOUtil.readString((DataInputStream)dis));
            subQueryDefn.setApplyOnGroupFlag(IOUtil.readBool((InputStream)dis));
            QueryDefnUtil.loadBaseQueryDefn(dis, subQueryDefn);
            subQuerys.add(subQueryDefn);
        }
        return subQuerys;
    }

    public static boolean isCompatibleSQs(Collection oldSubQueryDefns, Collection newSubQueryDefns) {
        if (oldSubQueryDefns == newSubQueryDefns) {
            return true;
        }
        if (oldSubQueryDefns == null) {
            return newSubQueryDefns.size() == 0;
        }
        if (newSubQueryDefns == null) {
            return true;
        }
        if (oldSubQueryDefns.size() < newSubQueryDefns.size()) {
            return false;
        }
        Iterator oldIt = oldSubQueryDefns.iterator();
        Iterator newIt = newSubQueryDefns.iterator();
        while (newIt.hasNext()) {
            ISubqueryDefinition oldSub = (ISubqueryDefinition)oldIt.next();
            ISubqueryDefinition newSub = (ISubqueryDefinition)newIt.next();
            if (!QueryDefnUtil.isEqualFilters(oldSub.getFilters(), newSub.getFilters())) {
                return false;
            }
            if (!QueryDefnUtil.isEqualSorts(oldSub.getSorts(), newSub.getSorts())) {
                return false;
            }
            if (!GroupDefnUtil.isEqualGroups(oldSub.getGroups(), newSub.getGroups())) {
                return false;
            }
            if (QueryDefnUtil.isEqualExprMap(oldSub.getResultSetExpressions(), newSub.getResultSetExpressions())) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualFilters(List oldFilter, List newFilter) {
        if (oldFilter == newFilter) {
            return true;
        }
        if (oldFilter.size() != newFilter.size()) {
            return false;
        }
        Iterator oldIt = oldFilter.iterator();
        Iterator newIt = newFilter.iterator();
        while (oldIt.hasNext()) {
            IFilterDefinition newDefn;
            IFilterDefinition oldDefn = (IFilterDefinition)oldIt.next();
            if (FilterDefnUtil.isEqualFilter(oldDefn, newDefn = (IFilterDefinition)newIt.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualSorts(List oldSorts, List newSorts) {
        if (oldSorts == newSorts) {
            return true;
        }
        if (oldSorts.size() != newSorts.size()) {
            return false;
        }
        Iterator oldIt = oldSorts.iterator();
        Iterator newIt = newSorts.iterator();
        while (oldIt.hasNext()) {
            ISortDefinition oldDefn = (ISortDefinition)oldIt.next();
            ISortDefinition newDefn = (ISortDefinition)newIt.next();
            if (QueryDefnUtil.isEqualString(oldDefn.getColumn(), newDefn.getColumn()) && ExprUtil.isEqualExpression(oldDefn.getExpression(), newDefn.getExpression()) && oldDefn.getSortDirection() == newDefn.getSortDirection()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualExprMap(Map oldExprMap, Map newExprMap) {
        if (oldExprMap == newExprMap) {
            return true;
        }
        if (oldExprMap == null) {
            return newExprMap.size() == 0;
        }
        if (oldExprMap == null) {
            return newExprMap.size() == 0;
        }
        return oldExprMap.size() >= newExprMap.size();
    }

    private static boolean isEqualString(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }
}

