/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.util.LogUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    static final long serialVersionUID = -6321437674805466582L;
    private static final String DESC_FILE = "com.ibm.log.util.Msgs";
    public static final int OFF_INDEX = Integer.MAX_VALUE;
    public static final int FATAL_INDEX = 7000;
    public static final int ERROR_INDEX = 6000;
    public static final int WARNING_INDEX = 5000;
    public static final int INFO_INDEX = 4000;
    public static final int DEBUG_MIN_INDEX = 3000;
    public static final int DEBUG_MID_INDEX = 2000;
    public static final int DEBUG_MAX_INDEX = 1000;
    public static final int ALL_INDEX = Integer.MIN_VALUE;
    private static Hashtable knownLevels = new Hashtable();
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, "LEVEL_OFF", "com.ibm.log.util.Msgs");
    public static final Level FATAL = new Level("FATAL", 7000, "LEVEL_FATAL", "com.ibm.log.util.Msgs");
    public static final Level ERROR = new Level("ERROR", 6000, "LEVEL_ERROR", "com.ibm.log.util.Msgs");
    public static final Level WARN = new Level("WARN", 5000, "LEVEL_WARNING", "com.ibm.log.util.Msgs");
    public static final Level INFO = new Level("INFO", 4000, "LEVEL_INFO", "com.ibm.log.util.Msgs");
    public static final Level DEBUG_MIN = new Level("DEBUG_MIN", 3000, "LEVEL_DEBUG_MIN", "com.ibm.log.util.Msgs");
    public static final Level DEBUG_MID = new Level("DEBUG_MID", 2000, "LEVEL_DEBUG_MID", "com.ibm.log.util.Msgs");
    public static final Level DEBUG_MAX = new Level("DEBUG_MAX", 1000, "LEVEL_DEBUG_MAX", "com.ibm.log.util.Msgs");
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, "LEVEL_ALL", "com.ibm.log.util.Msgs");
    protected int value = Integer.MAX_VALUE;
    protected String description = "";
    protected String descriptionFile = "";
    protected String descriptionKey = "";
    protected String name = "";

    public static Level getLevel(String string) {
        string = string.toUpperCase();
        return (Level)knownLevels.get(string);
    }

    public static Enumeration getAllLevels() {
        return knownLevels.elements();
    }

    protected Level(String string, int n) {
        this.setName(string);
        this.value = n;
        knownLevels.put(this.getName(), this);
    }

    protected Level(String string, int n, String string2) {
        this(string, n);
        this.setDescription(string2);
    }

    protected Level(String string, int n, String string2, String string3) {
        this(string, n);
        this.setDescription(string2, string3);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        if (string != null) {
            this.name = string = string.toUpperCase();
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setName");
            LogUtil.errorMsg(string2);
        }
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        String string = this.description;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.descriptionFile != null && this.descriptionKey != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.descriptionFile, locale);
                string = resourceBundle.getString(this.descriptionKey);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string;
    }

    protected void setDescription(String string) {
        if (string != null) {
            this.description = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDescription");
            LogUtil.errorMsg(string2);
        }
    }

    protected void setDescription(String string, String string2) {
        if (string != null && string2 != null) {
            this.descriptionKey = string;
            this.descriptionFile = string2;
        } else {
            String string3 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDescription");
            LogUtil.errorMsg(string3);
        }
    }

    public final int getValue() {
        return this.value;
    }

    public boolean equals(Level level) {
        boolean bl = false;
        if (this.getValue() == level.getValue()) {
            bl = true;
        }
        return bl;
    }

    public int hashcode() {
        return this.getValue();
    }

    public String toString() {
        return "levelName=" + this.getName() + ", levelValue=" + this.getValue();
    }
}

