/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EventXMLParser
extends DefaultHandler {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private Vector xEventType = new Vector();
    private Vector xTimeStamp = new Vector();
    private Vector xSourceName = new Vector();
    private Vector xSourceAddress = new Vector();
    private Vector xSourceSpecific = new Vector();

    static {
        Class<?> clazz;
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.EventXMLParser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public EventXMLParser() {
        String string = "EventXMLParser";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void error(SAXParseException sAXParseException) {
        String string = "error";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "An error was encountered parsing Event XML: " + sAXParseException.getMessage());
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        String string = "warning";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "A warning was encountered parsing Event XML: " + sAXParseException.getMessage());
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void fatalError(SAXParseException sAXParseException) {
        String string = "fatalError";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "EventCorrelator_XMLparsingError");
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "A fatal error was encountered parsing Event XML: " + sAXParseException.getMessage());
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("SmartEvent")) {
            this.xTimeStamp.addElement(attributes.getValue("TimeStamp"));
            this.xEventType.addElement(attributes.getValue("EventId"));
        } else if (string3.equalsIgnoreCase("InbandEvent")) {
            this.xTimeStamp.addElement(attributes.getValue("TimeStamp"));
            this.xEventType.addElement(attributes.getValue("EventType"));
        } else if (string3.equalsIgnoreCase("Source")) {
            this.xSourceName.addElement(attributes.getValue("Name"));
            this.xSourceAddress.addElement(attributes.getValue("Address"));
            this.xSourceSpecific.addElement(attributes.getValue("Specific"));
        }
    }

    public String[] getEventIds() {
        String[] stringArray = new String[this.xEventType.size()];
        this.xEventType.toArray(stringArray);
        return stringArray;
    }

    public String[] getTimeStamps() {
        String[] stringArray = new String[this.xTimeStamp.size()];
        this.xTimeStamp.toArray(stringArray);
        return stringArray;
    }

    public String[] getSourceNames() {
        String[] stringArray = new String[this.xSourceName.size()];
        this.xSourceName.toArray(stringArray);
        return stringArray;
    }

    public String[] getSourceAddresses() {
        String[] stringArray = new String[this.xSourceAddress.size()];
        this.xSourceAddress.toArray(stringArray);
        return stringArray;
    }

    public String[] getSourceSpecifics() {
        String[] stringArray = new String[this.xSourceSpecific.size()];
        this.xSourceSpecific.toArray(stringArray);
        return stringArray;
    }
}

