/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class FabricPortAlertPopulator
implements IPopulator {
    public static final String deviceType = "port";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.FabricPortAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public FabricPortAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getPortData(string3, hashtable, hashtable2)) {
            String string4 = ((String)hashtable.get("HLDType")).trim();
            String string5 = ((String)hashtable.get("HLDUniqueId")).trim();
            String string6 = "TPC_NEW_DEVICE_EVENT";
            int n = this.determineResourceId(string3, string5);
            short s = this.determineResourceType(string4);
            short s2 = this.determineAlertCondition(string4, string6);
            int n2 = -1;
            n2 = s2 == 106 ? EventDBAccessor.getAlertIDByCondition(s2) : this.getAlertId(s, n, s2, string3);
            if (n2 > 0) {
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s2;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 104;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string8 = this.getPEValue(n6, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n6], string8);
                    ++n6;
                }
                String string9 = "PhysicalEntityEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n7]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n7], string7);
                    ++n7;
                }
                String string10 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string10);
                string7 = "msgId";
                Object[] objectArray = null;
                if (string4.equals(deviceType) || string4.equals("")) {
                    string7 = "ALR4010I";
                    String string11 = this.getValue(hashtable, "label");
                    if (string11 == null || string11.equals("")) {
                        string11 = this.getValue(hashtable, "entityName");
                    }
                    objectArray = new Object[]{string11};
                } else {
                    string7 = "ALR4015I";
                    String string12 = this.getValue(hashtable, "HLDType");
                    String string13 = this.getValue(hashtable, "HLDLabel");
                    String string14 = this.getValue(hashtable, "label");
                    objectArray = new Object[]{string12, string13, string14};
                }
                fabricAlert = new FabricAlert(n4, n, s, alertDefinition, nArray, n5, hashtable, string9, hashtable2, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: port" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: port" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getPortData(string3, hashtable, hashtable2)) {
            String string4 = ((String)hashtable.get("HLDType")).trim();
            String string5 = ((String)hashtable.get("HLDUniqueId")).trim();
            String string6 = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short s = this.determineAlertCondition(string4, string6);
            int n3 = this.determineResourceId(string3, string5);
            short s2 = this.determineResourceType(string4);
            int n4 = this.getAlertId(s2, n3, s, string3);
            if (n4 > 0) {
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string9 = this.getPEValue(n8, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n8], string9);
                    ++n8;
                }
                String string10 = "PhysicalEntityEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string7);
                    ++n9;
                }
                String string11 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = null;
                Object[] objectArray = null;
                if (string4.equals(deviceType) || string4.equals("")) {
                    String string12;
                    string7 = "ALR4011W";
                    if (n == 1) {
                        string7 = "ALR4012I";
                    }
                    if ((string12 = this.getValue(hashtable, "label")) == null || string12.equals("")) {
                        string12 = this.getValue(hashtable, "entityName");
                    }
                    objectArray = new Object[]{string12};
                } else {
                    string7 = "ALR4016W";
                    if (n == 1) {
                        string7 = "ALR4017I";
                    }
                    String string13 = this.getValue(hashtable, "HLDType");
                    String string14 = this.getValue(hashtable, "HLDLabel");
                    String string15 = this.getValue(hashtable, "label");
                    objectArray = new Object[]{string13, string14, string15};
                }
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable, string10, hashtable2, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: port" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: port" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getPortData(string3, hashtable, hashtable2)) {
            short s;
            String string4 = ((String)hashtable.get("HLDType")).trim();
            String string5 = ((String)hashtable.get("HLDUniqueId")).trim();
            String string6 = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
            int n3 = this.determineResourceId(string3, string5);
            short s2 = this.determineResourceType(string4);
            int n4 = this.getAlertId(s2, n3, s = this.determineAlertCondition(string4, string6), string3);
            if (n4 > 0) {
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 116;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string8 = this.getPEValue(n8, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n8], string8);
                    ++n8;
                }
                String string9 = "PEOperationalStatusChangeEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string7);
                    ++n9;
                }
                String string10 = "MINOR";
                this.addCommonTecAttributes(hashtable4, string10);
                this.addOperationalStatusData(hashtable3, hashtable4, n, n2);
                string7 = null;
                Object[] objectArray = null;
                if (string4.equals(deviceType) || string4.equals("")) {
                    string7 = "ALR4013W";
                    if (n2 == 0) {
                        string7 = "ALR4014I";
                    }
                    String string11 = this.getValue(hashtable, "entityName");
                    objectArray = new Object[]{string11};
                } else {
                    string7 = "ALR4018W";
                    if (n2 == 0) {
                        string7 = "ALR4019I";
                    }
                    String string12 = this.getValue(hashtable, "HLDType");
                    String string13 = this.getValue(hashtable, "HLDLabel");
                    String string14 = this.getValue(hashtable, "label");
                    objectArray = new Object[]{string12, string13, string14};
                }
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string9, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: port" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: port" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("oldStatus", "" + n2);
    }

    private short determineAlertCondition(String string, String string2) {
        int n = 106;
        if (string.equals(deviceType)) {
            if (string2.equals("TPC_NEW_DEVICE_EVENT")) {
                n = 106;
            } else if (string2.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
                n = 101;
            } else if (string2.equals("TPC_DEVICE_OPERATIONAL_CHANGE_EVENT")) {
                n = 102;
            }
        } else {
            n = string.equals("switch") ? 96 : (string.equals("subsystem") ? 123 : (string.equals("host") ? 174 : 102));
        }
        return (short)n;
    }

    private int determineResourceId(String string, String string2) {
        int n = -1;
        n = string2 == null || string2.equals("") ? Integer.parseInt(string) : Integer.parseInt(string2);
        return n;
    }

    private short determineResourceType(String string) {
        int n = 137;
        if (string.equals("subsystem")) {
            n = 78;
        } else if (string.equals("host")) {
            n = 1;
        } else if (string.equals("switch")) {
            n = 121;
        } else if (string.equals("pe")) {
            n = 139;
        } else if (string.equals("node")) {
            n = 138;
        }
        return (short)n;
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private String getPEValue(int n, Hashtable hashtable) {
        if (peVarNames[n].equals("description")) {
            return peVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return peVarNames[n];
        }
        return (String)hashtable.get(peVarNames[n]);
    }

    private int getAlertId(short s, int n, short s2, String string) {
        int n2 = -1;
        n2 = EventDBAccessor.getAlertIDByResource(s, n, s2);
        if (n2 <= 0) {
            String string2 = EventDBAccessor.getFabricIdForPort(string);
            if (string2 != null && !string2.equals("")) {
                n2 = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(string2), s2);
            }
            if (n2 <= 0) {
                n2 = s == 137 ? EventDBAccessor.getAlertIDByResource((short)129, -1, s2) : EventDBAccessor.getAlertIDByResource(s, -1, s2);
            }
        }
        return n2;
    }

    private String getValue(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 == null || string2.equals("")) {
            string2 = "UNKNOWN";
        }
        return string2;
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

