/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.snmp.ConnectionManager;
import org.eclipse.aperi.monitor.snmp.PortListener;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SocketManager
extends Thread {
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;
    private static int originalPort = 162;
    private static int forwardingPortNumber = 49152;
    private static int ReconnectWaitSeconds = 60;
    private boolean stop = false;
    private PortListener originalListener = null;

    public SocketManager() {
    }

    public SocketManager(int n, int n2) {
        originalPort = n;
        forwardingPortNumber = n2;
    }

    public void requestStop() {
        this.stop = true;
    }

    public void run() {
        while (!this.stop) {
            block12: {
                if (traceLogger.isLogging()) {
                    traceLogger.message(IRecordType.TYPE_INFO, (Object)this, "run", "SNMP trap forwarding code is checking to see if SNMP port, " + originalPort + ", is not currently in use.");
                }
                if (this.makePortConnection()) {
                    if (traceLogger.isLogging()) {
                        traceLogger.message(IRecordType.TYPE_INFO, (Object)this, "run", "Successfully connected to SNMP trap port: " + originalPort);
                    }
                    try {
                        DatagramSocket datagramSocket = new DatagramSocket(forwardingPortNumber);
                        datagramSocket.setSoTimeout(0);
                        while (!this.stop) {
                            DatagramPacket datagramPacket = new DatagramPacket(new byte[10], 10);
                            datagramSocket.receive(datagramPacket);
                            ConnectionManager.addListener(datagramPacket);
                        }
                    }
                    catch (IOException iOException) {
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "run", (Throwable)iOException, "Error working with forwarding port, " + forwardingPortNumber + ".");
                        }
                        if (this.originalListener == null) break block12;
                        this.originalListener.requestStop();
                        ConnectionManager.clearListeners();
                    }
                }
            }
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.message(IRecordType.TYPE_INFO, (Object)this, "run", "Unable to connect to SNMP port (another application may already be connected and forwarding messages), will retry later.");
                }
                Thread.sleep(ReconnectWaitSeconds * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.originalListener != null) {
            this.originalListener.requestStop();
        }
    }

    private boolean makePortConnection() {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket(originalPort);
            this.originalListener = new PortListener(datagramSocket);
            this.originalListener.start();
        }
        catch (Exception exception) {}
        return datagramSocket != null;
    }

    public static void main(String[] stringArray) {
        SocketManager socketManager = new SocketManager();
        socketManager.start();
    }
}

