/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.objects.Agent;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentTableUpdater
extends AgentTableReader {
    static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    AgentTableUpdater(DBConnection dBConnection, String string) throws InterruptedException, SQLException {
        super(dBConnection, string);
    }

    boolean createHost(TdmAgent tdmAgent) throws SQLException {
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "createHost", (Object)tdmAgent.getUniqueAgentName());
        }
        Timestamp timestamp = new Timestamp(tdmAgent.status_lstchanged.getTime());
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "createHost", String.valueOf(tdmAgent.guid.toNoDotString()) + " " + tdmAgent.agentName + " " + tdmAgent.ipAddress + " " + tdmAgent.agentPort + " " + tdmAgent.osname + " " + timestamp + " " + tdmAgent.status + " " + tdmAgent.version);
        }
        DeviceAgent deviceAgent = new DeviceAgent();
        Host host = new Host();
        short s = AgentTableUpdater.osType(tdmAgent.osname);
        int n = tdmAgent.agentName.indexOf(46);
        String string = "";
        String string2 = "";
        if (n < 0) {
            string = tdmAgent.agentName;
        } else {
            string = tdmAgent.agentName.substring(0, n);
            string2 = tdmAgent.agentName.substring(n + 1);
        }
        host.setNetworkName(string);
        host.setHostName(tdmAgent.agentName);
        host.setDomainName(string2);
        host.setHostUrl(tdmAgent.agentName);
        host.setOsType(s);
        host.setIpAddress(tdmAgent.ipAddress);
        int n2 = 0;
        Host host2 = this.getResHost(tdmAgent.guid);
        if (host2 == null) {
            host.setGuid(tdmAgent.guid.toNoDotString());
            n2 = AutoIdentifier.getIdentifier((int)1, (int)1);
            host.setComputerId(n2);
            host.insert(this._dbc);
            this.updateScanner(tdmAgent);
        } else {
            n2 = host2.getComputerId();
            host.setComputerId(n2);
            host.update(this._dbc);
            this.updateScanner(tdmAgent);
        }
        deviceAgent.setPort(tdmAgent.agentPort);
        deviceAgent.setStatusLastChanged(timestamp);
        deviceAgent.setStatus(tdmAgent.status);
        deviceAgent.setVersion(tdmAgent.version);
        deviceAgent.setHostId(n2);
        n2 = AutoIdentifier.getIdentifier((int)1, (int)1);
        deviceAgent.setDeviceAgentId(n2);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "createHost", deviceAgent.toString());
        }
        boolean bl = deviceAgent.insert(this._dbc);
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "createHost", bl);
        }
        return bl;
    }

    int updateHost(TdmAgent tdmAgent, boolean bl) throws SQLException {
        int n;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateHost", (Object)tdmAgent.getUniqueAgentName());
        }
        int n2 = n = bl ? this.updateHostWithStatus(tdmAgent) : this.updateHostNoStatus(tdmAgent);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateHost", n);
        }
        return n;
    }

    private int updateHostWithStatus(TdmAgent tdmAgent) throws SQLException {
        String string = tdmAgent.getUniqueAgentName();
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateHostWithStatus", (Object)string);
        }
        Timestamp timestamp = new Timestamp(tdmAgent.status_lstchanged.getTime());
        Host host = new Host();
        short s = AgentTableUpdater.osType(tdmAgent.osname);
        int n = tdmAgent.agentName.indexOf(46);
        String string2 = "";
        String string3 = "";
        if (n < 0) {
            string2 = tdmAgent.agentName;
        } else {
            string2 = tdmAgent.agentName.substring(0, n);
            string3 = tdmAgent.agentName.substring(n + 1);
        }
        host.setNetworkName(string2);
        host.setHostName(tdmAgent.agentName);
        host.setDomainName(string3);
        host.setHostUrl(tdmAgent.agentName);
        host.setOsType(s);
        host.setIpAddress(tdmAgent.ipAddress);
        host.setGuid(tdmAgent.guid.toNoDotString());
        DeviceAgent deviceAgent = new DeviceAgent();
        deviceAgent.setDeviceAgentId(tdmAgent.index);
        deviceAgent.retrieve(this._dbc);
        host.setComputerId(deviceAgent.getHostId());
        host.update(this._dbc);
        this.updateScanner(tdmAgent);
        deviceAgent = new DeviceAgent();
        deviceAgent.setDeviceAgentId(tdmAgent.index);
        deviceAgent.setPort(tdmAgent.agentPort);
        deviceAgent.setStatusLastChanged(timestamp);
        deviceAgent.setStatus(tdmAgent.status);
        deviceAgent.setVersion(tdmAgent.version);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "updateHostWithStatus", String.valueOf(deviceAgent.toString()) + " " + tdmAgent.index + " " + string);
        }
        int n2 = deviceAgent.update(this._dbc);
        this._dbc.commit();
        HostAgentPingDbAccess.updateHostStatus((int)host.getComputerId(), (String)tdmAgent.status);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateHostWithStatus", n2);
        }
        return n2;
    }

    private int updateHostNoStatus(TdmAgent tdmAgent) throws SQLException {
        String string = tdmAgent.getUniqueAgentName();
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateHostNoStatus", (Object)string);
        }
        Host host = new Host();
        short s = AgentTableUpdater.osType(tdmAgent.osname);
        int n = tdmAgent.agentName.indexOf(46);
        String string2 = "";
        String string3 = "";
        if (n < 0) {
            string2 = tdmAgent.agentName;
        } else {
            string2 = tdmAgent.agentName.substring(0, n);
            string3 = tdmAgent.agentName.substring(n + 1);
        }
        host.setNetworkName(string2);
        host.setHostName(tdmAgent.agentName);
        host.setDomainName(string3);
        host.setHostUrl(tdmAgent.agentName);
        host.setOsType(s);
        host.setIpAddress(tdmAgent.ipAddress);
        host.setGuid(tdmAgent.guid.toNoDotString());
        DeviceAgent deviceAgent = new DeviceAgent();
        deviceAgent.setDeviceAgentId(tdmAgent.index);
        deviceAgent.retrieve(this._dbc);
        host.setComputerId(deviceAgent.getHostId());
        host.update(this._dbc);
        this.updateScanner(tdmAgent);
        deviceAgent = new DeviceAgent();
        deviceAgent.setDeviceAgentId(tdmAgent.index);
        deviceAgent.setPort(tdmAgent.agentPort);
        deviceAgent.setVersion(tdmAgent.version);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "updateHostNoStatus", String.valueOf(deviceAgent.toString()) + " " + tdmAgent.index + " " + string);
        }
        int n2 = deviceAgent.update(this._dbc);
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateHostNoStatus", n2);
        }
        return n2;
    }

    private void createScanner(TdmAgent tdmAgent) throws SQLException {
        Scanner scanner = new Scanner();
        scanner.clear();
        scanner.setAgentName(tdmAgent.guid.toNoDotString());
        scanner.setScannerId("PI1:" + tdmAgent.ipAddress + ":" + tdmAgent.agentPort);
        scanner.setType("PI1");
        scanner.setPort(tdmAgent.agentPort);
        scanner.setVersion(tdmAgent.version);
        if (!scanner.insert(this._dbc)) {
            System.out.println("Error inserting scanner " + tdmAgent.ipAddress);
        }
        scanner.setScannerId("PI2:" + tdmAgent.ipAddress + ":" + tdmAgent.agentPort);
        scanner.setType("PI2");
        scanner.setPort(tdmAgent.agentPort);
        scanner.setVersion(tdmAgent.version);
        if (!scanner.insert(this._dbc)) {
            System.out.println("Error inserting scanner " + tdmAgent.ipAddress);
        }
    }

    private void updateScanner(TdmAgent tdmAgent) throws SQLException {
        String string = "PI1:" + tdmAgent.ipAddress + ":" + tdmAgent.agentPort;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(Scanner.getColumnInfo((String)"SCANNER_ID"), string);
        Scanner scanner = Scanner.retrieve((DBConnection)this._dbc, hashtable);
        if (scanner == null) {
            this.createScanner(tdmAgent);
        } else {
            Scanner scanner2 = new Scanner();
            scanner2.clear();
            scanner2.setAgentName(tdmAgent.guid.toNoDotString());
            scanner2.setScannerId(string);
            scanner2.setType("PI1");
            scanner2.setPort(tdmAgent.agentPort);
            scanner2.setVersion(tdmAgent.version);
            scanner2.update(this._dbc);
            scanner2.setScannerId("PI2:" + tdmAgent.ipAddress + ":" + tdmAgent.agentPort);
            scanner2.setType("PI2");
            scanner2.setPort(tdmAgent.agentPort);
            scanner2.setVersion(tdmAgent.version);
            scanner2.update(this._dbc);
        }
    }

    int updateStatus(GUID gUID, int n, Timestamp timestamp, String string) throws SQLException {
        String string2 = gUID + ":" + n;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateStatus", (Object)string2);
        }
        Host host = this.getResHost(gUID);
        Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        hashtable.put(DeviceAgent.getColumnInfo((String)"STATUS_LAST_CHANGED"), timestamp);
        hashtable.put(DeviceAgent.getColumnInfo((String)"STATUS"), string);
        hashtable2.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        hashtable2.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + n);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "updateStatus", String.valueOf(hashtable.toString()) + hashtable2.toString());
        }
        int n2 = DeviceAgent.update((DBConnection)this._dbc, hashtable, hashtable2);
        this._dbc.commit();
        HostAgentPingDbAccess.updateHostStatus((int)host.getComputerId(), (String)string);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateStatus", n2);
        }
        return n2;
    }

    int deleteHost(int n) throws SQLException {
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "deleteHost", (Object)new Integer(n));
        }
        DeviceAgent deviceAgent = new DeviceAgent();
        deviceAgent.setDeviceAgentId(n);
        deviceAgent.retrieve(this._dbc);
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(Agent.getColumnInfo((String)"COMPUTER_ID"), "" + deviceAgent.getHostId());
        Agent.AgentCursor agentCursor = Agent.getCursor((DBConnection)this._dbc, hashtable, null);
        int n2 = deviceAgent.delete(this._dbc);
        if (!agentCursor.next()) {
            Host host = new Host();
            host.setComputerId(deviceAgent.getHostId());
            host.delete(this._dbc);
        }
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "deleteHost", n2);
        }
        return n2;
    }

    int moveAgentToDomain(GUID gUID, int n, int n2) throws SQLException {
        String string = gUID + ":" + n;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "moveAgent", (Object)string);
        }
        Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (n2 == 0) {
            hashtable.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), new Null());
        } else {
            hashtable.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), "" + n2);
        }
        Host host = this.getResHost(gUID);
        hashtable2.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        hashtable2.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + n);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "moveAgent", String.valueOf(hashtable.toString()) + hashtable2.toString());
        }
        int n3 = DeviceAgent.update((DBConnection)this._dbc, hashtable, hashtable2);
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "moveAgent", n3);
        }
        return n3;
    }
}

