/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;

class TdmAgentListImpl {
    static final String className;
    static final int INITIAL_HASHMAP_SIZE = 25;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentListImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    TdmAgentListImpl() {
    }

    static Map bldTdmHostMap() {
        TdmAgent[] tdmAgentArray;
        Map<String, TdmAgent> map;
        block5: {
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "bldTdmHostMap");
            }
            map = Collections.synchronizedMap(new HashMap(25));
            tdmAgentArray = null;
            try {
                tdmAgentArray = TdmAgentListImpl.getTdmHostList();
            }
            catch (Exception exception) {
                SANDiskMgrHostService.messages.exception((Object)className, "bldTdmHostMap", (Throwable)exception);
                if (!SANDiskMgrHostService.trace.isLogging()) break block5;
                SANDiskMgrHostService.trace.exception((Object)className, "bldTdmHostMap", (Throwable)exception);
            }
        }
        int n = 0;
        while (n != tdmAgentArray.length) {
            tdmAgentArray[n].status_lstchanged = new Date();
            map.put(tdmAgentArray[n].getUniqueAgentName(), tdmAgentArray[n]);
            ++n;
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "bldTdmHostMap");
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TdmAgent[] getTdmHostList() throws TdmException {
        AgentTableReader agentTableReader;
        TdmAgent[] tdmAgentArray;
        block20: {
            TdmAgent tdmAgent = null;
            Vector<TdmAgent> vector = new Vector<TdmAgent>();
            tdmAgentArray = null;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "getTdmHostList");
            }
            agentTableReader = null;
            DeviceAgent.DeviceAgentCursor deviceAgentCursor = null;
            try {
                try {
                    int n;
                    agentTableReader = SANDiskMgrHostService.getHostTableReader();
                    deviceAgentCursor = agentTableReader.listHosts();
                    while (true) {
                        if (!deviceAgentCursor.next()) {
                            tdmAgentArray = new TdmAgent[vector.size()];
                            n = 0;
                            break;
                        }
                        tdmAgent = TdmAgentBuilder.getTdmHost(deviceAgentCursor, agentTableReader);
                        vector.add(tdmAgent);
                    }
                    while (n != tdmAgentArray.length) {
                        tdmAgentArray[n] = (TdmAgent)vector.elementAt(n);
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getTdmHostList", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getTdmHostList", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getTdmHostList", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getTdmHostList", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (deviceAgentCursor != null) {
                    try {
                        deviceAgentCursor.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (agentTableReader != null) {
                    agentTableReader.close();
                }
                throw throwable;
            }
            {
                Object var6_10 = null;
                if (deviceAgentCursor == null) break block20;
            }
            try {}
            catch (SQLException sQLException) {}
            deviceAgentCursor.close();
        }
        if (agentTableReader != null) {
            agentTableReader.close();
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getTdmHostList");
        }
        return tdmAgentArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TdmAgent[] getTdmAgentListInDomain(int n) throws TdmException {
        TdmAgent[] tdmAgentArray;
        block14: {
            TdmAgent tdmAgent = null;
            Vector<TdmAgent> vector = new Vector<TdmAgent>();
            tdmAgentArray = null;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "getTdmAgentListInDomain");
            }
            AgentTableReader agentTableReader = null;
            try {
                try {
                    int n2;
                    agentTableReader = SANDiskMgrHostService.getHostTableReader();
                    DeviceAgent.DeviceAgentCursor deviceAgentCursor = agentTableReader.listAgentsInDomain(n);
                    while (true) {
                        if (!deviceAgentCursor.next()) {
                            deviceAgentCursor.close();
                            deviceAgentCursor = null;
                            tdmAgentArray = new TdmAgent[vector.size()];
                            n2 = 0;
                            break;
                        }
                        tdmAgent = TdmAgentBuilder.getTdmHost(deviceAgentCursor, agentTableReader);
                        vector.add(tdmAgent);
                    }
                    while (n2 != tdmAgentArray.length) {
                        tdmAgentArray[n2] = (TdmAgent)vector.elementAt(n2);
                        ++n2;
                    }
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getTdmAgentListInDomain", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getTdmAgentListInDomain", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getTdmAgentListInDomain", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getTdmAgentListInDomain", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (agentTableReader != null) {
                    agentTableReader.close();
                }
                throw throwable;
            }
            {
                Object var7_11 = null;
                if (agentTableReader == null) break block14;
                agentTableReader.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getTdmAgentListInDomain");
        }
        return tdmAgentArray;
    }
}

