/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAFileInputStream;
import org.eclipse.birt.core.archive.RAInputStream;

public class FileArchiveReader
implements IDocArchiveReader {
    private String fileName;
    private RandomAccessFile file = null;
    private HashMap lookupMap = new HashMap();

    public FileArchiveReader(String fileName) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IOException("The file archive name is null or empty string.");
        }
        File fd = new File(fileName);
        if (!fd.isFile()) {
            throw new IOException("The specified name is not a file name. The FileArchiveReader is expecting a valid file archive name.");
        }
        if (!fd.exists()) {
            throw new IOException("The specified file do not exist.");
        }
        this.fileName = fd.getCanonicalPath();
    }

    public String getName() {
        return this.fileName;
    }

    public void open() throws IOException {
        this.file = new RandomAccessFile(new File(this.fileName), "r");
        try {
            this.readFileTable();
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    protected void readFileTable() throws IOException {
        long streamSectionPos = this.file.readLong();
        long entryNumber = this.file.readLong();
        for (long i = 0L; i < entryNumber; ++i) {
            String relativeFilePath = this.file.readUTF();
            long[] positionAndLength = new long[]{this.file.readLong() + streamSectionPos, this.file.readLong()};
            this.lookupMap.put(relativeFilePath, positionAndLength);
        }
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        Object entryValue;
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = ArchiveUtil.UNIX_SEPERATOR + relativePath;
        }
        if ((entryValue = this.lookupMap.get(relativePath)) == null) {
            return null;
        }
        long[] positionAndLength = (long[])entryValue;
        RAFileInputStream inputStream = new RAFileInputStream(this.file, positionAndLength[0], positionAndLength[0] + positionAndLength[1]);
        return inputStream;
    }

    public boolean exists(String relativePath) {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = ArchiveUtil.UNIX_SEPERATOR + relativePath;
        }
        return this.lookupMap.get(relativePath) != null;
    }

    public List listStreams(String relativeStoragePath) throws IOException {
        ArrayList<String> streamList = new ArrayList<String>();
        if (!relativeStoragePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativeStoragePath = ArchiveUtil.UNIX_SEPERATOR + relativeStoragePath;
        }
        Iterator entryIter = this.lookupMap.entrySet().iterator();
        while (entryIter.hasNext()) {
            String diffString;
            Map.Entry entry = entryIter.next();
            String relativePath = (String)entry.getKey();
            if (!relativePath.startsWith(relativeStoragePath) || relativePath.equalsIgnoreCase(relativeStoragePath) || (diffString = ArchiveUtil.generateRelativePath(relativeStoragePath, relativePath)).lastIndexOf(ArchiveUtil.UNIX_SEPERATOR) != 0) continue;
            streamList.add(relativePath);
        }
        return streamList;
    }

    public void expandFileArchive(String folderArchiveName) throws IOException {
        File folder = new File(folderArchiveName);
        folderArchiveName = folder.getCanonicalPath();
        ArchiveUtil.DeleteAllFiles(folder);
        folder.mkdirs();
        List streamList = this.getAllStreams();
        for (int i = 0; i < streamList.size(); ++i) {
            String streamPath = (String)streamList.get(i);
            RAInputStream in = this.getStream(streamPath);
            String newFileName = ArchiveUtil.generateFullPath(folderArchiveName, streamPath);
            File fd = new File(newFileName);
            ArchiveUtil.createParentFolder(fd);
            FileOutputStream out = new FileOutputStream(fd);
            this.copyFileFromTheArchive(in, out);
        }
    }

    private List getAllStreams() {
        ArrayList<String> streamList = new ArrayList<String>();
        Iterator entryIter = this.lookupMap.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            String relativePath = (String)entry.getKey();
            streamList.add(relativePath);
        }
        return streamList;
    }

    private void copyFileFromTheArchive(RAInputStream in, FileOutputStream out) throws IOException {
        byte[] buf = new byte[5120];
        int i = 0;
        while ((i = in.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        in.close();
        out.close();
    }

    public Object lock(String stream) throws IOException {
        return stream.toString();
    }

    public void unlock(Object lock) {
    }
}

