/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.util.GregorianCalendar;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DateUtil {
    private static final int[] DAYS_MONTH;
    private static GregorianCalendar calendarInstance;
    private static String[] splitStrs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean checkValid(DateFormat df, String dateStr) {
        if (!$assertionsDisabled && df == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dateStr == null) {
            throw new AssertionError();
        }
        boolean isValid = true;
        if (df instanceof SimpleDateFormat) {
            String[] dateResult = DateUtil.splitDateStr(dateStr);
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String pattern = sdf.toPattern();
            String[] patternResult = DateUtil.splitDateStr(pattern);
            if (dateResult != null && patternResult != null) {
                isValid = DateUtil.isMatch(dateResult, patternResult);
            }
        }
        return isValid;
    }

    private static String[] splitDateStr(String dateStr) {
        String splitChar = null;
        for (int i = 0; i < splitStrs.length; ++i) {
            if (dateStr.indexOf(splitStrs[i]) < 0) continue;
            splitChar = splitStrs[i];
            break;
        }
        if (splitChar == null) {
            return null;
        }
        String[] result = dateStr.split(splitChar);
        if (result.length != 3) {
            return null;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    private static boolean isMatch(String[] dateStr, String[] patternStr) {
        if (!$assertionsDisabled && dateStr == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && patternStr == null) {
            throw new AssertionError();
        }
        int year = -1;
        int month = -1;
        int day = -1;
        for (int i = 0; i < dateStr.length; ++i) {
            int value = Integer.valueOf(dateStr[i]);
            if (patternStr[i].startsWith("y") || patternStr[i].startsWith("Y")) {
                year = value;
                continue;
            }
            if (patternStr[i].startsWith("M") || patternStr[i].startsWith("m")) {
                month = value;
                continue;
            }
            if (!patternStr[i].startsWith("d") && !patternStr[i].startsWith("D")) continue;
            day = value;
        }
        boolean result = true;
        if (year < 0 || month < 1 || month > 12 || DateUtil.isInvalidDay(day, year, month)) {
            result = false;
        }
        return result;
    }

    private static boolean isInvalidDay(int day, int year, int month) {
        if (calendarInstance == null) {
            calendarInstance = new GregorianCalendar();
        }
        int dayOfMonth = DAYS_MONTH[month - 1];
        if (month == 2) {
            dayOfMonth = calendarInstance.isLeapYear(year) ? 29 : 28;
        }
        return day < 1 || day > dayOfMonth;
    }

    static {
        $assertionsDisabled = !DateUtil.class.desiredAssertionStatus();
        DAYS_MONTH = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        calendarInstance = null;
        splitStrs = new String[]{"/", "-", "."};
    }
}

