/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class MemberHandle
extends SimpleValueHandle {
    protected CachedMemberRef memberRef;

    public MemberHandle(DesignElementHandle element, MemberRef ref) {
        super(element);
        this.memberRef = new CachedMemberRef(ref);
        if (!this.memberRef.checkOrCacheStructure(this.elementHandle.getModule(), this.elementHandle.getElement())) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
    }

    public MemberHandle(StructureHandle structHandle, StructPropertyDefn member) {
        super(structHandle.getElementHandle());
        this.memberRef = new CachedMemberRef(structHandle.getReference(), member);
        if (!this.memberRef.checkOrCacheStructure(this.elementHandle.getModule(), this.elementHandle.getElement())) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
    }

    public IPropertyDefn getDefn() {
        return this.memberRef.getMemberDefn();
    }

    public Object getValue() {
        Object value = this.memberRef.getValue(this.getModule(), this.getElement());
        if (value instanceof ReferenceValue) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, this.getElementHandle().getModule());
        }
        return value;
    }

    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.setMember(this.memberRef, value);
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.memberRef.getPropDefn();
    }

    public MemberRef getReference() {
        return this.memberRef;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }
}

