/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.HashSet;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IThemeModel;

public class ThemeHandle
extends ReportElementHandle
implements IThemeModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ThemeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public StyleHandle findStyle(String name) {
        Theme theme = (Theme)this.getElement();
        StyleElement style = theme.findStyle(name);
        if (style == null) {
            return null;
        }
        return (StyleHandle)style.getHandle(this.getModule());
    }

    String makeUniqueStyleName(String name) {
        if (!$assertionsDisabled && this == null) {
            throw new AssertionError();
        }
        SlotHandle styles = this.getStyles();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < styles.getCount(); ++i) {
            StyleHandle style = (StyleHandle)styles.get(i);
            set.add(style.getName());
        }
        int index = 0;
        String baseName = name;
        while (set.contains(name)) {
            name = baseName + ++index;
        }
        return name;
    }

    public String getDisplayLabel(int level) {
        String displayLabel = super.getDisplayLabel(level);
        Module rootModule = this.getModule();
        if (rootModule instanceof Library) {
            displayLabel = StringUtil.buildQualifiedReference(((Library)rootModule).getNamespace(), displayLabel);
        }
        return displayLabel;
    }

    static {
        $assertionsDisabled = !ThemeHandle.class.desiredAssertionStatus();
    }
}

