/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ExtensionPropertyDefinitionEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public class PropertyRecord
extends SimpleRecord {
    private DesignElement element = null;
    private ElementPropertyDefn propDefn = null;
    private Object oldValue = null;
    private Object newValue = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyRecord(DesignElement propertyOwner, String name, Object value) {
        if (!$assertionsDisabled && propertyOwner == null) {
            throw new AssertionError();
        }
        this.element = propertyOwner;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.propDefn = this.element.getPropertyDefn(name);
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.isIntrinsic()) {
            throw new AssertionError();
        }
        this.newValue = value;
        this.oldValue = propertyOwner.getLocalProperty(null, this.propDefn);
    }

    public PropertyRecord(DesignElement propertyOwner, ElementPropertyDefn prop, Object value) {
        if (!$assertionsDisabled && propertyOwner == null) {
            throw new AssertionError();
        }
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        this.element = propertyOwner;
        this.newValue = value;
        this.oldValue = propertyOwner.getLocalProperty(null, this.propDefn);
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
    }

    public DesignElement getTarget() {
        return this.element;
    }

    public NotificationEvent getEvent() {
        IReportItem extElement;
        if (this.element instanceof ExtendedItem && (extElement = ((ExtendedItem)this.element).getExtendedElement()) != null && extElement.refreshPropertyDefinition()) {
            return new ExtensionPropertyDefinitionEvent(this.element);
        }
        return new PropertyEvent(this.element, this.propDefn.getName());
    }

    protected void perform(boolean undo) {
        Object value = undo ? this.oldValue : this.newValue;
        this.element.setProperty(this.propDefn, value);
    }

    public List getValidators() {
        return ValidationExecutor.getValidationNodes(this.element, this.propDefn.getTriggerDefnSet(), false);
    }

    public ElementPropertyDefn getPropDefn() {
        return this.propDefn;
    }

    protected List getPostTasks() {
        ArrayList<LayoutRecordTask> retValue = new ArrayList<LayoutRecordTask>();
        retValue.addAll(super.getPostTasks());
        if (!(this.element instanceof Cell)) {
            return retValue;
        }
        String propName = this.propDefn.getName();
        if (!("colSpan".equalsIgnoreCase(propName) || "rowSpan".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName))) {
            return retValue;
        }
        ReportItem compoundElement = LayoutUtil.getCompoundContainer(this.element);
        if (compoundElement == null) {
            return retValue;
        }
        retValue.add(new LayoutRecordTask(compoundElement.getRoot(), compoundElement));
        return retValue;
    }

    static {
        $assertionsDisabled = !PropertyRecord.class.desiredAssertionStatus();
    }
}

