/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.metadata.ReferenceValue;

public class ElementRefValue
extends ReferenceValue {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ElementRefValue(String namespace, String theName) {
        super(namespace, theName);
    }

    public ElementRefValue(String namespace, DesignElement element) {
        super(namespace, element);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.resolved != null) {
            return ((DesignElement)this.resolved).getName();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void resolve(Object element) {
        if (!$assertionsDisabled && !(element instanceof DesignElement)) {
            throw new AssertionError();
        }
        this.name = null;
        this.resolved = (DesignElement)element;
    }

    public DesignElement getElement() {
        return (DesignElement)this.resolved;
    }

    public ReferenceableElement getTargetElement() {
        return (ReferenceableElement)this.resolved;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElementRefValue)) {
            return false;
        }
        ElementRefValue value = (ElementRefValue)obj;
        if (this.isResolved() != value.isResolved()) {
            return false;
        }
        if (value.isResolved()) {
            return this.getElement().equals(value.getElement());
        }
        if (!this.getName().equals(value.getName())) {
            return false;
        }
        String myNameSpace = this.getLibraryNamespace();
        String objNameSpace = value.getLibraryNamespace();
        if (myNameSpace == null && objNameSpace == null) {
            return true;
        }
        return myNameSpace != null && myNameSpace.equals(objNameSpace);
    }

    public Object copy() {
        return new ElementRefValue(this.getLibraryNamespace(), this.getName());
    }

    static {
        $assertionsDisabled = !ElementRefValue.class.desiredAssertionStatus();
    }
}

