/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.render.Pie;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class PieRenderer {
    static final int UNKNOWN = 0;
    private static final int LOWER = 1;
    private static final int UPPER = 2;
    private static final double LEADER_TICK_MIN_SIZE = 10.0;
    private static final int LESS = -1;
    private static final int MORE = 1;
    private static final int EQUAL = 0;
    private final transient double[] daAngleDelta;
    private final transient double[] daPercentDelta;
    private transient LeaderLine2D[] lla = null;
    private final Position lpDataPoint;
    private final Position lpSeriesTitle;
    private transient double dLeaderTick;
    private transient double dLeaderLength;
    private final LeaderLineStyle lls;
    private transient double dStartAngle = 0.0;
    private transient double dThickness;
    private transient double dExplosion = 0.0;
    private transient String sExplosionExpression = null;
    private transient boolean[] bExploded;
    private final Pie pie;
    private final PieSeries ps;
    private final ArrayList alPlanes = new ArrayList();
    private final Palette pa;
    private final Label laDataPoint;
    private final Label laSeriesTitle;
    private DataPointHints[] dpha;
    private double[] da;
    private int[] categoryIndex;
    private final LineAttributes liaLL;
    private final LineAttributes liaEdges;
    private transient IDisplayServer xs = null;
    private transient IDeviceRenderer idr = null;
    private transient Bounds boTitleContainer = null;
    private transient Insets insCA = null;
    private transient Bounds boSetDuringComputation = null;
    private final boolean bPaletteByCategory;
    private transient boolean bBoundsAdjustedForInsets = false;
    private transient boolean bMinSliceDefined = false;
    private transient double dMinSlice = 0.0;
    private transient double dAbsoluteMinSlice = 0.0;
    private transient boolean bPercentageMinSlice = false;
    private transient boolean bMinSliceApplied = false;
    private transient int orginalSliceCount = 0;
    private transient double ratio = 0.0;
    private static ILogger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$PolygonRenderEvent;
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$LineRenderEvent;

    PieRenderer(ChartWithoutAxes cwoa, Pie pie, DataPointHints[] dpha, double[] da, Palette pa) throws ChartException {
        ArrayList<Integer> caIndex;
        ArrayList<DataPointHints> dphaList;
        ArrayList<Double> daList;
        this.pa = pa;
        this.pie = pie;
        this.dpha = dpha;
        this.da = da;
        this.ps = (PieSeries)pie.getSeries();
        this.sExplosionExpression = this.ps.getExplosionExpression();
        this.dExplosion = (double)(this.ps.isSetExplosion() ? this.ps.getExplosion() : 0) * pie.getDeviceScale();
        this.dThickness = (cwoa.getDimension() == ChartDimension.TWO_DIMENSIONAL_LITERAL ? 0.0 : cwoa.getSeriesThickness()) * pie.getDeviceScale();
        this.ratio = this.ps.isSetRatio() ? this.ps.getRatio() : 1.0;
        this.liaLL = this.ps.getLeaderLineAttributes();
        if (this.ps.getLeaderLineAttributes().isVisible()) {
            this.dLeaderLength = this.ps.getLeaderLineLength() * pie.getDeviceScale();
            this.dLeaderTick = Math.max(this.dLeaderLength / 4.0, 10.0 * pie.getDeviceScale());
        } else {
            this.dLeaderLength = 0.0;
            this.dLeaderTick = 10.0 * pie.getDeviceScale();
        }
        this.liaEdges = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        this.bPaletteByCategory = cwoa.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
        this.lpDataPoint = this.ps.getLabelPosition();
        this.lpSeriesTitle = this.ps.getTitlePosition();
        this.laSeriesTitle = LabelImpl.copyInstance((Label)this.ps.getTitle());
        this.laSeriesTitle.getCaption().setValue(pie.getRunTimeContext().externalizedMessage(String.valueOf(this.ps.getSeriesIdentifier())));
        this.laSeriesTitle.getCaption().getFont().setAlignment(pie.switchTextAlignment(this.laSeriesTitle.getCaption().getFont().getAlignment()));
        this.laDataPoint = LabelImpl.copyInstance((Label)this.ps.getLabel());
        this.lls = this.ps.getLeaderLineStyle();
        this.bMinSliceDefined = cwoa.isSetMinSlice();
        this.dMinSlice = cwoa.getMinSlice();
        this.bPercentageMinSlice = cwoa.isMinSlicePercent();
        int n = da.length;
        double dTotal = 0.0;
        this.orginalSliceCount = n;
        for (int i = 0; i < n; ++i) {
            if (da[i] < 0.0) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, "exception.pie.negative.dataset.values", Messages.getResourceBundle(pie.getRunTimeContext().getULocale()));
            }
            if (Double.isNaN(da[i])) continue;
            dTotal += da[i];
        }
        if (this.bMinSliceDefined) {
            this.dAbsoluteMinSlice = this.bPercentageMinSlice ? this.dMinSlice * dTotal / 100.0 : this.dMinSlice;
            daList = new ArrayList();
            dphaList = new ArrayList();
            caIndex = new ArrayList();
            double residual = 0.0;
            DataPointHints dph = null;
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(da[i])) continue;
                if (da[i] >= this.dAbsoluteMinSlice) {
                    daList.add(new Double(da[i]));
                    dphaList.add(dpha[i]);
                    caIndex.add(new Integer(i));
                    continue;
                }
                if (dph == null) {
                    residual += da[i];
                    dph = dpha[i].getCopy();
                    continue;
                }
                residual += da[i];
                dph.accumulate(dpha[i].getBaseValue(), dpha[i].getOrthogonalValue(), dpha[i].getSeriesValue(), dpha[i].getPercentileOrthogonalValue());
            }
            if (dph != null) {
                daList.add(new Double(residual));
                dphaList.add(dph);
                caIndex.add(new Integer(this.orginalSliceCount));
                this.bMinSliceApplied = true;
            }
            Double[] dao = daList.toArray(new Double[daList.size()]);
            this.da = new double[dao.length];
            this.categoryIndex = new int[dao.length];
            for (int i = 0; i < dao.length; ++i) {
                this.da[i] = dao[i];
                this.categoryIndex[i] = (Integer)caIndex.get(i);
            }
            this.dpha = dphaList.toArray(new DataPointHints[dphaList.size()]);
        } else {
            daList = new ArrayList<Double>();
            dphaList = new ArrayList<DataPointHints>();
            caIndex = new ArrayList<Integer>();
            this.categoryIndex = new int[n];
            for (int i = 0; i < n; ++i) {
                this.categoryIndex[i] = i;
                if (Double.isNaN(da[i])) continue;
                daList.add(new Double(da[i]));
                dphaList.add(dpha[i]);
                caIndex.add(new Integer(i));
            }
            if (daList.size() != da.length) {
                Double[] dao = daList.toArray(new Double[daList.size()]);
                this.da = new double[dao.length];
                this.categoryIndex = new int[dao.length];
                for (int i = 0; i < dao.length; ++i) {
                    this.da[i] = dao[i];
                    this.categoryIndex[i] = (Integer)caIndex.get(i);
                }
                this.dpha = dphaList.toArray(new DataPointHints[dphaList.size()]);
            }
        }
        double angleTotal = 0.0;
        n = this.da.length;
        this.daAngleDelta = new double[n];
        this.daPercentDelta = new double[n];
        if (dTotal == 0.0) {
            dTotal = 1.0;
        }
        for (int i = 0; i < n; ++i) {
            this.daAngleDelta[i] = this.da[i] / dTotal * 360.0;
            this.daPercentDelta[i] = this.da[i] / dTotal * 100.0;
            angleTotal += this.daAngleDelta[i];
        }
        if (angleTotal > 0.0 && 360.0 - angleTotal > 0.001) {
            int n2 = n - 1;
            this.daAngleDelta[n2] = this.daAngleDelta[n2] + (360.0 - angleTotal);
        }
        this.initExploded();
    }

    private final void renderDataPoints(IDeviceRenderer idr) throws ChartException {
        if (!this.laDataPoint.isVisible()) {
            return;
        }
        ScriptHandler sh = this.pie.getRunTimeContext().getScriptHandler();
        if (this.lpDataPoint.getValue() == 5) {
            int i;
            if (this.laDataPoint.getShadowColor() != null) {
                for (i = 0; i < this.lla.length; ++i) {
                    this.lla[i].render(idr, 1, this.dpha[i]);
                }
            }
            for (i = 0; i < this.lla.length; ++i) {
                this.laDataPoint.getCaption().setValue(this.lla[i].getValue());
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)this.dpha[i], (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)this.laDataPoint);
                this.lla[i].setValue(this.laDataPoint.getCaption().getValue());
                if (this.laDataPoint.isVisible()) {
                    this.lla[i].render(idr, 2, this.dpha[i]);
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)this.dpha[i], (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)this.laDataPoint);
            }
        } else {
            for (int i = 0; i < this.lla.length; ++i) {
                this.laDataPoint.getCaption().setValue(this.lla[i].getValue());
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)this.dpha[i], (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)this.laDataPoint);
                this.lla[i].setValue(this.laDataPoint.getCaption().getValue());
                this.lla[i].render(idr, 3, this.dpha[i]);
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)this.dpha[i], (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)this.laDataPoint);
            }
        }
    }

    private final void computeLabelsInsidePie(Bounds bo) throws IllegalArgumentException {
        double w = bo.getWidth() / 2.0 - this.dExplosion;
        double h = bo.getHeight() / 2.0 - this.dExplosion - this.dThickness / 2.0;
        double xc = bo.getLeft() + w + this.dExplosion;
        double yc = bo.getTop() + h + this.dExplosion + this.dThickness / 2.0;
        if (this.ratio > 0.0 && w > 0.0) {
            if (h / w > this.ratio) {
                h = w * this.ratio;
            } else if (h / w < this.ratio) {
                w = h / this.ratio;
            }
        }
        if (w <= 0.0 || h <= 0.0) {
            h = 1.0;
            w = 1.0;
        }
        int n = this.daAngleDelta.length;
        double dStart = this.dStartAngle;
        if (this.lla == null || this.lla.length != n) {
            this.lla = new LeaderLine2D[n];
        }
        for (int i = 0; i < n; ++i) {
            double yDelta;
            double xDelta;
            double dMidAngleInDegrees = dStart + this.daAngleDelta[i] / 2.0;
            double dMidAngleInRadians = Math.toRadians(-dMidAngleInDegrees);
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            if (this.bExploded[i]) {
                xDelta = (w / 1.5 + this.dExplosion) * dCosThetaMid;
                yDelta = (h / 1.5 + this.dExplosion) * dSineThetaMid;
            } else {
                xDelta = w / 1.5 * dCosThetaMid;
                yDelta = h / 1.5 * dSineThetaMid;
            }
            this.lla[i] = new LeaderLine2D(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.lla[i].setValue(this.dpha[i].getDisplayValue());
            this.laDataPoint.getCaption().setValue(this.lla[i].getValue());
            BoundingBox bb = Methods.computeBox((IDisplayServer)this.xs, (int)1, (Label)this.laDataPoint, (double)0.0, (double)0.0);
            bb.setLeft(xc + xDelta - bb.getWidth() / 2.0);
            bb.setTop(yc - this.dThickness / 2.0 + yDelta - bb.getHeight() / 2.0);
            this.lla[i].setBounds(bb);
            this.lla[i].setValue(this.dpha[i].getDisplayValue());
            this.lla[i].setQuadrant(-1);
            dStart += this.daAngleDelta[i];
        }
    }

    private final void computeLabelsOutsidePie(Bounds bo) throws IllegalArgumentException {
        double w = bo.getWidth() / 2.0 - this.dExplosion;
        double h = bo.getHeight() / 2.0 - this.dExplosion - this.dThickness / 2.0;
        double xc = bo.getLeft() + w + this.dExplosion;
        double yc = bo.getTop() + h + this.dExplosion + this.dThickness / 2.0;
        if (this.ratio > 0.0 && w > 0.0) {
            if (h / w > this.ratio) {
                h = w * this.ratio;
            } else if (h / w < this.ratio) {
                w = h / this.ratio;
            }
        }
        if (w <= 0.0 || h <= 0.0) {
            h = 1.0;
            w = 1.0;
        }
        int n = this.daAngleDelta.length;
        int iLL = 0;
        BoundingBox bb = null;
        double dStart = this.dStartAngle;
        double dLeaderW = 0.0;
        double dLeaderH = 0.0;
        double dBottomLeaderW = 0.0;
        double dBottomLeaderH = 0.0;
        double dTopLeaderW = 0.0;
        double dTopLeaderH = 0.0;
        Location center = LocationImpl.create((double)xc, (double)(yc - this.dThickness / 2.0));
        Location depthCenter = LocationImpl.create((double)xc, (double)yc);
        double dX = 0.0;
        double dLeftSide = xc - this.dExplosion - w;
        double dRightSide = xc + this.dExplosion + w;
        if (this.lla == null || this.lla.length != n) {
            this.lla = new LeaderLine2D[n];
        }
        if (w > h) {
            dTopLeaderW = this.dLeaderTick;
            dTopLeaderH = this.dLeaderTick * this.ratio;
        } else {
            dTopLeaderH = this.dLeaderTick;
            dTopLeaderW = this.dLeaderTick / this.ratio;
        }
        for (int i = 0; i < n; ++i) {
            double yDelta2;
            double xDelta2;
            double yDelta1;
            double xDelta1;
            double dMidAngleInDegrees = dStart + this.daAngleDelta[i] / 2.0;
            double dMidAngleInRadians = Math.toRadians(-dMidAngleInDegrees);
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            if (this.dThickness > 0.0 && dMidAngleInDegrees > 180.0 && dMidAngleInDegrees < 360.0) {
                double dTmpLeaderTick = Math.max(this.dThickness * dSineThetaMid + 8.0 * this.pie.getDeviceScale(), this.dLeaderTick);
                if (w > h) {
                    dBottomLeaderW = dTmpLeaderTick;
                    dBottomLeaderH = dTmpLeaderTick * this.ratio;
                } else {
                    dBottomLeaderH = dTmpLeaderTick;
                    dBottomLeaderW = dTmpLeaderTick / this.ratio;
                }
                dLeaderW = dBottomLeaderW;
                dLeaderH = dBottomLeaderH;
            } else {
                dLeaderW = dTopLeaderW;
                dLeaderH = dTopLeaderH;
            }
            if (this.bExploded[i]) {
                xDelta1 = (w + this.dExplosion) * dCosThetaMid;
                yDelta1 = (h + this.dExplosion) * dSineThetaMid;
                xDelta2 = (w + dLeaderW + this.dExplosion) * dCosThetaMid;
                yDelta2 = (h + dLeaderH + this.dExplosion) * dSineThetaMid;
            } else {
                xDelta1 = w * dCosThetaMid;
                yDelta1 = h * dSineThetaMid;
                xDelta2 = (w + dLeaderW) * dCosThetaMid;
                yDelta2 = (h + dLeaderH) * dSineThetaMid;
            }
            if (this.lls == LeaderLineStyle.STRETCH_TO_SIDE_LITERAL) {
                if (dMidAngleInDegrees >= 90.0 && dMidAngleInDegrees < 270.0) {
                    dX = dLeftSide - dLeaderW * 1.5;
                    iLL = 1;
                } else {
                    dX = dRightSide + dLeaderW * 1.5;
                    iLL = 2;
                }
            } else if (this.lls == LeaderLineStyle.FIXED_LENGTH_LITERAL) {
                if (dMidAngleInDegrees > 90.0 && dMidAngleInDegrees < 270.0) {
                    dX = center.getX() + xDelta2 - this.dLeaderLength;
                    if (this.dLeaderLength > 0.0) {
                        iLL = 1;
                    } else if (dMidAngleInDegrees < 135.0) {
                        iLL = 3;
                    } else if (dMidAngleInDegrees < 225.0) {
                        iLL = 1;
                    } else if (dMidAngleInDegrees < 270.0) {
                        iLL = 4;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    dX = center.getX() + xDelta2 + this.dLeaderLength;
                    if (this.dLeaderLength > 0.0) {
                        iLL = 2;
                    } else if (dMidAngleInDegrees <= 45.0) {
                        iLL = 2;
                    } else if (dMidAngleInDegrees > 45.0 && dMidAngleInDegrees <= 90.0) {
                        iLL = 3;
                    } else if (dMidAngleInDegrees <= 315.0 && dMidAngleInDegrees >= 270.0) {
                        iLL = 4;
                    } else if (dMidAngleInDegrees > 315.0) {
                        iLL = 2;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            Location relativeCenter = dMidAngleInDegrees > 0.0 && dMidAngleInDegrees < 180.0 ? center : depthCenter;
            this.lla[i] = new LeaderLine2D(relativeCenter.getX() + xDelta1, relativeCenter.getY() + yDelta1, relativeCenter.getX() + xDelta2, relativeCenter.getY() + yDelta2, dX, relativeCenter.getY() + yDelta2);
            this.lla[i].setValue(this.dpha[i].getDisplayValue());
            this.laDataPoint.getCaption().setValue(this.lla[i].getValue());
            bb = Methods.computeBox((IDisplayServer)this.xs, (int)iLL, (Label)this.laDataPoint, (double)this.lla[i].loEnd.getX(), (double)this.lla[i].loEnd.getY());
            this.lla[i].setBounds(bb);
            this.lla[i].setQuadrant(PieRenderer.getQuadrant(dMidAngleInDegrees));
            dStart += this.daAngleDelta[i];
        }
    }

    private final Insets adjust(Bounds bo, Bounds boAdjusted, Insets ins) throws IllegalArgumentException {
        this.computeLabelsOutsidePie(boAdjusted);
        ins.set(0.0, 0.0, 0.0, 0.0);
        double dDelta = 0.0;
        BoundingBox bb = null;
        for (int i = 0; i < this.lla.length; ++i) {
            bb = this.lla[i].getBounds();
            if (bb.getLeft() < bo.getLeft()) {
                dDelta = bo.getLeft() - bb.getLeft();
                if (ins.getLeft() < dDelta) {
                    ins.setLeft(dDelta);
                }
            }
            if (bb.getTop() < bo.getTop()) {
                dDelta = bo.getTop() - bb.getTop();
                if (ins.getTop() < dDelta) {
                    ins.setTop(dDelta);
                }
            }
            if (bb.getLeft() + bb.getWidth() > bo.getLeft() + bo.getWidth()) {
                dDelta = bb.getLeft() + bb.getWidth() - bo.getLeft() - bo.getWidth();
                if (ins.getRight() < dDelta) {
                    ins.setRight(dDelta);
                }
            }
            if (!(bb.getTop() + bb.getHeight() > bo.getTop() + bo.getHeight())) continue;
            dDelta = bb.getTop() + bb.getHeight() - bo.getTop() - bo.getHeight();
            if (!(ins.getBottom() < dDelta)) continue;
            ins.setBottom(dDelta);
        }
        return ins;
    }

    final void computeInsets(Bounds bo) throws ChartException, IllegalArgumentException {
        this.boSetDuringComputation = BoundsImpl.copyInstance((Bounds)bo);
        this.xs = this.pie.getXServer();
        this.boTitleContainer = null;
        if (this.laSeriesTitle.isVisible()) {
            if (this.lpSeriesTitle == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 13, "exception.unspecified.visible.series.title", Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
            }
            BoundingBox bb = Methods.computeBox((IDisplayServer)this.xs, (int)4, (Label)this.laSeriesTitle, (double)0.0, (double)0.0);
            this.boTitleContainer = BoundsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
            switch (this.lpSeriesTitle.getValue()) {
                case 1: {
                    bo.setHeight(bo.getHeight() - bb.getHeight());
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop() + bo.getHeight(), bo.getWidth(), bb.getHeight());
                    break;
                }
                case 0: {
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop(), bo.getWidth(), bb.getHeight());
                    bo.setTop(bo.getTop() + bb.getHeight());
                    bo.setHeight(bo.getHeight() - bb.getHeight());
                    break;
                }
                case 2: {
                    bo.setWidth(bo.getWidth() - bb.getWidth());
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop(), bb.getWidth(), bo.getHeight());
                    bo.setLeft(bo.getLeft() + bb.getWidth());
                    break;
                }
                case 3: {
                    bo.setWidth(bo.getWidth() - bb.getWidth());
                    this.boTitleContainer.set(bo.getLeft() + bo.getWidth(), bo.getTop(), bb.getWidth(), bo.getHeight());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()).getString("exception.illegal.pie.series.title.position"), this.lpSeriesTitle));
                }
            }
        }
        if (!this.laDataPoint.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 13, "exception.unspecified.datapoint.visibility.pie", new Object[]{this.ps}, Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
        }
        if (this.lpDataPoint == Position.OUTSIDE_LITERAL) {
            if (this.laDataPoint.isVisible()) {
                Bounds boAdjusted = BoundsImpl.copyInstance((Bounds)bo);
                Insets insTrim = InsetsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
                do {
                    this.adjust(bo, boAdjusted, insTrim);
                    boAdjusted.adjust(insTrim);
                } while (!insTrim.areLessThan(0.5) && boAdjusted.getWidth() > 0.0 && boAdjusted.getHeight() > 0.0);
                bo = boAdjusted;
            }
        } else if (this.lpDataPoint == Position.INSIDE_LITERAL) {
            if (this.laDataPoint.isVisible()) {
                this.computeLabelsInsidePie(bo);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()).getString("exception.invalid.datapoint.position.pie"), this.lpDataPoint));
        }
        this.insCA = InsetsImpl.create((double)(bo.getTop() - this.boSetDuringComputation.getTop()), (double)(bo.getLeft() - this.boSetDuringComputation.getLeft()), (double)(this.boSetDuringComputation.getTop() + this.boSetDuringComputation.getHeight() - (bo.getTop() + bo.getHeight())), (double)(this.boSetDuringComputation.getLeft() + this.boSetDuringComputation.getWidth() - (bo.getLeft() + bo.getWidth())));
        this.bBoundsAdjustedForInsets = false;
    }

    final Insets getFittingInsets() {
        return this.insCA;
    }

    final void setFittingInsets(Insets insCA) throws IllegalArgumentException {
        this.insCA = insCA;
        if (!this.bBoundsAdjustedForInsets) {
            this.bBoundsAdjustedForInsets = true;
            this.boSetDuringComputation.adjust(insCA);
        }
        if (this.lpDataPoint == Position.OUTSIDE_LITERAL) {
            if (this.laDataPoint.isVisible()) {
                this.computeLabelsOutsidePie(this.boSetDuringComputation);
            }
        } else if (this.lpDataPoint == Position.INSIDE_LITERAL && this.laDataPoint.isVisible()) {
            this.computeLabelsInsidePie(this.boSetDuringComputation);
        }
    }

    public final void render(IDeviceRenderer idr, Bounds bo) throws ChartException {
        bo.adjust(this.insCA);
        this.xs = idr.getDisplayServer();
        this.idr = idr;
        if (!this.laSeriesTitle.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.pie.series.title.visibility", new Object[]{this.ps}, Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
        }
        ScriptHandler sh = this.pie.getRunTimeContext().getScriptHandler();
        double w = bo.getWidth() / 2.0 - this.dExplosion;
        double h = bo.getHeight() / 2.0 - this.dExplosion - this.dThickness / 2.0;
        double xc = bo.getLeft() + bo.getWidth() / 2.0;
        double yc = bo.getTop() + bo.getHeight() / 2.0;
        if (this.ratio > 0.0 && w > 0.0) {
            if (h / w > this.ratio) {
                h = w * this.ratio;
            } else if (h / w < this.ratio) {
                w = h / this.ratio;
            }
        }
        if (w > 0.0 && h > 0.0) {
            int i;
            double dStart = this.dStartAngle;
            int n = this.daAngleDelta.length;
            Fill fPaletteEntry = null;
            if (!this.bPaletteByCategory) {
                fPaletteEntry = this.getPaletteColor(this.pie.getSeriesDefinition().getRunTimeSeries().indexOf(this.ps));
            }
            if (this.dThickness > 0.0) {
                for (i = 0; i < n; ++i) {
                    if (this.bPaletteByCategory) {
                        fPaletteEntry = this.bMinSliceApplied && i == n - 1 ? this.getPaletteColor(this.orginalSliceCount) : this.getPaletteColor(this.categoryIndex[i]);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)this.dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)this.dpha[i], (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                    this.pie.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)this.dpha[i]);
                    this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)this.dpha[i]);
                    this.drawSlice(LocationImpl.create((double)xc, (double)yc), LocationImpl.create((double)0.0, (double)this.dThickness), SizeImpl.create((double)w, (double)h), new Range(dStart, this.daAngleDelta[i]), fPaletteEntry, this.dpha[i], 1, this.bExploded[i]);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)this.dpha[i], (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)this.dpha[i], (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                    this.pie.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)this.dpha[i]);
                    this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)this.dpha[i]);
                    dStart += this.daAngleDelta[i];
                }
                this.sortAndRenderPlanes();
            }
            dStart = this.dStartAngle;
            for (i = 0; i < n; ++i) {
                if (this.bPaletteByCategory) {
                    fPaletteEntry = this.bMinSliceApplied && i == n - 1 ? this.getPaletteColor(this.orginalSliceCount) : this.getPaletteColor(this.categoryIndex[i]);
                }
                this.drawSlice(LocationImpl.create((double)xc, (double)yc), LocationImpl.create((double)0.0, (double)this.dThickness), SizeImpl.create((double)w, (double)h), new Range(dStart, this.daAngleDelta[i]), fPaletteEntry, this.dpha[i], 2, this.bExploded[i]);
                dStart += this.daAngleDelta[i];
            }
        }
        ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawSeriesTitle", (Object)this.ps, (Object)this.laSeriesTitle, (Object)this.pie.getRunTimeContext().getScriptContext());
        this.pie.getRunTimeContext().notifyStructureChange("beforeDrawSeriesTitle", (Object)this.laSeriesTitle);
        if (this.laSeriesTitle.isVisible()) {
            TextRenderEvent tre = (TextRenderEvent)((EventObjectCache)idr).getEventObject((Object)WrappedStructureSource.createSeriesTitle((Series)this.ps, (Label)this.laSeriesTitle), TextRenderEvent.class);
            tre.setLabel(this.laSeriesTitle);
            tre.setBlockBounds(this.boTitleContainer);
            tre.setBlockAlignment(null);
            tre.setAction(3);
            idr.drawText(tre);
        }
        ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawSeriesTitle", (Object)this.ps, (Object)this.laSeriesTitle, (Object)this.pie.getRunTimeContext().getScriptContext());
        this.pie.getRunTimeContext().notifyStructureChange("afterDrawSeriesTitle", (Object)this.laSeriesTitle);
        try {
            this.renderDataPoints(idr);
        }
        catch (ChartException rex) {
            logger.log((Exception)((Object)rex));
        }
    }

    private static final int getQuadrant(double dAngle) {
        if (dAngle >= 0.0 && dAngle < 90.0) {
            return 1;
        }
        if (dAngle >= 90.0 && dAngle < 180.0) {
            return 2;
        }
        if (dAngle >= 180.0 && dAngle < 270.0) {
            return 3;
        }
        return 4;
    }

    private final void deferCurvedPlane(AreaRenderEvent areBentOrTwistedCurve, double dX1, double dX2) {
        this.alPlanes.add(new CurvedPlane(areBentOrTwistedCurve, dX1, dX2));
    }

    private final void deferFlatPlane(double[] daXPoints, double[] daYPoints, Fill cd, double dX1, double dX2, DataPointHints dph) {
        this.alPlanes.add(new FlatPlane(daXPoints, daYPoints, cd, dX1, dX2, dph));
    }

    private final void sortAndRenderPlanes() throws ChartException {
        int n = this.alPlanes.size();
        Collections.sort(this.alPlanes);
        for (int i = 0; i < n; ++i) {
            IDrawable id = (IDrawable)this.alPlanes.get(i);
            id.draw();
        }
        this.alPlanes.clear();
    }

    private final ColorDefinition getSliceOutline(Fill f) {
        if (this.ps.getSliceOutline() == null) {
            if (f instanceof ColorDefinition) {
                return ((ColorDefinition)f).darker();
            }
            return ColorDefinitionImpl.TRANSPARENT();
        }
        return ColorDefinitionImpl.copyInstance((ColorDefinition)this.ps.getSliceOutline());
    }

    private void initExploded() {
        this.bExploded = new boolean[this.dpha.length];
        Arrays.fill(this.bExploded, true);
        if (this.sExplosionExpression == null || !this.pie.getRunTimeContext().isScriptingEnabled()) {
            return;
        }
        for (int i = 0; i < this.dpha.length; ++i) {
            try {
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("categoryData", this.dpha[i].getBaseValue());
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("valueData", this.dpha[i].getOrthogonalValue());
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("valueSeriesName", this.dpha[i].getSeriesValue());
                Object obj = this.pie.getRunTimeContext().getScriptHandler().evaluate(this.sExplosionExpression);
                if (obj instanceof Boolean) {
                    this.bExploded[i] = (Boolean)obj;
                }
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("categoryData");
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("valueData");
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("valueSeriesName");
                continue;
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
            }
        }
    }

    private final void drawSlice(Location loC, Location loOffset, Size sz, Range r, Fill fi, DataPointHints dph, int iPieceType, boolean bExploded) throws ChartException {
        loC.translate(loOffset.getX() / 2.0, loOffset.getY() / 2.0);
        if (bExploded && this.dExplosion != 0.0) {
            double dMidAngleInRadians = Math.toRadians(r.dStartAngle + r.dAngleExtent / 2.0);
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            double xDelta = this.dExplosion * dCosThetaMid;
            double yDelta = this.dExplosion * dSineThetaMid;
            loC.translate(xDelta, -yDelta);
        }
        Location loCTop = LocationImpl.create((double)(loC.getX() - loOffset.getX()), (double)(loC.getY() - loOffset.getY()));
        double dAngleInRadians = Math.toRadians(r.dStartAngle);
        double dSineThetaStart = Math.sin(dAngleInRadians);
        double dCosThetaStart = Math.cos(dAngleInRadians);
        dAngleInRadians = Math.toRadians(r.dAngleExtent + r.dStartAngle);
        double dSineThetaEnd = Math.sin(dAngleInRadians);
        double dCosThetaEnd = Math.cos(dAngleInRadians);
        double xE = sz.getWidth() * dCosThetaEnd;
        double yE = sz.getHeight() * dSineThetaEnd;
        double xS = sz.getWidth() * dCosThetaStart;
        double yS = sz.getHeight() * dSineThetaStart;
        if (iPieceType == 1) {
            ArcRenderEvent are = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.setBackground(fi);
            this.liaEdges.setColor(this.getSliceOutline(fi));
            are.setOutline(this.liaEdges);
            are.setTopLeft(LocationImpl.create((double)(loCTop.getX() - sz.getWidth()), (double)(loCTop.getY() - sz.getHeight() + this.dThickness)));
            are.setWidth(sz.getWidth() * 2.0);
            are.setHeight(sz.getHeight() * 2.0);
            are.setStartAngle(r.dStartAngle);
            are.setAngleExtent(r.dAngleExtent);
            are.setStyle(3);
            this.idr.fillArc(are);
            double[] daXPoints = new double[]{loC.getX(), loCTop.getX(), loCTop.getX() + xE, loC.getX() + xE};
            double[] daYPoints = new double[]{loC.getY(), loCTop.getY(), loCTop.getY() - yE, loC.getY() - yE};
            this.deferFlatPlane(daXPoints, daYPoints, fi, loC.getX(), loC.getX() + xE, dph);
            daXPoints = new double[]{loC.getX(), loC.getX() + xS, loCTop.getX() + xS, loCTop.getX()};
            daYPoints = new double[]{loC.getY(), loC.getY() - yS, loCTop.getY() - yS, loCTop.getY()};
            this.deferFlatPlane(daXPoints, daYPoints, fi, loC.getX(), loC.getX() + xS, dph);
            daXPoints = new double[]{loC.getX() + xS, loCTop.getX() + xS, loCTop.getX() + xE, loC.getX() + xE};
            daYPoints = new double[]{loC.getY() - yS, loCTop.getY() - yS, loCTop.getY() - yE, loC.getY() - yE};
            LineRenderEvent lre1 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            lre1.setStart(LocationImpl.create((double)(loC.getX() + xS), (double)(loC.getY() - yS)));
            lre1.setEnd(LocationImpl.create((double)(loCTop.getX() + xS), (double)(loCTop.getY() - yS)));
            LineRenderEvent lre2 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            lre2.setStart(LocationImpl.create((double)(loCTop.getX() + xE), (double)(loCTop.getY() - yE)));
            lre2.setEnd(LocationImpl.create((double)(loC.getX() + xE), (double)(loC.getY() - yE)));
            Bounds r2dd1 = BoundsImpl.create((double)(loCTop.getX() - sz.getWidth()), (double)(loCTop.getY() - sz.getHeight()), (double)(sz.getWidth() * 2.0), (double)(sz.getHeight() * 2.0));
            Bounds r2dd2 = BoundsImpl.create((double)(loC.getX() - sz.getWidth()), (double)(loC.getY() - sz.getHeight()), (double)(sz.getWidth() * 2.0), (double)(sz.getHeight() * 2.0));
            this.registerCurvedSurface(r2dd1, r2dd2, r.dStartAngle, r.dAngleExtent, lre1, lre2, fi, dph);
        } else if (iPieceType == 2) {
            EList elTriggers;
            ArcRenderEvent are = (ArcRenderEvent)((EventObjectCache)this.idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph), ArcRenderEvent.class);
            are.setBackground(fi);
            this.liaEdges.setColor(this.getSliceOutline(fi));
            are.setOutline(this.liaEdges);
            are.setTopLeft(LocationImpl.create((double)(loCTop.getX() - sz.getWidth()), (double)(loCTop.getY() - sz.getHeight())));
            are.setWidth(sz.getWidth() * 2.0);
            are.setHeight(sz.getHeight() * 2.0);
            are.setStartAngle(r.dStartAngle);
            are.setAngleExtent(r.dAngleExtent);
            are.setStyle(3);
            this.idr.fillArc(are);
            this.idr.drawArc(are);
            if (this.pie.isInteractivityEnabled() && !(elTriggers = this.ps.getTriggers()).isEmpty()) {
                StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph);
                InteractionEvent iev = (InteractionEvent)((EventObjectCache)this.idr).getEventObject((Object)iSource, InteractionEvent.class);
                for (int t = 0; t < elTriggers.size(); ++t) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                    this.pie.processTrigger(tg, iSource);
                    iev.addTrigger(tg);
                }
                iev.setHotSpot((PrimitiveRenderEvent)are);
                this.idr.enableInteraction(iev);
            }
        }
    }

    protected Gradient getDepthGradient(Fill cd) {
        if (cd instanceof Gradient) {
            return GradientImpl.create((ColorDefinition)((Gradient)cd).getStartColor().darker(), (ColorDefinition)((Gradient)cd).getEndColor().darker(), (double)((Gradient)cd).getDirection(), (boolean)((Gradient)cd).isCyclic());
        }
        return GradientImpl.create((ColorDefinition)(cd instanceof ColorDefinition ? ((ColorDefinition)cd).darker() : ColorDefinitionImpl.GREY()), (ColorDefinition)ColorDefinitionImpl.BLACK(), (double)0.0, (boolean)true);
    }

    private final void registerCurvedSurface(Bounds topBound, Bounds bottomBound, double dStartAngle, double dAngleExtent, LineRenderEvent lre1, LineRenderEvent lre2, Fill cd, DataPointHints dph) {
        if (dAngleExtent + dStartAngle > 180.0 && dStartAngle < 180.0) {
            LineRenderEvent lre3 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            lre3.setEnd(LocationImpl.create((double)bottomBound.getLeft(), (double)(bottomBound.getTop() + bottomBound.getHeight() / 2.0)));
            lre3.setStart(LocationImpl.create((double)topBound.getLeft(), (double)(topBound.getTop() + topBound.getHeight() / 2.0)));
            ArcRenderEvent are1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            ArcRenderEvent are2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are1.setBounds(topBound);
            are1.setStartAngle(dStartAngle);
            are1.setAngleExtent(180.0 - dStartAngle);
            are1.setStyle(1);
            are2.setBounds(bottomBound);
            are2.setStartAngle(180.0);
            are2.setAngleExtent(dStartAngle - 180.0);
            are2.setStyle(1);
            AreaRenderEvent are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.add((PrimitiveRenderEvent)lre1);
            are.add((PrimitiveRenderEvent)are1);
            are.add((PrimitiveRenderEvent)lre3);
            are.add((PrimitiveRenderEvent)are2);
            are.setOutline(LineAttributesImpl.create((ColorDefinition)this.getSliceOutline(cd), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            are.setBackground((Fill)this.getDepthGradient(cd));
            this.deferCurvedPlane(are, lre1.getStart().getX(), lre3.getStart().getX());
            are1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are1.setBounds(topBound);
            are1.setStartAngle(180.0);
            are1.setAngleExtent(dStartAngle + dAngleExtent - 180.0);
            are1.setStyle(1);
            are2.setBounds(bottomBound);
            are2.setStartAngle(dStartAngle + dAngleExtent);
            are2.setAngleExtent(180.0 - (dStartAngle + dAngleExtent));
            are2.setStyle(1);
            LineRenderEvent lre4 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            lre4.setStart(LocationImpl.copyInstance((Location)lre3.getEnd()));
            lre4.setEnd(LocationImpl.copyInstance((Location)lre3.getStart()));
            are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.add((PrimitiveRenderEvent)lre4);
            are.add((PrimitiveRenderEvent)are1);
            are.add((PrimitiveRenderEvent)lre2);
            are.add((PrimitiveRenderEvent)are2);
            are.setOutline(LineAttributesImpl.create((ColorDefinition)this.getSliceOutline(cd), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            are.setBackground((Fill)this.getDepthGradient(cd));
            this.deferCurvedPlane(are, lre4.getStart().getX(), lre2.getStart().getX());
        } else {
            ArcRenderEvent are1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            ArcRenderEvent are2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are1.setBounds(topBound);
            are1.setStartAngle(dStartAngle);
            are1.setAngleExtent(dAngleExtent);
            are1.setStyle(1);
            are2.setBounds(bottomBound);
            are2.setStartAngle(dStartAngle + dAngleExtent);
            are2.setAngleExtent(-dAngleExtent);
            are2.setStyle(1);
            AreaRenderEvent are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.add((PrimitiveRenderEvent)lre1);
            are.add((PrimitiveRenderEvent)are1);
            are.add((PrimitiveRenderEvent)lre2);
            are.add((PrimitiveRenderEvent)are2);
            are.setOutline(LineAttributesImpl.create((ColorDefinition)this.getSliceOutline(cd), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            are.setBackground((Fill)this.getDepthGradient(cd));
            this.deferCurvedPlane(are, lre1.getStart().getX(), lre2.getStart().getX());
        }
    }

    private final Fill getPaletteColor(int iIndex) {
        Fill fiClone = (Fill)EcoreUtil.copy((EObject)((Fill)this.pa.getEntries().get(iIndex % this.pa.getEntries().size())));
        this.pie.updateTranslucency(fiClone, (Series)this.ps);
        return fiClone;
    }

    static {
        $assertionsDisabled = !PieRenderer.class.desiredAssertionStatus();
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    }

    private final class LeaderLine2D {
        private final Location loPie;
        private final Location loStart;
        private final Location loEnd;
        private BoundingBox bbDataPoint = null;
        private String sValue = null;
        private int iQuadrant = -1;

        LeaderLine2D(double dX0, double dY0, double dX1, double dY1, double dX2, double dY2) {
            this.loPie = LocationImpl.create((double)dX0, (double)dY0);
            this.loStart = LocationImpl.create((double)dX1, (double)dY1);
            this.loEnd = LocationImpl.create((double)dX2, (double)dY2);
        }

        LeaderLine2D(Location loPie, Location loStart, Location loEnd) {
            this.loPie = loPie;
            this.loStart = loStart;
            this.loEnd = loEnd;
        }

        final void setBounds(BoundingBox bb) {
            this.bbDataPoint = bb;
        }

        final BoundingBox getBounds() {
            return this.bbDataPoint;
        }

        final void setQuadrant(int iQuadrant) {
            this.iQuadrant = iQuadrant;
        }

        final void setValue(String sValue) {
            this.sValue = sValue;
        }

        final String getValue() {
            return this.sValue;
        }

        private final void render(IDeviceRenderer idr, int iTextRenderType, DataPointHints dph) throws ChartException {
            if (this.iQuadrant != -1) {
                if (iTextRenderType == 2) {
                    LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)dph), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? (class$org$eclipse$birt$chart$event$LineRenderEvent = PieRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent")) : class$org$eclipse$birt$chart$event$LineRenderEvent);
                    lre.setLineAttributes(PieRenderer.this.liaLL);
                    lre.setStart(this.loPie);
                    lre.setEnd(this.loStart);
                    idr.drawLine(lre);
                    lre = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)dph), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? (class$org$eclipse$birt$chart$event$LineRenderEvent = PieRenderer.class$("org.eclipse.birt.chart.event.LineRenderEvent")) : class$org$eclipse$birt$chart$event$LineRenderEvent);
                    lre.setLineAttributes(PieRenderer.this.liaLL);
                    lre.setStart(this.loStart);
                    lre.setEnd(this.loEnd);
                    idr.drawLine(lre);
                }
                PieRenderer.this.laDataPoint.getCaption().setValue(this.sValue);
                PieRenderer.this.pie.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)dph), 3, PieRenderer.this.laDataPoint, this.iQuadrant == 1 || this.iQuadrant == 4 ? Position.RIGHT_LITERAL : Position.LEFT_LITERAL, this.loEnd, BoundsImpl.create((double)this.bbDataPoint.getLeft(), (double)this.bbDataPoint.getTop(), (double)this.bbDataPoint.getWidth(), (double)this.bbDataPoint.getHeight()));
            } else {
                PieRenderer.this.laDataPoint.getCaption().setValue(this.sValue);
                PieRenderer.this.pie.renderLabel(StructureSource.createSeries((Series)PieRenderer.this.ps), 3, PieRenderer.this.laDataPoint, null, null, BoundsImpl.create((double)this.bbDataPoint.getLeft(), (double)this.bbDataPoint.getTop(), (double)this.bbDataPoint.getWidth(), (double)this.bbDataPoint.getHeight()));
            }
        }
    }

    private static interface IDrawable {
        public void draw() throws ChartException;

        public Bounds getBounds();
    }

    private final class FlatPlane
    implements Comparable,
    IDrawable {
        private final double[] _daXPoints;
        private final double[] _daYPoints;
        private Fill _cd;
        private final Bounds _bo;
        private DataPointHints _dph;

        FlatPlane(double[] daXPoints, double[] daYPoints, Fill cd, double dX1, double dX2, DataPointHints dph) {
            this._daXPoints = daXPoints;
            this._daYPoints = daYPoints;
            this._dph = dph;
            int n = this._daXPoints.length;
            double dMinX = 0.0;
            double dMinY = 0.0;
            double dMaxX = 0.0;
            double dMaxY = 0.0;
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    dMinX = this._daXPoints[i];
                    dMinY = this._daYPoints[i];
                    dMaxX = dMinX;
                    dMaxY = dMinY;
                    continue;
                }
                if (dMinX > this._daXPoints[i]) {
                    dMinX = this._daXPoints[i];
                }
                if (dMinY > this._daYPoints[i]) {
                    dMinY = this._daYPoints[i];
                }
                if (dMaxX < this._daXPoints[i]) {
                    dMaxX = this._daXPoints[i];
                }
                if (!(dMaxY < this._daYPoints[i])) continue;
                dMaxY = this._daYPoints[i];
            }
            this._bo = BoundsImpl.create((double)dMinX, (double)dMinY, (double)(dMaxX - dMinX), (double)(dMaxY - dMinY));
            this._cd = cd;
            int nPoints = this._daXPoints.length;
            int[] iaX = new int[nPoints];
            int[] iaY = new int[nPoints];
            for (int i = 0; i < nPoints; ++i) {
                iaX[i] = (int)daXPoints[i];
                iaY[i] = (int)daYPoints[i];
            }
        }

        public Bounds getBounds() {
            return this._bo;
        }

        public final void draw() throws ChartException {
            PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)PieRenderer.this.idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this._dph), class$org$eclipse$birt$chart$event$PolygonRenderEvent == null ? (class$org$eclipse$birt$chart$event$PolygonRenderEvent = PieRenderer.class$("org.eclipse.birt.chart.event.PolygonRenderEvent")) : class$org$eclipse$birt$chart$event$PolygonRenderEvent);
            pre.setPoints(this.toLocationArray());
            PieRenderer.this.liaEdges.setColor(PieRenderer.this.getSliceOutline(this._cd));
            pre.setOutline(PieRenderer.this.liaEdges);
            pre.setBackground((Fill)PieRenderer.this.getDepthGradient(this._cd));
            PieRenderer.this.idr.fillPolygon(pre);
            PieRenderer.this.idr.drawPolygon(pre);
        }

        public final int compareTo(Object o) {
            FlatPlane pi1 = this;
            if (o instanceof FlatPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                FlatPlane pi2 = (FlatPlane)o;
                double dMinY1 = pi1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = pi2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : (dDiff > 0.0 ? 1 : 0);
                }
                double dMaxY1 = pi1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = pi2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = pi1.getMinX();
                dDiff = dMinX1 - (dMinX2 = pi2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = pi1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = pi2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            if (o instanceof CurvedPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                CurvedPlane pi2 = (CurvedPlane)o;
                double dMinY1 = pi1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = pi2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxY1 = pi1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = pi2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = pi1.getMinX();
                dDiff = dMinX1 - (dMinX2 = pi2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = pi1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = pi2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            return 0;
        }

        private final double getMinY() {
            return this._bo.getTop();
        }

        private final double getMinX() {
            return this._bo.getLeft();
        }

        private final double getMaxX() {
            return this._bo.getLeft() + this._bo.getWidth();
        }

        private final double getMaxY() {
            return this._bo.getTop() + this._bo.getHeight();
        }

        private final Location[] toLocationArray() {
            int n = this._daXPoints.length;
            Location[] loa = new Location[n];
            for (int i = 0; i < n; ++i) {
                loa[i] = LocationImpl.create((double)this._daXPoints[i], (double)this._daYPoints[i]);
            }
            return loa;
        }
    }

    private final class CurvedPlane
    implements Comparable,
    IDrawable {
        private final AreaRenderEvent _are;
        private final Bounds _bo;

        CurvedPlane(AreaRenderEvent are, double dX1, double dX2) {
            this._are = are;
            this._bo = are.getBounds();
        }

        public final Bounds getBounds() {
            return this._bo;
        }

        public final int compareTo(Object o) {
            CurvedPlane cp1 = this;
            if (o instanceof CurvedPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                CurvedPlane cp2 = (CurvedPlane)o;
                double dMinY1 = cp1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = cp2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : (dDiff > 0.0 ? 1 : 0);
                }
                double dMaxY1 = cp1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = cp2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = cp1.getMinX();
                dDiff = dMinX1 - (dMinX2 = cp2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = cp1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = cp2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            if (o instanceof FlatPlane) {
                FlatPlane pi2 = (FlatPlane)o;
                return pi2.compareTo(cp1) * -1;
            }
            return 0;
        }

        public final void draw() throws ChartException {
            PieRenderer.this.idr.fillArea(this._are);
            PieRenderer.this.idr.drawArea(this._are);
        }

        private final double getMinY() {
            return this._bo.getTop();
        }

        private final double getMinX() {
            return this._bo.getLeft();
        }

        private final double getMaxX() {
            return this._bo.getLeft() + this._bo.getWidth();
        }

        private final double getMaxY() {
            return this._bo.getTop() + this._bo.getHeight();
        }
    }

    private static final class Range {
        double dStartAngle;
        double dAngleExtent;

        Range(double _dStartAngle, double _dEndAngle) {
            this.dStartAngle = _dStartAngle;
            this.dAngleExtent = _dEndAngle;
        }
    }
}

