/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class ScanResultSet
extends NoPutResultSetImpl {
    private final boolean tableLocked;
    private final boolean unspecifiedIsolationLevel;
    private final int suppliedLockMode;
    private boolean isolationLevelNeedsUpdate;
    int lockMode;
    int isolationLevel;
    final ExecRow candidate;

    ScanResultSet(Activation activation, int n, GeneratedMethod generatedMethod, int n2, boolean bl, int n3, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.tableLocked = bl;
        this.suppliedLockMode = n2;
        if (n3 == 0) {
            this.unspecifiedIsolationLevel = true;
            n3 = this.lcc.getCurrentIsolationLevel();
        } else {
            this.unspecifiedIsolationLevel = false;
        }
        this.lockMode = this.getLockMode(n3);
        this.isolationLevel = this.translateLanguageIsolationLevel(n3);
        this.candidate = (ExecRow)generatedMethod.invoke(activation);
    }

    void initIsolationLevel() {
        if (this.isolationLevelNeedsUpdate) {
            int n = this.lcc.getCurrentIsolationLevel();
            this.lockMode = this.getLockMode(n);
            this.isolationLevel = this.translateLanguageIsolationLevel(n);
            this.isolationLevelNeedsUpdate = false;
        }
    }

    private int getLockMode(int n) {
        if (this.tableLocked || n == 4) {
            return this.suppliedLockMode;
        }
        return 6;
    }

    private int translateLanguageIsolationLevel(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                if (!this.canGetInstantaneousLocks()) {
                    return 2;
                }
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    abstract boolean canGetInstantaneousLocks();

    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    public void close() throws StandardException {
        this.isolationLevelNeedsUpdate = this.unspecifiedIsolationLevel;
        this.candidate.resetRowArray();
        super.close();
    }
}

