/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import com.ibm.icu.util.ULocale;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.util.DeviceUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;

public final class SwingEventHandler
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");
    private Action acTooltip = null;
    private ShapedAction saHighlighted = null;
    private final Map lhmAllTriggers;
    private final IUpdateNotifier iun;
    private final ULocale lcl;

    SwingEventHandler(Map _lhmAllTriggers, IUpdateNotifier _jc, ULocale _lcl) {
        this.lhmAllTriggers = _lhmAllTriggers;
        this.iun = _jc;
        this.lcl = _lcl;
    }

    private final boolean isLeftButton(MouseEvent e) {
        return (e.getButton() & 1) == 1;
    }

    private final ShapedAction getShapedActionForConditionPoint(TriggerCondition[] tca, Point p) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        for (int i = 0; i < tca.length; ++i) {
            List tal = (List)this.lhmAllTriggers.get(tca[i]);
            if (tal == null) continue;
            for (int j = tal.size() - 1; j >= 0; --j) {
                ShapedAction sa = (ShapedAction)tal.get(j);
                if (p != null && !sa.getShape().contains(p)) continue;
                return sa;
            }
        }
        return null;
    }

    private void handleAction(TriggerCondition[] tg, InputEvent event) {
        this.handleAction(tg, event, true);
    }

    private synchronized void handleAction(TriggerCondition[] tg, InputEvent event, boolean cleanState) {
        ShapedAction sa;
        if (tg == null || event == null) {
            return;
        }
        Point p = null;
        if (event instanceof MouseEvent) {
            p = ((MouseEvent)event).getPoint();
        }
        if (event instanceof KeyEvent) {
            // empty if block
        }
        if ((sa = this.getShapedActionForConditionPoint(tg, p)) == null) {
            return;
        }
        StructureSource src = sa.getSource();
        Action ac = null;
        for (int i = 0; i < tg.length && (ac = sa.getActionForCondition(tg[i])) == null; ++i) {
        }
        if (ac == null) {
            return;
        }
        boolean bFound = false;
        switch (ac.getType().getValue()) {
            case 0: {
                URLValue uv = (URLValue)ac.getValue();
                logger.log(1, Messages.getString("SwingEventHandler.info.redirect.url", this.lcl) + uv.getBaseUrl());
                DeviceUtil.openURL(uv.getBaseUrl());
                break;
            }
            case 1: {
                if (ac != this.acTooltip) {
                    this.hideTooltip();
                }
                bFound = true;
                this.showTooltip(ac);
                break;
            }
            case 2: {
                if (src.getType() != StructureType.SERIES && src.getType() != StructureType.SERIES_DATA_POINT) break;
                Series seRT = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
                logger.log(1, Messages.getString("SwingEventHandler.info.toggle.visibility", this.lcl) + seRT);
                Series seDT = null;
                try {
                    seDT = this.findDesignTimeSeries(seRT);
                }
                catch (ChartException oosx) {
                    logger.log((Exception)((Object)oosx));
                    return;
                }
                seDT.setVisible(!seDT.isVisible());
                this.iun.regenerateChart();
                break;
            }
            case 6: {
                if (src.getType() != StructureType.SERIES && src.getType() != StructureType.SERIES_DATA_POINT) break;
                Series seRT = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
                logger.log(1, Messages.getString("SwingEventHandler.info.toggle.datapoint.visibility", this.lcl) + seRT);
                Series seDT = null;
                try {
                    seDT = this.findDesignTimeSeries(seRT);
                }
                catch (ChartException oosx) {
                    logger.log((Exception)((Object)oosx));
                    return;
                }
                seDT.getLabel().setVisible(!seDT.getLabel().isVisible());
                this.iun.regenerateChart();
                break;
            }
            case 4: {
                boolean newRegion;
                bFound = true;
                boolean bl = newRegion = this.saHighlighted == null;
                if (!(newRegion || p != null && this.saHighlighted.getShape().contains(p))) {
                    newRegion = true;
                }
                if (!newRegion) break;
                this.saHighlighted = sa;
                this.toggleHighlight(sa);
                break;
            }
            case 5: {
                if (this.iun instanceof ICallBackNotifier) {
                    CallBackValue cv = (CallBackValue)ac.getValue();
                    ((ICallBackNotifier)this.iun).callback((Object)event, (Object)sa.getSource(), cv);
                    break;
                }
                logger.log(2, Messages.getString("SwingEventHandler.info.improper.callback.notifier", new Object[]{this.iun}, this.lcl));
            }
        }
        if (!bFound && this.acTooltip != null) {
            this.hideTooltip();
            this.acTooltip = null;
        }
        if (cleanState || !bFound && this.saHighlighted != null) {
            this.saHighlighted = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONCLICK_LITERAL}, e);
    }

    private final Series findDesignTimeSeries(Series seRT) throws ChartException {
        Series seDT = null;
        Chart cmRT = this.iun.getRunTimeModel();
        Chart cmDT = this.iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithAxes cwaRT = (ChartWithAxes)cmRT;
            ChartWithAxes cwaDT = (ChartWithAxes)cmDT;
            Axis[] axaBase = cwaRT.getPrimaryBaseAxes();
            Axis axBase = axaBase[0];
            Axis[] axaOrthogonal = cwaRT.getOrthogonalAxes(axBase, true);
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = axaBase[0].getSeriesDefinitions();
            for (j = 0; j < elSD.size(); ++j) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                for (k = 0; k < elSE.size(); ++k) {
                    se = (Series)elSE.get(k);
                    if (seRT != se) continue;
                    bFound = true;
                    break;
                }
                if (bFound) break;
            }
            if (!bFound) {
                for (i = 0; i < axaOrthogonal.length; ++i) {
                    elSD = axaOrthogonal[i].getSeriesDefinitions();
                    for (j = 0; j < elSD.size(); ++j) {
                        sd = (SeriesDefinition)elSD.get(j);
                        elSE = sd.getSeries();
                        for (k = 0; k < elSE.size(); ++k) {
                            se = (Series)elSE.get(k);
                            if (seRT != se) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) break;
                    }
                    if (bFound) break;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 8, "SwingEventHandler.info.cannot.find.series", new Object[]{seRT}, Messages.getResourceBundle(this.lcl));
            }
            axaBase = cwaDT.getPrimaryBaseAxes();
            axBase = axaBase[0];
            axaOrthogonal = cwaDT.getOrthogonalAxes(axBase, true);
            elSD = i == -1 ? axaBase[0].getSeriesDefinitions() : axaOrthogonal[i].getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        } else if (cmDT instanceof ChartWithoutAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithoutAxes cwoaRT = (ChartWithoutAxes)cmRT;
            ChartWithoutAxes cwoaDT = (ChartWithoutAxes)cmDT;
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = cwoaRT.getSeriesDefinitions();
            for (j = 0; j < elSD.size(); ++j) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                for (k = 0; k < elSE.size(); ++k) {
                    se = (Series)elSE.get(k);
                    if (seRT != se) continue;
                    bFound = true;
                    break;
                }
                if (bFound) break;
            }
            if (!bFound) {
                i = 1;
                elSD = ((SeriesDefinition)cwoaRT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
                for (j = 0; j < elSD.size(); ++j) {
                    sd = (SeriesDefinition)elSD.get(j);
                    elSE = sd.getSeries();
                    for (k = 0; k < elSE.size(); ++k) {
                        se = (Series)elSE.get(k);
                        if (seRT != se) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) break;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 8, "SwingEventHandler.info.cannot.find.series", new Object[]{seRT}, Messages.getResourceBundle(this.lcl));
            }
            elSD = i == -1 ? cwoaDT.getSeriesDefinitions() : ((SeriesDefinition)cwoaDT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        }
        return seDT;
    }

    private Series findCategorySeries(Series seDT) {
        Chart cmDT = this.iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            return (Series)((SeriesDefinition)((ChartWithAxes)cmDT).getBaseAxes()[0].getSeriesDefinitions().get(0)).getSeries().get(0);
        }
        return (Series)((SeriesDefinition)((ChartWithoutAxes)cmDT).getSeriesDefinitions().get(0)).getSeries().get(0);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEDOWN_LITERAL}, e);
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONMOUSEUP_LITERAL}, e);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        ShapedAction sa = this.getShapedActionForConditionPoint(new TriggerCondition[]{TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONCLICK_LITERAL, TriggerCondition.ONMOUSEDOWN_LITERAL}, p);
        if (sa != null) {
            ((JComponent)this.iun.peerInstance()).setCursor(Cursor.getPredefinedCursor(12));
        } else {
            ((JComponent)this.iun.peerInstance()).setCursor(Cursor.getDefaultCursor());
        }
        this.handleAction(new TriggerCondition[]{TriggerCondition.MOUSE_HOVER_LITERAL, TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL}, e, false);
    }

    public void keyPressed(KeyEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONKEYDOWN_LITERAL}, e);
    }

    public void keyReleased(KeyEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONKEYUP_LITERAL, TriggerCondition.ONKEYPRESS_LITERAL}, e);
    }

    public void keyTyped(KeyEvent e) {
    }

    private final void hideTooltip() {
        ((JComponent)this.iun.peerInstance()).setToolTipText(null);
    }

    private final void showTooltip(Action ac) {
        TooltipValue tv = (TooltipValue)ac.getValue();
        String tooltip = tv.getText().replaceAll("\\\n", "<br>");
        tooltip = !tooltip.equals(tv.getText()) ? "<html>" + tooltip + "</html>" : tv.getText();
        ((JComponent)this.iun.peerInstance()).setToolTipText(tooltip);
    }

    private final void toggleHighlight(ShapedAction sa) {
        if (sa == null) {
            return;
        }
        StructureSource src = sa.getSource();
        if (src.getType() == StructureType.SERIES || src.getType() == StructureType.SERIES_DATA_POINT) {
            Series seRT = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
            logger.log(1, Messages.getString("SwingEventHandler.info.toggle.visibility", this.lcl) + seRT);
            Series seDT = null;
            SeriesDefinition sdDT = null;
            try {
                seDT = this.findDesignTimeSeries(seRT);
                if (seDT.eContainer() instanceof SeriesDefinition) {
                    sdDT = (SeriesDefinition)seDT.eContainer();
                }
            }
            catch (ChartException oosx) {
                logger.log((Exception)((Object)oosx));
                return;
            }
            boolean highlight = this.iun.getContext((Object)seDT) == null;
            boolean changed = false;
            if (seDT != null) {
                changed = this.performHighlight(seDT, highlight);
            }
            if (sdDT != null) {
                Iterator itr = sdDT.getSeriesPalette().getEntries().iterator();
                while (itr.hasNext()) {
                    Object entry = itr.next();
                    if (!(entry instanceof ColorDefinition)) continue;
                    this.performHighlight((ColorDefinition)entry, highlight);
                    changed = true;
                }
            }
            if (highlight) {
                if (this.iun.getContext((Object)seDT) == null) {
                    this.iun.putContext((Object)seDT, (Object)Boolean.TRUE);
                }
            } else {
                this.iun.removeContext((Object)seDT);
            }
            if (changed) {
                this.iun.regenerateChart();
            }
        }
    }

    private boolean performHighlight(Series se, boolean highlighted) {
        Object context;
        boolean changed = false;
        List lineContext = highlighted ? new ArrayList() : ((context = this.iun.getContext((Object)se)) instanceof List ? (List)context : new ArrayList());
        int idx = 0;
        TreeIterator itr = se.eAllContents();
        while (itr.hasNext()) {
            Object context2;
            Object obj = itr.next();
            if (obj instanceof ColorDefinition && !(((ColorDefinition)obj).eContainer() instanceof LineAttributes)) {
                this.performHighlight((ColorDefinition)obj, highlighted);
                changed = true;
                continue;
            }
            if (!(obj instanceof LineAttributes)) continue;
            LineAttributes la = (LineAttributes)obj;
            if (highlighted) {
                int[] ls = new int[]{la.getThickness(), la.getColor().getRed(), la.getColor().getGreen(), la.getColor().getBlue(), la.getColor().getTransparency()};
                lineContext.add(ls);
                la.setThickness(3);
                la.getColor().set(255, 255, 255, 127);
                changed = true;
            } else if (idx < lineContext.size() && (context2 = lineContext.get(idx)) instanceof int[] && ((int[])context2).length > 4) {
                int[] ls = (int[])context2;
                la.setThickness(ls[0]);
                la.getColor().setRed(ls[1]);
                la.getColor().setGreen(ls[2]);
                la.getColor().setBlue(ls[3]);
                la.getColor().setTransparency(ls[4]);
                changed = true;
            }
            ++idx;
        }
        if (highlighted && lineContext.size() > 0) {
            this.iun.putContext((Object)se, lineContext);
        }
        return changed;
    }

    private void performHighlight(ColorDefinition cd, boolean highlighted) {
        if (cd != null) {
            if (highlighted) {
                cd.setRed((cd.getRed() + 255) / 2);
                cd.setGreen((cd.getGreen() + 255) / 2);
                cd.setBlue((cd.getBlue() + 255) / 2);
            } else {
                cd.setRed(Math.max(0, cd.getRed() * 2 - 255));
                cd.setGreen(Math.max(0, cd.getGreen() * 2 - 255));
                cd.setBlue(Math.max(0, cd.getBlue() * 2 - 255));
            }
        }
    }
}

