/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;

public class RptEndToEnd
extends RepositoryAccessor
implements GuiDataProvider {
    private static final short LD = 11;
    private static final String MOST_RECENT = "'" + Integer.toString(3) + "'";
    private static final String COMPUTER_TO_DISK_SS = " select distinct c.computer_id, sd.disk_id, c.host_name, ss_chunk.chunk_size,   ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name, ss.name,  vendor.vendor_name,   ss_pv.device_id, model.model_name, ss_pv.serial_number,  ss_chunk.offset, sv.unique_id  from  t_stat_disk sd , t_res_vendor vendor , t_res_model model ,       t_res_chunk ss_chunk , t_res_storage_subsystem ss , t_res_host c ,       t_res_view_ssluncmp ssluncmp ,       t_res_storage_volume sv , t_res_physical_volume ss_pv  where ssluncmp.svid = sv.svid       and ssluncmp.computer_id = c.computer_id       and ssluncmp.subsystem_id = ss.subsystem_id       and ss_pv.vendor_id=vendor.vendor_id       and ss_pv.model_id=model.model_id       and ss_pv.physical_volume_id = sd.disk_id       and ss_chunk.logical_disk_id = sv.svid       and ss_chunk.disk_id = ss_pv.physical_volume_id ";
    private static final String COMPUTER_TO_DISK_SVC = " select distinct c.computer_id, sd.disk_id, c.host_name, svc_chunk.chunk_size,   ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name, ss.name,  cast(null as char),   svc_se.element_name, cast(null as char), cast(null as char),  svc_chunk.offset, sv.unique_id  from  t_stat_disk sd , t_res_vendor vendor , t_res_model model ,       t_res_chunk svc_chunk , t_res_storage_subsystem ss , t_res_host c ,       t_res_view_ssluncmp ssluncmp ,       t_res_storage_volume sv , t_res_storage_extent svc_se  where ssluncmp.svid = sv.svid       and ssluncmp.computer_id = c.computer_id       and ssluncmp.subsystem_id = ss.subsystem_id       and ss.vendor_id=vendor.vendor_id       and ss.model_id=model.model_id       and svc_se.storage_extent_id = sd.disk_id       and svc_chunk.logical_disk_id = sv.svid       and svc_chunk.disk_id = svc_se.storage_extent_id ";
    private static final String LVID_SIMPLE_TO_DISK_SS = " select distinct ld.logical_disk_id, ss_chunk.chunk_size, ss.os_type,  case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name  else ss.display_name end display_name, ss.name, ss_pv.physical_volume_id,  ss_pv.device_id, vendor.vendor_name,  model.model_name, ss_pv.serial_number, ss_chunk.offset, sv.unique_id  from  t_res_logical_disk ld  , t_res_chunk ss_chunk  , t_res_chunk computer_chunk  , t_res_storage_subsystem ss  , t_res_vendor vendor  , t_res_model model  , t_res_view_ssluncmp ssluncmp  , t_res_physical_volume computer_pv  , t_res_physical_volume ss_pv  , t_res_storage_volume sv  where  ssluncmp.subsystem_id = ss.subsystem_id   and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and computer_pv.physical_volume_id = computer_chunk.disk_id and ld.logical_disk_id = computer_chunk.logical_disk_id  and sv.svid = ss_chunk.logical_disk_id  and ss_chunk.disk_id = ss_pv.physical_volume_id  and ss_pv.vendor_id = vendor.vendor_id  and ss_pv.model_id = model.model_id ";
    private static final String LVID_SIMPLE_TO_DISK_SVC = " select distinct ld.logical_disk_id, svc_chunk.chunk_size, ss.os_type,  case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name  else ss.display_name end display_name, ss.name, svc_se.storage_extent_id,  svc_se.element_name, cast(null as char),  cast(null as char), cast(null as char), svc_chunk.offset, sv.unique_id  from  t_res_logical_disk ld  , t_res_chunk svc_chunk  , t_res_chunk computer_chunk  , t_res_storage_subsystem ss  , t_res_vendor vendor  , t_res_model model  , t_res_view_ssluncmp ssluncmp  , t_res_physical_volume computer_pv  , t_res_storage_extent svc_se  , t_res_storage_volume sv  where  ssluncmp.subsystem_id = ss.subsystem_id   and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and computer_pv.physical_volume_id = computer_chunk.disk_id and ld.logical_disk_id = computer_chunk.logical_disk_id  and sv.svid = svc_chunk.logical_disk_id  and svc_chunk.disk_id = svc_se.storage_extent_id  and ss.vendor_id = vendor.vendor_id  and ss.model_id = model.model_id ";
    private static final String LVID_COMPOUND_TO_DISK = "select distinct l2.logical_disk_id, h1.chunk_size, c.os_type, c.host_url, cast(null as char), d1.disk_id, a.path, v.vendor_id, v.model_id,  case when v.subsystem_serial_number is not null then       v.subsystem_serial_number || '/' || v.serial_number  else v.serial_number end,  h1.offset, cast(null as char) from t_res_logical_disk l2, t_res_logical_disk l, t_res_chunk h1, t_res_chunk h2, t_stat_disk d1, t_stat_disk d2, t_res_share s, t_res_physical_volume v, t_res_dev_access a, t_res_host c where (l2.parent_logdisk_id <= 0) and (l.parent_logdisk_id = l2.logical_disk_id) and (h2.logical_disk_id = l.logical_disk_id) and (d2.disk_id = h2.disk_id) and (s.resource_type = 11) and (s.resource_id = d2.logical_disk_id) and (h1.logical_disk_id = s.resource_id) and (h1.logical_disk_id = d2.logical_disk_id) and (c.computer_id = s.computer_id) and (d1.disk_id = h1.disk_id) and (v.physical_volume_id = h1.disk_id) and (v.physical_volume_id = d1.disk_id) and (a.device_id = v.physical_volume_id) and (a.device_id = d1.disk_id)";
    private static final String FILESYSTEM_INFO = " select c.host_name, fs.mount_point, fs.capacity, fs.free_space,   fs.filesystem_id, vendor.vendor_name  from  t_res_host c  , t_res_filesystem fs  , t_res_chunk chunk  , t_res_physical_volume pv  , t_res_vendor vendor  where    (fs.logical_disk_id = ?)  and (c.computer_id = fs.computer_id)  and (fs.logical_disk_id = chunk.logical_disk_id)  and (chunk.disk_id = pv.physical_volume_id)  and (pv.vendor_id = vendor.vendor_id) ";
    private static final String LV_INFO = "select c.host_name, s.path,  l.capacity from t_res_host c, t_res_share s, t_res_logical_disk l where (s.resource_type = 11) and (l.logical_disk_id = s.resource_id) and (l.logical_disk_id = ?) and (s.resource_id = ?) and (l.parent_logdisk_id <= 0) and (c.computer_id = s.computer_id)";
    private static final String FILESYSTEM_SIMPLE_TO_LUN = "   select distinct fs2lun.logical_disk_id, fs2lun.sd_disk_id, host_name  \t,  ss_vendor_name, fs2lun.mount_point, fs2lun.fs_capacity   \t,  fs2lun.fs_free_space, fs2lun.filesystem_id , da_path   \t,  ss_os_type,  ss_display_name, ss_name    \t, share.name, sv_display_name,  sd_capacity    \t, sv_unique_id, sv_display_name, cimv_device_id    from   t_res_fs2lun fs2lun    \t\t,t_res_share share    where fs2lun.logical_disk_id = share.resource_id    \tand share.resource_type = 11 ";
    private static final String FILESYSTEM_COMPOUND_TO_LUN = "select distinct f.logical_disk_id, d.disk_id, c2.host_name, c1.vendor_id, f.mount_point, f.capacity, f.free_space, f.filesystem_id, a.path, c1.os_type, case when c1.user_provided_name is not null  and c1.user_provided_name not in ('')  then c1.user_provided_name  else c1.display_name end display_name, c1.name, share.name, share.path, d.capacity, sv.unique_id, sv.display_name, cimv.device_id  from t_res_filesystem f, t_res_storage_subsystem c1, t_res_host c2, t_res_share share, t_res_logical_disk l2, t_res_logical_disk l, t_res_chunk h, t_stat_disk d, t_res_dev_access a, t_res_controller n , t_res_vendor vendor  , t_res_view_ssluncmp ssluncmp  , t_res_storage_volume sv  , t_res_cimkey_volume cimv  where (l2.parent_logdisk_id <= 0) and (f.logical_disk_id = l2.logical_disk_id) and (l.parent_logdisk_id = l2.logical_disk_id) and (l.parent_logdisk_id = f.logical_disk_id) and (h.logical_disk_id = l.logical_disk_id) and (c2.computer_id = f.computer_id) and (d.disk_id = h.disk_id) and (a.device_id = d.disk_id) and (a.device_id = h.disk_id) and (n.computer_id = f.computer_id) and (n.computer_id = c2.computer_id) and ssluncmp.computer_id = c2.computer_id  and ssluncmp.svid = sv.svid  and sv.svid = cimv.volume_id  and ssluncmp.subsystem_id = c1.subsystem_id  and c1.vendor_id = vendor.vendor_id  and ssluncmp.physical_volume_id = d.disk_id  and ssluncmp.physical_volume_id = a.device_id  and (a.controller_id = n.controller_id) and (share.resource_type = 11) and (share.resource_id = d.logical_disk_id) and (c1.subsystem_id = share.computer_id)";
    private static final String LV_SIMPLE_TO_LUN = "   select distinct lv2lun.logical_disk_id, physical_volume_id  , host_name   \t, ss_vendor_name, share.path ,ld_capacity    \t,  da_path, ss_os_type, ss_display_name, ss_name, share.name    \t, sv_display_name, sd_capacity, sv_unique_id, sv_display_name,   cimv_device_id  from   t_res_lv2lun lv2lun         ,t_res_share share  where   share.resource_id = lv2lun.logical_disk_id  and share.computer_id = lv2lun.computer_id ";
    private static final String LV_COMPOUND_TO_LUN = "select distinct l2.logical_disk_id, d.disk_id, c2.host_name, c1.vendor_id, s2.path, l.capacity, a.path, c1.os_type, case when c1.user_provided_name is not null  and c1.user_provided_name not in ('')  then c1.user_provided_name else c1.display_name end display_name, c1.name,  share.name, share.path, d.capacity, sv.unique_id, sv.display_name, cimv.device_id  from t_res_logical_disk l2, t_res_logical_disk l, t_res_storage_subsystem c1, t_res_host c2, t_res_share share, t_res_share s2, t_res_dev_access a, t_res_chunk h, t_stat_disk d, t_res_controller n , t_res_vendor vendor  , t_res_view_ssluncmp ssluncmp  , t_res_storage_volume sv  , t_res_cimkey_volume cimv  where (l2.parent_logdisk_id <= 0) and (l.parent_logdisk_id = l2.logical_disk_id) and (s2.resource_type = 11) and (s2.resource_id = l2.logical_disk_id) and (s2.resource_id = l.parent_logdisk_id) and (c2.computer_id = s2.computer_id) and (h.logical_disk_id = l.logical_disk_id) and (d.disk_id = h.disk_id) and (a.device_id = d.disk_id) and (a.device_id = h.disk_id) and (n.computer_id = c2.computer_id) and (n.computer_id = s2.computer_id) and ssluncmp.computer_id = c2.computer_id  and ssluncmp.svid = sv.svid  and sv.svid = cimv.volume_id  and ssluncmp.subsystem_id = c1.subsystem_id  and c1.vendor_id = vendor.vendor_id  and ssluncmp.physical_volume_id = d.disk_id  and ssluncmp.physical_volume_id = a.device_id  and (a.controller_id = n.controller_id) and (share.resource_type = 11) and (c1.subsystem_id = share.computer_id) and (share.resource_id = d.logical_disk_id)";
    private static final String COMPUTER_TO_LUN = "  select \tdistinct comp2lun.computer_id, sd_disk_id, host_name   \t, da_path, ss_os_type, ss_display_name    \t, ss_name, ss_vendor_name, sv_display_name    \t, share.path, sd_capacity, sdh_free_space    \t, sv_unique_id, sv_display_name, cimv_device_id   from   \tt_res_comp2lun comp2lun    \t, t_res_share share   where \tcomp2lun.physical_volume_id = share.resource_id ";
    private static final String LVID_SIMPLE_TO_DISK_ARRAY = " select distinct ldisk.logical_disk_id,  ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, vendor.vendor_name  from  t_res_logical_disk ldisk  , t_res_chunk chunk  , t_res_host c  , t_res_physical_volume pv  , t_res_storage_subsystem ss  , t_res_vendor vendor  , t_res_view_ssluncmp ssluncmp  where ssluncmp.computer_id = c.computer_id  and pv.physical_volume_id=ssluncmp.physical_volume_id  and ssluncmp.subsystem_id=ss.subsystem_id  and pv.physical_volume_id = chunk.disk_id  and chunk.logical_disk_id = ldisk.logical_disk_id  and pv.vendor_id = vendor.vendor_id ";
    private static final String LVID_COMPOUND_TO_DISK_ARRAY = "select distinct l2.logical_disk_id, ss.os_type, case when ss.user_provided_name  is not null then ss.user_provided_name else ss.display_name end  display_name, ss.name, ss.vendor_id from t_res_logical_disk l2, t_res_logical_disk l, t_res_storage_subsystem ss, t_stat_disk d, t_res_chunk h, t_res_share s where (l2.parent_logdisk_id <= 0) and (l.parent_logdisk_id = l2.logical_disk_id) and (h.logical_disk_id = l.logical_disk_id) and (d.disk_id = h.disk_id) and (s.resource_type = 11) and (s.resource_id = d.logical_disk_id) and (ss.subsystem_id = s.computer_id)";
    private static final String COMPUTER_TO_DISK_ARRAY_SS = " select distinct c.computer_id, ss.subsystem_id, ssluncmp.lun_id,  ss_chunk.chunk_size, computer_sd.capacity, computer_sdh.free_space,  c.host_name, ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, ss_chunk.offset, ss_chunk.disk_id  from t_res_host c,  t_res_storage_subsystem ss,  t_res_storage_volume sv,  t_res_chunk ss_chunk,  t_res_view_ssluncmp ssluncmp,  t_res_physical_volume ss_pv,  t_res_physical_volume computer_pv,  t_stat_disk computer_sd,  t_stat_disk_hist computer_sdh  where ssluncmp.subsystem_id = ss.subsystem_id  and ssluncmp.computer_id = c.computer_id  and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and ss_pv.physical_volume_id = ss_chunk.disk_id  and computer_pv.physical_volume_id = computer_sd.disk_id  and computer_pv.physical_volume_id = computer_sdh.disk_id  and computer_sdh.statistic_type = " + MOST_RECENT + " " + " and sv.svid = ss_chunk.logical_disk_id ";
    private static final String COMPUTER_TO_DISK_ARRAY_SVC = " select distinct c.computer_id, ss.subsystem_id, ssluncmp.lun_id,  svc_chunk.chunk_size, computer_sd.capacity, computer_sdh.free_space,  c.host_name, ss.os_type, case when ss.user_provided_name is not null  and ss.user_provided_name not in ('')  then ss.user_provided_name else ss.display_name end display_name,  ss.name, svc_chunk.offset, svc_chunk.disk_id  from t_res_host c,  t_res_storage_subsystem ss,  t_res_storage_volume sv,  t_res_chunk svc_chunk,  t_res_view_ssluncmp ssluncmp,  t_res_storage_extent svc_se,  t_res_physical_volume computer_pv,  t_stat_disk computer_sd,  t_stat_disk_hist computer_sdh  where ssluncmp.subsystem_id = ss.subsystem_id  and ssluncmp.computer_id = c.computer_id  and ssluncmp.svid = sv.svid  and ssluncmp.physical_volume_id = computer_pv.physical_volume_id  and svc_se.storage_extent_id = svc_chunk.disk_id  and computer_pv.physical_volume_id = computer_sd.disk_id  and computer_pv.physical_volume_id = computer_sdh.disk_id  and computer_sdh.statistic_type = " + MOST_RECENT + " " + " and sv.svid = svc_chunk.logical_disk_id ";

    public RptEndToEnd(Connection connection) {
        super(connection);
        this.tableName = "t_res_storage_subsystem+";
    }

    private RespEndToEnd getFSAndLVInfo(RespEndToEnd respEndToEnd) throws GeneralException {
        RespEndToEnd respEndToEnd2 = null;
        RespEndToEnd respEndToEnd3 = null;
        RespEndToEnd respEndToEnd4 = null;
        int n = -1;
        this.selectStmt = this.prepareStmt(FILESYSTEM_INFO);
        while (respEndToEnd != null) {
            RespEndToEnd respEndToEnd5 = respEndToEnd.reeNext;
            if (respEndToEnd.reeLogicalDiskID != n) {
                n = respEndToEnd.reeLogicalDiskID;
                this.setPhase();
                try {
                    this.setInt(this.selectStmt, n);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (!this.nextResult()) {
                        respEndToEnd4 = null;
                    } else {
                        this.getPhase();
                        respEndToEnd4 = new RespEndToEnd();
                        respEndToEnd4.reeComputer = this.getString(this.resultSet);
                        respEndToEnd4.reeLVFSPath = this.getString(this.resultSet);
                        respEndToEnd4.reeCapacity = this.getLong(this.resultSet);
                        respEndToEnd4.reeFreeSpace = this.getLong(this.resultSet);
                        respEndToEnd4.reeFilesystemID = this.getLong(this.resultSet);
                        respEndToEnd4.reeManufacturer = this.getString(this.resultSet);
                        if (respEndToEnd4.reeManufacturer != null && respEndToEnd4.reeManufacturer.equals("HP")) {
                            respEndToEnd4.reeManufacturer = "Hewlett-Packard";
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.stmtType = 0;
                    this.sqlError(sQLException);
                }
                this.closeResultSet();
            }
            if (respEndToEnd4 == null) {
                respEndToEnd.reeNext = respEndToEnd2;
                respEndToEnd2 = respEndToEnd;
            } else {
                respEndToEnd.reeComputer = respEndToEnd4.reeComputer;
                respEndToEnd.reeLVFSPath = respEndToEnd4.reeLVFSPath;
                respEndToEnd.reeCapacity = respEndToEnd4.reeCapacity;
                respEndToEnd.reeFreeSpace = respEndToEnd4.reeFreeSpace;
                respEndToEnd.reeFilesystemID = respEndToEnd4.reeFilesystemID;
                respEndToEnd.reeManufacturer = respEndToEnd4.reeManufacturer;
                respEndToEnd.reeNext = respEndToEnd3;
                respEndToEnd3 = respEndToEnd;
            }
            respEndToEnd = respEndToEnd5;
        }
        this.closeSelect();
        if (respEndToEnd2 == null) {
            return respEndToEnd3;
        }
        respEndToEnd4 = null;
        n = -1;
        boolean bl = false;
        this.selectStmt = this.prepareStmt(LV_INFO);
        respEndToEnd = respEndToEnd2;
        while (respEndToEnd != null) {
            if (respEndToEnd.reeLogicalDiskID == n) {
                if (bl) {
                    respEndToEnd.reeComputer = respEndToEnd4.reeComputer;
                    respEndToEnd.reeLVFSPath = respEndToEnd4.reeLVFSPath;
                    respEndToEnd.reeCapacity = respEndToEnd4.reeCapacity;
                } else if (respEndToEnd4 != null) {
                    respEndToEnd4.reeNext = respEndToEnd.reeNext;
                } else {
                    respEndToEnd2 = respEndToEnd.reeNext;
                }
            } else {
                n = respEndToEnd.reeLogicalDiskID;
                this.setPhase();
                try {
                    this.setInt(this.selectStmt, n);
                    this.setInt(this.selectStmt, n);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    bl = this.nextResult();
                    if (!bl) {
                        if (respEndToEnd4 != null) {
                            respEndToEnd4.reeNext = respEndToEnd.reeNext;
                        } else {
                            respEndToEnd2 = respEndToEnd.reeNext;
                        }
                    } else {
                        this.getPhase();
                        respEndToEnd.reeComputer = this.getString(this.resultSet);
                        respEndToEnd.reeLVFSPath = this.getString(this.resultSet);
                        respEndToEnd.reeCapacity = this.getLong(this.resultSet);
                        respEndToEnd4 = respEndToEnd;
                    }
                }
                catch (SQLException sQLException) {
                    this.stmtType = 0;
                    this.sqlError(sQLException);
                }
                this.closeResultSet();
            }
            respEndToEnd = respEndToEnd.reeNext;
        }
        this.closeSelect();
        if (respEndToEnd4 != null) {
            respEndToEnd4.reeNext = respEndToEnd3;
        } else {
            respEndToEnd2 = respEndToEnd3;
        }
        return respEndToEnd2;
    }

    private StringBuffer lvToDiskSQL(String string, GuiReportReq guiReportReq, String string2, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(1000);
        } else {
            stringBuffer.append(" UNION ");
        }
        stringBuffer.append(string);
        String string3 = guiReportReq.reportSubtype == 76 ? (bl ? String.valueOf(string2) + ".logical_disk_id" : (bl2 ? "svc_se.storage_extent_id" : "ss_pv.physical_volume_id")) : String.valueOf(string2) + ".logical_disk_id";
        SQLUtil.appendInClause(stringBuffer, string3, guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        return stringBuffer;
    }

    private RespEndToEnd lvToDisk(GuiReportReq guiReportReq, RespEndToEnd respEndToEnd) throws GeneralException {
        StringBuffer stringBuffer = null;
        if (respEndToEnd == null) {
            stringBuffer = this.lvToDiskSQL(LVID_SIMPLE_TO_DISK_SS, guiReportReq, "ld", null, false, false);
            stringBuffer = this.lvToDiskSQL(LVID_SIMPLE_TO_DISK_SVC, guiReportReq, "ld", stringBuffer, false, true);
        } else {
            stringBuffer = this.lvToDiskSQL(LVID_COMPOUND_TO_DISK, guiReportReq, "l2", null, true, false);
        }
        stringBuffer.append(" order by 1, 4");
        String string = stringBuffer.toString();
        stringBuffer = null;
        int n = -1;
        int n2 = -1;
        this.setSQLText(string);
        RespEndToEnd respEndToEnd2 = null;
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(string);
            while (this.nextResult()) {
                this.getPhase();
                int n3 = this.getInt(this.resultSet);
                long l = this.getLong(this.resultSet);
                short s = this.getShort(this.resultSet);
                String string2 = this.getString(this.resultSet);
                String string3 = this.getString(this.resultSet);
                int n4 = this.getInt(this.resultSet);
                if (n3 != n || n4 != n2) {
                    n = n3;
                    n2 = n4;
                    if (respEndToEnd2 != null) {
                        respEndToEnd2.reeNext = respEndToEnd;
                        respEndToEnd = respEndToEnd2;
                    }
                    respEndToEnd2 = new RespEndToEnd();
                    respEndToEnd2.reeLogicalDiskID = n3;
                    respEndToEnd2.reeDiskArray = string2;
                    respEndToEnd2.reeDiskArrayName = string3;
                    respEndToEnd2.reeOSType = s;
                    respEndToEnd2.reeArraySidePath = this.getString(this.resultSet);
                    respEndToEnd2.reeManufacturer = this.getString(this.resultSet);
                    respEndToEnd2.reeModel = this.getString(this.resultSet);
                    respEndToEnd2.reeSerialNumber = this.getString(this.resultSet);
                    this.getLong(this.resultSet);
                    respEndToEnd2.reeUniqueID = this.getString(this.resultSet);
                }
                respEndToEnd2.reePhysicalAlloc += l;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        if (respEndToEnd2 != null) {
            respEndToEnd2.reeNext = respEndToEnd;
            respEndToEnd = respEndToEnd2;
        }
        return respEndToEnd;
    }

    private RespEndToEnd lvToDisk(GuiReportReq guiReportReq) throws GeneralException {
        RespEndToEnd respEndToEnd = this.lvToDisk(guiReportReq, null);
        if ((respEndToEnd = this.lvToDisk(guiReportReq, respEndToEnd)) != null) {
            respEndToEnd = this.getFSAndLVInfo(respEndToEnd);
        }
        return respEndToEnd;
    }

    private RespEndToEnd lvToDiskArray(GuiReportReq guiReportReq, String string, String string2, RespEndToEnd respEndToEnd) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(string);
        String string3 = guiReportReq.reportSubtype == 74 ? "ss.subsystem_id" : String.valueOf(string2) + ".logical_disk_id";
        SQLUtil.appendInClause(stringBuffer, string3, guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        stringBuffer.append(" order by 1");
        string = stringBuffer.toString();
        stringBuffer = null;
        this.setSQLText(string);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(string);
            while (this.nextResult()) {
                this.getPhase();
                RespEndToEnd respEndToEnd2 = new RespEndToEnd();
                respEndToEnd2.reeLogicalDiskID = this.getInt(this.resultSet);
                respEndToEnd2.reeOSType = this.getShort(this.resultSet);
                respEndToEnd2.reeDiskArray = this.getString(this.resultSet);
                respEndToEnd2.reeDiskArrayName = this.getString(this.resultSet);
                respEndToEnd2.reeManufacturer = this.getString(this.resultSet);
                respEndToEnd2.reeNext = respEndToEnd;
                respEndToEnd = respEndToEnd2;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        return respEndToEnd;
    }

    private RespEndToEnd lvToDiskArray(GuiReportReq guiReportReq) throws GeneralException {
        RespEndToEnd respEndToEnd = this.lvToDiskArray(guiReportReq, LVID_SIMPLE_TO_DISK_ARRAY, "ldisk", null);
        if ((respEndToEnd = this.lvToDiskArray(guiReportReq, LVID_COMPOUND_TO_DISK_ARRAY, "l2", respEndToEnd)) != null) {
            respEndToEnd = this.getFSAndLVInfo(respEndToEnd);
        }
        return respEndToEnd;
    }

    private RespEndToEnd lvToLUN(GuiReportReq guiReportReq, String string, String string2, RespEndToEnd respEndToEnd, Map map) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(string);
        String string3 = guiReportReq.reportSubtype == 75 ? "share.resource_id" : String.valueOf(string2) + ".logical_disk_id";
        SQLUtil.appendInClause(stringBuffer, string3, guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        stringBuffer.append(" order by 1, 2");
        string = stringBuffer.toString();
        stringBuffer = null;
        this.setSQLText(string);
        int n = -1;
        int n2 = -1;
        MutableInteger mutableInteger = new MutableInteger();
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(string);
            while (this.nextResult()) {
                this.getPhase();
                int n3 = this.getInt(this.resultSet);
                int n4 = this.getInt(this.resultSet);
                if (n3 == n && n4 == n2) continue;
                n = n3;
                n2 = n4;
                if (map != null) {
                    mutableInteger.value = n3;
                    if (map.get(mutableInteger) != null) continue;
                }
                RespEndToEnd respEndToEnd2 = new RespEndToEnd();
                respEndToEnd2.reeLogicalDiskID = n3;
                respEndToEnd2.reeComputer = this.getString(this.resultSet);
                respEndToEnd2.reeManufacturer = this.getString(this.resultSet);
                respEndToEnd2.reeLVFSPath = this.getString(this.resultSet);
                respEndToEnd2.reeCapacity = this.getLong(this.resultSet);
                if (map == null) {
                    respEndToEnd2.reeFreeSpace = this.getLong(this.resultSet);
                    respEndToEnd2.reeFilesystemID = this.getLong(this.resultSet);
                }
                respEndToEnd2.reeCompLUNPath = this.getString(this.resultSet);
                respEndToEnd2.reeOSType = this.getShort(this.resultSet);
                respEndToEnd2.reeDiskArray = this.getString(this.resultSet);
                respEndToEnd2.reeDiskArrayName = this.getString(this.resultSet);
                String string4 = this.getString(this.resultSet);
                if (SQLUtil.isNullString(string4)) {
                    respEndToEnd2.reeLUNWWN = null;
                    respEndToEnd2.reeArraySidePath = this.getString(this.resultSet);
                } else {
                    respEndToEnd2.reeLUNWWN = this.getString(this.resultSet);
                    respEndToEnd2.reeArraySidePath = string4;
                }
                if (respEndToEnd2.reeOSType == 14) {
                    respEndToEnd2.reeLUNWWN = null;
                }
                respEndToEnd2.reeLUNCapacity = this.getLong(this.resultSet);
                respEndToEnd2.reeUniqueID = this.getString(this.resultSet);
                String string5 = this.getString(this.resultSet);
                String string6 = this.getString(this.resultSet);
                if (respEndToEnd2.reeOSType == 25 || respEndToEnd2.reeOSType == 27 || respEndToEnd2.reeOSType == 15 || respEndToEnd2.reeOSType == 21) {
                    if (SQLUtil.isNullString(string5)) {
                        respEndToEnd2.reeArraySidePath = string6;
                        respEndToEnd2.reeLUNWWN = null;
                    } else {
                        respEndToEnd2.reeArraySidePath = string5;
                        respEndToEnd2.reeLUNWWN = string6;
                    }
                }
                respEndToEnd2.reeNext = respEndToEnd;
                respEndToEnd = respEndToEnd2;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        return respEndToEnd;
    }

    private RespEndToEnd lvToLUN(GuiReportReq guiReportReq) throws GeneralException {
        RespEndToEnd respEndToEnd = this.lvToLUN(guiReportReq, FILESYSTEM_SIMPLE_TO_LUN, "fs2lun", null, null);
        respEndToEnd = this.lvToLUN(guiReportReq, FILESYSTEM_COMPOUND_TO_LUN, "f", respEndToEnd, null);
        int n = -1;
        HashMap<MutableInteger, RespEndToEnd> hashMap = new HashMap<MutableInteger, RespEndToEnd>();
        RespEndToEnd respEndToEnd2 = respEndToEnd;
        while (respEndToEnd2 != null) {
            if (respEndToEnd2.reeLogicalDiskID != n) {
                n = respEndToEnd2.reeLogicalDiskID;
                MutableInteger mutableInteger = new MutableInteger(n);
                hashMap.put(mutableInteger, respEndToEnd2);
            }
            respEndToEnd2 = respEndToEnd2.reeNext;
        }
        respEndToEnd = this.lvToLUN(guiReportReq, LV_SIMPLE_TO_LUN, "lv2lun", respEndToEnd, hashMap);
        respEndToEnd = this.lvToLUN(guiReportReq, LV_COMPOUND_TO_LUN, "l2", respEndToEnd, hashMap);
        return respEndToEnd;
    }

    private StringBuffer computerToDiskSQL(String string, GuiReportReq guiReportReq, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(1000);
        } else {
            stringBuffer.append(" UNION ");
        }
        stringBuffer.append(string);
        String string2 = null;
        string2 = guiReportReq.reportSubtype == 76 ? "sd.disk_id" : "c.computer_id";
        SQLUtil.appendInClause(stringBuffer, string2, guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        return stringBuffer;
    }

    private RespEndToEnd computerToDisk(GuiReportReq guiReportReq) throws GeneralException {
        StringBuffer stringBuffer = this.computerToDiskSQL(COMPUTER_TO_DISK_SS, guiReportReq, null);
        stringBuffer = this.computerToDiskSQL(COMPUTER_TO_DISK_SVC, guiReportReq, stringBuffer);
        stringBuffer.append(" order by 1, 2");
        String string = stringBuffer.toString();
        stringBuffer = null;
        RespEndToEnd respEndToEnd = null;
        RespEndToEnd respEndToEnd2 = null;
        int n = -1;
        int n2 = -1;
        this.setSQLText(string);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(string);
            while (this.nextResult()) {
                this.getPhase();
                int n3 = this.getInt(this.resultSet);
                int n4 = this.getInt(this.resultSet);
                String string2 = this.getString(this.resultSet);
                long l = this.getLong(this.resultSet);
                if (n3 != n || n4 != n2) {
                    n = n3;
                    n2 = n4;
                    if (respEndToEnd2 != null) {
                        respEndToEnd2.reeNext = respEndToEnd;
                        respEndToEnd = respEndToEnd2;
                    }
                    respEndToEnd2 = new RespEndToEnd();
                    respEndToEnd2.reeComputer = string2;
                    respEndToEnd2.reeOSType = this.getShort(this.resultSet);
                    respEndToEnd2.reeDiskArray = this.getString(this.resultSet);
                    respEndToEnd2.reeDiskArrayName = this.getString(this.resultSet);
                    respEndToEnd2.reeManufacturer = this.getString(this.resultSet);
                    respEndToEnd2.reeArraySidePath = this.getString(this.resultSet);
                    respEndToEnd2.reeModel = this.getString(this.resultSet);
                    respEndToEnd2.reeSerialNumber = this.getString(this.resultSet);
                    this.getLong(this.resultSet);
                    respEndToEnd2.reeUniqueID = this.getString(this.resultSet);
                }
                respEndToEnd2.reePhysicalAlloc += l;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        if (respEndToEnd2 != null) {
            respEndToEnd2.reeNext = respEndToEnd;
            respEndToEnd = respEndToEnd2;
        }
        return respEndToEnd;
    }

    private RespEndToEnd computerToLUN(GuiReportReq guiReportReq) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(COMPUTER_TO_LUN);
        RespEndToEnd respEndToEnd = null;
        String string = guiReportReq.reportSubtype == 75 ? "share.resource_id" : "comp2lun.computer_id";
        SQLUtil.appendInClause(stringBuffer, string, guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        stringBuffer.append(" order by 1, 2");
        String string2 = stringBuffer.toString();
        stringBuffer = null;
        int n = -1;
        String string3 = "-1";
        this.setSQLText(string2);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(string2);
            while (this.nextResult()) {
                this.getPhase();
                int n2 = this.getInt(this.resultSet);
                String string4 = this.getString(this.resultSet);
                if (n2 == n && string4.compareTo(string3) == 0) continue;
                n = n2;
                string3 = string4;
                RespEndToEnd respEndToEnd2 = new RespEndToEnd();
                respEndToEnd2.reeComputer = this.getString(this.resultSet);
                respEndToEnd2.reeCompLUNPath = this.getString(this.resultSet);
                respEndToEnd2.reeOSType = this.getShort(this.resultSet);
                respEndToEnd2.reeDiskArray = this.getString(this.resultSet);
                respEndToEnd2.reeDiskArrayName = this.getString(this.resultSet);
                respEndToEnd2.reeManufacturer = this.getString(this.resultSet);
                String string5 = this.getString(this.resultSet);
                if (SQLUtil.isNullString(string5)) {
                    respEndToEnd2.reeArraySidePath = this.getString(this.resultSet);
                    respEndToEnd2.reeLUNWWN = null;
                } else {
                    respEndToEnd2.reeArraySidePath = string5;
                    respEndToEnd2.reeLUNWWN = this.getString(this.resultSet);
                }
                if (respEndToEnd2.reeOSType == 14) {
                    respEndToEnd2.reeLUNWWN = null;
                }
                respEndToEnd2.reeCapacity = this.getLong(this.resultSet);
                respEndToEnd2.reeFreeSpace = this.getLong(this.resultSet);
                respEndToEnd2.reeUniqueID = this.getString(this.resultSet);
                String string6 = this.getString(this.resultSet);
                String string7 = this.getString(this.resultSet);
                if (respEndToEnd2.reeOSType == 25 || respEndToEnd2.reeOSType == 27 || respEndToEnd2.reeOSType == 15 || respEndToEnd2.reeOSType == 21) {
                    if (SQLUtil.isNullString(string6)) {
                        respEndToEnd2.reeArraySidePath = string7;
                        respEndToEnd2.reeLUNWWN = null;
                    } else {
                        respEndToEnd2.reeArraySidePath = string6;
                        respEndToEnd2.reeLUNWWN = respEndToEnd2.reeOSType == 21 ? GuiUtil.getString((String)"STG0019T") : string7;
                    }
                }
                if (respEndToEnd2.reeFreeSpace > respEndToEnd2.reeCapacity) {
                    respEndToEnd2.reeFreeSpace = respEndToEnd2.reeCapacity;
                }
                respEndToEnd2.reeNext = respEndToEnd;
                respEndToEnd = respEndToEnd2;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        return respEndToEnd;
    }

    private StringBuffer computerToDiskArraySQL(String string, GuiReportReq guiReportReq, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(1000);
        } else {
            stringBuffer.append(" UNION ");
        }
        stringBuffer.append(string);
        String string2 = null;
        string2 = guiReportReq.reportSubtype == 74 ? "ss.subsystem_id" : "c.computer_id";
        SQLUtil.appendInClause(stringBuffer, string2, guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        return stringBuffer;
    }

    private RespEndToEnd computerToDiskArray(GuiReportReq guiReportReq) throws GeneralException {
        StringBuffer stringBuffer = this.computerToDiskArraySQL(COMPUTER_TO_DISK_ARRAY_SS, guiReportReq, null);
        stringBuffer = this.computerToDiskArraySQL(COMPUTER_TO_DISK_ARRAY_SVC, guiReportReq, stringBuffer);
        stringBuffer.append(" order by 1, 2, 3");
        String string = stringBuffer.toString();
        stringBuffer = null;
        RespEndToEnd respEndToEnd = null;
        int n = -1;
        int n2 = -1;
        String string2 = "-1";
        RespEndToEnd respEndToEnd2 = null;
        this.setSQLText(string);
        try {
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(string);
            while (this.nextResult()) {
                this.getPhase();
                int n3 = this.getInt(this.resultSet);
                int n4 = this.getInt(this.resultSet);
                String string3 = this.getString(this.resultSet);
                long l = this.getLong(this.resultSet);
                long l2 = this.getLong(this.resultSet);
                long l3 = this.getLong(this.resultSet);
                if (n3 != n || n4 != n2) {
                    n = n3;
                    n2 = n4;
                    string2 = "-1";
                    if (respEndToEnd2 != null) {
                        respEndToEnd2.reeNext = respEndToEnd;
                        respEndToEnd = respEndToEnd2;
                    }
                    respEndToEnd2 = new RespEndToEnd();
                    respEndToEnd2.reeComputer = this.getString(this.resultSet);
                    respEndToEnd2.reeOSType = this.getShort(this.resultSet);
                    respEndToEnd2.reeDiskArray = this.getString(this.resultSet);
                    respEndToEnd2.reeDiskArrayName = this.getString(this.resultSet);
                } else {
                    this.getString(this.resultSet);
                    this.getShort(this.resultSet);
                    this.getString(this.resultSet);
                    this.getString(this.resultSet);
                }
                this.getLong(this.resultSet);
                this.getInt(this.resultSet);
                if (string3.compareTo(string2) != 0) {
                    string2 = string3;
                    respEndToEnd2.reeCapacity += l2;
                    respEndToEnd2.reeFreeSpace += l3;
                }
                respEndToEnd2.reePhysicalAlloc += l;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        if (respEndToEnd2 != null) {
            respEndToEnd2.reeNext = respEndToEnd;
            respEndToEnd = respEndToEnd2;
        }
        return respEndToEnd;
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        RespEndToEnd respEndToEnd;
        int n;
        int n2;
        if (guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 73) {
            n2 = guiReportReq.reportSubtype;
            n = guiReportReq.bySubtype;
        } else {
            n2 = guiReportReq.bySubtype;
            n = guiReportReq.reportSubtype;
        }
        if (n2 == 73) {
            switch (n) {
                case 76: {
                    respEndToEnd = this.lvToDisk(guiReportReq);
                    break;
                }
                case 75: {
                    respEndToEnd = this.lvToLUN(guiReportReq);
                    break;
                }
                default: {
                    respEndToEnd = this.lvToDiskArray(guiReportReq);
                    break;
                }
            }
        } else {
            switch (n) {
                case 76: {
                    respEndToEnd = this.computerToDisk(guiReportReq);
                    break;
                }
                case 75: {
                    respEndToEnd = this.computerToLUN(guiReportReq);
                    break;
                }
                default: {
                    respEndToEnd = this.computerToDiskArray(guiReportReq);
                }
            }
        }
        RespEndToEnd respEndToEnd2 = respEndToEnd;
        if (respEndToEnd != null && guiReportReq.columnFilters != null) {
            respEndToEnd2 = null;
            ReportFilter reportFilter = new ReportFilter(guiReportReq, respEndToEnd);
            RespEndToEnd respEndToEnd3 = respEndToEnd;
            while (respEndToEnd != null) {
                respEndToEnd3 = respEndToEnd;
                respEndToEnd = respEndToEnd3.reeNext;
                RespEndToEnd respEndToEnd4 = (RespEndToEnd)respEndToEnd3.clone();
                if (!reportFilter.isSelected(respEndToEnd4)) continue;
                respEndToEnd3.reeNext = respEndToEnd2;
                respEndToEnd2 = respEndToEnd3;
            }
        }
        return (Serializable)Packer.pack((Packable)respEndToEnd2);
    }
}

