/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class RptPing
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private static final int REPLACE = 0;
    private static final int DISCARD = 1;
    private static final int KEEP = 2;
    private int groupID = Integer.MIN_VALUE;
    private PingReport resultList;
    private int totalRows;
    private GuiReportReq grr;
    private Timestamp tsNull = new Timestamp(0L);
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT_CLAUSE = "select p.monitor_start, p.monitor_end, p.transmitted, p.received, p.damaged, p.min_transit_time, p.max_transit_time, p.avg_transit_time, p.statistic_type, p.computer_id";
    private static final String SELECT_DISTINCT_CLAUSE = "select distinct p.monitor_start, p.monitor_end, p.transmitted, p.received, p.damaged, p.min_transit_time, p.max_transit_time, p.avg_transit_time, p.statistic_type, p.computer_id";
    private static final String FROM_CLAUSE = " from t_stat_ping_hist p";
    private static final String COMP_GROUP_JOIN = " p.computer_id = c.computer_id and c.computer_id = gr.resource_id and g.group_id    = gr.group_id";
    private static final String DOMAIN_JOIN = " p.computer_id = c.computer_id and c.domain_id = d.domain_id";
    private static final String SELECT_HIST_GRAPH = "select computer_id, monitor_end, statistic_type, transmitted, received, avg_transit_time from t_stat_ping_hist";
    private static final String COMPUTER_COL = "computer_id";

    public RptPing(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptPing", (String)"dbc");
        }
        this.tableName = "t_stat_ping_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptPing");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        PingReport pingReport;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = guiReportReq;
        if (guiReportReq.histSubtype > 0) {
            Serializable serializable = this.getHistoryGraphData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        PingReport pingReport2 = new PingReport();
        PingReport pingReport3 = null;
        this.totalRows = 0;
        int n = 0;
        String string = this.buildReportQuery();
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.selectStmt, 86400000L, this.tsNull);
            if (guiReportReq.startTime > 0L) {
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.fetch(pingReport2)) {
                if (n != pingReport2.pngComputerID || guiReportReq.reportSubtype == 13) {
                    if (pingReport3 == null) {
                        pingReport3 = new PingReport();
                    } else {
                        this.aggregate(pingReport3);
                    }
                    n = pingReport2.pngComputerID;
                    pingReport = pingReport2;
                    pingReport2 = pingReport3;
                    pingReport3 = pingReport;
                    continue;
                }
                int n2 = this.analyzeRow(pingReport2, pingReport3);
                switch (n2) {
                    case 2: {
                        this.aggregate(pingReport3);
                    }
                    case 0: {
                        PingReport pingReport4 = pingReport2;
                        pingReport2 = pingReport3;
                        pingReport3 = pingReport4;
                    }
                }
            }
            if (pingReport3 != null) {
                this.aggregate(pingReport3);
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (guiReportReq.columnFilters != null) {
            this.applyFilter(new ReportFilter(guiReportReq, pingReport2));
        }
        if (guiReportReq.isBatchReport && (guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 28)) {
            this.getComputerNames(this.resultList);
        }
        pingReport = this.packItUp((PingHist)this.resultList);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)pingReport);
        }
        return pingReport;
    }

    private String buildReportQuery() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"buildReportQuery", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        switch (this.grr.reportSubtype) {
            case 12: 
            case 28: {
                stringBuffer.append(SELECT_CLAUSE);
                stringBuffer.append(FROM_CLAUSE);
                this.appendWhereClause(stringBuffer, null, "p.computer_id");
                this.appendOrderByClause(stringBuffer, null);
                break;
            }
            case 13: 
            case 82: {
                stringBuffer.append(SELECT_DISTINCT_CLAUSE);
                stringBuffer.append(", g.group_id, g.creator, g.name");
                stringBuffer.append(FROM_CLAUSE);
                stringBuffer.append(", t_stat_computer c, t_group g, t_view_group2res gr ");
                this.appendWhereClause(stringBuffer, COMP_GROUP_JOIN, "g.group_id");
                if (this.grr.reportSubtype == 13) {
                    stringBuffer.append(" and g.group_type <> 99");
                } else {
                    stringBuffer.append(" and g.group_type = 99");
                }
                this.appendOrderByClause(stringBuffer, "g.group_id");
                break;
            }
            case 14: {
                stringBuffer.append(SELECT_CLAUSE);
                stringBuffer.append(", d.domain_id, d.name");
                stringBuffer.append(FROM_CLAUSE);
                stringBuffer.append(", t_stat_computer c, t_res_domain d");
                this.appendWhereClause(stringBuffer, DOMAIN_JOIN, "d.domain_id");
                this.appendOrderByClause(stringBuffer, "d.domain_id");
                break;
            }
            default: {
                stringBuffer.append(SELECT_CLAUSE);
                stringBuffer.append(FROM_CLAUSE);
                this.appendWhereClause(stringBuffer, null, null);
                this.appendOrderByClause(stringBuffer, null);
            }
        }
        String string = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"buildReportQuery", (Object)string);
        }
        return string;
    }

    private void appendWhereClause(StringBuffer stringBuffer, String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendWhereClause", (String)"buffer, joinCondition, inColumn");
        }
        stringBuffer.append(" where p.monitor_start > ?");
        if (this.grr.startTime > 0L) {
            stringBuffer.append(" and p.monitor_start >= ? and p.monitor_end <= ? ");
        }
        if (string != null) {
            stringBuffer.append(" and ");
            stringBuffer.append(string);
        }
        SQLUtil.appendInClause(stringBuffer, string2, this.grr.selectedResources, this.grr.isResourceInList, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendWhereClause");
        }
    }

    private void appendOrderByClause(StringBuffer stringBuffer, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendOrderByClause", (String)"buffer, colName");
        }
        stringBuffer.append(" order by ");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(',');
        }
        stringBuffer.append(" p.computer_id, monitor_start, monitor_end");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendOrderByClause");
        }
    }

    private boolean fetch(PingReport pingReport) throws SQLException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"pr");
        }
        if (bl = this.resultSet.next()) {
            this.colIndex = 1;
            pingReport.pngMonitorStart = this.getTimestamp(this.resultSet);
            pingReport.pngMonitorEnd = this.getTimestamp(this.resultSet);
            pingReport.pngTransmitted = this.getInt(this.resultSet);
            pingReport.pngReceived = this.getInt(this.resultSet);
            pingReport.pngDamaged = this.getInt(this.resultSet);
            pingReport.pngMinTransitTime = this.getInt(this.resultSet);
            pingReport.pngMaxTransitTime = this.getInt(this.resultSet);
            pingReport.pngAvgTransitTime = this.getLong(this.resultSet);
            pingReport.pngStatisticType = this.getByte(this.resultSet);
            pingReport.pngComputerID = this.getInt(this.resultSet);
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                pingReport.prID = pingReport.pngComputerID;
            } else if (this.grr.reportSubtype != 15) {
                pingReport.prID = this.getInt(this.resultSet);
                pingReport.prName1 = this.getString(this.resultSet);
                if (this.grr.reportSubtype == 13 || this.grr.reportSubtype == 82) {
                    pingReport.setPrName2(this.getString(this.resultSet));
                }
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl2);
        }
        return bl2;
    }

    private void aggregate(PingReport pingReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregate", (String)"row");
        }
        if (this.groupID != pingReport.prID) {
            PingReport pingReport2 = (PingReport)pingReport.clone();
            pingReport2.pngNext = this.resultList;
            this.resultList = pingReport2;
            ++this.totalRows;
            if (this.grr.reportSubtype == 28) {
                if (pingReport2.pngStatisticType >= 3 && pingReport2.pngReceived > 0) {
                    pingReport2.pngAvgTransitTime /= (long)pingReport2.pngReceived;
                }
            } else {
                this.groupID = pingReport.prID;
                if (pingReport2.pngStatisticType < 3) {
                    pingReport2.pngAvgTransitTime *= (long)pingReport2.pngReceived;
                }
            }
        } else {
            if (this.resultList.pngMonitorStart > pingReport.pngMonitorStart) {
                this.resultList.pngMonitorStart = pingReport.pngMonitorStart;
            }
            if (this.resultList.pngMonitorEnd < pingReport.pngMonitorEnd) {
                this.resultList.pngMonitorEnd = pingReport.pngMonitorEnd;
            }
            this.resultList.pngTransmitted += pingReport.pngTransmitted;
            this.resultList.pngReceived += pingReport.pngReceived;
            this.resultList.pngDamaged += pingReport.pngDamaged;
            if (this.resultList.pngMinTransitTime > pingReport.pngMinTransitTime) {
                this.resultList.pngMinTransitTime = pingReport.pngMinTransitTime;
            }
            if (this.resultList.pngMaxTransitTime < pingReport.pngMaxTransitTime) {
                this.resultList.pngMaxTransitTime = pingReport.pngMaxTransitTime;
            }
            if (pingReport.pngStatisticType < 3) {
                pingReport.pngAvgTransitTime *= (long)pingReport.pngReceived;
            }
            this.resultList.pngAvgTransitTime += pingReport.pngAvgTransitTime;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregate");
        }
    }

    private int analyzeRow(PingReport pingReport, PingReport pingReport2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"analyzeRow", (String)"currentRow, lastRow");
        }
        if (this.grr.reportSubtype == 28) {
            int n = 2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        if (pingReport.pngMonitorStart >= pingReport2.pngMonitorEnd) {
            int n = 2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        if (pingReport.pngMonitorStart == pingReport2.pngMonitorStart) {
            int n = 1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        if (pingReport.pngMonitorEnd <= pingReport2.pngMonitorEnd && pingReport.pngMonitorStart <= this.grr.startTime) {
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        int n = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
        }
        return n;
    }

    private void applyFilter(ReportFilter reportFilter) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"applyFilter", (String)"filter");
        }
        PingReport pingReport = this.resultList;
        PingReport pingReport2 = null;
        this.resultList = null;
        this.totalRows = 0;
        while (pingReport != null) {
            PingReport pingReport3 = pingReport;
            pingReport = (PingReport)pingReport3.pngNext;
            pingReport3.pngNext = null;
            PingReport pingReport4 = (PingReport)pingReport3.clone();
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                this.getComputerNames(pingReport4);
            }
            if (!reportFilter.isSelected(pingReport4)) continue;
            if (this.resultList == null) {
                this.resultList = pingReport3;
            } else {
                pingReport2.pngNext = pingReport3;
            }
            pingReport2 = pingReport3;
            ++this.totalRows;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"applyFilter");
        }
    }

    private void getComputerNames(PingReport pingReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (pingReport != null) {
            pingReport.prName1 = agentManager.getAgentName(pingReport.prID);
            pingReport = (PingReport)pingReport.pngNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }

    private PingReport[] packItUp(PingHist pingHist) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packItUp", (String)"head");
        }
        PingReport[] pingReportArray = new PingReport[this.totalRows];
        this.totalRows = 0;
        while (pingHist != null) {
            PingHist pingHist2 = pingHist.pngNext;
            pingHist.pngNext = null;
            pingReportArray[this.totalRows] = (PingReport)pingHist;
            ++this.totalRows;
            pingHist = pingHist2;
        }
        PingReport[] pingReportArray2 = pingReportArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packItUp", (Object)pingReportArray2);
        }
        return pingReportArray2;
    }

    public Serializable getHistoryGraphData(GuiReportReq guiReportReq) throws GeneralException {
        SpaceHistory spaceHistory;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getHistoryGraphData", (String)"grr");
        }
        SpaceHistory spaceHistory2 = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(SELECT_HIST_GRAPH);
        stringBuffer.append(" where statistic_type in ('");
        stringBuffer.append(guiReportReq.histType);
        stringBuffer.append('\'');
        if (guiReportReq.histType != 0) {
            stringBuffer.append(",'");
            stringBuffer.append(guiReportReq.histType + 2);
            stringBuffer.append('\'');
        }
        stringBuffer.append(") and");
        if (guiReportReq.startTime > 0L) {
            stringBuffer.append(" monitor_end between ? and ? and");
        }
        SQLUtil.appendInClause(stringBuffer, COMPUTER_COL, guiReportReq.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            if (guiReportReq.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            spaceHistory = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                spaceHistory.shLegendID1 = this.getInt(this.resultSet);
                spaceHistory.shLegendID2 = Integer.MIN_VALUE;
                spaceHistory.shStatisticTime = this.getTimestamp(this.resultSet);
                byte by = this.getByte(this.resultSet);
                int n2 = this.getInt(this.resultSet);
                int n3 = this.getInt(this.resultSet);
                long l = this.getLong(this.resultSet);
                if (guiReportReq.histSubtype == 7) {
                    if (n3 == 0) continue;
                    spaceHistory.shFileCount = by == 3 || by == 4 ? (long)((int)(l / (long)n3)) : (long)((int)l);
                } else {
                    spaceHistory.shFileCount = (int)((double)n3 / (double)n2 * 100.0);
                }
                spaceHistory.shNext = spaceHistory2;
                spaceHistory2 = spaceHistory;
                spaceHistory = new SpaceHistory();
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getHistoryGraphData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        spaceHistory = RptUserSpace.packUpHistory(spaceHistory2, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptPing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getHistoryGraphData", (Object)spaceHistory);
        }
        return spaceHistory;
    }
}

