/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.AgentLessManagedNode;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class TResComputer
extends RepositoryAccessor {
    private static final String SELECT_ID = "select computer_id from t_res_host where";
    private static final String SELECT_SS_ID = "select subsystem_id from t_res_storage_subsystem where";
    private static final String BY_NAME = " host_name = ?";
    private static final String BY_SS_NAME = " name = ?";
    private static final String BY_NETWORK_NAME = " network_name = ? and domain_name = ?";
    private static final String SELECT_COMPUTER_ID = "select computer_id from t_res_host where host_url = ?";
    private static final String SELECT_NAME = "select host_name from t_res_host where computer_id = ?";
    private static final String SELECT_LOCAL_HOSTNAME = "select case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name from t_res_storage_subsystem  where subsystem_id = ?";
    private static final String SELECT_NETWORK_HOSTNAME = "select network_name, domain_name from t_res_host where computer_id = ?";
    private static final String SELECT_NODE_HOSTED_NAME = "select host_name from t_stat_computer s, t_res_host c where c.computer_id = s.computer_id and c.computer_id = (select node_hosted_id from t_stat_computer where computer_id = ?)";
    private static final String SELECT_DEPENDENTS = "select c.host_name, c.computer_id, a.exclude from t_res_host c, t_res_attribute a where a.attribute_id = ? and a.resource_id = c.computer_id order by 1 desc";
    private static final String SELECT_BY_ID = "select host_name, network_name, host_url, ip_address, vendor_id, os_type from t_res_host where computer_id = ?";
    private static final String SELECT_BY_SS_ID = "select name, case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name, ip_address, vendor_id, os_type, name_format from t_res_storage_subsystem where subsystem_id = ?";
    private static final String SELECT_BY_LIBRARY_ID = "select name, display_name from t_res_tape_library where tape_library_id = ?";
    private static final String AGENT_JOIN = "select c.computer_id from t_res_host c, t_res_agent a where upper(c.host_name) = ? and a.computer_id = c.computer_id";
    private static final String SELECT_AGENTLESS_COMPUTERS = "select computer_id, os_type, host_name, host_url, network_name, domain_name from t_res_host where computer_id not in (select computer_id from t_res_agent)";
    private static final String SELECT_IP_ADDRESS = "select ip_address from t_res_host where computer_id = ?";
    private static final String SELECT_SS = "select os_type from t_res_storage_subsystem where subsystem_id = ? ";
    private static final String SELECT_TAPE = "select name from t_res_tape_library where tape_library_id = ? ";
    private TResVendorModel vmAccessor = null;

    public TResComputer(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResComputer", (String)"dbc");
        }
        this.tableName = "t_res_host";
        this.vmAccessor = new TResVendorModel(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResComputer");
        }
    }

    public void prepSelectName() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectName", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_NAME);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectName");
        }
    }

    public void prepSelectLocalHostname() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectLocalHostname", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_LOCAL_HOSTNAME);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectLocalHostname");
        }
    }

    public String fetchName(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchName", (String)"computerID, failFriendly");
        }
        String string = null;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                string = this.getString(this.resultSet);
            } else if (bl) {
                string = "? (" + Integer.toString(n) + ')';
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchName", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchName", string2);
        }
        return string2;
    }

    public String fetchName(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchName", (String)"computerID");
        }
        String string = this.fetchName(n, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchName", (Object)string);
        }
        return string;
    }

    public NameList queryDependents(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryDependents", (String)"attributeID");
        }
        NameList nameList = null;
        this.selectStmt = this.prepareStmt(SELECT_DEPENDENTS);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList nameList2 = new NameList();
                this.colIndex = 1;
                nameList2.nlName = this.getString(this.resultSet);
                nameList2.nlID = this.getInt(this.resultSet);
                if (this.getBoolean(this.resultSet)) {
                    nameList2.nlState = 1;
                }
                nameList2.nlInfo = 1;
                nameList2.nlNext = nameList;
                nameList = nameList2;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"queryDependents", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        NameList nameList3 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryDependents", nameList3);
        }
        return nameList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNetworkHostname(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNetworkHostname", (String)"computerID");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        this.selectStmt = this.prepareStmt(SELECT_NETWORK_HOSTNAME);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            try {
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    this.stmtPhase = 1;
                    this.colIndex = 1;
                    string = this.getString(this.resultSet);
                    string2 = this.getString(this.resultSet);
                    if (!Util.isEmpty((String)string)) {
                        string3 = string;
                        if (!Util.isEmpty((String)string2)) {
                            string3 = String.valueOf(string3) + "." + string2;
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getNetworkHostname", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeSelect();
            this.closeResultSet();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.closeSelect();
        this.closeResultSet();
        String string4 = string3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNetworkHostname", string4);
        }
        return string4;
    }

    private void setVirtualServerDomainName(TComputer tComputer, int n) {
        AgentManager agentManager;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setVirtualServerDomainName", (String)"computer, parentCompID");
        }
        if ((string = (agentManager = Server.getAgentManager()).getAgentHostAddress(n)) != null) {
            if (TResComputer.isIPAddress(string)) {
                int n2;
                if (tComputer.ipAddress != null && (n2 = tComputer.ipAddress.indexOf(46)) > 0) {
                    tComputer.networkName = tComputer.ipAddress.substring(0, n2);
                    tComputer.domainName = tComputer.ipAddress.substring(n2 + 1);
                }
            } else {
                int n3 = string.indexOf(46);
                tComputer.domainName = n3 < 0 ? null : string.substring(n3 + 1);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setVirtualServerDomainName");
        }
    }

    private static boolean isIPAddress(String string) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isIPAddress", (String)"ip");
        }
        int n = 0;
        int n2 = TResComputer.testOctet(string, 0);
        while (n2 > 0) {
            ++n;
            n2 = TResComputer.testOctet(string, n2);
        }
        boolean bl2 = bl = n == 4;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isIPAddress", (boolean)bl);
        }
        return bl;
    }

    private static int testOctet(String string, int n) {
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"testOctet", (String)"s, start");
        }
        int n3 = 0;
        int n4 = 32;
        boolean bl = n == 0;
        while (n < string.length()) {
            if ((n2 = string.charAt(n++)) == 46) break;
            if (!Character.isDigit((char)n2)) {
                int n5 = -1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"testOctet", (int)n5);
                }
                return n5;
            }
            if (n4 == 32) {
                n4 = n2;
            }
            n3 *= 10;
            if ((n3 += n2 - 48) <= 255) continue;
            int n6 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"testOctet", (int)n6);
            }
            return n6;
        }
        if (n3 == 0) {
            if (bl || n4 == 32) {
                n = -1;
            }
        } else if (n4 == 48) {
            n = -1;
        }
        n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"testOctet", (int)n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIPAddress(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIPAddress", (String)"computerID");
        }
        String string = null;
        this.selectStmt = this.prepareStmt(SELECT_IP_ADDRESS);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            try {
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    this.stmtPhase = 1;
                    this.colIndex = 1;
                    string = this.getString(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getIPAddress", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeSelect();
            this.closeResultSet();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeSelect();
        this.closeResultSet();
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIPAddress", (Object)string2);
        }
        return string2;
    }

    public NameList[] agentNameToComputerID(NameList[] nameListArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"agentNameToComputerID", (String)"agents");
        }
        if (nameListArray != null) {
            this.selectStmt = this.prepareStmt(AGENT_JOIN);
            int n = nameListArray.length;
            while (n-- > 0) {
                NameList nameList = nameListArray[n];
                if (nameList == null || nameList.nlID != 0 || nameList.nlName == null) continue;
                nameList.nlID = this.getnlName(nameList.nlName);
            }
        }
        this.closeSelect();
        NameList[] nameListArray2 = nameListArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"agentNameToComputerID", (Object)nameListArray2);
        }
        return nameListArray2;
    }

    public int getnlName(String string) throws GeneralException {
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.selectStmt, string.toUpperCase());
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                return this.getInt(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"agentNameToComputerID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.colIndex = 1;
        int n = string.indexOf(46);
        if (n == -1) {
            return 0;
        }
        try {
            String string2 = string.substring(0, n);
            this.setString(this.selectStmt, string2.toUpperCase());
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                return this.getInt(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"agentNameToComputerID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return 0;
    }

    public void prepGetNasFiler() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepGetNasFiler", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepGetNasFiler");
        }
    }

    public void prepGetSS() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepGetSS", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_SS_ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepGetSS");
        }
    }

    public void prepGetTape() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepGetTape", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_LIBRARY_ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepGetTape");
        }
    }

    public NasFiler getNasFiler(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNasFiler", (String)"computerID");
        }
        this.execQueryByID(n);
        NasFiler nasFiler = null;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                nasFiler = new NasFiler();
                nasFiler.nfName = this.getString(this.resultSet);
                nasFiler.nfNetworkName = this.getString(this.resultSet);
                nasFiler.nfAlias = this.getString(this.resultSet);
                nasFiler.nfIPAddress = this.getString(this.resultSet);
                this.vmAccessor = new TResVendorModel(this.dbc);
                nasFiler.nfManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
                nasFiler.nfOSType = this.getShort(this.resultSet);
                nasFiler.nfComputerID = n;
            }
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNasFiler", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(sQLException);
        }
        NasFiler nasFiler2 = nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasFiler", (Object)nasFiler2);
        }
        return nasFiler2;
    }

    public NasFiler getSS(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSS", (String)"subsystemID");
        }
        this.execQueryByID(n);
        NasFiler nasFiler = null;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                nasFiler = new NasFiler();
                nasFiler.nfName = this.getString(this.resultSet);
                nasFiler.nfAlias = this.getString(this.resultSet);
                nasFiler.nfIPAddress = this.getString(this.resultSet);
                this.vmAccessor = new TResVendorModel(this.dbc);
                nasFiler.nfManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
                nasFiler.nfOSType = this.getShort(this.resultSet);
                nasFiler.nfNameFormat = this.getShort(this.resultSet);
                nasFiler.nfComputerID = n;
            }
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNasFiler", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(sQLException);
        }
        NasFiler nasFiler2 = nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasFiler", (Object)nasFiler2);
        }
        return nasFiler2;
    }

    public NasFiler getTape(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTape", (String)"libraryID");
        }
        this.execQueryByID(n);
        NasFiler nasFiler = null;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                nasFiler = new NasFiler();
                nasFiler.nfName = this.getString(this.resultSet);
                nasFiler.nfAlias = this.getString(this.resultSet);
                nasFiler.nfIPAddress = null;
                nasFiler.nfManufacturer = null;
                nasFiler.nfOSType = (short)26;
                nasFiler.nfComputerID = n;
            }
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNasFiler", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(sQLException);
        }
        NasFiler nasFiler2 = nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasFiler", (Object)nasFiler2);
        }
        return nasFiler2;
    }

    public void fillNodeMap(Map map) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fillNodeMap", (String)"nodeMap");
        }
        map.clear();
        this.staticStmt = this.createStatement();
        try {
            this.stmtPhase = 3;
            this.resultSet = this.staticStmt.executeQuery(SELECT_AGENTLESS_COMPUTERS);
            while (this.nextResult()) {
                this.getPhase();
                AgentLessManagedNode agentLessManagedNode = new AgentLessManagedNode(this.getInt(this.resultSet), this.getShort(this.resultSet), this.getString(this.resultSet), this.getString(this.resultSet), this.getString(this.resultSet), this.getString(this.resultSet));
                map.put(agentLessManagedNode, agentLessManagedNode);
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fillNodeMap", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fillNodeMap");
        }
    }

    public void deleteByID(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"computerID, commit");
        }
        try {
            this.deleteStmt = this.prepareStmt("delete from t_res_host where computer_id = ?");
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, n);
            this.executeUpdate(this.deleteStmt);
            if (bl) {
                this.dbc.commit();
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByID", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }

    public void getIDs(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIDs", (String)"filerList");
        }
        int n = this.selectIDs(nasFiler);
        if (nasFiler != null) {
            this.updateFilers(nasFiler);
        }
        if (n > 0) {
            try {
                HardwareID hardwareID = new HardwareID(null, null, null, 8);
                TComputer tComputer = new TComputer();
                tComputer.hwID = hardwareID;
                tComputer.timezoneID = TimeZone.getDefault().getID();
                int n2 = StorageRepositoryAccessor.getIdentifier(1, n, this.dbc);
                NasFiler nasFiler2 = nasFiler;
                while (nasFiler2 != null) {
                    if (nasFiler2.nfComputerID == -1) {
                        nasFiler2.nfNewFiler = true;
                        nasFiler2.nfComputerID = n2++;
                        tComputer.tsName = nasFiler2.nfName;
                        tComputer.ipAddress = nasFiler2.nfIPAddress;
                        tComputer.networkName = nasFiler2.nfNetworkName;
                        if (Constants.isCimomManaged((short)nasFiler2.nfComputer.cmpOSType) || Constants.isUnmanagedOS((short)nasFiler2.nfComputer.cmpOSType)) {
                            tComputer.domainName = nasFiler2.nfDomain.domName;
                        }
                        hardwareID.manufacturer = nasFiler2.nfManufacturer;
                        hardwareID.hostName = nasFiler2.nfComputer.cmpOSType == 26 ? nasFiler2.nfComputer.cmpModel : (Util.isEmpty((String)nasFiler2.nfAlias) ? nasFiler2.nfName : nasFiler2.nfAlias);
                        hardwareID.hardwareID = String.valueOf(nasFiler2.nfComputerID).getBytes();
                        hardwareID.osType = nasFiler2.nfComputer.cmpOSType;
                        if (Constants.isVirtualServer((int)hardwareID.osType)) {
                            this.setVirtualServerDomainName(tComputer, nasFiler2.nfParentComputerID);
                            nasFiler2.nfComputer.cmpNewVS = true;
                        }
                        if (Constants.isCimomManaged((short)nasFiler2.nfComputer.cmpOSType)) {
                            tComputer.prepareInsertSS(this.dbc);
                            tComputer.insertSS(this.dbc);
                        } else {
                            tComputer.prepareInsert(this.dbc);
                            tComputer.insertComputer(this.dbc, nasFiler2.nfComputerID);
                        }
                    }
                    nasFiler2 = nasFiler2.nfNext;
                }
                tComputer.closeInsert();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getIDs", (Throwable)sQLException);
                }
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIDs");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFilers(NasFiler nasFiler) throws GeneralException {
        block29: {
            GeneralException generalException;
            block30: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"updateFilers", (String)"filerList");
                }
                TComputer tComputer = new TComputer();
                TComputer tComputer2 = new TComputer();
                AgentManager agentManager = Server.getAgentManager();
                generalException = null;
                boolean bl = false;
                try {
                    block28: {
                        try {
                            NasFiler nasFiler2 = nasFiler;
                            while (nasFiler2 != null) {
                                block32: {
                                    block34: {
                                        boolean bl2;
                                        block33: {
                                            if (nasFiler2.nfComputerID == -1 || Constants.isUnmanagedOS((short)nasFiler2.nfComputer.cmpOSType)) break block32;
                                            boolean bl3 = Constants.isVirtualServer((int)nasFiler2.nfComputer.cmpOSType);
                                            bl2 = Constants.isCimomManaged((short)nasFiler2.nfComputer.cmpOSType);
                                            if (!bl3 && !bl2 || (tComputer2 = bl2 ? TComputer.getSS(nasFiler2.nfComputerID, this.dbc) : TComputer.getComputer(null, null, nasFiler2.nfComputerID, null, this.dbc)) == null) break block32;
                                            if (!bl3) break block33;
                                            tComputer.computerID = nasFiler2.nfComputerID;
                                            tComputer.guid = tComputer2.guid;
                                            tComputer.hwID = tComputer2.hwID;
                                            tComputer.ipAddress = nasFiler2.nfIPAddress;
                                            tComputer.networkName = nasFiler2.nfNetworkName;
                                            this.setVirtualServerDomainName(tComputer, nasFiler2.nfParentComputerID);
                                            tComputer.productState = tComputer2.productState;
                                            tComputer.timezoneID = TimeZone.getDefault().getID();
                                            tComputer.tsName = tComputer2.tsName;
                                            if (tComputer.equalsRepositoryComputer(tComputer2)) break block32;
                                            bl = true;
                                            break block34;
                                        }
                                        if (!bl2) break block34;
                                        if (nasFiler2.nfDomain != null && Util.stringsEqual((String)tComputer2.domainName, (String)nasFiler2.nfDomain.domName)) break block32;
                                        bl = true;
                                        tComputer = tComputer2;
                                        tComputer.domainName = nasFiler2.nfDomain.domName;
                                    }
                                    if (bl) {
                                        bl = false;
                                        tComputer.updateComputer(tComputer2, this.dbc);
                                        agentManager.updateAgentLessManagedNode(tComputer);
                                    }
                                }
                                nasFiler2 = nasFiler2.nfNext;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"updateFilers", (Throwable)sQLException);
                            }
                            this.stmtType = 2;
                            try {
                                this.sqlError(sQLException);
                            }
                            catch (GeneralException generalException2) {
                                if (generalException == null) {
                                    generalException = generalException2;
                                    break block28;
                                }
                                generalException.addException((StorageException)generalException2);
                            }
                        }
                    }
                    Object var10_14 = null;
                    if (generalException == null) break block29;
                    if (!TraceLogger.enableTrace) break block30;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (generalException == null) {
                        throw throwable;
                    }
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"updateFilers");
                    }
                    throw generalException;
                }
                try {}
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)Class.forName("org.eclipse.aperi.repository.table.TResComputer").getName(), (String)"updateFilers");
            }
            throw generalException;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateFilers");
        }
    }

    public int selectIDs(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectIDs", (String)"filerList");
        }
        int n = 0;
        try {
            NasFiler nasFiler2 = nasFiler;
            while (nasFiler2 != null) {
                if (Constants.isVirtualServer((int)nasFiler2.nfOSType)) {
                    nasFiler2.nfNewFiler = false;
                }
                this.selectStmt = Constants.isDiskArray((short)nasFiler2.nfOSType) ? this.prepareStmt("select subsystem_id from t_res_storage_subsystem where name = ?") : this.prepareStmt("select computer_id from t_res_host where host_name = ?");
                this.setPhase();
                this.setString(this.selectStmt, nasFiler2.nfName);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    this.getPhase();
                    nasFiler2.nfComputerID = this.getInt(this.resultSet);
                } else {
                    nasFiler2.nfComputerID = -1;
                    ++n;
                }
                this.resultSet.close();
                nasFiler2 = nasFiler2.nfNext;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectIDs", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectIDs", (int)n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int selectID(String string) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectID", (String)"localHostName");
        }
        int n = -1;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_COMPUTER_ID);
                this.setPhase();
                this.setString(this.selectStmt, string);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.nextResult()) {
                    n = this.getInt(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectID", (int)n2);
        }
        return n2;
    }

    public int selectCID(String string) throws GeneralException {
        return this.selectCID(string, null);
    }

    public int selectCID(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectCID", (String)"name1, name2");
        }
        int n = -1;
        try {
            String string3 = string2 == null ? BY_NAME : BY_NETWORK_NAME;
            this.selectStmt = this.prepareStmt(SELECT_ID + string3);
            this.setPhase();
            this.setString(this.selectStmt, string);
            if (string2 != null) {
                this.setString(this.selectStmt, string2);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.nextResult()) {
                n = this.getInt(this.resultSet);
            }
            this.resultSet.close();
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectCID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectCID", (int)n);
        }
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVSNodeName(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVSNodeName", (String)"computer_id");
        }
        String string = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_NODE_HOSTED_NAME);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.nextResult()) {
                    string = this.getString(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getVSNodeName", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeSelect();
            this.closeResultSet();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeSelect();
        this.closeResultSet();
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVSNodeName", (Object)string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getStorageSubsystemType(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStorageSubsystemType", (String)"id");
        }
        this.selectStmt = this.prepareStmt(SELECT_SS);
        short s = -1;
        try {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                if (this.nextResult()) {
                    this.colIndex = 1;
                    s = this.getShort(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"isStorageSubsystem", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isStorageSubsystem", (short)s);
        }
        return s;
    }

    public boolean isStorageSubsystem(int n) throws GeneralException {
        return this.getStorageSubsystemType(n) > -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTapeLibrary(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isTapeLibrary", (String)"id");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append(SELECT_TAPE);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        try {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                if (this.nextResult()) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"isTapeLibrary", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isTapeLibrary", (boolean)bl2);
        }
        return bl2;
    }
}

