/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.server.handler.StormReportHndlr;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class PartitionHndlr
implements RequestHandler,
ThreadSafe {
    private static final String FILE_PREFIX = "REPORT_";
    private static final String FILE_SUFFIX = ".PRT";
    private static final int PART_WAIT_TIME = 300;
    private static final int SLEEP_TIME = 5;
    private static final int MAX_RETRY_COUNT = 60;

    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, comm");
        }
        if (request.requestData instanceof long[]) {
            this.deletePartitions((long[])request.requestData);
            Response response = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", response);
            }
            return response;
        }
        Response response = Response.getResponse((short)12, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.server.guireq.PartitionedReport");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        PartitionedReport partitionedReport = (PartitionedReport)request.requestData;
        String string = PartitionHndlr.makeFileName(partitionedReport);
        int n = 300 * partitionedReport.prPartition;
        int n2 = (int)((System.currentTimeMillis() - partitionedReport.prID) / 1000L);
        int n3 = (n - n2) / 5;
        if (n3 > 60) {
            n3 = 60;
        }
        File file = new File(string);
        int n4 = 0;
        while (n4 < n3) {
            if (!file.exists()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz5.getName(), (String)"handle", (Throwable)interruptedException);
                    }
                    response.errorMessage = MessageLog.getMessage((String)"GEN0159E");
                    Response response3 = response;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz6;
                        try {
                            clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz6.getName(), (String)"handle", (Object)response3);
                    }
                    return response3;
                }
            }
            ++n4;
        }
        Response response4 = PartitionHndlr.getPartition(string, partitionedReport, response);
        if (TraceLogger.enableTrace) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz7.getName(), (String)"handle", (Object)response4);
        }
        return response4;
    }

    private static Response getPartition(String string, PartitionedReport partitionedReport, Response response) {
        Response response2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPartition", (String)"fileName, partition, response");
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)fileNotFoundException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0160E", (Exception)fileNotFoundException);
            Response response3 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getPartition", (Object)response3);
            }
            return response3;
        }
        try {
            objectInputStream = new ObjectInputStream(fileInputStream);
        }
        catch (ObjectStreamException objectStreamException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)objectStreamException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0155E", (Exception)objectStreamException, (Object)string);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)iOException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0154E", (Exception)iOException, (Object)string);
        }
        if (objectInputStream == null) {
            PartitionHndlr.closeInputStream(fileInputStream);
            response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getPartition", (Object)response2);
            }
            return response2;
        }
        try {
            response.responseData = (Serializable)objectInputStream.readObject();
            response.status = 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)classNotFoundException);
            }
            Object[] objectArray = new Object[]{classNotFoundException.getMessage(), string};
            response.errorMessage = MessageLog.getMessage((String)"GEN0157E", (Object[])objectArray);
        }
        catch (ObjectStreamException objectStreamException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)objectStreamException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0155E", (Exception)objectStreamException, (Object)string);
        }
        catch (EOFException eOFException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)eOFException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0156E", (Exception)eOFException, (Object)string);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)iOException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0154E", (Exception)iOException, (Object)string);
        }
        catch (ClassCastException classCastException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPartition", (Throwable)classCastException);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0158E", (Exception)classCastException, (Object)string, (Object)"PartitionedReport");
        }
        PartitionHndlr.closeInputStream(objectInputStream);
        response2 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPartition", (Object)response2);
        }
        return response2;
    }

    private static void closeInputStream(InputStream inputStream) {
        block10: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"closeInputStream", (String)"is");
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"closeInputStream", (Throwable)iOException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeInputStream");
        }
    }

    public static String makeFileName(PartitionedReport partitionedReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeFileName", (String)"partition");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(Server.TEMP_DIR);
        stringBuffer.append(FILE_PREFIX);
        stringBuffer.append(partitionedReport.prID);
        stringBuffer.append('_');
        stringBuffer.append(partitionedReport.prPartition);
        stringBuffer.append(FILE_SUFFIX);
        String string = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeFileName", (Object)string);
        }
        return string;
    }

    public static PartitionedReport getPartitionZero(long l) {
        PartitionedReport partitionedReport;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPartitionZero", (String)"partitionToken");
        }
        PartitionedReport partitionedReport2 = new PartitionedReport();
        partitionedReport2.prID = l;
        Response response = Response.getResponse((short)12, null);
        PartitionHndlr.getPartition(PartitionHndlr.makeFileName(partitionedReport2), partitionedReport2, response);
        PartitionedReport partitionedReport3 = partitionedReport = response.status == 0 ? (PartitionedReport)response.responseData : null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPartitionZero", (Object)partitionedReport);
        }
        return partitionedReport;
    }

    public static void savePartition(PartitionedReport partitionedReport, StormReportHndlr stormReportHndlr) throws GeneralException {
        boolean bl;
        File file;
        block53: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"savePartition", (String)"partition, grh");
            }
            if (partitionedReport.prPartition == 0) {
                if (!partitionedReport.prLastPart) {
                    partitionedReport.prID = Server.getUniqueTimestamp();
                }
                stormReportHndlr.transmitReportData(partitionedReport);
                if (partitionedReport.prLastPart) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"savePartition");
                    }
                    return;
                }
                PartitionHndlr.ageFiles(partitionedReport.prID);
            }
            try {
                file = File.createTempFile("TMP", FILE_SUFFIX, new File(Server.TEMP_DIR));
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"savePartition", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)iOException);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"savePartition");
                }
                throw new GeneralException();
            }
            String string = file.getName();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"savePartition", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)iOException);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"savePartition");
                }
                throw new GeneralException();
            }
            bl = false;
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(partitionedReport);
                bl = true;
            }
            catch (ObjectStreamException objectStreamException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"savePartition", (Throwable)objectStreamException);
                }
                MessageLog.logException((String)"GEN0153E", (Exception)objectStreamException, (Object)string);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"savePartition", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0152E", (Exception)iOException, (Object)string);
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"savePartition", (Throwable)iOException);
                    }
                    if (bl) {
                        MessageLog.logException((String)"GEN0152E", (Exception)iOException, (Object)string);
                        bl = false;
                    }
                    break block53;
                }
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block53;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"savePartition", (Throwable)iOException);
                }
            }
        }
        if (!bl) {
            file.delete();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"savePartition");
            }
            throw new GeneralException();
        }
        bl = file.renameTo(new File(PartitionHndlr.makeFileName(partitionedReport)));
        partitionedReport.prPartition = (short)(partitionedReport.prPartition + 1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"savePartition");
        }
    }

    private void deletePartitions(long[] lArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deletePartitions", (String)"idArray");
        }
        PartitionHndlr.remove(new DeletePartitionFilter(lArray));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deletePartitions");
        }
    }

    private static void ageFiles(long l) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageFiles", (String)"timestamp");
        }
        PartitionHndlr.remove(new AgeFilesFilter(l - (long)(AgentSvp.keepCachedReport * 60 * 1000)));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageFiles");
        }
    }

    private static void remove(FilenameFilter filenameFilter) {
        File[] fileArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"remove", (String)"filter");
        }
        if ((fileArray = new File(Server.TEMP_DIR).listFiles(filenameFilter)) != null) {
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n].delete();
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"remove");
        }
    }

    private static class AgeFilesFilter
    implements FilenameFilter {
        String deletePrefix;

        AgeFilesFilter(long l) {
            this.deletePrefix = PartitionHndlr.FILE_PREFIX + l;
        }

        public boolean accept(File file, String string) {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$AgeFilesFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"accept", (String)"dir, fileName");
            }
            boolean bl2 = bl = string.startsWith(PartitionHndlr.FILE_PREFIX) && string.endsWith(PartitionHndlr.FILE_SUFFIX) && string.compareTo(this.deletePrefix) < 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$AgeFilesFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"accept", (boolean)bl);
            }
            return bl;
        }
    }

    private static class DeletePartitionFilter
    implements FilenameFilter {
        String[] partitionIDs;

        DeletePartitionFilter(long[] lArray) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$DeletePartitionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"DeletePartitionFilter", (String)"idArray");
            }
            this.partitionIDs = new String[lArray.length];
            int n = 0;
            while (n < lArray.length) {
                this.partitionIDs[n] = Long.toString(lArray[n]);
                ++n;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$DeletePartitionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"DeletePartitionFilter");
            }
        }

        public boolean accept(File file, String string) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$DeletePartitionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"accept", (String)"dir, fileName");
            }
            if (!string.startsWith(PartitionHndlr.FILE_PREFIX) || !string.endsWith(PartitionHndlr.FILE_SUFFIX)) {
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$DeletePartitionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"accept", (boolean)bl);
                }
                return bl;
            }
            int n = 0;
            while (n < this.partitionIDs.length) {
                if (string.regionMatches(PartitionHndlr.FILE_PREFIX.length(), this.partitionIDs[n], 0, this.partitionIDs[n].length())) {
                    boolean bl = true;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$DeletePartitionFilter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"accept", (boolean)bl);
                    }
                    return bl;
                }
                ++n;
            }
            n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.PartitionHndlr$DeletePartitionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"accept", n != 0);
            }
            return n != 0;
        }
    }
}

