/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.objects.ConfigSettings;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class JobLogDeletionHandler
implements FilenameFilter {
    public static final int RESTART = -4096;
    public static String scriptsDir;
    private static NumberFormat schedRunFormat;
    private static NumberFormat jobRunFormat;
    private String dirPath = this.getDeviceServerLogDir();
    public static final String MESSAGE_NAME = "aperi.logger.message.JobDeletionHandler";
    public static final String TRACE_NAME = "aperi.logger.trace.JobDeletionHandler";
    public static String MSG_FILE;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    private long purgeBefore;
    private boolean purgeNecessary;
    private int retainDays = -100;
    private int retention = -100;

    static {
        Class<?> clazz;
        MSG_FILE = "org.eclipse.aperi.resources.Discover";
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.JobLogDeletionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        schedRunFormat = new DecimalFormat("0000");
        jobRunFormat = new DecimalFormat("00000000");
    }

    public boolean accept(File file, String string) {
        int n = string.length();
        if (n < 20) {
            return false;
        }
        if (!string.endsWith(".log")) {
            return false;
        }
        String string2 = string.substring(0, n - 4);
        int n2 = string2.indexOf(46);
        if (n2 < 0) {
            return false;
        }
        File file2 = new File(file, string);
        long l = file2.lastModified();
        if (l < this.purgeBefore) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "accept", "The File " + file2.getName() + " is marked for deletion ");
            }
            return true;
        }
        return false;
    }

    private JobLogDeletionHandler() {
        this.getLogRetentionValuesFromDb();
        if (this.retainDays <= 0) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "invalid log file retention value.");
            }
            this.purgeBefore = Long.MIN_VALUE;
        } else {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "Log file retention is " + this.retainDays + " days");
            }
            long l = this.retainDays;
            l *= 86400000L;
            try {
                this.purgeBefore = CurrentTime.getTimestamp().getTime() - l;
                this.purgeNecessary = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (traceLogger != null && traceLogger.isLogging()) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.JobLogDeletionHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz.getName(), "constructor", exception);
                }
                return;
            }
        }
        if (this.retention > 0) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "Number of copies to retain is " + this.retention);
            }
            this.purgeNecessary = true;
        }
    }

    public static void purgeLogFiles(int n, int n2) {
        JobLogDeletionHandler jobLogDeletionHandler = new JobLogDeletionHandler();
        if (!jobLogDeletionHandler.purgeNecessary) {
            return;
        }
        jobLogDeletionHandler.purgeLogsForSchedule(n, n2, jobLogDeletionHandler.retention);
        File file = new File(jobLogDeletionHandler.dirPath);
        String[] stringArray = file.list(jobLogDeletionHandler);
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                File file2 = new File(file, stringArray[n3]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogFiles", "Deleting the expired file " + file2.getName());
                }
                file2.delete();
                ++n3;
            }
        }
    }

    public static void purgeControlLogFiles() {
        JobLogDeletionHandler jobLogDeletionHandler = new JobLogDeletionHandler();
        if (!jobLogDeletionHandler.purgeNecessary) {
            return;
        }
        jobLogDeletionHandler.purgeControlLogsForSchedule();
        File file = new File(jobLogDeletionHandler.dirPath);
        String[] stringArray = file.list(jobLogDeletionHandler);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeControlLogFiles", "Deleting the expired file " + file2.getName());
                }
                file2.delete();
                ++n;
            }
        }
    }

    private void purgeLogsForSchedule(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "purgeLogsForSchedule", "Schedule Id = " + Integer.toString(n) + " sid_run_number= " + Integer.toString(n2) + " retention is " + Integer.toString(n3));
        }
        int n4 = n2 - n3;
        ArrayList arrayList = this.getLogFileNames(n, n4);
        int n5 = 0;
        while (n5 < arrayList.size()) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogsForSchedule", "Marking file " + (String)arrayList.get(n5) + " For deletion");
            }
            ++n5;
        }
        this.purgeLogFiles(arrayList);
    }

    private void purgeControlLogsForSchedule() {
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, "purgeControlLogsForSchedule");
        }
        ArrayList arrayList = this.getControlLogFileNames();
        int n = 0;
        while (n < arrayList.size()) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "purgeControlLogsForSchedule", "Marking file " + (String)arrayList.get(n) + " For deletion");
            }
            ++n;
        }
        this.purgeLogFiles(arrayList);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getLogRetentionValuesFromDb() {
        block21: {
            block20: {
                var1_1 = ServiceUtils.getConnection();
                var1_1.getSchema();
                new Hashtable<K, V>();
                var2_2 = null;
                try {
                    try {
                        var2_2 = ConfigSettings.getCursor(var1_1, null, null);
                        if (var2_2.next()) {
                            var3_3 = var2_2.getObject();
                            this.retainDays = var3_3.getRetainDays();
                            this.retention = var3_3.getRetainCopies();
                        }
                        if (JobLogDeletionHandler.traceLogger != null && JobLogDeletionHandler.traceLogger.isLogging()) {
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogRetentionValuesFromDb", "Retain copies =" + Integer.toString(this.retention) + " retain Days =" + Integer.toString(this.retainDays));
                        }
                    }
                    catch (Exception var3_4) {
                        var3_4.printStackTrace();
                        if (JobLogDeletionHandler.traceLogger != null && JobLogDeletionHandler.traceLogger.isLogging()) {
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_ALL, JobLogDeletionHandler.className, "getLogRetentionValuesFromDb", "Exception while retrieving retention values from the DB ");
                        }
                    }
                }
                catch (Throwable var5_5) {
                    block19: {
                        block18: {
                            var4_6 = null;
                            if (var2_2 != null) {
                                try {
                                    var2_2.close();
                                }
                                catch (Exception v0) {
                                    if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block18;
                                    JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                                }
                            }
                        }
                        if (var1_1 == null) throw var5_5;
                        try {
                            var1_1.commit();
                        }
                        catch (Exception var6_8) {
                            var6_8.printStackTrace();
                            if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block19;
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                        }
                    }
                    try {
                        var1_1.close();
                        throw var5_5;
                    }
                    catch (Exception var6_8) {
                        var6_8.printStackTrace();
                    }
                    throw var5_5;
                }
                {
                    var4_7 = null;
                    if (var2_2 == null) break block20;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 191->198)] { 
lbl53:
                // 1 sources

                var2_2.close();
                break block20;
lbl55:
                // 1 sources

                catch (Exception v1) {
                    if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block20;
                    JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                }
            }
            if (var1_1 == null) return;
            ** try [egrp 3[TRYBLOCK] [4 : 240->247)] { 
lbl61:
            // 1 sources

            var1_1.commit();
            break block21;
lbl63:
            // 1 sources

            catch (Exception var6_9) {
                var6_9.printStackTrace();
                if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block21;
                JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
            }
        }
        try {}
        catch (Exception var6_9) {
            var6_9.printStackTrace();
            return;
        }
        var1_1.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getLogFileNames(int var1_1, int var2_2) {
        block22: {
            block21: {
                var3_3 = new ArrayList<String>();
                var4_4 = ServiceUtils.getConnection();
                var5_5 = "SELECT Log_file_name FROM  T_RUN_JOBS  WHERE T_RUN_JOBS.SID_RUN_NUMBER <= " + Integer.toString(var2_2) + " AND T_RUN_JOBS.SCHEDULE_ID= " + Integer.toString(var1_1);
                var6_6 = "delete FROM  T_RUN_JOBS  WHERE T_RUN_JOBS.SID_RUN_NUMBER <= " + Integer.toString(var2_2) + " AND T_RUN_JOBS.SCHEDULE_ID= " + Integer.toString(var1_1);
                var7_7 = null;
                try {
                    try {
                        var7_7 = ComplexQuery.sqlQuery(var4_4, var5_5, new Hashtable<K, V>());
                        if (var7_7 != null) {
                            while (var7_7.next()) {
                                var8_8 = var7_7.getString("Log_file_name");
                                if (!var8_8.startsWith(this.getDeviceServerLogDir())) continue;
                                var3_3.add(var8_8);
                            }
                        }
                        if (var3_3.size() == 0 && JobLogDeletionHandler.traceLogger != null && JobLogDeletionHandler.traceLogger.isLogging()) {
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "No file names returned for scheduleId =" + Integer.toString(var1_1) + " And sid_run_number<= " + Integer.toString(var2_2));
                        }
                        ComplexQuery.sqlUpdate(var4_4, var6_6, new Hashtable<K, V>());
                    }
                    catch (Exception var8_9) {
                        var8_9.printStackTrace();
                        if (JobLogDeletionHandler.traceLogger != null && JobLogDeletionHandler.traceLogger.isLogging()) {
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_WARN, JobLogDeletionHandler.className, "getLogFileNames", "Exception while getting log file names from the DB ");
                        }
                    }
                }
                catch (Throwable var10_10) {
                    block20: {
                        block19: {
                            var9_11 = null;
                            if (var7_7 != null) {
                                try {
                                    var7_7.close();
                                }
                                catch (Exception var11_13) {
                                    var11_13.printStackTrace();
                                    if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block19;
                                    JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                                }
                            }
                        }
                        if (var4_4 == null) throw var10_10;
                        try {
                            var4_4.commit();
                        }
                        catch (Exception var11_13) {
                            var11_13.printStackTrace();
                            if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block20;
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "Exception while committing the DB Connection");
                        }
                    }
                    try {
                        var4_4.close();
                        throw var10_10;
                    }
                    catch (Exception var11_13) {
                        var11_13.printStackTrace();
                        if (JobLogDeletionHandler.traceLogger == null) throw var10_10;
                        if (JobLogDeletionHandler.traceLogger.isLogging() == false) throw var10_10;
                        JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "Exception while closing the DB Connection");
                    }
                    throw var10_10;
                }
                {
                    var9_12 = null;
                    if (var7_7 == null) break block21;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 301->309)] { 
lbl59:
                // 1 sources

                var7_7.close();
                break block21;
lbl61:
                // 1 sources

                catch (Exception var11_14) {
                    var11_14.printStackTrace();
                    if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block21;
                    JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                }
            }
            if (var4_4 == null) return var3_3;
            ** try [egrp 3[TRYBLOCK] [4 : 358->366)] { 
lbl68:
            // 1 sources

            var4_4.commit();
            break block22;
lbl70:
            // 1 sources

            catch (Exception var11_14) {
                var11_14.printStackTrace();
                if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block22;
                JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "Exception while committing the DB Connection");
            }
        }
        try {}
        catch (Exception var11_14) {
            var11_14.printStackTrace();
            if (JobLogDeletionHandler.traceLogger == null) return var3_3;
            if (JobLogDeletionHandler.traceLogger.isLogging() == false) return var3_3;
            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getLogFileNames", "Exception while closing the DB Connection");
            return var3_3;
        }
        var4_4.close();
        return var3_3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getControlLogFileNames() {
        block22: {
            block21: {
                var1_1 = new ArrayList<String>();
                var2_2 = ServiceUtils.getConnection();
                var3_3 = "SELECT Log_file_name FROM T_RUN_JOBS WHERE T_RUN_JOBS.SID_RUN_NUMBER = -9999";
                var4_4 = "DELETE FROM T_RUN_JOBS WHERE sid_run_number = -9999";
                var5_5 = null;
                try {
                    try {
                        var5_5 = ComplexQuery.sqlQuery(var2_2, var3_3, new Hashtable<K, V>());
                        if (var5_5 != null) {
                            while (var5_5.next()) {
                                var6_6 = var5_5.getString("Log_file_name");
                                if (!var6_6.startsWith(this.getDeviceServerLogDir())) continue;
                                var1_1.add(var6_6);
                            }
                        }
                        if (var1_1.size() == 0 && JobLogDeletionHandler.traceLogger != null && JobLogDeletionHandler.traceLogger.isLogging()) {
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "No Expired Control Logs");
                        }
                        ComplexQuery.sqlUpdate(var2_2, var4_4, new Hashtable<K, V>());
                    }
                    catch (Exception var6_7) {
                        var6_7.printStackTrace();
                        if (JobLogDeletionHandler.traceLogger != null && JobLogDeletionHandler.traceLogger.isLogging()) {
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_WARN, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while getting log file names from the DB ");
                        }
                    }
                }
                catch (Throwable var8_8) {
                    block20: {
                        block19: {
                            var7_9 = null;
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (Exception var9_11) {
                                    var9_11.printStackTrace();
                                    if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block19;
                                    JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while closing the logFile DB Result Set");
                                }
                            }
                        }
                        if (var2_2 == null) throw var8_8;
                        try {
                            var2_2.commit();
                        }
                        catch (Exception var9_11) {
                            var9_11.printStackTrace();
                            if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block20;
                            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while committing the DB Connection");
                        }
                    }
                    try {
                        var2_2.close();
                        throw var8_8;
                    }
                    catch (Exception var9_11) {
                        var9_11.printStackTrace();
                        if (JobLogDeletionHandler.traceLogger == null) throw var8_8;
                        if (JobLogDeletionHandler.traceLogger.isLogging() == false) throw var8_8;
                        JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while closing the DB Connection");
                    }
                    throw var8_8;
                }
                {
                    var7_10 = null;
                    if (var5_5 == null) break block21;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 206->214)] { 
lbl59:
                // 1 sources

                var5_5.close();
                break block21;
lbl61:
                // 1 sources

                catch (Exception var9_12) {
                    var9_12.printStackTrace();
                    if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block21;
                    JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while closing the logFile DB Result Set");
                }
            }
            if (var2_2 == null) return var1_1;
            ** try [egrp 3[TRYBLOCK] [4 : 262->269)] { 
lbl68:
            // 1 sources

            var2_2.commit();
            break block22;
lbl70:
            // 1 sources

            catch (Exception var9_12) {
                var9_12.printStackTrace();
                if (JobLogDeletionHandler.traceLogger == null || !JobLogDeletionHandler.traceLogger.isLogging()) break block22;
                JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while committing the DB Connection");
            }
        }
        try {}
        catch (Exception var9_12) {
            var9_12.printStackTrace();
            if (JobLogDeletionHandler.traceLogger == null) return var1_1;
            if (JobLogDeletionHandler.traceLogger.isLogging() == false) return var1_1;
            JobLogDeletionHandler.traceLogger.text(IRecordType.TYPE_INFO, JobLogDeletionHandler.className, "getControlLogFileNames", "Exception while closing the DB Connection");
            return var1_1;
        }
        var2_2.close();
        return var1_1;
    }

    private String getDeviceServerLogDir() {
        String string = Variables.getBaseDirectory();
        String string2 = String.valueOf(string) + File.separator + "log" + File.separator;
        return string2;
    }

    private void purgeLogFiles(ArrayList arrayList) {
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                File file = new File((String)arrayList.get(n));
                if (file.exists()) {
                    file.delete();
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogFiles", "Could not delete non existent File " + file.getName());
                }
                ++n;
            }
        }
    }
}

