/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExportsAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String EXPORT = MessageLog.getMessageNoID("STG1243L");
    private static final String PATH = MessageLog.getMessageNoID("STG1219L");
    private static final String PROTOCOL = MessageLog.getMessageNoID("STG1244L");
    private static final String DISCOVERED = MessageLog.getMessageNoID("STG1134L");
    public String[] columnNameList = new String[]{COMPUTER, EXPORT, PATH, PROTOCOL, DISCOVERED};
    private static final int COMPUTER_COL = 0;
    private static final int EXPORT_COL = 1;
    private static final int PATH_COL = 2;
    private static final int PROTOCOL_COL = 3;
    private static final int DISCOVERED_COL = 4;
    private Export[] exports;
    private Date[] discDate;
    private GuiReportReq grr;
    private int[] rendererArray;
    private boolean batch;

    public ExportsAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.rendererArray = new int[this.columnNameList.length];
        this.rendererArray[4] = 1;
        this.columnNameList = this.getCustomizedColNames(this.columnNameList);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        if (this.grr.reportSubtype == 37) {
            Arrays.sort(this.exports, new Sorter());
        }
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.exports = (Export[])objectArray;
        int n = this.exports.length;
        this.discDate = new Date[n];
        int n2 = 0;
        while (n2 < n) {
            this.discDate[n2] = new Date();
            ++n2;
        }
    }

    public void adjustData() {
        int n = this.exports.length;
        int n2 = 0;
        while (n2 < n) {
            if (!this.batch) {
                this.exports[n2].xpComputerName = GuiUtil.getComputer((int)this.exports[n2].xpComputerID).gcTSName;
            }
            ++n2;
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        columnDescriptorArray[3].cdValidValue = ColumnDescriptor.EXPORT_PROTOCOLS;
    }

    public int getNumberRows() {
        return this.exports.length;
    }

    public int getNumberColumns() {
        return this.columnNameList.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getCellData(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.exports[n].xpComputerName;
            }
            case 1: {
                return this.exports[n].xpExportName;
            }
            case 2: {
                return this.exports[n].xpPath;
            }
            case 3: {
                return Export.PROTOCOL[this.exports[n].xpProtocol];
            }
            case 4: {
                this.discDate[n].setTime(this.exports[n].xpDiscoveredTime);
                return this.discDate[n];
            }
        }
        return null;
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object object, Object object2) {
            Export export = (Export)object;
            Export export2 = (Export)object2;
            if (export.xpDiscoveredTime == export2.xpDiscoveredTime) {
                return 0;
            }
            if (export.xpDiscoveredTime > export2.xpDiscoveredTime) {
                return -1;
            }
            return 1;
        }
    }
}

