/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.gui.DiskTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    protected NameList computer;
    protected int controllerID;
    protected int volgroupID;

    protected String getMsgID() {
        if (this.computer.nlID2 == 21) {
            return "SAG0072L";
        }
        return "STG1004L";
    }

    protected short getQualifier() {
        return 0;
    }

    public DiskTreeLabel(NameList nameList, int n) {
        this(nameList, n, -1);
    }

    public DiskTreeLabel(NameList nameList, int n, int n2) {
        this.computer = nameList;
        this.controllerID = n;
        this.volgroupID = n2;
        this.setUserObject(MessageLog.getMessageNoID(this.getMsgID(), null));
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.diskList(request, this.computer.nlID, this.controllerID, this.getQualifier());
            GuiListReq guiListReq = (GuiListReq)request.requestData;
            guiListReq.groupID = this.volgroupID;
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short s, Response response) {
        NameList nameList;
        boolean bl = this.controllerID <= 0;
        NameList nameList2 = nameList = new NameList();
        NameList nameList3 = null;
        if (s <= 4) {
            nameList3 = (NameList)response.responseData;
        }
        while (nameList3 != null) {
            nameList = nameList2;
            if (bl && this.findDisk(nameList3.nlID, nameList)) {
                nameList3 = nameList3.nlNext;
                continue;
            }
            this.add(new DiskTreeNode(this.computer, nameList3.nlID, nameList3.nlName));
            nameList3 = nameList3.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    public boolean findDisk(int n, NameList nameList) {
        NameList nameList2 = nameList;
        while (nameList != null) {
            if (nameList.nlID == n) {
                return true;
            }
            nameList2 = nameList;
            nameList = nameList.nlNext;
        }
        nameList2.nlID = n;
        nameList2.nlNext = new NameList();
        return false;
    }
}

