/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSGroupEditor;
import org.eclipse.aperi.TStorm.gui.FSGroupSelectorHelper;
import org.eclipse.aperi.TStorm.gui.MultiPicker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.tape.common.TapeConstants;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
Runnable {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private MultiPicker picker;
    private TreeSelector selector;
    private FSGroupEditor editor;

    public GroupCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition groupDefinition = (GroupDefinition)this.createHeaderPanel.getData();
        groupDefinition.members = this.DDI.nlInfo == 0 ? FSGroupSelectorHelper.getSelectedComputers(this.selector) : this.picker.getData(0);
        return groupDefinition;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        GroupDefinition groupDefinition = (GroupDefinition)createHeader;
        if (groupDefinition.members == null) {
            String string = MessageLog.getMessageNoTS("STG3156E", null);
            throw new GeneralException(string);
        }
    }

    private void create(GroupDefinition groupDefinition) {
        this.createHeaderPanel = new CreateHeaderPanel(groupDefinition, this, this.DDI);
        if (this.DDI.nlInfo == 0) {
            this.editor = new FSGroupEditor(groupDefinition.members, this, true);
        } else {
            NameList[] nameListArray = new NameList[]{groupDefinition.members};
            String[] stringArray = new String[]{"STG4030L"};
            short s = (short)(this.DDI.nlInfo + 1);
            this.picker = new MultiPicker(s, nameListArray, null, "STG4029L", null, null, stringArray, null, false);
            this.createHeaderPanel.add(this.picker.getComponent(), "Center");
            this.DDI.panel = this.createHeaderPanel;
            this.DDI.show();
            this.createHeaderPanel.gettingFocus();
        }
    }

    public void run() {
        this.selector = this.editor.selector;
        this.editor = null;
        this.createHeaderPanel.add((Component)this.selector, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader createHeader) {
        this.createHeaderPanel.replace(createHeader);
        NameList nameList = new NameList();
        nameList.nlInfo = this.DDI.nlInfo;
        ChangeManager.signalChange(100, nameList);
    }

    private void submitRetrieve(int n) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.ID = n;
        groupDefinition.groupType = this.DDI.nlInfo;
        groupDefinition.members = null;
        request.requestData = groupDefinition;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = this.DDI.nlInfo;
        this.create(groupDefinition);
        this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
        this.create(groupDefinition);
    }

    public String getHelpID(int n) {
        switch (this.DDI.nlInfo) {
            case 0: {
                return "mogr5";
            }
            case 77: {
                return "mogr7";
            }
            case 113: {
                return FabricGuiUtil.FHELP_GROUPS_FABRIC;
            }
            case 133: {
                return TapeConstants.LIBRARY_GROUPS_HELP;
            }
        }
        return null;
    }
}

