/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList memberSelections;
    private NameList groupSelections;
    private NameList clusterSelections;
    private NameList devicesAvailable;
    private NameList switchesAvailable;
    private NameList rootName;
    private short memberType;
    private short groupType;
    private TreeSet memberSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private String groupRootLabel;
    private String memberRootLabel;
    private String allMembersLabel;
    private String clustersRootLabel;
    private TreeSelectorNode sourceGroupLabel;
    private TreeSelectorNode sourceClusterLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    public boolean allMembersSelected;
    private boolean excludeNAS;
    private boolean getVersions;
    private boolean includeClusters;
    private boolean excludeVS;
    private boolean clusterExpanding = false;
    private boolean groupExpanding = false;
    private static final int ROOT_ID = -5;
    private static final int GROUP_ID = -4;
    private static final int MEMBER_ID = -3;
    private static final int CLUSTER_ID = -2;
    private static final int ALL_MEMBER_ID = Integer.MAX_VALUE;
    private boolean doPerfAlert = false;
    private boolean doSwitchPerfAlert = false;
    private int listRequested = -1;

    public GroupSelector(short s) {
        this(s, null, null, null, false, false, false);
    }

    public GroupSelector(short s, NameList nameList, NameList nameList2, boolean bl) {
        this(s, nameList, nameList2, null, bl, false, false, false, false, false);
    }

    public GroupSelector(short s, NameList nameList, NameList nameList2, boolean bl, boolean bl2) {
        this(s, nameList, nameList2, null, bl, bl2, false, false, false, false);
    }

    public GroupSelector(short s, NameList nameList, NameList nameList2, boolean bl, boolean bl2, boolean bl3) {
        this(s, nameList, nameList2, null, bl, bl2, false, false, false, bl3);
    }

    public GroupSelector(short s, NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3) {
        this(s, nameList, nameList2, nameList3, bl, bl2, false, false, bl3, false);
    }

    public GroupSelector(short s, NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.memberType = s;
        this.memberSelections = nameList;
        this.groupSelections = nameList2;
        this.clusterSelections = nameList3;
        this.allMembersSelected = bl;
        this.excludeNAS = bl2;
        this.getVersions = bl4;
        this.clustersRootLabel = "LABEL_CLUSTERS";
        this.includeClusters = bl5;
        this.excludeVS = bl6;
        if (this.memberType == 1) {
            this.groupType = 0;
            this.memberRootLabel = "STG4041L";
            this.groupRootLabel = "STG3012L";
            this.allMembersLabel = "STG3100L";
        } else if (this.memberType == 78) {
            this.groupType = (short)77;
            this.memberRootLabel = "STG4191L";
            this.groupRootLabel = "STG5500L";
            this.allMembersLabel = "STG5501L";
        } else if (this.memberType == 121) {
            this.groupType = (short)120;
            this.memberRootLabel = "FabricAlert_SwitchTabTitle";
            this.groupRootLabel = "FabricAlert_SwitchGroupLabel";
            this.allMembersLabel = "STG4605L";
        } else if (this.memberType == 129) {
            this.groupType = (short)122;
            this.memberRootLabel = "FabricAlert_EndpointTabTitle";
            this.groupRootLabel = "FabricAlert_EndpointGroupLabel";
            this.allMembersLabel = "STG4606L";
        }
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList nameList = null;
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList[] nameListArray = new NameList[3];
        this.allMembersSelected = false;
        NameList nameList4 = this.selector.getNameList();
        while (nameList4 != null) {
            NameList nameList5 = (NameList)nameList4.clone();
            nameList5.nlNext = null;
            if ((this.memberType == 121 || this.memberType == 129) && nameList5.nlInfo == 114) {
                if (nameList == null) {
                    nameListArray[1] = nameList5;
                } else {
                    nameList.nlNext = nameList5;
                }
                nameList = nameList5;
            } else if (nameList5.nlInfo == this.groupType) {
                if (nameList == null) {
                    nameListArray[1] = nameList5;
                } else {
                    nameList.nlNext = nameList5;
                }
                nameList = nameList5;
            } else if (nameList5.nlInfo == 13) {
                this.allMembersSelected = true;
            } else if (nameList5.nlInfo == 99) {
                if (nameList3 == null) {
                    nameListArray[2] = nameList5;
                } else {
                    nameList3.nlNext = nameList5;
                }
                nameList3 = nameList5;
            } else {
                if (nameList2 == null) {
                    nameListArray[0] = nameList5;
                } else {
                    nameList2.nlNext = nameList5;
                }
                nameList2 = nameList5;
            }
            nameList4 = nameList4.nlNext;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        if (!this.doPerfAlert && !this.doSwitchPerfAlert) {
            this.sourceGroupLabel = this.addGroupLabel(treeSelectorNode);
        }
        this.addMemberLabel(treeSelectorNode);
        if (this.includeClusters) {
            this.sourceClusterLabel = this.addClusterLabel(treeSelectorNode);
        }
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = null;
        TreeSelectorNode treeSelectorNode5 = this.newRoot();
        NameList nameList = this.clusterSelections;
        while (nameList != null) {
            if (treeSelectorNode4 == null) {
                treeSelectorNode4 = this.addClusterLabel(treeSelectorNode5);
            }
            treeSelectorNode4.add(new TreeSelectorNode(nameList, true, false, true, true, null, false, this.includeClusters));
            nameList = nameList.nlNext;
        }
        nameList = this.groupSelections;
        while (nameList != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addGroupLabel(treeSelectorNode5);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList, true, false, true, true, null, this.includeClusters, this.includeClusters));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.memberSelections, true, false);
        if (this.allMembersSelected || !this.memberSet.isEmpty()) {
            treeSelectorNode2 = this.addMemberLabel(treeSelectorNode5);
            if (this.allMembersSelected) {
                this.addAllMembersNode(treeSelectorNode2, true);
            }
            this.addTreeSet(treeSelectorNode2, this.memberSet);
        }
        if (!this.excludeSet.isEmpty()) {
            treeSelectorNode3 = TreeSelector.makeExcludeRoot();
            treeSelectorNode5.add(treeSelectorNode3);
            this.addTreeSet(treeSelectorNode3, this.excludeSet);
        }
        return treeSelectorNode5;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList nameList, NameList nameList2, boolean bl) {
        this.replace(nameList, nameList2, null, bl);
    }

    public void replace(NameList nameList, NameList nameList2, NameList nameList3, boolean bl) {
        this.memberSelections = nameList;
        this.groupSelections = nameList2;
        this.clusterSelections = nameList3;
        this.allMembersSelected = bl;
        this.memberSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeSelectorNode, true);
        this.selectedTree.setModel(defaultTreeModel);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, boolean bl, boolean bl2) {
        TreeSelectorNode treeSelectorNode = null;
        boolean bl3 = this.includeClusters;
        boolean bl4 = this.includeClusters;
        while (nameList != null) {
            boolean bl5;
            boolean bl6;
            TreeSet treeSet;
            if ((nameList.nlState & 1) != 0) {
                treeSet = this.excludeSet;
                bl6 = false;
                bl5 = true;
            } else {
                treeSet = this.memberSet;
                bl6 = bl;
                bl5 = bl2;
            }
            if (this.clusterExpanding) {
                bl3 = false;
                bl6 = false;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl6, bl5, false, false, null, bl3, bl4);
            if (this.clusterExpanding || this.groupExpanding) {
                treeSelectorNode.setButtonFlag(false);
            }
            treeSet.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    public void addGroup(NameList nameList) {
        if (!this.sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList2, true, false, true, true, null);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, this.sourceGroupLabel, treeSelectorNode);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        this.clusterExpanding = false;
        this.groupExpanding = false;
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (nameList.nlID == -4) {
                this.sendRequest(this.groupType, -1);
            } else if (nameList.nlID == -3) {
                this.sendRequest(this.memberType, -1);
            } else if (nameList.nlID == -2) {
                this.sendRequest((short)101, -1);
            }
        } else if (nameList.nlInfo == this.groupType) {
            this.sendRequest(this.memberType, nameList.nlID);
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 99) {
            this.clusterExpanding = true;
            this.sendRequest(nameList.nlInfo, nameList.nlID);
        } else if (nameList.nlInfo == 13) {
            this.sendRequest(this.memberType, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    protected GuiListReq makeListRequestData(short s, int n) {
        GuiListReq guiListReq = new GuiListReq();
        if (s == 99) {
            guiListReq.listRequested = 11;
        } else {
            if (s == 101) {
                s = (short)99;
            }
            guiListReq.listRequested = s == 114 ? (int)s : 10000 + s;
            guiListReq.listRequested = s == 134 ? (int)s : 10000 + s;
            guiListReq.groupID = n;
        }
        if (this.excludeNAS) {
            guiListReq.excludeNAS = true;
        }
        if (this.excludeVS) {
            guiListReq.excludeVS = true;
        }
        if (this.getVersions) {
            guiListReq.getVersions = true;
            guiListReq.excludeVS = true;
        }
        return guiListReq;
    }

    protected GroupDefinition makeGroupRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendRequest(short s, int n) {
        Request request;
        if (s == 99) {
            GroupDefinition groupDefinition = this.makeGroupRequestData(s, n);
            this.listRequested = -1;
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        } else {
            GuiListReq guiListReq = this.makeListRequestData(s, n);
            this.listRequested = guiListReq.listRequested;
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        Cloneable cloneable;
        if (s > 4) {
            return;
        }
        boolean bl = this.includeClusters;
        boolean bl2 = this.includeClusters;
        Serializable serializable = response.responseData;
        NameList nameList = null;
        if (serializable instanceof GroupDefinition) {
            cloneable = (GroupDefinition)response.responseData;
            nameList = cloneable.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        cloneable = this.expansionNode.getNameList();
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList == null) {
            if (this.expansionTree == this.sourceTree && ((NameList)cloneable).nlID != -4) {
                this.addAllMembersNode(this.expansionNode, false);
                this.expansionModel.nodeStructureChanged(this.expansionNode);
                if (this.expansionTree == this.selectedTree) {
                    this.selector.pruneExcluded(this.expansionNode);
                } else {
                    this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
                }
            }
            return;
        }
        if (nameList.nlInfo == this.groupType || nameList.nlInfo == 99) {
            if (nameList.nlInfo == 99) {
                bl = false;
            }
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, true, false, false, true, null, bl, bl2);
                this.expansionNode.add(treeSelectorNode);
                nameList = nameList.nlNext;
            }
        } else {
            boolean bl3 = this.expansionTree == this.sourceTree;
            boolean bl4 = !bl3;
            this.addAllMembersNode(this.expansionNode, false);
            this.memberSet.clear();
            this.fillSets(nameList, bl3, bl4);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.groupRootLabel, -4, treeSelectorNode);
    }

    private TreeSelectorNode addClusterLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.clustersRootLabel, -2, treeSelectorNode);
    }

    private TreeSelectorNode addMemberLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.memberRootLabel, -3, treeSelectorNode);
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        String string2 = Util.getString(string);
        NameList nameList = this.newNameList(string2, n, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode2.setButtonFlag(false);
        treeSelectorNode2.setSortKey(n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllMembersNode(TreeSelectorNode treeSelectorNode, boolean bl) {
        String string = MessageLog.getMessageNoID(this.allMembersLabel);
        NameList nameList = this.newNameList(string, Integer.MAX_VALUE, 13);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }

    public void setDoPerfAlert(boolean bl) {
        this.doPerfAlert = bl;
    }

    public void setDoSwitchPerfAlert(boolean bl) {
        this.doSwitchPerfAlert = bl;
    }

    public void resetSelector() {
        Serializable serializable;
        Serializable serializable2;
        if (this.sourceTree != null) {
            serializable2 = this.newRoot();
            if (!this.doPerfAlert && !this.doSwitchPerfAlert) {
                this.sourceGroupLabel = this.addGroupLabel((TreeSelectorNode)serializable2);
            }
            this.addMemberLabel((TreeSelectorNode)serializable2);
            serializable = (DefaultTreeModel)this.sourceTree.getModel();
            ((DefaultTreeModel)serializable).setRoot((TreeNode)((Object)serializable2));
        }
        if (this.selectedTree != null) {
            serializable2 = (DefaultTreeModel)this.selectedTree.getModel();
            serializable = (TreeSelectorNode)((DefaultTreeModel)serializable2).getRoot();
            ((DefaultMutableTreeNode)serializable).removeAllChildren();
            serializable2 = new DefaultTreeModel((TreeNode)((Object)serializable));
            this.selectedTree.setModel((TreeModel)((Object)serializable2));
        }
    }

    public void setDevicesAvailable(NameList nameList) {
        this.devicesAvailable = nameList;
    }

    public void setSwitchesAvailable(NameList nameList) {
        this.switchesAvailable = nameList;
    }

    public void setMemberSelction(NameList nameList) {
        this.memberSelections = nameList;
    }
}

