/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.ResourceSettingsEditor;
import org.eclipse.aperi.TStorm.gui.SettingsDDI;
import org.eclipse.aperi.TStorm.gui.SettingsEditor;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class RemovedResourceSettingsEditor
extends ResourceSettingsEditor
implements SettingsEditor {
    private static final int FILESYSTEM = 0;
    private static final int DISK = 1;
    private static final int FILERS = 2;
    private static final int SUBSYSTEMS = 3;
    private static final int FABRIC = 4;
    private static final int TAPE = 5;
    private static final int TOTAL_FIELDS = 6;
    private static final itemDescriptor[] labelIDs = new itemDescriptor[]{new itemDescriptor("STG2600L", "NAME_FILESYSTEMS", "DESCRIPTION_FILESYSTEMS", "MNEMONIC_DAYSTOKEEPFORFS"), new itemDescriptor("STG1004L", "NAME_DISKS", "DESCRIPTION_DISKS", "MNEMONIC_DAYSTOKEEPFORDISK"), new itemDescriptor("FILERS", "FILERS", "DESCRIPTION_FILERS", "MNEMONIC_DAYSTOKEEPFORFILER"), new itemDescriptor("SUBSYSTEMS", "SUBSYSTEMS", "DESCRIPTION_SYBSYSTEMS", "MNEMONIC_DAYSTOKEEPFORSUBSYSTEM"), new itemDescriptor("LABEL_FABRIC", "LABEL_FABRIC", "DESCRIPTION_FABRIC", "MNEMONIC_DAYSTOKEEPFORFABRIC"), new itemDescriptor("LABEL_TAPE", "LABEL_TAPE", "DESCRIPTION_TAPE", "MNEMONIC_DAYSTOKEEPFORTAPE")};
    private String forString;

    public RemovedResourceSettingsEditor(SettingsDDI settingsDDI) {
        this.ddi = settingsDDI;
    }

    protected void fillSettingsFromValues(Settings settings) {
        int n = 0;
        settings.seKeepRemovedFS = this.values[n++];
        settings.seKeepRemovedDev = this.values[n++];
        settings.seKeepRemovedFilers = this.values[n++];
        settings.seKeepRemovedSubsystems = this.values[n++];
        settings.seKeepRemovedFabric = this.values[n++];
        settings.seKeepRemovedTape = this.values[n++];
    }

    protected void fillValuesFromSettings(Settings settings) {
        int n = 0;
        this.values[n++] = settings.seKeepRemovedFS;
        this.values[n++] = settings.seKeepRemovedDev;
        this.values[n++] = settings.seKeepRemovedFilers;
        this.values[n++] = settings.seKeepRemovedSubsystems;
        this.values[n++] = settings.seKeepRemovedFabric;
        this.values[n++] = settings.seKeepRemovedTape;
    }

    private JCheckBox newCheckBox(int n) {
        JCheckBox jCheckBox = new JCheckBox(Util.getString(RemovedResourceSettingsEditor.labelIDs[n].itemLabel));
        GuiUtil.setAccessible(jCheckBox, RemovedResourceSettingsEditor.labelIDs[n].itemComponent, RemovedResourceSettingsEditor.labelIDs[n].itemDescription);
        this.checkBoxes[n] = jCheckBox;
        return jCheckBox;
    }

    private JLabel newLabel(int n, String string) {
        this.leadingLabels[n] = new JLabel(string);
        this.leadingLabels[n].setForeground(Color.black);
        return this.leadingLabels[n];
    }

    private JTextField newTextField(int n) {
        this.fields[n] = TTextField.newTTextField(null, 3, 5, true);
        this.fields[n].setEnabled(true);
        return this.fields[n];
    }

    private JLabel makeRow(int n, Container container, GridBagConstraints gridBagConstraints) {
        JCheckBox jCheckBox = this.newCheckBox(n);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 23;
        container.add((Component)jCheckBox, gridBagConstraints);
        JLabel jLabel = this.newLabel(n, this.forString);
        gridBagConstraints.insets.left = 0;
        container.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.newTextField(n);
        GuiUtil.setAccessibleLabel(jLabel, jTextField, RemovedResourceSettingsEditor.labelIDs[n].itemMnemonic, RemovedResourceSettingsEditor.labelIDs[n].itemLabel, RemovedResourceSettingsEditor.labelIDs[n].itemLabel);
        gridBagConstraints.insets.left = 3;
        container.add((Component)jTextField, gridBagConstraints);
        jLabel = new JLabel("");
        gridBagConstraints.gridwidth = 0;
        return jLabel;
    }

    public JComponent getComponent(Settings settings) {
        this.checkBoxes = new JCheckBox[6];
        this.fields = new JTextField[6];
        this.leadingLabels = new JLabel[6];
        this.forString = MessageLog.getMessageNoID("STG3260L");
        String string = MessageLog.getMessageNoID("STG3249L");
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.top = 6;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        jLabel = this.makeRow(0, jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        jLabel = this.makeRow(1, jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        jLabel = this.makeRow(2, jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        jLabel = this.makeRow(3, jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 0;
        jLabel = this.makeRow(4, jPanel, gridBagConstraints);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 0;
        jLabel = this.makeRow(5, jPanel, gridBagConstraints);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalStrut(1), gridBagConstraints);
        this.values = new short[6];
        int n = 0;
        while (n < this.checkBoxes.length) {
            this.checkBoxes[n].addChangeListener(this);
            ++n;
        }
        this.pushSettingsOntoPanel(settings);
        return jPanel;
    }

    private static final class itemDescriptor {
        String itemLabel;
        String itemComponent;
        String itemDescription;
        String itemMnemonic;

        public itemDescriptor(String string, String string2, String string3, String string4) {
            this.itemLabel = string;
            this.itemComponent = string2;
            this.itemDescription = string3;
            this.itemMnemonic = string4;
        }
    }
}

