/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList memberSelections;
    private NameList groupSelections;
    private NameList reportingSelections;
    private NameList rootName;
    private short memberType;
    private short groupType;
    private TreeSet memberSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private String groupRootLabel;
    private String memberRootLabel;
    private String allMembersLabel;
    private TreeSelectorNode sourceGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    public boolean allMembersSelected;
    private boolean excludeNAS;
    private static final int ROOT_ID = -4;
    private static final int GROUP_ID = -3;
    private static final int REPORTING_GROUP_ID = -2;
    private static final int MEMBER_ID = -1;
    private static final int ALL_MEMBER_ID = Integer.MAX_VALUE;
    private String reportingGroupsLabel;
    private short repGroupType;
    private boolean useReportingGroups;
    private boolean resourcesAvailable;
    private short fsGroupType;
    private boolean isFS = false;
    private static final int FS_ID = -6;
    private static final int FS_GROUP_ID = -7;
    private TreeSelectorNode root;
    private int returnedObjectType;
    private int excludeMe;
    private boolean memType;
    private int savedID;

    public ReportingGroupSelector(short s, NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3, int n) {
        this.memberType = s;
        this.memberSelections = nameList;
        this.groupSelections = nameList2;
        this.reportingSelections = nameList3;
        this.allMembersSelected = bl;
        this.excludeNAS = bl2;
        this.useReportingGroups = bl3;
        this.excludeMe = n;
        switch (this.memberType) {
            case 1: {
                this.groupType = 0;
                this.repGroupType = (short)89;
                this.memberRootLabel = "STG4041L";
                this.groupRootLabel = "STG3012L";
                this.allMembersLabel = "STG3100L";
                this.reportingGroupsLabel = "STG4226L";
                break;
            }
            case 78: {
                this.groupType = (short)77;
                this.repGroupType = (short)93;
                this.memberRootLabel = "STG4191L";
                this.groupRootLabel = "STG5500L";
                this.allMembersLabel = "STG5501L";
                this.reportingGroupsLabel = "STG4226L";
                break;
            }
            case 3: {
                this.groupType = (short)2;
                this.repGroupType = (short)90;
                this.memberRootLabel = "STG1006L";
                this.groupRootLabel = "STG4032L";
                this.allMembersLabel = "STG4033L";
                this.reportingGroupsLabel = "STG4226L";
            }
        }
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList nameList = null;
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList[] nameListArray = new NameList[3];
        this.allMembersSelected = false;
        NameList nameList4 = this.selector.getNameList();
        while (nameList4 != null) {
            NameList nameList5 = (NameList)nameList4.clone();
            nameList5.nlNext = null;
            if (nameList5.nlInfo == this.groupType) {
                if (nameList2 == null) {
                    nameListArray[1] = nameList5;
                } else {
                    nameList2.nlNext = nameList5;
                }
                nameList2 = nameList5;
            } else if (nameList5.nlInfo == 13) {
                this.allMembersSelected = true;
            } else if (nameList5.nlInfo == this.repGroupType) {
                if (nameList == null) {
                    nameListArray[2] = nameList5;
                } else {
                    nameList.nlNext = nameList5;
                }
                nameList = nameList5;
            } else {
                if (nameList3 == null) {
                    nameListArray[0] = nameList5;
                } else {
                    nameList3.nlNext = nameList5;
                }
                nameList3 = nameList5;
            }
            nameList4 = nameList4.nlNext;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        this.sourceGroupLabel = this.addGroupLabel(treeSelectorNode);
        if (this.useReportingGroups) {
            this.addReportingGroupLabel(treeSelectorNode);
        }
        if (this.isFS) {
            this.addFSLabel(treeSelectorNode);
        } else {
            this.addMemberLabel(treeSelectorNode);
        }
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = null;
        TreeSelectorNode treeSelectorNode5 = this.newRoot();
        NameList nameList = this.groupSelections;
        while (nameList != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addGroupLabel(treeSelectorNode5);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList, true, false, true, true, null));
            nameList = nameList.nlNext;
        }
        nameList = this.reportingSelections;
        while (nameList != null) {
            if (treeSelectorNode4 == null) {
                treeSelectorNode4 = this.addReportingGroupLabel(treeSelectorNode5);
            }
            treeSelectorNode4.add(new TreeSelectorNode(nameList, true, false, true, true, null));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.memberSelections, true, false);
        if (this.allMembersSelected || !this.memberSet.isEmpty()) {
            treeSelectorNode2 = this.addMemberLabel(treeSelectorNode5);
            if (this.allMembersSelected) {
                this.addAllMembersNode(treeSelectorNode2, true);
            }
            this.addTreeSet(treeSelectorNode2, this.memberSet);
        }
        if (!this.excludeSet.isEmpty()) {
            treeSelectorNode3 = TreeSelector.makeExcludeRoot();
            treeSelectorNode5.add(treeSelectorNode3);
            this.addTreeSet(treeSelectorNode3, this.excludeSet);
        }
        this.fillSetsForReporting(this.reportingSelections, true, false);
        return treeSelectorNode5;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList nameList, NameList nameList2, boolean bl) {
        this.memberSelections = nameList;
        this.groupSelections = nameList2;
        this.allMembersSelected = bl;
        this.memberSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeSelectorNode, true);
        this.selectedTree.setModel(defaultTreeModel);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, boolean bl, boolean bl2) {
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl3;
            boolean bl4;
            TreeSet treeSet;
            if ((nameList.nlState & 1) != 0) {
                treeSet = this.excludeSet;
                bl4 = false;
                bl3 = true;
            } else {
                treeSet = this.memberSet;
                bl4 = bl;
                bl3 = bl2;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl4, bl3, false, false, null, true, true);
            treeSet.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void fillSetsForReporting(NameList nameList, boolean bl, boolean bl2) {
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl3;
            boolean bl4;
            TreeSet treeSet;
            if ((nameList.nlState & 1) != 0) {
                treeSet = this.excludeSet;
                bl4 = false;
                bl3 = true;
            } else {
                treeSet = this.memberSet;
                bl4 = bl;
                bl3 = bl2;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl4, bl3, false, false, null, true, true);
            treeSet.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    public void addGroup(NameList nameList) {
        if (!this.sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList2, true, false, true, true, null, true, true);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, this.sourceGroupLabel, treeSelectorNode);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (nameList.nlID == -3) {
                this.sendRequest(this.groupType, -1);
            } else if (nameList.nlID == -1) {
                this.sendRequest(this.memberType, -1);
            } else if (nameList.nlID == -2) {
                this.sendRequest(this.repGroupType, -1);
            } else if (nameList.nlID == -6) {
                this.sendRequest(this.fsGroupType, -1);
            } else if (nameList.nlInfo == this.groupType) {
                this.memType = true;
                this.sendRequest(this.memberType, nameList.nlID);
            } else if (nameList.nlInfo == 89) {
                this.returnedObjectType = 1;
                this.sendGroupListRequest((short)89, nameList.nlID);
            } else if (nameList.nlInfo == 93) {
                this.returnedObjectType = 1;
                this.sendGroupListRequest((short)93, nameList.nlID);
            }
        } else if (nameList.nlInfo == 89) {
            this.returnedObjectType = 1;
            this.sendGroupListRequest((short)89, nameList.nlID);
        } else if (nameList.nlInfo == this.groupType) {
            this.memType = true;
            this.sendRequest(this.memberType, nameList.nlID);
        } else if (nameList.nlInfo == 13) {
            this.sendRequest(this.memberType, -1);
        } else if (nameList.nlInfo == 89) {
            this.returnedObjectType = 1;
            this.sendGroupListRequest((short)89, nameList.nlID);
        } else if (nameList.nlInfo == 93) {
            this.returnedObjectType = 1;
            this.sendGroupListRequest((short)93, nameList.nlID);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    protected GuiListReq makeRequestData(short s, int n) {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10000 + s;
        guiListReq.groupID = n;
        if (this.excludeNAS) {
            guiListReq.excludeNAS = true;
        }
        if (s == 1) {
            guiListReq.includeUnmanaged = true;
        }
        return guiListReq;
    }

    private void sendRequest(short s, int n) {
        GuiListReq guiListReq = this.makeRequestData(s, n);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        GuiClient.doRequest(this, request);
    }

    protected GroupDefinition makeGroupListRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendGroupListRequest(short s, int n) {
        GroupDefinition groupDefinition = this.makeGroupListRequestData(s, n);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (this.returnedObjectType == 1) {
            this.processGroupList(response);
            this.returnedObjectType = 0;
        } else {
            this.processNameList(response);
        }
    }

    private void processGroupList(Response response) {
        Object object;
        Object object2;
        GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
        if (groupDefinition == null) {
            return;
        }
        NameList nameList = groupDefinition.members;
        NameList nameList2 = groupDefinition.maskList;
        if (nameList == null && nameList2 == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList != null) {
            if (nameList.nlInfo == this.groupType) {
                while (nameList != null) {
                    if (nameList.nlInfo == 89) {
                        object2 = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                        nameList.nlName = object2;
                        object = new TreeSelectorNode(nameList, false, false, true, false, null);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    } else if (nameList.nlInfo == 0) {
                        object2 = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                        nameList.nlName = object2;
                        object = new TreeSelectorNode(nameList, false, false, true, false, null);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    } else {
                        object = new TreeSelectorNode(nameList, false, false, false, false, null, true, true);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    }
                    if (object != null) {
                        this.expansionNode.add((MutableTreeNode)object);
                    }
                    nameList = nameList.nlNext;
                }
            } else if (nameList.nlInfo == this.repGroupType) {
                while (nameList != null) {
                    object = null;
                    object2 = "";
                    boolean bl = false;
                    if (nameList.nlInfo == 89 || nameList.nlInfo == 93) {
                        object2 = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                    } else if (nameList.nlInfo == 0 || nameList.nlInfo == 77) {
                        object2 = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                    } else {
                        bl = true;
                    }
                    if (!bl) {
                        nameList.nlName = object2;
                        object = new TreeSelectorNode(nameList, false, false, true, false, null, true, true);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    } else {
                        object = new TreeSelectorNode(nameList, false, false, false, false, null);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    }
                    if (object != null) {
                        this.expansionNode.add((MutableTreeNode)object);
                    }
                    nameList = nameList.nlNext;
                }
            } else if (nameList.nlInfo == 1) {
                while (nameList != null) {
                    object = null;
                    if (nameList.nlInfo == 89) {
                        nameList.nlName = object2 = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                        object = new TreeSelectorNode(nameList, false, false, true, false, null);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    } else if (nameList.nlInfo == 0) {
                        nameList.nlName = object2 = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                        object = new TreeSelectorNode(nameList, false, false, true, false, null);
                    } else {
                        object = new TreeSelectorNode(nameList, false, false, false, false, null, true, true);
                        ((TreeSelectorNode)object).setButtonFlag(false);
                    }
                    if (object != null) {
                        this.expansionNode.add((MutableTreeNode)object);
                    }
                    nameList = nameList.nlNext;
                }
            }
        }
        if (nameList2 != null) {
            while (nameList2 != null) {
                object = "";
                object2 = null;
                object = Util.getString("STG4229L", Util.getTranslatedName(nameList2.nlName));
                nameList2.nlName = object;
                object2 = new TreeSelectorNode(nameList2, false, false, false, false, null);
                ((TreeSelectorNode)object2).setButtonFlag(false);
                if (object2 != null) {
                    this.expansionNode.add((MutableTreeNode)object2);
                }
                nameList2 = nameList2.nlNext;
            }
        } else {
            boolean bl = this.expansionTree == this.sourceTree;
            boolean bl2 = !bl;
            this.memberSet.clear();
            this.fillSets(nameList, bl, bl2);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private void processNameList(Response response) {
        NameList nameList = (NameList)response.responseData;
        if (nameList == null) {
            this.resourcesAvailable = true;
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == this.groupType) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, true, false, true, true, null);
                if (treeSelectorNode != null) {
                    this.expansionNode.add(treeSelectorNode);
                }
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == this.repGroupType) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode = null;
                boolean bl = false;
                if (nameList.nlInfo != 89 && nameList.nlInfo != 93) {
                    bl = true;
                }
                if (!bl) {
                    if (nameList.nlID != this.excludeMe && nameList.nlID != this.savedID) {
                        treeSelectorNode = new TreeSelectorNode(nameList, true, false, true, true, null, true, true);
                    }
                } else {
                    treeSelectorNode = new TreeSelectorNode(nameList, true, false, false, false, null, true, true);
                }
                if (treeSelectorNode != null) {
                    this.expansionNode.add(treeSelectorNode);
                }
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 78) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode;
                if (this.groupType == 77) {
                    treeSelectorNode = new TreeSelectorNode(nameList, false, false, true, true, null);
                    treeSelectorNode.setButtonFlag(false);
                } else {
                    treeSelectorNode = new TreeSelectorNode(nameList, false, false, true, false, null);
                }
                if (treeSelectorNode != null) {
                    this.expansionNode.add(treeSelectorNode);
                }
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 1) {
            while (nameList != null) {
                TreeSelectorNode treeSelectorNode;
                if (this.memType) {
                    treeSelectorNode = new TreeSelectorNode(nameList, false, false, false, false, null, true, true);
                    treeSelectorNode.setButtonFlag(false);
                } else {
                    boolean bl = false;
                    if (this.repGroupType == 89) {
                        bl = true;
                    }
                    treeSelectorNode = new TreeSelectorNode(nameList, bl, false, false, false, null, true, true);
                }
                if (treeSelectorNode != null) {
                    this.expansionNode.add(treeSelectorNode);
                }
                nameList = nameList.nlNext;
            }
            this.memType = false;
        } else {
            boolean bl = this.expansionTree == this.sourceTree;
            boolean bl2 = !bl;
            this.memberSet.clear();
            this.fillSets(nameList, bl, bl2);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
        this.resourcesAvailable = true;
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -4, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.groupRootLabel, -3, treeSelectorNode);
    }

    private TreeSelectorNode addMemberLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.memberRootLabel, -1, treeSelectorNode);
    }

    private TreeSelectorNode addReportingGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.reportingGroupsLabel, -2, treeSelectorNode);
    }

    private TreeSelectorNode addFSLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode("STG1006L", -6, treeSelectorNode);
    }

    private TreeSelectorNode addFSGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode("STG4032L", -7, treeSelectorNode);
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        String string2 = MessageLog.getMessageNoID(string);
        NameList nameList = this.newNameList(string2, n, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode2.setButtonFlag(false);
        treeSelectorNode2.setSortKey(n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllMembersNode(TreeSelectorNode treeSelectorNode, boolean bl) {
        String string = MessageLog.getMessageNoID(this.allMembersLabel);
        NameList nameList = this.newNameList(string, Integer.MAX_VALUE, 13);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }

    public JTree getSourceTree() {
        return this.sourceTree;
    }

    public JTree getSelectedTree() {
        return this.selectedTree;
    }

    public TreeSelector getTreeSelector() {
        return this.selector;
    }

    public boolean getResourcesAvailable() {
        return this.resourcesAvailable;
    }

    public void hideSavedID(int n) {
        this.savedID = n;
    }
}

