/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.dbaccess;

import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.SlpAttributes;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.Vendor;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.util.SRMCrypto;

public class CIMOMDbAccess {
    static final String className;
    private static final String DEVICE_TYPE_UNKNOWN = "type_unknown";
    private static final String VENDOR_UNKNOWN = "vendor_unknown";
    private static final Map stParsDevTypeDef;
    private static final Map stParsVendorDef;
    private static final Map stParsNSpcDef;
    private static final Map stDevTypeDef;
    private static final Map stVendorDef;
    private static final Map stNSpcDef;
    protected static Map<String, Boolean> stSaxParsing;
    protected static Map<String, Boolean> stConcurrentAccess;
    private static int cUniqueInt;
    private static final short UNIQUENUMBERLENGTHDEFAULT = 7;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        stParsDevTypeDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.SaxParsing.SubsystemTypes");
        stParsVendorDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.SaxParsing.Vendors");
        stParsNSpcDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.SaxParsing.NameSpaces");
        stDevTypeDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.ReqSync.SubsystemTypes");
        stVendorDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.ReqSync.Vendors");
        stNSpcDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.ReqSync.NameSpaces");
        stSaxParsing = Collections.synchronizedMap(new HashMap());
        stConcurrentAccess = Collections.synchronizedMap(new HashMap());
        cUniqueInt = 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMOM getCIMMOMByDBKey(int n) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getCIMMOMByDBKey", new Object[]{String.valueOf(n)});
        CIMOM cIMOM = null;
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            DBCursor dBCursor = null;
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            try {
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), Integer.toString(n));
                    dBCursor = RegisteredCimom.getCursor(dBConnection, hashtable, null);
                    if (dBCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    if (dBCursor.next()) {
                        RegisteredCimom registeredCimom = ((RegisteredCimom.RegisteredCimomCursor)dBCursor).getObject();
                        if (registeredCimom == null) throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        if (registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        cIMOM = CIMOMDbAccess.createCIMOMObject(registeredCimom, dBConnection, logTraceHelper);
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (dBCursor != null) {
                        dBCursor.close();
                    }
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            {
                Object var7_10 = null;
            }
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
            if (dBCursor != null) {
                dBCursor.close();
            }
            dBConnection.close();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var10_15 = null;
            logTraceHelper.exit(null);
            return cIMOM;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMOM[] getCIMOMs(String[] stringArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getCIMOMs", stringArray);
        Object[] objectArray = new CIMOM[]{};
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            RegisteredCimom.RegisteredCimomCursor registeredCimomCursor = null;
            Vector<String> vector = new Vector<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    vector.add(stringArray[n]);
                    ++n;
                }
            }
            Vector<CIMOM> vector2 = new Vector<CIMOM>();
            try {
                try {
                    registeredCimomCursor = RegisteredCimom.getCursor(dBConnection, null, null);
                    if (registeredCimomCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    while (registeredCimomCursor.next()) {
                        RegisteredCimom registeredCimom = registeredCimomCursor.getObject();
                        if (registeredCimom == null) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        String string = registeredCimom.getServiceUrl();
                        if (vector.size() != 0 && !vector.contains(string) || registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) continue;
                        CIMOM cIMOM = CIMOMDbAccess.createCIMOMObject(registeredCimom, dBConnection, logTraceHelper);
                        vector2.add(cIMOM);
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (registeredCimomCursor != null) {
                        registeredCimomCursor.close();
                    }
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            {
                Object var10_14 = null;
            }
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
            if (registeredCimomCursor != null) {
                registeredCimomCursor.close();
            }
            dBConnection.close();
            objectArray = new CIMOM[vector2.size()];
            vector2.copyInto(objectArray);
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            logTraceHelper.exit(objectArray);
            throw throwable;
        }
        {
            Object var13_19 = null;
            logTraceHelper.exit(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CIMOM createCIMOMObject(RegisteredCimom registeredCimom, DBConnection dBConnection, LogTraceHelper logTraceHelper) throws SQLException, ServerException {
        Object object;
        SlpAttributes.SlpAttributesCursor slpAttributesCursor = null;
        String string = registeredCimom.getServiceUrl();
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl(string);
        cIMOM.setHiName(registeredCimom.getHiName());
        cIMOM.setDescription(registeredCimom.getDescription());
        cIMOM.setSoftwareLevel(registeredCimom.getSoftwareLevel());
        cIMOM.setProtocolVersion(registeredCimom.getProtocolVersion());
        cIMOM.setAuthenticationMechanism(registeredCimom.getAuthenticationMechanism());
        cIMOM.setUserId(registeredCimom.getUserId());
        cIMOM.setServiceId(String.valueOf(registeredCimom.getRegCimomId()));
        String string2 = registeredCimom.getPassword();
        if (string2 != null) {
            try {
                cIMOM.setPassword(SRMCrypto.decrypt(string2));
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Failed to decrypt password " + string2 + " for CIMOM " + string + "due to " + exception.getMessage(), exception);
            }
        }
        cIMOM.setTrustStoreLocation(registeredCimom.getTrustStoreLocation());
        cIMOM.setTrustStorePassphrase(registeredCimom.getTrustStorePassphrase());
        cIMOM.setInteropSchemaNamespace(registeredCimom.getInteropSchemaNamespace());
        cIMOM.setProtocol(registeredCimom.getProtocol());
        cIMOM.setDisplayName(registeredCimom.getDisplayName());
        cIMOM.setStatus(CIMOMConnectionStatus.getStatus(registeredCimom.getStatus()));
        Timestamp timestamp = registeredCimom.getStatusTimestamp();
        if (timestamp != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(timestamp);
            cIMOM.setStatusTimestamp((Calendar)object);
        }
        try {
            try {
                slpAttributesCursor = SlpAttributes.getCursor(dBConnection, null, null);
                if (slpAttributesCursor == null) {
                    throw DiskMessageHelper.getServerException("HWN021804E", string, logTraceHelper);
                }
                object = new String();
                while (slpAttributesCursor.next()) {
                    SlpAttributes slpAttributes = slpAttributesCursor.getObject();
                    if (slpAttributes == null) {
                        throw DiskMessageHelper.getServerException("HWN021804E", string, logTraceHelper);
                    }
                    if (slpAttributes.getRegCimomId() != registeredCimom.getRegCimomId()) continue;
                    object = String.valueOf(object) + slpAttributes.getAttributeName() + ":" + slpAttributes.getValue();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (slpAttributesCursor == null) throw throwable;
                slpAttributesCursor.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
        }
        if (slpAttributesCursor == null) return cIMOM;
        slpAttributesCursor.close();
        return cIMOM;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean needsSaxParsing(String string) {
        boolean bl;
        LogTraceHelper logTraceHelper = null;
        Boolean bl2 = null;
        try {
            bl2 = stSaxParsing.get(string);
            if (bl2 == null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                logTraceHelper = LogTraceHelper.entry(clazz.getName(), "needsSaxParsing", new Object[]{string});
                String string2 = "subsystem type";
                bl2 = CIMOMDbAccess.checkForSubsystemCIMOMParsing(string);
                if (bl2 == null) {
                    string2 = "switch vendor";
                    bl2 = CIMOMDbAccess.checkForVendorParsing(string, CIMOMDbAccess.getSwitchVendorForCIMOM(string));
                    if (bl2 == null) {
                        string2 = "tape library vendor";
                        bl2 = CIMOMDbAccess.checkForVendorParsing(string, CIMOMDbAccess.getLibraryVendorForCIMOM(string));
                        if (bl2 == null) {
                            string2 = "namespace";
                            bl2 = CIMOMDbAccess.checkForNamespaceofCIMOMParsing(string);
                            if (bl2 == null) {
                                bl2 = Boolean.FALSE;
                                Object var4_4 = null;
                                if (logTraceHelper == null) return false;
                                logTraceHelper.exit(bl2);
                                return false;
                            }
                        }
                    }
                }
                logTraceHelper.traceWarning("Caching 'SAX parsing needed = " + bl2.toString() + "' for CIMOM " + string + " (Reason: " + string2 + ")");
                stSaxParsing.put(string, bl2);
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (logTraceHelper == null) throw throwable;
            logTraceHelper.exit(bl2);
            throw throwable;
        }
        Object var4_5 = null;
        if (logTraceHelper == null) return bl;
        logTraceHelper.exit(bl2);
        return bl;
    }

    private static final Boolean checkForNamespaceofCIMOMParsing(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(clazz.getName(), "checkForNamespaceofCIMOMParsing", new Object[]{string});
        Boolean bl = null;
        try {
            List list = CIMOMDbAccess.getNamespacesForCIMOM(string);
            Iterator iterator = list.iterator();
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string3 = (String)stParsNSpcDef.get(string2);
                if (string3 == null) continue;
                bl = Boolean.TRUE;
            }
            Boolean bl2 = bl;
            Object var7_8 = null;
            logTraceHelper.exit(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            logTraceHelper.exit(bl);
            throw throwable;
        }
    }

    private static final Boolean checkForVendorParsing(String string, String string2) {
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block5: {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper = LogTraceHelper.entry(clazz.getName(), "checkForVendorParsing", new Object[]{string, string2});
            bl = null;
            try {
                if (!VENDOR_UNKNOWN.equals(string2)) break block5;
                Object var5_4 = null;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stParsVendorDef.get(string2);
        bl = string3 == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl2 = bl;
        Object var5_5 = null;
        logTraceHelper.exit(bl);
        return bl2;
    }

    private static final Boolean checkForSubsystemCIMOMParsing(String string) {
        String string2;
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block6: {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper = LogTraceHelper.entry(clazz.getName(), "checkForSubsystemCIMOMParsing", new Object[]{string});
            bl = null;
            try {
                string2 = CIMOMDbAccess.getSubsystemTypeForCIMOM(string);
                if (!DEVICE_TYPE_UNKNOWN.equals(string2)) {
                    if (!"Unknown".equals(string2)) break block6;
                }
                Object var5_4 = null;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stParsDevTypeDef.get(string2);
        bl = string3 == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl2 = bl;
        Object var5_5 = null;
        logTraceHelper.exit(bl);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean allowsConcurrentAccess(String string) {
        boolean bl;
        LogTraceHelper logTraceHelper = null;
        Boolean bl2 = null;
        try {
            bl2 = stConcurrentAccess.get(string);
            if (bl2 == null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                logTraceHelper = LogTraceHelper.entry(clazz.getName(), "allowsConcurrentAccess", new Object[]{string});
                String string2 = "subsystem type";
                bl2 = CIMOMDbAccess.checkForSubsystemCIMOM(string);
                if (bl2 == null) {
                    string2 = "switch vendor";
                    bl2 = CIMOMDbAccess.checkForVendor(string, CIMOMDbAccess.getSwitchVendorForCIMOM(string));
                    if (bl2 == null) {
                        string2 = "tape library vendor";
                        bl2 = CIMOMDbAccess.checkForVendor(string, CIMOMDbAccess.getLibraryVendorForCIMOM(string));
                        if (bl2 == null) {
                            string2 = "namespace";
                            bl2 = CIMOMDbAccess.checkForNamespaceofCIMOM(string);
                            if (bl2 == null) {
                                bl2 = Boolean.TRUE;
                                Object var4_4 = null;
                                if (logTraceHelper == null) return true;
                                logTraceHelper.exit(bl2);
                                return true;
                            }
                        }
                    }
                }
                logTraceHelper.traceWarning("Caching 'concurrent access = " + bl2.toString() + "' for CIMOM " + string + " (Reason: " + string2 + ")");
                stConcurrentAccess.put(string, bl2);
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (logTraceHelper == null) throw throwable;
            logTraceHelper.exit(bl2);
            throw throwable;
        }
        Object var4_5 = null;
        if (logTraceHelper == null) return bl;
        logTraceHelper.exit(bl2);
        return bl;
    }

    private static final Boolean checkForSubsystemCIMOM(String string) {
        String string2;
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block6: {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper = LogTraceHelper.entry(clazz.getName(), "checkForSubsystemCIMOM", new Object[]{string});
            bl = null;
            try {
                string2 = CIMOMDbAccess.getSubsystemTypeForCIMOM(string);
                if (!DEVICE_TYPE_UNKNOWN.equals(string2)) {
                    if (!"Unknown".equals(string2)) break block6;
                }
                Object var5_4 = null;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stDevTypeDef.get(string2);
        bl = string3 == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = bl;
        Object var5_5 = null;
        logTraceHelper.exit(bl);
        return bl2;
    }

    private static final Boolean checkForNamespaceofCIMOM(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(clazz.getName(), "checkForNamespaceofCIMOM", new Object[]{string});
        Boolean bl = null;
        try {
            List list = CIMOMDbAccess.getNamespacesForCIMOM(string);
            Iterator iterator = list.iterator();
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string3 = (String)stNSpcDef.get(string2);
                if (string3 == null) continue;
                bl = Boolean.FALSE;
            }
            Boolean bl2 = bl;
            Object var7_8 = null;
            logTraceHelper.exit(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            logTraceHelper.exit(bl);
            throw throwable;
        }
    }

    private static final Boolean checkForVendor(String string, String string2) {
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block5: {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.common.dbaccess.CIMOMDbAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper = LogTraceHelper.entry(clazz.getName(), "checkForVendor", new Object[]{string, string2});
            bl = null;
            try {
                if (!VENDOR_UNKNOWN.equals(string2)) break block5;
                Object var5_4 = null;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stVendorDef.get(string2);
        bl = string3 == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = bl;
        Object var5_5 = null;
        logTraceHelper.exit(bl);
        return bl2;
    }

    /*
     * Loose catch block
     */
    private static final String getSubsystemTypeForCIMOM(String string) {
        DBResultSet dBResultSet;
        DBPreparedStatement dBPreparedStatement;
        DBConnection dBConnection;
        block19: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select ss.").append("TYPE").append(" from ");
            stringBuffer.append(StorageSubsystem.getTablename()).append(" as ss where ss.");
            stringBuffer.append("SUBSYSTEM_ID").append(" in (select ck.");
            stringBuffer.append("SUBSYSTEM_ID").append(" from ").append(CimkeySubsystem.getTablename());
            stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
            stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
            stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
            stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
            stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?)))");
            dBConnection = null;
            dBPreparedStatement = null;
            dBResultSet = null;
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (!dBResultSet.next()) break block19;
            String string2 = dBResultSet.getString(1);
            Object var5_6 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return string2;
        }
        while (true) {
            Object var5_7 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return DEVICE_TYPE_UNKNOWN;
            catch (Exception exception) {
                try {
                    continue;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        if (dBResultSet != null) {
                            dBResultSet.close();
                        }
                        if (dBPreparedStatement != null) {
                            dBPreparedStatement.close();
                        }
                        if (dBConnection != null) {
                            dBConnection.commit();
                            dBConnection.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * Loose catch block
     */
    private static final String getSwitchVendorForCIMOM(String string) {
        DBResultSet dBResultSet;
        DBPreparedStatement dBPreparedStatement;
        DBConnection dBConnection;
        block19: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select v.").append("VENDOR_NAME").append(" from ");
            stringBuffer.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
            stringBuffer.append("select sw.").append("VENDOR_ID").append(" from ");
            stringBuffer.append(Switch.getTablename()).append(" as sw where sw.");
            stringBuffer.append("SWITCH_WWN").append(" in (select ck.");
            stringBuffer.append("SWITCH_WWN").append(" from ").append(CimkeySwitch.getTablename());
            stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
            stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
            stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
            stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
            stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
            dBConnection = null;
            dBPreparedStatement = null;
            dBResultSet = null;
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (!dBResultSet.next()) break block19;
            String string2 = dBResultSet.getString(1);
            Object var5_6 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return string2;
        }
        while (true) {
            Object var5_7 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return VENDOR_UNKNOWN;
            catch (Exception exception) {
                try {
                    continue;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        if (dBResultSet != null) {
                            dBResultSet.close();
                        }
                        if (dBPreparedStatement != null) {
                            dBPreparedStatement.close();
                        }
                        if (dBConnection != null) {
                            dBConnection.commit();
                            dBConnection.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * Loose catch block
     */
    private static final String getLibraryVendorForCIMOM(String string) {
        DBResultSet dBResultSet;
        DBPreparedStatement dBPreparedStatement;
        DBConnection dBConnection;
        block19: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select v.").append("VENDOR_NAME").append(" from ");
            stringBuffer.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
            stringBuffer.append("select tf.").append("VENDOR_ID").append(" from ");
            stringBuffer.append(TapeFrame.getTablename()).append(" as tf where tf.");
            stringBuffer.append("TAPE_LIBRARY_ID").append(" in (select ck.");
            stringBuffer.append("TAPE_LIBRARY_ID").append(" from ").append(CimkeyTapeLibrary.getTablename());
            stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
            stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
            stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
            stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
            stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
            dBConnection = null;
            dBPreparedStatement = null;
            dBResultSet = null;
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (!dBResultSet.next()) break block19;
            String string2 = dBResultSet.getString(1);
            Object var5_6 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return string2;
        }
        while (true) {
            Object var5_7 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return VENDOR_UNKNOWN;
            catch (Exception exception) {
                try {
                    continue;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        if (dBResultSet != null) {
                            dBResultSet.close();
                        }
                        if (dBPreparedStatement != null) {
                            dBPreparedStatement.close();
                        }
                        if (dBConnection != null) {
                            dBConnection.commit();
                            dBConnection.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final List getNamespacesForCIMOM(String string) {
        ArrayList<String> arrayList2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select c2n.").append("NAMESPACE").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?)");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try {
                dBConnection = ServiceUtils.getConnection();
                dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
                dBPreparedStatement.clearParameters();
                dBPreparedStatement.setString(1, string);
                dBResultSet = dBPreparedStatement.executeQuery();
                while (true) {
                    if (!dBResultSet.next()) {
                        arrayList2 = arrayList;
                        Object var6_8 = null;
                        break;
                    }
                    arrayList.add(dBResultSet.getString(1));
                }
            }
            catch (Exception exception) {
                ArrayList arrayList3 = new ArrayList();
                Object var6_9 = null;
                try {
                    if (dBResultSet != null) {
                        dBResultSet.close();
                    }
                    if (dBPreparedStatement != null) {
                        dBPreparedStatement.close();
                    }
                    if (dBConnection == null) return arrayList3;
                    dBConnection.commit();
                    dBConnection.close();
                    return arrayList3;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                return arrayList3;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {}
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw throwable;
            }
            if (dBResultSet != null) {
                dBResultSet.close();
            }
            if (dBPreparedStatement != null) {
                dBPreparedStatement.close();
            }
            if (dBConnection == null) throw throwable;
            dBConnection.commit();
            dBConnection.close();
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return arrayList2;
        }
        if (dBResultSet != null) {
            dBResultSet.close();
        }
        if (dBPreparedStatement != null) {
            dBPreparedStatement.close();
        }
        if (dBConnection == null) return arrayList2;
        dBConnection.commit();
        dBConnection.close();
        return arrayList2;
    }

    private static final Map getDefinitionForSync(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getDefinitionForSync", new Object[]{string});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = DiskManagerConfigSvc.getConfigValue(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "]");
                String string3 = null;
                String[] stringArray = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().substring(1);
                    stringArray = string3.split(";");
                    logTraceHelper.traceWarning("Using synchronized access for device type " + string3);
                    if (stringArray.length > 1) {
                        hashMap.put(stringArray[0], stringArray[1]);
                        continue;
                    }
                    hashMap.put(stringArray[0], "*");
                }
            }
            HashMap<String, String> hashMap2 = hashMap;
            Object var7_8 = null;
            logTraceHelper.exit(hashMap);
            return hashMap2;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            logTraceHelper.exit(hashMap);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getCIMOMIDforURL(String var0) throws SQLException {
        block15: {
            block14: {
                var1_1 = LogTraceHelper.entry(CIMOMDbAccess.className, "getCIMOMIDforURL", new Object[]{var0});
                var2_2 = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                var3_3 = null;
                var4_4 = 0;
                try {
                    var5_5 = new Hashtable<ColumnInfo, String>();
                    var5_5.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), var0);
                    var6_6 = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " = ?";
                    var3_3 = ComplexQuery.sqlQuery(var2_2, var6_6, var5_5);
                    if (var3_3.next()) {
                        var4_4 = var3_3.getInt(1);
                    }
                }
                catch (Throwable var8_7) {
                    var7_8 = null;
                    try {
                        if (var3_3 != null) {
                            var3_3.closeAll();
                        }
                    }
                    catch (SQLException var9_10) {
                        var1_1.traceError("Unable to close database result set due to " + var9_10.getMessage(), var9_10);
                    }
                    try {
                        var2_2.close();
                    }
                    catch (SQLException var9_10) {
                        var1_1.traceError("Unable to close database connection due to " + var9_10.getMessage(), var9_10);
                    }
                    var1_1.exit(Integer.toString(var4_4));
                    throw var8_7;
                }
                {
                    var7_9 = null;
                }
                ** try [egrp 1[TRYBLOCK] [2 : 130->141)] { 
lbl34:
                // 1 sources

                if (var3_3 != null) {
                    var3_3.closeAll();
                }
                break block14;
lbl37:
                // 1 sources

                catch (SQLException var9_11) {
                    var1_1.traceError("Unable to close database result set due to " + var9_11.getMessage(), var9_11);
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 170->177)] { 
lbl41:
            // 1 sources

            var2_2.close();
            break block15;
lbl43:
            // 1 sources

            catch (SQLException var9_11) {
                var1_1.traceError("Unable to close database connection due to " + var9_11.getMessage(), var9_11);
            }
        }
        var1_1.exit(Integer.toString(var4_4));
        return var4_4;
    }

    public static CIMOM[] findCIMOMsByNetAddress(InetAddress inetAddress) {
        try {
            CIMOM[] cIMOMArray = CIMOMDbAccess.searchCimomInDb(inetAddress.getHostAddress());
            if (cIMOMArray.length == 0) {
                cIMOMArray = CIMOMDbAccess.searchCimomInDb(inetAddress.getCanonicalHostName());
            }
            return cIMOMArray;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private static CIMOM[] searchCimomInDb(String string) throws SQLException {
        CIMOM[] cIMOMArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "searchCimomInDb", new Object[]{string});
        DBResultSet dBResultSet = null;
        CIMOM[] cIMOMArray2 = null;
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), "%//" + string + ":%");
            String string2 = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " LIKE (?)";
            dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (dBResultSet.next()) {
                arrayList.add(dBResultSet.getString("SERVICE_URL"));
            }
            cIMOMArray = cIMOMArray2 = CIMOMDbAccess.getCIMOMs(arrayList.toArray(new String[arrayList.size()]));
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.closeAll();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database result set due to " + sQLException.getMessage(), sQLException);
            }
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
            }
            logTraceHelper.exit(cIMOMArray2);
            throw throwable;
        }
        try {
            if (dBResultSet != null) {
                dBResultSet.closeAll();
            }
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceError("Unable to close database result set due to " + sQLException.getMessage(), sQLException);
        }
        try {
            if (dBConnection != null) {
                dBConnection.close();
            }
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
        }
        logTraceHelper.exit(cIMOMArray2);
        return cIMOMArray;
    }

    public static String getUniqueNumberString() {
        int n;
        String string;
        int n2 = 7;
        if ((string = Integer.toString(n = cUniqueInt++)).length() > n2) {
            return string.substring(string.length() - n2);
        }
        if (string.length() < n2) {
            return String.valueOf("000000000000000000000000000".substring(0, n2 - string.length())) + string;
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRegCimomIDForCimomURL(String string, ILogger iLogger) throws Exception {
        DBConnection dBConnection;
        String string2 = "getRegCimomIDForCimomURL";
        int n = -1;
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
        }
        if ((dBConnection = ServiceUtils.getConnection()) == null) {
            return -1;
        }
        String string3 = "SELECT REG_CIMOM_ID FROM " + TResRegisteredCimomTable.getTablename() + " " + "WHERE SERVICE_URL = '" + string + "'";
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.text(IRecordType.TYPE_INFO, className, string2, "query = " + string3);
        }
        DBResultSet dBResultSet = null;
        try {
            try {
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
                if (dBResultSet.next()) {
                    n = dBResultSet.getInt(1);
                }
                dBConnection.commit();
            }
            catch (Exception exception) {
                if (iLogger == null) throw exception;
                if (!iLogger.isLogging()) throw exception;
                iLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (Exception exception) {}
        if (dBResultSet != null) {
            dBResultSet.close();
        }
        try {}
        catch (Exception exception) {}
        if (dBConnection != null) {
            dBConnection.close();
        }
        if (iLogger == null) return n;
        if (!iLogger.isLogging()) return n;
        iLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return n;
    }
}

