/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.RemoveMissingUtils;
import org.eclipse.aperi.discovery.interfaces.IRemoveMissingProcessor;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.discovery.SubsystemDBHelper;
import org.eclipse.aperi.gui.tape.common.model.TapeLibraryDBHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2hba;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Port2port;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceDeletedEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class RemoveMissingProcessor
implements IRemoveMissingProcessor {
    private static final String className;
    public static final String MESSAGE_NAME = "aperi.logger.message.RemoveMissing";
    public static final String TRACE_NAME = "aperi.logger.trace.RemoveMissing";
    public static String MSG_FILE;
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    private static HashMap classMap;
    HashSet entityGroups = null;
    private IDiskManagementService cMgmtOps = null;
    private TapeLibraryDBHelper cTapeDBHelper = null;
    private boolean isHostRemovable = true;
    private String mDeviceServerHost = null;
    private int mDeviceServerPort = -1;
    private static boolean TRACE;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.RemoveMissingProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        MSG_FILE = "org.eclipse.aperi.resources.RemoveMissingProcessorTMS";
        msgLogger = null;
        traceLogger = null;
        classMap = new HashMap();
        TRACE = TraceLogger.enableTrace;
    }

    public RemoveMissingProcessor() {
        this(null, -1);
    }

    public RemoveMissingProcessor(String string, int n) {
        Class<?> clazz;
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        this.mDeviceServerHost = string;
        this.mDeviceServerPort = n;
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.api.IDiskManagerService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.cMgmtOps = (IDiskManagementService)ConnectorClient.getService((String)string, (int)n, clazz, (String)"DiskManagerService");
        this.cTapeDBHelper = new TapeLibraryDBHelper();
        TRACE = TraceLogger.enableTrace;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized short performDeletionForSelectedMissingEntities(String[] var1_1) {
        block16: {
            var2_2 = "performDeletionForSelectedMissingEntities";
            var3_3 = false;
            var4_4 = null;
            this.isHostRemovable = true;
            if (RemoveMissingProcessor.TRACE) {
                TraceLogger.entry(RemoveMissingProcessor.className, var2_2, var1_1.toString());
                var5_5 = "";
                if (var1_1 != null && var1_1.length > 0) {
                    var6_7 = new StringBuffer();
                    var7_8 = 0;
                    while (true) {
                        if (var7_8 >= var1_1.length) {
                            var5_5 = String.valueOf(var1_1.length) + " missing entities: " + var6_7.toString() + " are selected.";
                            TraceLogger.traceMessage(1, RemoveMissingProcessor.className, var2_2, (String)var5_5);
                            break block16;
                        }
                        var6_7.append(var1_1[var7_8]);
                        var6_7.append("||");
                        ++var7_8;
                    }
                }
                var5_5 = "No missing entity selected.";
                TraceLogger.traceMessage(1, RemoveMissingProcessor.className, var2_2, (String)var5_5);
            }
        }
        try {
            try {
                block17: {
                    var4_4 = RemoveMissingUtils.getDBConnection();
                    var5_5 = this.determineSelectedMissingList(var1_1, var4_4);
                    if (var5_5.isEmpty()) break block17;
                    var3_3 = this.processDeleteMissing((HashSet)var5_5, var4_4);
                    ** GOTO lbl-1000
                }
                var3_3 = true;
            }
            catch (Exception var5_6) {
                TraceLogger.exception(RemoveMissingProcessor.className, var2_2, var5_6);
            }
        }
        catch (Throwable var7_9) {
            var6_7 = null;
            RemoveMissingUtils.closeConnection(var4_4);
            throw var7_9;
        }
lbl-1000:
        // 3 sources

        {
            var6_7 = null;
        }
        RemoveMissingUtils.closeConnection(var4_4);
        if (!this.isHostRemovable) {
            if (var3_3) {
                if (RemoveMissingProcessor.TRACE) {
                    var5_5 = "Remove success except selected host is not removable.";
                    TraceLogger.traceMessage(1, RemoveMissingProcessor.className, var2_2, (String)var5_5);
                    TraceLogger.exit(RemoveMissingProcessor.className, var2_2);
                }
                return 100;
            }
            if (RemoveMissingProcessor.TRACE) {
                var5_5 = "Remove failed and selected host is not removable.";
                TraceLogger.traceMessage(1, RemoveMissingProcessor.className, var2_2, (String)var5_5);
                TraceLogger.exit(RemoveMissingProcessor.className, var2_2);
            }
            return 12;
        }
        if (var3_3) {
            if (RemoveMissingProcessor.TRACE) {
                var5_5 = "Remove success.";
                TraceLogger.traceMessage(1, RemoveMissingProcessor.className, var2_2, (String)var5_5);
                TraceLogger.exit(RemoveMissingProcessor.className, var2_2);
            }
            return 0;
        }
        if (RemoveMissingProcessor.TRACE) {
            var5_5 = "Remove failed.";
            TraceLogger.traceMessage(1, RemoveMissingProcessor.className, var2_2, (String)var5_5);
            TraceLogger.exit(RemoveMissingProcessor.className, var2_2);
        }
        return 12;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized short performScheduledDeletionForMissingEntity(String var1_1, String var2_2) {
        block22: {
            block24: {
                block25: {
                    var3_3 = "performScheduledDeletionForMissingEntity";
                    var4_4 = 0;
                    var5_5 = null;
                    var6_6 = new HashSet<String>();
                    var7_7 = null;
                    var8_8 = null;
                    var9_9 = null;
                    if (RemoveMissingProcessor.traceLogger.isLogging()) {
                        RemoveMissingProcessor.traceLogger.entry(IRecordType.TYPE_ENTRY, RemoveMissingProcessor.className, var3_3);
                    }
                    if (var2_2 == null) break block25;
                    var5_5 = new String[]{String.valueOf(var1_1) + ':' + var2_2};
                    try lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var6_6.size() > 0) {
                                var5_5 = var6_6.toArray(new String[0]);
                            }
                            if (var5_5 != null) {
                                var4_4 = this.performDeletionForSelectedMissingEntities(var5_5);
                            }
                            break block22;
                            break;
                        }
                    }
                    catch (Exception var10_14) {
                        RemoveMissingProcessor.traceLogger.exception(IRecordType.TYPE_ERROR, RemoveMissingProcessor.className, var3_3, var10_14);
                    }
                    break block22;
                }
                try {
                    try {
                        block26: {
                            var9_9 = RemoveMissingUtils.getDBConnection();
                            if (!var1_1.equals("switch")) break block26;
                            var8_8 = RemoveMissingUtils.getAllMissingSwitches(var7_7, var9_9);
                            while (var8_8.next()) {
                                var10_10 = "" + var8_8.getInt("switchId");
                                var6_6.add("switch:" + var10_10);
                            }
                            ** GOTO lbl-1000
                        }
                        if (var1_1.equals("fabric")) {
                            var8_8 = RemoveMissingUtils.getAllMissingFabrics(var7_7, var9_9);
                            while (var8_8.next()) {
                                var10_11 = "" + var8_8.getInt("fabricId");
                                var6_6.add("fabric:" + var10_11);
                            }
                        } else if (var1_1.equals("tapelibrary")) {
                            var8_8 = RemoveMissingUtils.getAllMissingTapeLibraries(var7_7, var9_9);
                            while (var8_8.next()) {
                                var10_12 = "" + var8_8.getInt("libId");
                                var6_6.add("tapelibrary:" + var10_12);
                            }
                        }
                    }
                    catch (Exception var10_13) {
                        var10_13.printStackTrace();
                    }
                }
                catch (Throwable var12_15) {
                    var11_16 = null;
                    if (var8_8 != null) {
                        try {
                            var8_8.getStatement().close();
                        }
                        catch (Exception v0) {}
                    }
                    RemoveMissingUtils.closeConnection(var9_9);
                    throw var12_15;
                }
lbl-1000:
                // 4 sources

                {
                    var11_17 = null;
                    if (var8_8 == null) break block24;
                }
                try {}
                catch (Exception v1) {}
                var8_8.getStatement().close();
            }
            RemoveMissingUtils.closeConnection(var9_9);
            ** while (true)
        }
        if (RemoveMissingProcessor.traceLogger.isLogging()) {
            RemoveMissingProcessor.traceLogger.exit(IRecordType.TYPE_EXIT, RemoveMissingProcessor.className, var3_3);
        }
        return var4_4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean performScheduledFabricDeletion() {
        CharSequence charSequence;
        short s;
        String string;
        block20: {
            block21: {
                DBConnection dBConnection;
                String[] stringArray;
                block19: {
                    string = "performScheduledFabricDeletion";
                    s = 12;
                    if (traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
                    }
                    if (TRACE) {
                        TraceLogger.entry(className, string, "");
                    }
                    stringArray = this.getExpiredFabricEntities();
                    dBConnection = null;
                    if (TRACE) {
                        if (stringArray != null && stringArray.length > 0) {
                            charSequence = new StringBuffer();
                            int n = 0;
                            while (true) {
                                if (n >= stringArray.length) {
                                    String string2 = "Deleting " + stringArray.length + " required missing obects...";
                                    TraceLogger.traceMessage(1, className, string, string2);
                                    break block19;
                                }
                                ((StringBuffer)charSequence).append(stringArray[n]);
                                ((StringBuffer)charSequence).append("||");
                                ++n;
                            }
                        }
                        charSequence = "No required missing entity found.";
                        TraceLogger.traceMessage(1, className, string, (String)charSequence);
                    }
                }
                if (stringArray == null || stringArray.length <= 0) break block21;
                try {
                    try {
                        dBConnection = RemoveMissingUtils.getDBConnection();
                        dBConnection.setAutoCommit(false);
                        int n = 0;
                        while (true) {
                            if (n >= stringArray.length) {
                                dBConnection.commit();
                                s = 0;
                            }
                            int n2 = stringArray[n].indexOf(58);
                            String string3 = stringArray[n].substring(0, n2);
                            String string4 = stringArray[n].substring(n2 + 1);
                            this.deleteEntityWithRetry(string3, string4, dBConnection);
                            ++n;
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        try {
                            dBConnection.rollback();
                        }
                        catch (SQLException sQLException2) {
                            sQLException2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    RemoveMissingUtils.closeConnection(dBConnection);
                    throw throwable;
                }
                {
                    Object var9_16 = null;
                    RemoveMissingUtils.closeConnection(dBConnection);
                    break block20;
                }
            }
            s = 0;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, s);
        }
        if (s == 0) {
            if (TRACE) {
                charSequence = "Success";
                TraceLogger.traceMessage(1, className, string, (String)charSequence);
            }
            return true;
        }
        if (TRACE) {
            charSequence = "Failed.";
            TraceLogger.traceMessage(1, className, string, (String)charSequence);
        }
        return false;
    }

    public synchronized boolean performScheduledTapeDeletion() {
        boolean bl;
        String string = "performScheduledTapeDeletion";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        short s = 12;
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        String[] stringArray = this.getExpiredTapeLibraries();
        if (TRACE) {
            CharSequence charSequence;
            if (stringArray != null && stringArray.length > 0) {
                charSequence = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    ((StringBuffer)charSequence).append(stringArray[n]);
                    ((StringBuffer)charSequence).append("||");
                    ++n;
                }
                String string2 = "Deleting " + stringArray.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, string, string2);
            } else {
                charSequence = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, string, (String)charSequence);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf(58);
                    String string3 = stringArray[n].substring(0, n2);
                    String string4 = stringArray[n].substring(n2 + 1);
                    this.handleTape(string3, string4);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    TraceLogger.exception(className, string, exception);
                }
                s = 12;
            }
        }
        s = (bl = this.handleExpiredTapeSubentities()) ? (short)0 : 12;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, s);
        }
        if (s == 0) {
            if (TRACE) {
                String string5 = "Success";
                TraceLogger.traceMessage(1, className, string, string5);
            }
            return true;
        }
        if (TRACE) {
            String string6 = "Failed.";
            TraceLogger.traceMessage(1, className, string, string6);
        }
        return false;
    }

    public synchronized boolean performScheduledSubsystemDeletion() {
        boolean bl;
        String string = "performScheduledSubsystemDeletion";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        short s = 12;
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        String[] stringArray = this.getExpiredSubsystems();
        if (TRACE) {
            CharSequence charSequence;
            if (stringArray != null && stringArray.length > 0) {
                charSequence = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    ((StringBuffer)charSequence).append(stringArray[n]);
                    ((StringBuffer)charSequence).append("||");
                    ++n;
                }
                String string2 = "Deleting " + stringArray.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, string, string2);
            } else {
                charSequence = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, string, (String)charSequence);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf(58);
                    String string3 = stringArray[n].substring(0, n2);
                    String string4 = stringArray[n].substring(n2 + 1);
                    this.handleSubsystem(string3, string4);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                s = 12;
            }
        }
        s = (bl = this.handleExpiredSubsystemSubentities()) ? (short)0 : 12;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, s);
        }
        if (s == 0) {
            if (TRACE) {
                String string5 = "Success";
                TraceLogger.traceMessage(1, className, string, string5);
            }
            return true;
        }
        if (TRACE) {
            String string6 = "Failed.";
            TraceLogger.traceMessage(1, className, string, string6);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getExpiredFabricEntities() {
        DBConnection dBConnection;
        block6: {
            String[] stringArray;
            String string = "getExpiredFabricEntities";
            ArrayList arrayList = new ArrayList();
            dBConnection = RemoveMissingUtils.getDBConnection();
            if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
                return null;
            }
            try {
                try {
                    String[] stringArray2;
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("fabric", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("fabric2switch", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("switch", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("blade", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("switch2port", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("host", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("hba", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("node2hba", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("pe", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("pe2node", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("node", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("port", dBConnection));
                    arrayList.addAll(RemoveMissingUtils.getExpiredMissingEntities("port2port", dBConnection));
                    if (arrayList == null) break block6;
                    stringArray = stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    Object var5_7 = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                RemoveMissingUtils.closeConnection(dBConnection);
                throw throwable;
            }
            RemoveMissingUtils.closeConnection(dBConnection);
            return stringArray;
        }
        Object var5_9 = null;
        RemoveMissingUtils.closeConnection(dBConnection);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getExpiredTapeLibraries() {
        DBConnection dBConnection;
        block6: {
            String[] stringArray;
            String string = "getExpiredFabricEntities";
            ArrayList arrayList = null;
            dBConnection = RemoveMissingUtils.getDBConnection();
            if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
                return null;
            }
            try {
                try {
                    String[] stringArray2;
                    arrayList = RemoveMissingUtils.getExpiredMissingEntities("tapelibrary", dBConnection);
                    if (arrayList == null) break block6;
                    stringArray = stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    Object var5_7 = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                RemoveMissingUtils.closeConnection(dBConnection);
                throw throwable;
            }
            RemoveMissingUtils.closeConnection(dBConnection);
            return stringArray;
        }
        Object var5_9 = null;
        RemoveMissingUtils.closeConnection(dBConnection);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getExpiredSubsystems() {
        DBConnection dBConnection;
        block6: {
            String[] stringArray;
            String string = "getExpiredFabricEntities";
            ArrayList arrayList = null;
            dBConnection = RemoveMissingUtils.getDBConnection();
            if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
                return null;
            }
            try {
                try {
                    String[] stringArray2;
                    arrayList = RemoveMissingUtils.getExpiredMissingEntities("subsystem", dBConnection);
                    if (arrayList == null) break block6;
                    stringArray = stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    Object var5_7 = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                RemoveMissingUtils.closeConnection(dBConnection);
                throw throwable;
            }
            RemoveMissingUtils.closeConnection(dBConnection);
            return stringArray;
        }
        Object var5_9 = null;
        RemoveMissingUtils.closeConnection(dBConnection);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleExpiredTapeSubentities() {
        String string = "handleExpiredTapesubentities";
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList = null;
        Integer[] integerArray = null;
        int n = 0;
        DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
            return false;
        }
        try {
            try {
                int n2;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("tapedrive", "tapelibrary", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    bl = this.cTapeDBHelper.deleteTapeDrivesByID(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        if (!bl) {
                            TraceLogger.traceMessage(1, className, string, "Error while deleting tape drives. some missing tape drives may not have been deleted.");
                        }
                        TraceLogger.traceMessage(1, className, string, "List of expired tape drives:");
                        n += integerArray.length;
                        n2 = 0;
                        while (n2 < integerArray.length) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                            ++n2;
                        }
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("tapemediachanger", "tapelibrary", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    bl2 = this.cTapeDBHelper.deleteTapeMediaChangersByID(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        if (!bl2) {
                            TraceLogger.traceMessage(1, className, string, "Error while deleting tape media changers. some expired missing media changers may not have been deleted.");
                        }
                        TraceLogger.traceMessage(1, className, string, "List of expired tape media changers:");
                        n += integerArray.length;
                        n2 = 0;
                        while (n2 < integerArray.length) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    TraceLogger.exception(className, string, exception);
                }
                Object var9_10 = null;
                RemoveMissingUtils.closeConnection(dBConnection);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            RemoveMissingUtils.closeConnection(dBConnection);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        RemoveMissingUtils.closeConnection(dBConnection);
        if (n == 0 && TRACE) {
            TraceLogger.traceMessage(1, className, string, "No expired subsystem subentities found.");
            TraceLogger.exit(className, string);
        }
        return bl2 && bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleExpiredSubsystemSubentities() {
        String string = "handleExpiredSubsystemSubentities";
        if (TRACE) {
            TraceLogger.entry(className, string, "");
        }
        boolean bl = true;
        ArrayList arrayList = null;
        Integer[] integerArray = null;
        int n = 0;
        DBConnection dBConnection = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(string, dBConnection)) {
            return false;
        }
        try {
            try {
                int n2;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("storagevolume", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    bl = SubsystemDBHelper.deleteStorageVolumes(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired storage volumes:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("storagepool", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    boolean bl2 = bl = bl && SubsystemDBHelper.deleteStoragePools(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired storage pools:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("physicalvolume", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    boolean bl3 = bl = bl && SubsystemDBHelper.deletePhysicalVolumes(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired physical volumes:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
                arrayList = null;
                integerArray = null;
                arrayList = RemoveMissingUtils.getExpiredMissingEntities("port", "subsystem", dBConnection);
                if (arrayList != null && arrayList.size() != 0) {
                    integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                    boolean bl4 = bl = bl && SubsystemDBHelper.deletePorts(RemoveMissingProcessor.getPrimitiveIntArray(integerArray));
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, string, "List of expired subsystem ports:");
                    }
                    n += integerArray.length;
                    n2 = 0;
                    while (n2 < integerArray.length) {
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, "entity[" + n2 + "]=" + integerArray[n2]);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    TraceLogger.exception(className, string, exception);
                }
                Object var8_9 = null;
                RemoveMissingUtils.closeConnection(dBConnection);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            RemoveMissingUtils.closeConnection(dBConnection);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        RemoveMissingUtils.closeConnection(dBConnection);
        if (n == 0 && TRACE) {
            TraceLogger.traceMessage(1, className, string, "No expired subsystem subentities found.");
            TraceLogger.exit(className, string);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet determineMissingEntitiesByDeviceTypes(String[] stringArray, String string, DBConnection dBConnection) {
        HashSet hashSet;
        String string2;
        block26: {
            string2 = "detrmineMissingEntitiesByDeviceTypes";
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet = new HashSet();
            DBResultSet dBResultSet = null;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, stringArray);
            }
            try {
                try {
                    int n = 0;
                    while (true) {
                        block25: {
                            Object var11_14;
                            block27: {
                                if (n < stringArray.length) break block27;
                                if (hashSet2.size() > 0) {
                                    String[] stringArray2 = (String[])hashSet2.toArray();
                                    hashSet = this.determineSelectedMissingList(stringArray2, dBConnection);
                                }
                                break;
                            }
                            String string3 = stringArray[n];
                            try {
                                try {
                                    String string4;
                                    if (string3.equals("switch")) {
                                        dBResultSet = RemoveMissingUtils.getAllMissingSwitches(string, dBConnection);
                                        while (dBResultSet.next()) {
                                            string4 = "" + dBResultSet.getInt("switchId");
                                            hashSet2.add("switch:" + string4);
                                        }
                                    } else if (string3.equals("fabric")) {
                                        dBResultSet = RemoveMissingUtils.getAllMissingFabrics(string, dBConnection);
                                        while (dBResultSet.next()) {
                                            string4 = "" + dBResultSet.getInt("fabricId");
                                            hashSet2.add("fabric:" + string4);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    if (traceLogger.isLogging()) {
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                var11_14 = null;
                                if (dBResultSet == null) throw throwable;
                                try {
                                    dBResultSet.getStatement().close();
                                    throw throwable;
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            {
                                var11_14 = null;
                                if (dBResultSet == null) break block25;
                            }
                            try {}
                            catch (Exception exception) {}
                            dBResultSet.getStatement().close();
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, exception);
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var13_18 = null;
                if (dBResultSet == null) break block26;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    private HashSet determineSelectedMissingList(String[] stringArray, DBConnection dBConnection) {
        String string = "determineSelectedMissingList";
        HashSet hashSet = new HashSet();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, stringArray);
        }
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"fabric"};
            String string2 = "currenttime";
            hashSet = this.determineMissingEntitiesByDeviceTypes(stringArray2, string2, dBConnection);
        } else {
            int n = 0;
            while (n < stringArray.length) {
                AbstractCollection abstractCollection;
                Object object;
                int n2 = stringArray[n].indexOf(58);
                String string3 = stringArray[n].substring(0, n2);
                Object object2 = stringArray[n].substring(n2 + 1);
                if (string3.equals("host")) {
                    if (RemoveMissingUtils.isHostRemovable((String)object2)) {
                        object = new HashSet<String>();
                        ((HashSet)object).add(stringArray[n]);
                        ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                        hashSet.add(object);
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, String.valueOf(stringArray[n]) + " is removable");
                        }
                    } else {
                        traceLogger.text(IRecordType.TYPE_WARN, className, string, String.valueOf(stringArray[n]) + " is not removable");
                        if (TRACE) {
                            TraceLogger.traceMessage(1, className, string, String.valueOf(stringArray[n]) + " is not removable");
                        }
                        this.isHostRemovable = false;
                    }
                } else if (string3.equals("switch")) {
                    object = this.getFabricIdOnlyHasThisSwitch((String)object2);
                    if (object != null && !((String)object).equals("")) {
                        string3 = "fabric";
                        object2 = object;
                        abstractCollection = new HashSet();
                        ((HashSet)abstractCollection).add(String.valueOf(string3) + ':' + (String)object2);
                        abstractCollection.addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                        hashSet.add(abstractCollection);
                    } else {
                        abstractCollection = new HashSet<String>();
                        ((HashSet)abstractCollection).add(stringArray[n]);
                        abstractCollection.addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                        hashSet.add(abstractCollection);
                    }
                } else if (string3.equals("fabric")) {
                    object = new HashSet<String>();
                    ((HashSet)object).add(stringArray[n]);
                    ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                    hashSet.add(object);
                    if (RemoveMissingUtils.isPhysicalFabric((String)object2)) {
                        abstractCollection = this.getMissingVsansForFabric((String)object2, dBConnection);
                        Iterator iterator = ((ArrayList)abstractCollection).iterator();
                        while (iterator.hasNext()) {
                            object = new HashSet();
                            string3 = "fabric";
                            object2 = (String)iterator.next();
                            ((HashSet)object).add(String.valueOf(string3) + ':' + (String)object2);
                            ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                            hashSet.add(object);
                        }
                    }
                } else {
                    object = new HashSet();
                    ((HashSet)object).add(stringArray[n]);
                    ((AbstractCollection)object).addAll(this.determineMissingSubEntityCollection(string3, (String)object2, dBConnection));
                    hashSet.add(object);
                }
                ++n;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForSwitch(String string, DBConnection dBConnection) {
        DBResultSet dBResultSet;
        DBResultSet dBResultSet2;
        DBResultSet dBResultSet3;
        HashSet<String> hashSet;
        String string2;
        block33: {
            string2 = "getMissingSubEntitiesForSwitch";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string2);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet4 = null;
            dBResultSet3 = null;
            dBResultSet2 = null;
            dBResultSet = null;
            try {
                try {
                    int n;
                    String string3;
                    dBResultSet3 = RemoveMissingUtils.getFabric2SwitchForSwitch(string, dBConnection);
                    while (true) {
                        if (!dBResultSet3.next()) break;
                        string3 = "" + dBResultSet3.getInt("fabric2switchId");
                        n = dBResultSet3.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("fabric2switch:" + string3);
                    }
                    dBResultSet2 = RemoveMissingUtils.getBladesForSwitch(string, dBConnection);
                    while (true) {
                        if (!dBResultSet2.next()) break;
                        string3 = "" + dBResultSet2.getInt("bladeId");
                        n = dBResultSet2.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("blade:" + string3);
                    }
                    dBResultSet = RemoveMissingUtils.getSwitch2PortForSwitch(string, dBConnection);
                    while (true) {
                        if (!dBResultSet.next()) {
                            dBResultSet4 = RemoveMissingUtils.getPortsForSwitch(string, dBConnection);
                            break;
                        }
                        string3 = "" + dBResultSet.getInt("switch2portId");
                        n = dBResultSet.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("switch2port:" + string3);
                    }
                    while (dBResultSet4.next()) {
                        string3 = "" + dBResultSet4.getInt("portId");
                        n = dBResultSet4.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("port:" + string3);
                        hashSet.addAll(this.getMissingSubEntitiesForPort(string3, dBConnection));
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (dBResultSet4 != null) {
                    try {
                        dBResultSet4.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet3 != null) {
                    try {
                        dBResultSet3.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var11_14 = null;
                if (dBResultSet4 == null) break block33;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet4.getStatement().close();
        }
        if (dBResultSet2 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet2.getStatement().close();
        }
        if (dBResultSet3 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet3.getStatement().close();
        }
        if (dBResultSet != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForPort(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block11: {
            string2 = "getMissingSubEntitiesForPort";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet = null;
            try {
                try {
                    dBResultSet = RemoveMissingUtils.getPort2portForPort(string, dBConnection);
                    while (dBResultSet.next()) {
                        int n = dBResultSet.getInt("state");
                        String string3 = "" + dBResultSet.getInt("port2portId");
                        if (n != 0) continue;
                        hashSet.add("port2port:" + string3);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (dBResultSet == null) break block11;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForNode(String string, DBConnection dBConnection) {
        DBResultSet dBResultSet;
        HashSet<String> hashSet;
        String string2;
        block19: {
            string2 = "getMissingSubEntitiesForNode";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet2 = null;
            dBResultSet = null;
            try {
                try {
                    int n;
                    String string3;
                    dBResultSet2 = RemoveMissingUtils.getPortsForNode(string, dBConnection);
                    while (true) {
                        if (!dBResultSet2.next()) {
                            dBResultSet = RemoveMissingUtils.getNode2HBAForNode(string, dBConnection);
                            break;
                        }
                        string3 = "" + dBResultSet2.getInt("portId");
                        n = dBResultSet2.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("port:" + string3);
                        hashSet.addAll(this.getMissingSubEntitiesForPort(string3, dBConnection));
                    }
                    while (dBResultSet.next()) {
                        string3 = "" + dBResultSet.getInt("node2hbaId");
                        n = dBResultSet.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("node2hba:" + string3);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var9_12 = null;
                if (dBResultSet2 == null) break block19;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet2.getStatement().close();
        }
        if (dBResultSet != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForFabric(String string, DBConnection dBConnection) {
        DBResultSet dBResultSet;
        DBResultSet dBResultSet2;
        DBResultSet dBResultSet3;
        DBResultSet dBResultSet4;
        DBResultSet dBResultSet5;
        DBResultSet dBResultSet6;
        HashSet<String> hashSet;
        String string2;
        block53: {
            string2 = "getMissingSubEntitiesForFabric";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet7 = null;
            dBResultSet6 = null;
            dBResultSet5 = null;
            dBResultSet4 = null;
            dBResultSet3 = null;
            dBResultSet2 = null;
            dBResultSet = null;
            try {
                try {
                    int n;
                    String string3;
                    dBResultSet7 = RemoveMissingUtils.getSwitchesForFabric(string, dBConnection);
                    while (true) {
                        if (!dBResultSet7.next()) break;
                        string3 = "" + dBResultSet7.getInt("switchId");
                        n = dBResultSet7.getInt("state1");
                        int n2 = dBResultSet7.getInt("state2");
                        String string4 = "" + dBResultSet7.getInt("fabric2switchId");
                        if (n == 0) {
                            hashSet.add("switch:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForSwitch(string3, dBConnection));
                        }
                        if (n2 != 0) continue;
                        hashSet.add("fabric2switch:" + string4);
                    }
                    dBResultSet6 = RemoveMissingUtils.getHostsForFabric(string, dBConnection);
                    while (true) {
                        if (!dBResultSet6.next()) break;
                        string3 = "" + dBResultSet6.getInt("hostId");
                        n = dBResultSet6.getInt("state");
                        if (n == 0 && RemoveMissingUtils.isHostRemovable(string3)) {
                            hashSet.add("host:" + string3);
                        }
                        hashSet.addAll(this.getMissingSubEntitiesForHost(string3, dBConnection));
                    }
                    dBResultSet5 = RemoveMissingUtils.getPEsForFabric(string, dBConnection);
                    while (true) {
                        if (!dBResultSet5.next()) {
                            dBResultSet4 = RemoveMissingUtils.getNodesForFabric(string, dBConnection);
                            break;
                        }
                        string3 = "" + dBResultSet5.getInt("peId");
                        n = dBResultSet5.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("pe:" + string3);
                        hashSet.addAll(this.getMissingSubEntitiesForPE(string3, dBConnection));
                    }
                    while (dBResultSet4.next()) {
                        string3 = "" + dBResultSet4.getInt("nodeId");
                        n = dBResultSet4.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("node:" + string3);
                        hashSet.addAll(this.getMissingSubEntitiesForNode(string3, dBConnection));
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (dBResultSet7 != null) {
                    try {
                        dBResultSet7.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet6 != null) {
                    try {
                        dBResultSet6.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet5 != null) {
                    try {
                        dBResultSet5.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet4 != null) {
                    try {
                        dBResultSet4.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet3 != null) {
                    try {
                        dBResultSet3.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var16_19 = null;
                if (dBResultSet7 == null) break block53;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet7.getStatement().close();
        }
        if (dBResultSet6 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet6.getStatement().close();
        }
        if (dBResultSet5 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet5.getStatement().close();
        }
        if (dBResultSet4 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet4.getStatement().close();
        }
        if (dBResultSet3 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet3.getStatement().close();
        }
        if (dBResultSet2 != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet2.getStatement().close();
        }
        if (dBResultSet != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForZone(String string, DBConnection dBConnection) {
        DBResultSet dBResultSet;
        HashSet<String> hashSet;
        String string2;
        block19: {
            string2 = "getMissingSubEntitiesForZone";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet2 = null;
            dBResultSet = null;
            try {
                try {
                    String string3;
                    boolean bl;
                    dBResultSet2 = RemoveMissingUtils.getZoneSet2ZonesForZone(string, dBConnection);
                    while (true) {
                        if (!dBResultSet2.next()) {
                            dBResultSet = RemoveMissingUtils.getZone2MembersForZone(string, dBConnection);
                            break;
                        }
                        bl = false;
                        string3 = "" + dBResultSet2.getInt("zset2zoneId");
                        if (bl) continue;
                        hashSet.add("zset2zone:" + string3);
                    }
                    while (dBResultSet.next()) {
                        bl = false;
                        string3 = "" + dBResultSet.getInt("zone2memberId");
                        if (bl) continue;
                        hashSet.add("zone2member:" + string3);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (dBResultSet2 != null) {
                    try {
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var9_12 = null;
                if (dBResultSet2 == null) break block19;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet2.getStatement().close();
        }
        if (dBResultSet != null) {
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    private HashSet getMissingSubEntitiesForZoneSet(String string, DBConnection dBConnection) {
        String string2 = "getMissingSubEntitiesForZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
        }
        HashSet hashSet = new HashSet();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForPE(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block12: {
            string2 = "getMissingSubEntitiesForPE";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet = null;
            try {
                try {
                    dBResultSet = RemoveMissingUtils.getNodesForPE(string, dBConnection);
                    while (dBResultSet.next()) {
                        String string3 = "" + dBResultSet.getInt("nodeId");
                        String string4 = "" + dBResultSet.getInt("pe2nodeId");
                        int n = dBResultSet.getInt("state1");
                        int n2 = dBResultSet.getInt("state2");
                        if (n == 0) {
                            hashSet.add("node:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForNode(string3, dBConnection));
                        }
                        if (n2 != 0) continue;
                        hashSet.add("pe2node:" + string4);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var10_13 = null;
                if (dBResultSet == null) break block12;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForHost(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block11: {
            string2 = "getMissingSubEntitiesForHost";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet = null;
            try {
                try {
                    dBResultSet = RemoveMissingUtils.getHBAsForHost(string, dBConnection);
                    while (dBResultSet.next()) {
                        String string3 = "" + dBResultSet.getInt("hbaId");
                        int n = dBResultSet.getInt("state");
                        if (n != 0) continue;
                        hashSet.add("hba:" + string3);
                        hashSet.addAll(this.getMissingSubEntitiesForHBA(string3, dBConnection));
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (dBResultSet == null) break block11;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashSet getMissingSubEntitiesForHBA(String string, DBConnection dBConnection) {
        HashSet<String> hashSet;
        String string2;
        block12: {
            string2 = "getMissingSubEntitiesForHBA";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, string);
            }
            hashSet = new HashSet<String>();
            DBResultSet dBResultSet = null;
            try {
                try {
                    dBResultSet = RemoveMissingUtils.getNodesForHBA(string, dBConnection);
                    while (dBResultSet.next()) {
                        String string3 = "" + dBResultSet.getInt("nodeId");
                        String string4 = "" + dBResultSet.getInt("node2hbaId");
                        int n = dBResultSet.getInt("state1");
                        int n2 = dBResultSet.getInt("state2");
                        if (n == 0) {
                            hashSet.add("node:" + string3);
                            hashSet.addAll(this.getMissingSubEntitiesForNode(string3, dBConnection));
                        }
                        if (n2 != 0) continue;
                        hashSet.add("node2hba:" + string4);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var10_13 = null;
                if (dBResultSet == null) break block12;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return hashSet;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return hashSet;
    }

    private HashSet determineDeletionTypes(HashSet hashSet) {
        String string = "determineDeletionTypes";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            HashSet hashSet3 = (HashSet)iterator.next();
            Iterator iterator2 = hashSet3.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = string2.substring(0, 2);
                String string4 = (String)classMap.get(string3);
                if (string4 == null) continue;
                hashSet2.add(string4);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return hashSet2;
    }

    private String convertHashSetToString(HashSet hashSet) {
        String string = "convertHashSetToString";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, string);
        }
        String string2 = null;
        if (hashSet.size() != 0) {
            Iterator iterator = hashSet.iterator();
            int n = 0;
            String string3 = " ";
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                string2 = string2 == null ? String.valueOf(string4) + string3 : String.valueOf(string2) + string4 + string3;
                ++n;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processDeleteMissing(HashSet hashSet, DBConnection dBConnection) {
        String string = "processDeleteMissing";
        boolean bl = false;
        IEventMonitorService iEventMonitorService = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, hashSet);
        }
        Iterator iterator = hashSet.iterator();
        ViewReportTablesUpdater viewReportTablesUpdater = new ViewReportTablesUpdater();
        try {
            if (dBConnection == null) {
                return bl;
            }
            block8: while (iterator.hasNext()) {
                String string2 = null;
                String string3 = null;
                try {
                    dBConnection.setAutoCommit(false);
                    HashSet hashSet2 = (HashSet)iterator.next();
                    Iterator iterator2 = hashSet2.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            dBConnection.commit();
                            bl = true;
                            continue block8;
                        }
                        String string4 = (String)iterator2.next();
                        int n = string4.indexOf(58);
                        string2 = string4.substring(0, n);
                        string3 = string4.substring(n + 1);
                        this.deleteEntity(dBConnection, string2, string3);
                        if (string2.equals("switch") || string2.equals("subsystem")) {
                            if (iEventMonitorService == null) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                iEventMonitorService = (IEventMonitorService)ConnectorClient.getService((String)this.mDeviceServerHost, (int)this.mDeviceServerPort, clazz, (String)"SANEventCorrelatorFactory");
                            }
                            iEventMonitorService.publish((SRMEvent)new DeviceDeletedEvent(string2, string3));
                        }
                        viewReportTablesUpdater.deleteDependentViews(string2, string3);
                    }
                }
                catch (Exception exception) {
                    traceLogger.text(IRecordType.TYPE_WARN, className, string, String.valueOf(string2) + string3 + " is not deleted.");
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string, exception);
                    if (dBConnection != null) {
                        try {
                            dBConnection.rollback();
                        }
                        catch (Exception exception2) {}
                    }
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            traceLogger.exception(IRecordType.TYPE_EXIT, className, string, exception);
            bl = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        viewReportTablesUpdater = null;
        return bl;
    }

    private void deleteEntity(DBConnection dBConnection, String string, String string2) throws SQLException {
        String string3 = "deleteMissingEntity";
        String string4 = "Deleted missing entity: " + string + string2;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, new Object[]{string, string2});
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (string.equals("port")) {
            hashtable.put(Port.getColumnInfo("PORT_ID"), string2);
            hashtable.put(Port.getColumnInfo("DETECTABLE"), "0");
            Port.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("node")) {
            hashtable.put(Node.getColumnInfo("NODE_ID"), string2);
            hashtable.put(Node.getColumnInfo("DETECTABLE"), "0");
            Node.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("hba")) {
            hashtable.put(Hba.getColumnInfo("HBA_ID"), string2);
            hashtable.put(Hba.getColumnInfo("DETECTABLE"), "0");
            Hba.deletes(dBConnection, hashtable);
            RemoveMissingUtils.markHBAPortAsNormalPort(string2, dBConnection);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("host")) {
            hashtable.put(Host.getColumnInfo("COMPUTER_ID"), string2);
            hashtable.put(Host.getColumnInfo("DETECTABLE"), "0");
            Host.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("switch")) {
            String string5 = RemoveMissingUtils.getSwitchWWNById(string2);
            if (string5 != null) {
                RemoveMissingUtils.deleteAttributeSnapshot(string, string5, dBConnection);
            }
            hashtable.put(Switch.getColumnInfo("SWITCH_ID"), string2);
            hashtable.put(Switch.getColumnInfo("DETECTABLE"), "0");
            Switch.deletes(dBConnection, hashtable);
        } else if (string.equals("blade")) {
            hashtable.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), string2);
            hashtable.put(SwitchBlade.getColumnInfo("DETECTABLE"), "0");
            SwitchBlade.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("fabric")) {
            String string6;
            if (RemoveMissingUtils.isPhysicalFabric(string2)) {
                RemoveMissingUtils.markChildVsansAsRegular(string2, dBConnection);
            }
            if ((string6 = RemoveMissingUtils.getFabricWWNById(string2)) != null) {
                RemoveMissingUtils.deleteAttributeSnapshot(string, string6, dBConnection);
            }
            hashtable.put(Fabric.getColumnInfo("FABRIC_ID"), string2);
            hashtable.put(Fabric.getColumnInfo("DETECTABLE"), "0");
            Fabric.deletes(dBConnection, hashtable);
        } else if (string.equals("pe")) {
            hashtable.put(PhyPe.getColumnInfo("PHY_PE_ID"), string2);
            hashtable.put(PhyPe.getColumnInfo("DETECTABLE"), "0");
            PhyPe.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("pe2node")) {
            hashtable.put(Pe2node.getColumnInfo("PE2NODE_ID"), string2);
            hashtable.put(Pe2node.getColumnInfo("DETECTABLE"), "0");
            Pe2node.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("port2port")) {
            hashtable.put(Port2port.getColumnInfo("PORT2PORT_ID"), string2);
            hashtable.put(Port2port.getColumnInfo("DETECTABLE"), "0");
            Port2port.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("node2hba")) {
            hashtable.put(Node2hba.getColumnInfo("NODE2HBA_ID"), string2);
            hashtable.put(Node2hba.getColumnInfo("DETECTABLE"), "0");
            Node2hba.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("fabric2switch")) {
            hashtable.put(Fabric2switch.getColumnInfo("FABRIC2SWITCH_ID"), string2);
            hashtable.put(Fabric2switch.getColumnInfo("DETECTABLE"), "0");
            Fabric2switch.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("switch2port")) {
            hashtable.put(Switch2port.getColumnInfo("SWITCH2PORT_ID"), string2);
            hashtable.put(Switch2port.getColumnInfo("DETECTABLE"), "0");
            Switch2port.deletes(dBConnection, hashtable);
            RemoveMissingUtils.deleteAttributeSnapshot(string, string2, dBConnection);
        } else if (string.equals("zone")) {
            hashtable.put(Zone.getColumnInfo("ZONE_ID"), string2);
            Zone.deletes(dBConnection, hashtable);
        } else if (string.equals("zset")) {
            hashtable.put(Zset.getColumnInfo("ZSET_ID"), string2);
            Zset.deletes(dBConnection, hashtable);
        } else if (string.equals("zonemember")) {
            hashtable.put(ZoneMember.getColumnInfo("ZONE_MEMBER_ID"), string2);
            ZoneMember.deletes(dBConnection, hashtable);
        } else if (string.equals("zone2member")) {
            hashtable.put(Zone2member.getColumnInfo("ZONE2MEMBER_ID"), string2);
            Zone2member.deletes(dBConnection, hashtable);
        } else if (string.equals("zset2zone")) {
            hashtable.put(Zset2zone.getColumnInfo("ZSET2ZONE_ID"), string2);
            Zset2zone.deletes(dBConnection, hashtable);
        } else if (string.equals("subsystem")) {
            this.handleSubsystem(string, string2);
        } else if (string.equals("tapelibrary")) {
            this.handleTape(string, string2);
        } else {
            string4 = String.valueOf(string) + string2 + "s not supported by RemovingMissing function.";
        }
        if (TRACE) {
            TraceLogger.traceMessage(1, className, string3, string4);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
        }
    }

    /*
     * Exception decompiling
     */
    private void handleSubsystem(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 218->222)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleTape(String string, String string2) {
        this.cTapeDBHelper.deleteLibraryByID(Integer.parseInt(string2));
    }

    private HashSet determineMissingSubEntityCollection(String string, String string2, DBConnection dBConnection) {
        String string3 = "determineMissingSubEntityCollection";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, new Object[]{string, string2});
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (string.equals("port")) {
            hashSet = this.getMissingSubEntitiesForPort(string2, dBConnection);
        } else if (string.equals("node")) {
            hashSet = this.getMissingSubEntitiesForNode(string2, dBConnection);
        } else if (string.equals("switch")) {
            hashSet = this.getMissingSubEntitiesForSwitch(string2, dBConnection);
        } else if (string.equals("fabric")) {
            hashSet = this.getMissingSubEntitiesForFabric(string2, dBConnection);
        } else if (string.equals("pe")) {
            hashSet = this.getMissingSubEntitiesForPE(string2, dBConnection);
        } else if (string.equals("hba")) {
            hashSet = this.getMissingSubEntitiesForHBA(string2, dBConnection);
        } else if (string.equals("host")) {
            hashSet = this.getMissingSubEntitiesForHost(string2, dBConnection);
        } else if (string.equals("port2port")) {
            hashSet = new HashSet<String>();
            hashSet.add(String.valueOf(string) + ':' + string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, hashSet);
        }
        return hashSet;
    }

    private boolean deleteEntityWithRetry(String string, String string2, DBConnection dBConnection) throws SQLException {
        String string3 = "deleteEntityWithRetry";
        boolean bl = false;
        boolean bl2 = false;
        int n = 3;
        do {
            try {
                this.deleteEntity(dBConnection, string, string2);
                bl2 = false;
                bl = true;
            }
            catch (SQLException sQLException) {
                bl2 = true;
                if (--n > 0) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, string3, "Unable to delete " + string + string2 + ". Retying...");
                    continue;
                }
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, string3, "Unable to delete " + string + string2 + ". " + n + " retry attemped.");
                }
                throw sQLException;
            }
        } while (bl2 && n > 0);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFabricIdOnlyHasThisSwitch(String string) {
        DBConnection dBConnection;
        String string2;
        block21: {
            String string3 = "getfabricIdOnlyHasThisSwitch";
            string2 = null;
            DBResultSet dBResultSet = null;
            dBConnection = null;
            try {
                block19: {
                    try {
                        dBConnection = RemoveMissingUtils.getDBConnection();
                        dBResultSet = RemoveMissingUtils.getFabricForSwitch(string, dBConnection);
                        if (!dBResultSet.next()) break block19;
                        String string4 = "" + dBResultSet.getInt("fabricId");
                        int n = dBResultSet.getInt("state");
                        if (n != 0) break block19;
                        boolean bl = true;
                        DBResultSet dBResultSet2 = null;
                        try {
                            block20: {
                                try {
                                    dBResultSet2 = RemoveMissingUtils.getSwitchesForFabric(string4, dBConnection);
                                    while (dBResultSet2.next()) {
                                        String string5 = "" + dBResultSet2.getInt("switchId");
                                        if (string5.equals(string)) continue;
                                        bl = false;
                                        break;
                                    }
                                    if (bl) {
                                        string2 = string4;
                                    }
                                }
                                catch (Exception exception) {
                                    if (!traceLogger.isLogging()) break block20;
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
                                }
                            }
                            Object var11_15 = null;
                            if (dBResultSet2 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            Object var11_14 = null;
                            if (dBResultSet2 == null) throw throwable;
                            try {
                                dBResultSet2.getStatement().close();
                                throw throwable;
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {}
                        catch (Exception exception) {
                        }
                        dBResultSet2.getStatement().close();
                    }
                    catch (Exception exception) {
                        if (!traceLogger.isLogging()) break block19;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string3, exception);
                    }
                }
                Object var13_18 = null;
                if (dBResultSet == null) break block21;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (dBResultSet != null) {
                    try {
                        dBResultSet.getStatement().close();
                    }
                    catch (Exception exception) {}
                }
                RemoveMissingUtils.closeConnection(dBConnection);
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        RemoveMissingUtils.closeConnection(dBConnection);
        return string2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getMissingVsansForFabric(String string, DBConnection dBConnection) {
        ArrayList<String> arrayList;
        String string2;
        block11: {
            string2 = "getMissingVsansForFabric";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, string2);
            }
            new HashSet();
            DBResultSet dBResultSet = null;
            arrayList = new ArrayList<String>();
            try {
                try {
                    dBResultSet = RemoveMissingUtils.getVsansForFabric(string, dBConnection);
                    while (dBResultSet.next()) {
                        String string3 = "" + dBResultSet.getInt("vsanId");
                        int n = dBResultSet.getInt("vsanState");
                        if (n != 0) continue;
                        arrayList.add(string3);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (dBResultSet == null) break block11;
            }
            try {}
            catch (Exception exception) {}
            dBResultSet.getStatement().close();
        }
        if (!traceLogger.isLogging()) return arrayList;
        traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        return arrayList;
    }

    public static int[] getPrimitiveIntArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            nArray[n] = integerArray[n];
            ++n;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length > 2) {
            return;
        }
        RemoveMissingProcessor removeMissingProcessor = new RemoveMissingProcessor();
        if (stringArray.length == 1) {
            String[] stringArray2 = new String[]{stringArray[0]};
            removeMissingProcessor.performDeletionForSelectedMissingEntities(stringArray2);
        } else if (stringArray.length == 2) {
            removeMissingProcessor.performScheduledDeletionForMissingEntity(stringArray[0], stringArray[1]);
        }
    }
}

