/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GlassPaneMouseListener
extends MouseAdapter
implements MouseMotionListener {
    private JButton stopButton;
    private Component glassPane;
    private Container contentPane;
    private Window window;
    private Rectangle stopBounds;

    public GlassPaneMouseListener(JButton jButton, Component component, Container container, JFrame jFrame) {
        this(jButton, component, container, (Window)jFrame);
    }

    public GlassPaneMouseListener(JButton jButton, Component component, Container container, Window window) {
        this.stopButton = jButton;
        this.glassPane = component;
        this.contentPane = container;
        this.window = window;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = null;
        Point point2 = SwingUtilities.convertPoint(this.glassPane, point, this.contentPane);
        component = SwingUtilities.getDeepestComponentAt(this.contentPane, point2.x, point2.y);
        if (component == this.stopButton) {
            this.stopButton.doClick();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.stopBounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(0));
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.window.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.stopBounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(0));
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.window.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void setStopBounds() {
        Point point = SwingUtilities.convertPoint(this.stopButton, 0, 0, this.glassPane);
        this.stopBounds = new Rectangle(point, this.stopButton.getSize());
    }
}

