/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.text.DateFormat;
import java.text.DecimalFormat;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;

public class TableCellRenderers {
    public static final DefaultTableCellRenderer date = new DateRenderer();
    public static final DefaultTableCellRenderer number = new NumberRenderer();
    public static final DefaultTableCellRenderer number2 = new NumberRenderer2();
    public static final DefaultTableCellRenderer space = new SpaceRenderer();
    public static final DefaultTableCellRenderer spaceInt = new SpaceNoDecimalRenderer();
    public static final DefaultTableCellRenderer percent = new PercentRenderer();
    public static final DefaultTableCellRenderer duration = new DurationRenderer();
    public static final DefaultTableCellRenderer megabyte = new MegabyteRenderer();
    public static final DefaultTableCellRenderer hertz = new HertzRenderer();
    private static final DateFormat df = DateFormat.getDateTimeInstance();
    private static final DecimalFormat d0Fmt = new DecimalFormat();
    private static final StringBuffer buffer = new StringBuffer(25);

    public static String formatDuration(int n) {
        return TableCellStrings.formatDuration(n, buffer);
    }

    public static class DecimalRenderer
    extends DefaultTableCellRenderer {
        private int scale;
        private String suffix;

        public DecimalRenderer(int n, String string) {
            this.scale = (int)Math.pow(10.0, n);
            this.suffix = string;
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.DecimalRenderer(this.scale, this.suffix, object, buffer));
        }
    }

    private static class DateRenderer
    extends DefaultTableCellRenderer {
        private DateRenderer() {
        }

        public void setValue(Object object) {
            this.setText(TableCellStrings.DateRenderer(object, df));
        }
    }

    private static class NumberRenderer
    extends DefaultTableCellRenderer {
        private NumberRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.NumberRenderer(object, d0Fmt));
        }
    }

    private static class NumberRenderer2
    extends DefaultTableCellRenderer {
        private NumberRenderer2() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.NumberRenderer2(object, d0Fmt));
        }
    }

    private static class MegabyteRenderer
    extends DefaultTableCellRenderer {
        private MegabyteRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.MegabyteRenderer(object, d0Fmt));
        }
    }

    private static class SpaceRenderer
    extends DefaultTableCellRenderer {
        private SpaceRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.SpaceRenderer(object));
        }
    }

    private static class SpaceNoDecimalRenderer
    extends DefaultTableCellRenderer {
        private SpaceNoDecimalRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.SpaceNoDecimalRenderer(object));
        }
    }

    private static class PercentRenderer
    extends DefaultTableCellRenderer {
        private PercentRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.PercentRenderer(object, d0Fmt));
        }
    }

    private static class DurationRenderer
    extends DefaultTableCellRenderer {
        private DurationRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.DurationRenderer(object, buffer));
        }
    }

    private static class HertzRenderer
    extends DefaultTableCellRenderer {
        private HertzRenderer() {
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(Util.formatHertz(((Number)object).intValue()));
        }
    }

    private static class NumberWithSuffixRenderer
    extends DefaultTableCellRenderer {
        private String suffix;

        public NumberWithSuffixRenderer(String string) {
            this.suffix = string;
        }

        public void setValue(Object object) {
            this.setHorizontalAlignment(4);
            this.setText(TableCellStrings.NumberWithSuffixRenderer(object, d0Fmt, this.suffix));
        }
    }
}

