/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.xmsg.MessageLog;

public class TreeSelectorNode
extends DefaultMutableTreeNode
implements Comparable {
    public boolean selectable;
    public boolean excludable;
    public boolean expandOnRightOnly;
    public boolean childrenFetched;
    public int hiOrderSortKey;
    public TreeSelector.ExcludeList excludeParents;
    protected String selectErrorMsgID;
    private boolean buttonFlag = true;
    public boolean showClusterName;
    public boolean showVsName;
    public boolean isNonClusteredLabel;

    public TreeSelectorNode(NameList nameList, boolean bl, boolean bl2, boolean bl3) {
        this(nameList, bl, bl2, bl3, false, null);
    }

    public TreeSelectorNode(NameList nameList, boolean bl, boolean bl2, String string) {
        this(nameList, false, bl, bl2, false, string);
    }

    public TreeSelectorNode(NameList nameList, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        this(nameList, bl, bl2, bl3, bl4, string, false, false);
    }

    public TreeSelectorNode(NameList nameList, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, boolean bl5, boolean bl6) {
        super(nameList, bl3);
        this.selectable = bl;
        this.excludable = bl2;
        this.expandOnRightOnly = bl4;
        this.selectErrorMsgID = string;
        this.showClusterName = bl5;
        this.showVsName = bl6;
    }

    public NameList getNameList() {
        return (NameList)this.getUserObject();
    }

    public Object clone() {
        TreeSelectorNode treeSelectorNode = null;
        treeSelectorNode = (TreeSelectorNode)super.clone();
        treeSelectorNode.setUserObject(this.getNameList().clone());
        return treeSelectorNode;
    }

    public void setSortKey(int n) {
        this.hiOrderSortKey = n;
    }

    public int compareTo(Object object) {
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)object;
        int n = this.hiOrderSortKey - treeSelectorNode.hiOrderSortKey;
        if (n == 0) {
            NameList nameList = treeSelectorNode.getNameList();
            NameList nameList2 = this.getNameList();
            n = nameList2.toString().compareTo(nameList.toString());
            if (n == 0) {
                n = nameList2.nlID - nameList.nlID;
            }
        }
        return n;
    }

    protected boolean isSelectable() {
        return true;
    }

    protected void displaySelectionError() {
        String string;
        if (this.selectErrorMsgID == null) {
            Object[] objectArray = new String[]{this.getNameList().toString()};
            string = MessageLog.getMessageNoTS("GUI0249E", objectArray);
        } else {
            string = MessageLog.getMessageNoTS(this.selectErrorMsgID, null);
        }
        GuiUtil.displayErrorMessage(string);
    }

    public void setButtonFlag(boolean bl) {
        this.buttonFlag = bl;
    }

    public boolean getButtonFlag() {
        return this.buttonFlag;
    }

    public String toString() {
        NameList nameList = (NameList)this.getUserObject();
        if (Constants.isVirtualServer(nameList.nlID2) && this.showVsName) {
            String string = String.valueOf(Util.getTranslatedName(nameList.nlName)) + "[" + nameList.nlHostName + "]";
            if (this.showClusterName) {
                string = String.valueOf(string) + "(" + nameList.nlClusterName + ")";
            }
            return string;
        }
        if (nameList.nlClusterID > 0 && this.showClusterName && nameList.nlInfo != 99) {
            return String.valueOf(Util.getTranslatedName(nameList.nlName)) + "(" + nameList.nlClusterName + ")";
        }
        return Util.getTranslatedName(nameList.nlName);
    }

    public boolean canSelect() {
        return this.selectable;
    }

    public void setNonClusteredLabel() {
        this.isNonClusteredLabel = true;
    }
}

