/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.ChangeDeviceServerPasswordDialog;
import org.eclipse.aperi.gui.admin.DeviceServerData;
import org.eclipse.aperi.gui.admin.GenericDeviceServiceTreeNode;

public class DeviceServerServiceTreeNode
extends GenericDeviceServiceTreeNode
implements ActionListener {
    private static String deviceServerServiceName = Util.getString("DEVICE_SERVER");
    private static String CHANGEPWD = Util.getString("CHANGE_PWD");
    private String actionCommand;
    public JPopupMenu popup = null;
    private int port;
    private String jdbcUrl;
    private String jdbcDriver;
    private String dbPoolCount;
    private int inactiveAgents;
    private int totalAgents;
    private long vmSize;
    private long elapsedTime;
    private long startTime;

    public DeviceServerServiceTreeNode(String string, String string2, byte by, int n, long l, long l2, long l3, String string3, String string4, String string5, int n2, int n3) {
        super(deviceServerServiceName, string, string2, by);
        this.jdbcUrl = string3;
        this.jdbcDriver = string4;
        this.dbPoolCount = string5;
        this.totalAgents = n2;
        this.inactiveAgents = n3;
        this.port = n;
        this.vmSize = l;
        this.elapsedTime = l2;
        this.startTime = l3;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        boolean bl = true;
        if (mouseEvent == null) {
            bl = false;
        }
        this.popup = this.getPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(CHANGEPWD);
        jMenuItem.setName(CHANGEPWD);
        jMenuItem.setEnabled(DeviceServerServiceTreeNode.guiMain.getUserPrefs().administrator);
        jMenuItem.setActionCommand(CHANGEPWD);
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        if (bl) {
            this.showPopupMenu(this.popup, mouseEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionCommand = actionEvent.getActionCommand();
        if (this.actionCommand == CHANGEPWD) {
            this.changePassword();
        }
    }

    private void changePassword() {
        ChangeDeviceServerPasswordDialog changeDeviceServerPasswordDialog = new ChangeDeviceServerPasswordDialog(guiMain.getFrame(), Util.getString("CHANGE_PWD"), true);
        GuiUtil.centerDialog(changeDeviceServerPasswordDialog);
        changeDeviceServerPasswordDialog.displayDialog();
    }

    public boolean isRepresentingTheServerService() {
        return false;
    }

    public JPanel getPanel() {
        return new DeviceServerData(this);
    }

    public String getDbPoolCount() {
        return this.dbPoolCount;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public int getPort() {
        return this.port;
    }

    public void setDbPoolCount(String string) {
        this.dbPoolCount = string;
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public void setJdbcUrl(String string) {
        this.jdbcUrl = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getInactiveAgents() {
        return this.inactiveAgents;
    }

    public int getTotalAgents() {
        return this.totalAgents;
    }

    public void setInactiveAgents(int n) {
        this.inactiveAgents = n;
    }

    public void setTotalAgents(int n) {
        this.totalAgents = n;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getVMSize() {
        return this.vmSize;
    }
}

