/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JLabel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.IListTableModel;
import org.eclipse.aperi.gui.admin.agent.UtilsTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.config.service.ServiceConfigTab;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;

public class InbandFabricAgentTableModel
extends BaseTableModel
implements IListTableModel {
    private Hashtable agentsHash;
    public final String[] COL_NAMES = new String[]{GuiUtil.getString("CONFIG_COMMON_TABLE_COL_AGENT"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_IP"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_STATE"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_OS_VERSION")};
    public static final int DS_NAME = 0;
    public static final int DS_IP = 1;
    public static final int DS_STATE = 2;
    public static final int DS_OS = 3;
    public ArrayList agents = null;
    public ArrayList agentsInfo = null;

    public InbandFabricAgentTableModel(ArrayList arrayList, ArrayList arrayList2) {
        this.agents = arrayList;
        this.agentsInfo = arrayList2;
        this.columnNames = this.COL_NAMES;
        this.rowCount = arrayList != null ? arrayList.size() : 0;
        this.agentsHash = new Hashtable();
        int n = 0;
        while (n < this.rowCount) {
            Integer n2 = new Integer(((NameList)arrayList.get((int)n)).nlID);
            this.agentsHash.put(n2, new Integer(n));
            ++n;
        }
    }

    public InbandFabricAgentTableModel() {
        this(new ArrayList(), new ArrayList());
    }

    public Object getTableDataItem(int n, int n2) {
        try {
            NameList nameList = (NameList)this.agents.get(n);
            InbandFabricAgentInfo inbandFabricAgentInfo = (InbandFabricAgentInfo)this.agentsInfo.get(n);
            switch (n2) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(nameList.nlName);
                }
                case 1: {
                    return GUIEntityUtil.getDisplayText(inbandFabricAgentInfo.ipaddress);
                }
                case 2: {
                    String string = FabricGuiUtil.getInbandFabricAgentStatusString(nameList.nlState);
                    switch (nameList.nlState) {
                        case 1: {
                            return new JLabel(string, ServiceConfigTab.ICON_UP, 10);
                        }
                        case 0: {
                            return new JLabel(string, ServiceConfigTab.ICON_DOWN, 10);
                        }
                    }
                    return new JLabel(string, ServiceConfigTab.ICON_UNKNOWN, 10);
                }
                case 3: {
                    return GUIEntityUtil.getDisplayText(inbandFabricAgentInfo.OperatingSystemAndVersion);
                }
            }
            return "";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    public void refreshAgent(NameList nameList, InbandFabricAgentInfo inbandFabricAgentInfo) {
        Integer n = (Integer)this.agentsHash.get(new Integer(nameList.nlID));
        if (n != null) {
            this.agents.set(n, nameList);
            this.agentsInfo.set(n, inbandFabricAgentInfo);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void refreshAgent(NameList nameList) {
        int n = 0;
        Integer n2 = (Integer)this.agentsHash.get(new Integer(nameList.nlID));
        if (n2 != null) {
            this.agents.set(n2, nameList);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void refreshAgentsInfo(short s, Response response, boolean bl) {
        int n = 0;
        InbandFabricAgentInfo inbandFabricAgentInfo = null;
        if (s <= 4) {
            InbandFabricAgentInfo[] inbandFabricAgentInfoArray = (InbandFabricAgentInfo[])response.responseData;
            n = 0;
            while (n < inbandFabricAgentInfoArray.length) {
                inbandFabricAgentInfo = inbandFabricAgentInfoArray[n];
                Integer n2 = (Integer)this.agentsHash.get(new Integer(inbandFabricAgentInfo.hostId));
                if (n2 != null) {
                    this.agentsInfo.set(n2, inbandFabricAgentInfo);
                }
                ++n;
            }
            if (bl) {
                this.fireTableDataChanged();
            }
        }
    }

    public void refreshAgents(short s, Response response, boolean bl, AgentListDDI agentListDDI) {
        NameList nameList = null;
        ArrayList<InbandFabricAgentInfo> arrayList = new ArrayList<InbandFabricAgentInfo>();
        ArrayList<NameList> arrayList2 = new ArrayList<NameList>();
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        if (s <= 4) {
            int n2 = this.agents.size();
            boolean[] blArray = new boolean[n2];
            nameList = (NameList)response.responseData;
            while (nameList != null) {
                NameList nameList2 = nameList.nlNext;
                nameList.nlNext = null;
                Integer n3 = (Integer)this.agentsHash.get(new Integer(nameList.nlID));
                if (n3 != null) {
                    n = n3;
                    blArray[n] = true;
                    this.agents.set(n, nameList);
                } else {
                    arrayList2.add(nameList);
                    arrayList.add(new InbandFabricAgentInfo());
                }
                nameList = nameList2;
            }
            n = 0;
            while (n < blArray.length) {
                if (!blArray[n]) {
                    arrayList3.add(this.agents.get(n));
                }
                ++n;
            }
            if (arrayList3.size() > 0 || arrayList2.size() > 0) {
                UtilsTableModel.removeAndAddAgents(arrayList3, arrayList2, arrayList, false, this);
            }
            if (bl) {
                this.fireTableDataChanged();
            }
            if (agentListDDI != null) {
                agentListDDI.setLastRefreshTime(true);
            }
        } else if (agentListDDI != null) {
            agentListDDI.setLastRefreshTime(false);
        }
    }

    public void removeAgents(NameList[] nameListArray) {
        if (nameListArray == null) {
            return;
        }
        TreeSet treeSet = new TreeSet();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < nameListArray.length) {
            treeSet.add(this.agentsHash.get(new Integer(nameListArray[n].nlID)));
            ++n;
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            arrayList.add(this.agents.get(n2));
        }
        UtilsTableModel.removeAndAddAgents(arrayList, null, null, true, this);
    }

    public int getNumRows() {
        return this.agents.size();
    }

    public int getRowCount() {
        return this.agents.size();
    }

    public Object elementAt(int n) {
        return this.agents.get(n);
    }

    public Integer getPosForAgent(Object object) {
        if (object == null) {
            return null;
        }
        Integer n = new Integer(((NameList)object).nlID);
        return (Integer)this.agentsHash.get(n);
    }

    public Object getAgentInfoAt(int n) {
        return this.agentsInfo.get(n);
    }

    public void removeAgentAt(int n) {
        NameList nameList = (NameList)this.agents.get(n);
        this.agents.remove(n);
        this.agentsInfo.remove(n);
        this.agentsHash.remove(new Integer(nameList.nlID));
    }

    public void addAgents(int n, Collection collection, Collection collection2) {
        if (collection == null) {
            return;
        }
        this.agents.addAll(n, collection);
        this.agentsInfo.addAll(n, collection2);
    }

    public void rehashAgent(Object object, Integer n) {
        if (object == null || n == null) {
            return;
        }
        Integer n2 = new Integer(((NameList)object).nlID);
        this.agentsHash.put(n2, n);
    }

    public void clear(boolean bl) {
        this.agents.clear();
        this.agentsInfo.clear();
        if (!bl) {
            this.agentsHash.clear();
        }
    }

    public void fireTableRowsInserted(int n, int n2) {
        super.fireTableRowsInserted(n, n2);
    }

    public void fireTableRowsDeleted(int n, int n2) {
        super.fireTableRowsDeleted(n, n2);
    }
}

