/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationKey;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class AperiChartCustomizationManager {
    private HashMap customMap = new HashMap();
    private String userID;
    private static AperiChartCustomizationManager staticReference = null;

    private AperiChartCustomizationManager() {
    }

    private AperiChartCustomizationManager(String string, ArrayList arrayList) {
        this.setUserID(string);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            GuiChartSettingsReq guiChartSettingsReq = (GuiChartSettingsReq)iterator.next();
            AperiChartCustomizationKey aperiChartCustomizationKey = new AperiChartCustomizationKey(guiChartSettingsReq);
            this.getCustomMap().put(aperiChartCustomizationKey, guiChartSettingsReq.options);
        }
    }

    public ChartOptions getChartCustomization(AperiChartCustomizationKey aperiChartCustomizationKey) {
        return (ChartOptions)this.getCustomMap().get(aperiChartCustomizationKey);
    }

    private GuiChartSettingsReq newGCSR(AperiChartCustomizationKey aperiChartCustomizationKey, ChartOptions chartOptions) {
        GuiChartSettingsReq guiChartSettingsReq = new GuiChartSettingsReq();
        guiChartSettingsReq.reportId = aperiChartCustomizationKey.reportId;
        guiChartSettingsReq.reportSubtype = aperiChartCustomizationKey.reportSubtype;
        guiChartSettingsReq.chartId = aperiChartCustomizationKey.chartId;
        guiChartSettingsReq.chartSubtype = aperiChartCustomizationKey.chartSubtype;
        guiChartSettingsReq.batchId = aperiChartCustomizationKey.batchId;
        guiChartSettingsReq.creator = this.getUserID();
        guiChartSettingsReq.options = chartOptions;
        return guiChartSettingsReq;
    }

    private Request newRequest(GuiChartSettingsReq guiChartSettingsReq) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        request.requestData = guiChartSettingsReq;
        return request;
    }

    public void saveChartCustomization(AperiChartCustomizationKey aperiChartCustomizationKey, ChartOptions chartOptions) {
        GuiChartSettingsReq guiChartSettingsReq = this.newGCSR(aperiChartCustomizationKey, chartOptions);
        guiChartSettingsReq.reqType = 2;
        this.getCustomMap().put(aperiChartCustomizationKey, chartOptions.clone());
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
            }
        }, this.newRequest(guiChartSettingsReq));
    }

    public void saveChartCustomization(Request request) {
        if (request == null || request.requestData == null || !(request.requestData instanceof GuiChartSettingsReq)) {
            return;
        }
        GuiChartSettingsReq guiChartSettingsReq = (GuiChartSettingsReq)request.requestData;
        ChartOptions chartOptions = guiChartSettingsReq.options;
        if (chartOptions == null) {
            return;
        }
        AperiChartCustomizationKey aperiChartCustomizationKey = new AperiChartCustomizationKey(guiChartSettingsReq);
        guiChartSettingsReq.reqType = 2;
        this.getCustomMap().put(aperiChartCustomizationKey, chartOptions.clone());
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
            }
        }, this.newRequest(guiChartSettingsReq));
    }

    public void deleteChartCustomization(AperiChartCustomizationKey aperiChartCustomizationKey) {
        GuiChartSettingsReq guiChartSettingsReq = this.newGCSR(aperiChartCustomizationKey, null);
        guiChartSettingsReq.reqType = 3;
        this.getCustomMap().remove(aperiChartCustomizationKey);
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
            }
        }, this.newRequest(guiChartSettingsReq));
    }

    private HashMap getCustomMap() {
        return this.customMap;
    }

    private String getUserID() {
        return this.userID;
    }

    private void setUserID(String string) {
        this.userID = string;
    }

    public static AperiChartCustomizationManager getManager() {
        if (staticReference == null) {
            GuiClient.getChartCustomizations(GuiUtil.getUserName());
        }
        return staticReference;
    }

    public static void initManager(String string, ArrayList arrayList) {
        staticReference = new AperiChartCustomizationManager(string, arrayList);
    }
}

