/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialog;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialogCallbackInterface;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationKey;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;

public class AperiCustomizableChart
extends AperiChart
implements AperiChartCustomizationDialogCallbackInterface {
    private static final long serialVersionUID = 1L;
    private ChartOptions defaultSettings;
    private ChartOptions currentSettings;
    private AperiChartCustomizationKey customizationKey;
    private JButton prevButton = new JButton(Util.getString("CHART_PREV"));
    private JButton upButton = new JButton(Util.getString("CHART_UP"));
    private JLabel interactiveStatus = new JLabel();
    private JButton downButton = new JButton(Util.getString("CHART_DOWN"));
    private JButton nextButton = new JButton(Util.getString("CHART_NEXT"));
    JPanel buttonPanel = new JPanel();
    private boolean buttonsEnabled = false;

    public AperiCustomizableChart(int n, int n2, double[][] dArray, double[][] dArray2, String[] stringArray, ChartOptions chartOptions, GuiReportReq guiReportReq) {
        super(0, n, n2, dArray, dArray2, stringArray);
        this.configureCustomization(chartOptions, guiReportReq);
        this.configurePaging();
    }

    private void configurePaging() {
        if (this.isPageable()) {
            this.add(this.createButtonPanel(), "South");
        }
    }

    public AperiCustomizableChart(int n, int n2, Number[][] numberArray, String[] stringArray, String[] stringArray2, ChartOptions chartOptions, GuiReportReq guiReportReq) {
        super(1, n, n2, numberArray, stringArray, (Object[])stringArray2);
        this.configureCustomization(chartOptions, guiReportReq);
        this.configurePaging();
    }

    private boolean isPrevNext() {
        if (this.getChart().getChartType() == 0 && this.getCurrentSettings().seriesPerChart != -1 && this.getChart().getYValues() != null && this.getChart().getYValues().length > this.getCurrentSettings().seriesPerChart) {
            return true;
        }
        return this.getCurrentSettings().chartsPerView != -1 && this.getChart().getXCategories() != null && this.getChart().getXCategories().length > 1 && this.getChart().getYSeries() != null && this.getChart().getYSeries().length > 0 && this.getChart().getYSeries()[0] != null && this.getChart().getYSeries()[0].length > this.getCurrentSettings().chartsPerView;
    }

    private boolean isUpDown() {
        return this.getCurrentSettings().seriesPerChart != -1 && this.getChart().getChartType() != 0 && this.getChart().getXCategories().length == 1 && this.getChart().getYSeries().length > this.getCurrentSettings().seriesPerChart;
    }

    private boolean isPageable() {
        return this.isPrevNext() || this.isUpDown();
    }

    private void configureCustomization(ChartOptions chartOptions, GuiReportReq guiReportReq) {
        this.setCustomizationKey(new AperiChartCustomizationKey(guiReportReq));
        this.getChart().addMouseListener(new MyMouseAdapter());
        this.setDefaultSettings(chartOptions);
        ChartOptions chartOptions2 = null;
        if (AperiChartCustomizationManager.getManager() != null) {
            chartOptions2 = AperiChartCustomizationManager.getManager().getChartCustomization(this.getCustomizationKey());
        }
        if (chartOptions2 == null) {
            this.setCurrentSettings((ChartOptions)this.defaultSettings.clone());
        } else {
            this.setCurrentSettings(chartOptions2);
        }
        this.applyOptions(this.getCurrentSettings());
    }

    private Component createButtonPanel() {
        this.buttonPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.buttonPanel.setVisible(true);
        this.buttonPanel.setLayout(new FlowLayout());
        if (this.isPrevNext()) {
            this.buttonPanel.add(this.getPrevButton());
        }
        if (this.isUpDown()) {
            this.buttonPanel.add(this.getUpButton());
        }
        this.buttonPanel.add(this.getInteractiveStatus());
        if (this.isUpDown()) {
            this.buttonPanel.add(this.getDownButton());
        }
        if (this.isPrevNext()) {
            this.buttonPanel.add(this.getNextButton());
        }
        return this.buttonPanel;
    }

    private void applyOptions(ChartOptions chartOptions) {
        this.getChart().setChartTitle(chartOptions.title);
        this.getChart().setYValuePointsVisible(!chartOptions.hoverText);
        if (this.getChart().getChartType() == 0) {
            if (chartOptions.chartType != 0) {
                throw new RuntimeException("Attempt to change history chart type not allowed");
            }
            if (chartOptions.seriesPerChart != -1) {
                this.enablePrevNextSeriesButtons();
            }
            this.getChart().setTrendLineVisible(chartOptions.trends);
        } else {
            switch (chartOptions.chartType) {
                case 2: {
                    this.getChart().setChartType(2);
                    this.getChart().setChartOrientation(0);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 3: {
                    this.getChart().setChartType(2);
                    this.getChart().setChartOrientation(1);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 4: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(0);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 5: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(1);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 6: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(0);
                    this.getChart().setYAxisScaling(1);
                    break;
                }
                case 7: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(1);
                    this.getChart().setYAxisScaling(1);
                    break;
                }
                default: {
                    this.getChart().setYAxisScaling(0);
                    this.getChart().setChartType(1);
                }
            }
            this.getChart().setChartSubtype(this.determineChartSubtype(chartOptions));
            if (chartOptions.chartsPerView != -1 && chartOptions.chartsPerView != 1) {
                this.enablePrevNextChartsButtons();
            } else if (chartOptions.seriesPerChart != -1) {
                this.enableUpDownButtons();
            }
        }
    }

    private void refreshInteractiveStatus() {
        int n;
        int n2;
        int n3;
        if (this.getChart().getChartType() == 0) {
            n3 = this.getChart().getYValues().length;
            n2 = this.getChart().getSeriesOffset();
            n = Math.min(this.getChart().getSeriesOffset() + this.getChart().getSeriesPerChart(), n3);
        } else if (this.getChart().getChartSubtype() == 0) {
            n3 = this.getChart().getYSeries().length;
            n2 = this.getChart().getSeriesOffset();
            n = Math.min(this.getChart().getSeriesOffset() + this.getChart().getSeriesPerChart(), n3);
        } else {
            n3 = this.getChart().getXCategories().length;
            n2 = this.getChart().getCategoryOffset();
            n = Math.min(this.getChart().getCategoryOffset() + this.getChart().getChartsPerView(), n3);
        }
        this.getInteractiveStatus().setText(Util.getString("CHART_STATUS", new String[]{String.valueOf(n2), String.valueOf(n), String.valueOf(n3)}));
    }

    private void enableUpDownButtons() {
        this.getChart().setSeriesPerChart(0, this.getCurrentSettings().seriesPerChart);
        if (!this.buttonsEnabled) {
            this.getDownButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(AperiCustomizableChart.this.getChart().getSeriesOffset() + ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart, ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() > AperiCustomizableChart.this.getChart().getYSeries().length) {
                        AperiCustomizableChart.this.getDownButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() > 0) {
                        AperiCustomizableChart.this.getUpButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getDownButton().setEnabled(true);
        if (!this.buttonsEnabled) {
            this.getUpButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(Math.max(0, AperiCustomizableChart.this.getChart().getSeriesOffset() - ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart), ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() == 0) {
                        AperiCustomizableChart.this.getUpButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() < AperiCustomizableChart.this.getChart().getYSeries().length) {
                        AperiCustomizableChart.this.getDownButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getUpButton().setEnabled(false);
        this.refreshInteractiveStatus();
        this.buttonsEnabled = true;
    }

    private void enablePrevNextChartsButtons() {
        this.getChart().setChartsPerView(0, this.getCurrentSettings().chartsPerView);
        this.getChart().setSeriesPerChart(0, this.getCurrentSettings().seriesPerChart);
        if (!this.buttonsEnabled) {
            this.getNextButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AperiCustomizableChart.this.getChart().setChartsPerView(AperiCustomizableChart.this.getChart().getCategoryOffset() + ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView, ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView);
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() + AperiCustomizableChart.this.getChart().getChartsPerView() > AperiCustomizableChart.this.getChart().getXCategories().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() > 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(true);
                    }
                }
            });
        }
        this.getNextButton().setEnabled(true);
        if (!this.buttonsEnabled) {
            this.getPrevButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AperiCustomizableChart.this.getChart().setChartsPerView(Math.min(0, AperiCustomizableChart.this.getChart().getChartsPerView() - ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView), ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView);
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() == 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() + AperiCustomizableChart.this.getChart().getChartsPerView() <= AperiCustomizableChart.this.getChart().getXCategories().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(true);
                    }
                }
            });
        }
        this.getPrevButton().setEnabled(false);
        this.buttonsEnabled = true;
    }

    private void enablePrevNextSeriesButtons() {
        this.getChart().setSeriesPerChart(0, this.getCurrentSettings().seriesPerChart);
        if (!this.buttonsEnabled) {
            this.getNextButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(AperiCustomizableChart.this.getChart().getSeriesOffset() + ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart, ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() > AperiCustomizableChart.this.getChart().getYValues().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() > 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getNextButton().setEnabled(true);
        if (!this.buttonsEnabled) {
            this.getPrevButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(Math.max(0, AperiCustomizableChart.this.getChart().getSeriesOffset() - ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart), ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() == 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() < AperiCustomizableChart.this.getChart().getYValues().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getPrevButton().setEnabled(false);
        this.refreshInteractiveStatus();
        this.buttonsEnabled = true;
    }

    private int determineChartSubtype(ChartOptions chartOptions) {
        return chartOptions.seriesPerChart != -1 ? 0 : 1;
    }

    public void setCustomOptions(ChartOptions chartOptions) {
        this.setCurrentSettings((ChartOptions)chartOptions.clone());
        this.applyOptions(this.getCurrentSettings());
    }

    public void saveCustomOptions(ChartOptions chartOptions) {
        if (AperiChartCustomizationManager.getManager() == null) {
            return;
        }
        if (chartOptions.equals(this.defaultSettings)) {
            AperiChartCustomizationManager.getManager().deleteChartCustomization(this.getCustomizationKey());
        } else {
            AperiChartCustomizationManager.getManager().saveChartCustomization(this.getCustomizationKey(), chartOptions);
        }
    }

    private AperiCustomizableChart getSelfReference() {
        return this;
    }

    private ChartOptions getDefaultSettings() {
        return this.defaultSettings;
    }

    private void setDefaultSettings(ChartOptions chartOptions) {
        this.defaultSettings = chartOptions;
    }

    private ChartOptions getCurrentSettings() {
        return this.currentSettings;
    }

    private void setCurrentSettings(ChartOptions chartOptions) {
        this.currentSettings = chartOptions;
    }

    private AperiChartCustomizationKey getCustomizationKey() {
        return this.customizationKey;
    }

    private void setCustomizationKey(AperiChartCustomizationKey aperiChartCustomizationKey) {
        this.customizationKey = aperiChartCustomizationKey;
    }

    private JButton getDownButton() {
        return this.downButton;
    }

    private void setDownButton(JButton jButton) {
        this.downButton = jButton;
    }

    private JLabel getInteractiveStatus() {
        return this.interactiveStatus;
    }

    private void setInteractiveStatus(JLabel jLabel) {
        this.interactiveStatus = jLabel;
    }

    private JButton getNextButton() {
        return this.nextButton;
    }

    private void setNextButton(JButton jButton) {
        this.nextButton = jButton;
    }

    private JButton getPrevButton() {
        return this.prevButton;
    }

    private void setPrevButton(JButton jButton) {
        this.prevButton = jButton;
    }

    private JButton getUpButton() {
        return this.upButton;
    }

    private void setUpButton(JButton jButton) {
        this.upButton = jButton;
    }

    private class MyMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

        private MyMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = jPopupMenu.add(Util.getString("CUSTOMIZE_THIS_CHART"));
                jMenuItem.setActionCommand("Customize");
                jMenuItem.addActionListener(this);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AperiChartCustomizationDialog aperiChartCustomizationDialog = new AperiChartCustomizationDialog(this.guiMain.getFrame(), AperiCustomizableChart.this.getSelfReference(), Util.getString("CHART_CUSTOMIZATION"), null, AperiCustomizableChart.this.getCurrentSettings(), AperiCustomizableChart.this.getDefaultSettings(), AperiCustomizableChart.this.getChart().getChartType() != 0, true, AperiCustomizableChart.this.getChart().getChartType() != 0, AperiCustomizableChart.this.getChart().getChartSubtype() == 0, AperiCustomizableChart.this.getChart().getChartType() == 0);
            GuiUtil.centerDialog(aperiChartCustomizationDialog);
            aperiChartCustomizationDialog.setVisible(true);
        }
    }
}

