/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.disk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.common.model.DataAccessor;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class SubsystemSection
extends ConfigSection
implements GuiRequestor,
ActionListener,
TJCTableMouseInterface {
    private int countTotal = 0;
    private int countNormal = 0;
    private int countCritical = 0;
    private int countWarning = 0;
    private int countUnreachable = 0;
    private MegaTable table = null;
    private StorageSubsystemTableModel tableModel = null;
    private JButton link2detail = null;
    private ArrayList ssNodePath = null;
    private JButton link2asset = null;
    private ArrayList assetRepPath = null;
    private JButton link2topo = null;
    private ArrayList topoNodePath = null;
    private JLabel noData = null;
    protected static Vector subsystems = new Vector();
    protected ArrayList ssArray;
    private Vector changedDetailsPanels = new Vector();
    private GUIStorageSubsystem subsystem = null;
    private int subsystemInternalId = -1;

    public SubsystemSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        this.assetRepPath = new ArrayList();
        try {
            clazz5 = Class.forName("org.eclipse.aperi.TStorm.gui.StormTreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.assetRepPath.add(clazz5);
        try {
            clazz4 = Class.forName("org.eclipse.aperi.TStorm.gui.ReportingTreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.assetRepPath.add(clazz4);
        this.assetRepPath.add(MessageLog.getMessageNoID("STG1000L", null));
        try {
            clazz3 = Class.forName("org.eclipse.aperi.San.gui.DiskArrayTreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.assetRepPath.add(clazz3);
        this.topoNodePath = new ArrayList();
        try {
            clazz2 = Class.forName("org.eclipse.aperi.TStorm.gui.TreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.topoNodePath.add(clazz2);
        try {
            clazz = Class.forName("org.eclipse.aperi.topology.gui.TopologyViewerTreeLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.topoNodePath.add(clazz);
        this.topoNodePath.add(GuiUtil.getString("TOPO_LABEL_ENTITY_STORAGE"));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_STORAGE_SUBSYSTEMS");
        if (!this.isExpanded()) {
            string = GuiUtil.getString("CONFIG_SS_SECTION_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countNormal), String.valueOf(this.countCritical), String.valueOf(this.countWarning), String.valueOf(this.countUnreachable)});
        }
        return string;
    }

    public void refresh(boolean bl) {
        if (this.link2detail == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_SHOW_SS_DETAILS"));
            this.link2detail.addActionListener(this);
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            jPanel2.add(this.link2detail);
            this.link2detail.setEnabled(false);
            this.link2asset = new JButton(GuiUtil.getString("CONFIG_SS_ASSET_REPORT"));
            this.link2asset.addActionListener(this);
            GuiUtil.setAccessible(this.link2asset, this.link2asset.getText(), this.link2asset.getText());
            jPanel2.add(this.link2asset);
            this.link2asset.setEnabled(false);
            this.link2topo = new JButton(GuiUtil.getString("CONFIG_STTOPO_BTN"));
            this.link2topo.addActionListener(this);
            GuiUtil.setAccessible(this.link2topo, this.link2topo.getText(), this.link2topo.getText());
            if (!this.capabilities.isDiskOp()) {
                this.link2topo.setEnabled(false);
            }
            jPanel2.add(this.link2topo);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_SS_NOTE1"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
            ConfigNote configNote2 = new ConfigNote(GuiUtil.getString("CONFIG_SS_NOTE2"), jPanel);
            configNote2.setAlignmentX(0.0f);
            jPanel.add(configNote2);
            ConfigNote configNote3 = new ConfigNote(GuiUtil.getString("CONFIG_CIMOM_DESC"), jPanel);
            configNote3.setAlignmentX(0.0f);
            jPanel.add(configNote3);
            this.getSubsystems();
        }
        if (bl) {
            this.getSubsystems();
        }
    }

    public void getSubsystems() {
        GUIRequestData gUIRequestData = new GUIRequestData(0);
        DataAccessor.sendGuiRequest(this, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", gUIRequestData);
    }

    private void buildTable() {
        this.tableModel = new StorageSubsystemTableModel(this.ssArray);
        if (this.ssArray.size() != 0 && this.tableModel != null) {
            Class<?> clazz;
            Class<?> clazz2;
            if (this.table != null) {
                this.remove(this.table);
            }
            if (this.noData != null) {
                this.remove(this.noData);
            }
            this.table = new MegaTable();
            this.table.setVisibleRows(10);
            this.table.setMouseListener(this);
            this.table.setBaseTableModel(this.tableModel);
            try {
                clazz2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.table.setCellRenderer(clazz2, new NumberRenderer());
            try {
                clazz = Class.forName("javax.swing.JLabel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.table.setCellRenderer(clazz, new LabelRenderer());
            this.table.setSelectionPolicy(0);
            this.table.sortByColumn(3, 1);
            this.selectionChanged(true);
            this.table.updateUI();
            this.add((Component)this.table, "First");
        } else {
            if (this.table != null) {
                this.remove(this.table);
            }
            this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_SSUBSYSTEM_DATA"));
            this.add((Component)this.noData, "Center");
        }
        if (this.getContainer() != null) {
            this.getContainer().updateSectionTitle();
        }
        this.selectionChanged(false);
        this.revalidate();
        this.repaint();
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (s <= 4 && response != null && response.responseData != null) {
            HashMap hashMap = (HashMap)response.responseData;
            subsystems = new Vector(hashMap.values());
            Iterator iterator = subsystems.iterator();
            this.ssArray = new ArrayList();
            this.resetStateCount();
            while (iterator.hasNext()) {
                GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)iterator.next();
                this.ssArray.add(gUIStorageSubsystem);
                this.setStateCount(gUIStorageSubsystem);
            }
            this.buildTable();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2detail) {
            int[] nArray;
            if (this.tableModel != null && this.tableModel.getNumRows() != 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
                int n = nArray[0];
                GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)this.tableModel.subsystems.get(n);
                this.subsystemInternalId = gUIStorageSubsystem.getInternalId();
                SubsystemDDI subsystemDDI = new SubsystemDDI(this.subsystemInternalId);
                ((DataDisplayInfo)subsystemDDI).reDisplay();
            }
        } else if (actionEvent.getSource() == this.link2asset) {
            int[] nArray;
            if (this.tableModel != null && this.tableModel.getNumRows() != 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
                int n = nArray[0];
                GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)this.tableModel.subsystems.get(n);
                String string = gUIStorageSubsystem.getDeviceId();
                ArrayList<String> arrayList = new ArrayList<String>(this.assetRepPath);
                arrayList.add(string);
                new ConfigUtil().selectNode(arrayList);
            }
        } else if (actionEvent.getSource() == this.link2topo) {
            ArrayList arrayList = new ArrayList(this.topoNodePath);
            new ConfigUtil().selectNode(arrayList);
        }
    }

    private void resetStateCount() {
        this.countNormal = 0;
        this.countCritical = 0;
        this.countWarning = 0;
        this.countUnreachable = 0;
        this.countTotal = 0;
    }

    private void setStateCount(GUIStorageSubsystem gUIStorageSubsystem) {
        if (!gUIStorageSubsystem.isDetectable()) {
            ++this.countUnreachable;
        } else {
            switch (gUIStorageSubsystem.getState()) {
                case 0: {
                    ++this.countNormal;
                    break;
                }
                case 1: {
                    ++this.countWarning;
                    break;
                }
                case 2: {
                    ++this.countCritical;
                    break;
                }
                default: {
                    ++this.countUnreachable;
                }
            }
        }
        ++this.countTotal;
    }

    public void selectionChanged(boolean bl) {
        if (this.tableModel != null && this.tableModel.getNumRows() != 0) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                int n = nArray[0];
                GUIStorageSubsystem cfr_ignored_0 = (GUIStorageSubsystem)this.tableModel.subsystems.get(n);
                this.link2detail.setEnabled(true);
                this.link2asset.setEnabled(true);
            }
        } else {
            this.link2detail.setEnabled(false);
            this.link2asset.setEnabled(false);
        }
        if (!this.capabilities.isDiskOp()) {
            this.link2topo.setEnabled(false);
        } else {
            this.link2topo.setEnabled(true);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    public class StorageSubsystemTableModel
    extends BaseTableModel {
        public final String[] COL_NAMES = new String[]{GuiUtil.getString("DISK_SUBSYSTEM_COLUMN_SYSID_LABEL"), GuiUtil.getString("DISK_COMMON_LABEL"), GuiUtil.getString("DISK_SUBSYSTEM_COLUMN_TYPE_LABEL"), GuiUtil.getString("DISK_SUBSYSTEM_COLUMN_STATUS_LABEL"), GuiUtil.getString("CONFIG_SS_PRV_ENABLED")};
        private static final int SYS_ID = 0;
        private static final int SYS_NAME = 1;
        private static final int SYS_TYPE = 2;
        private static final int SYS_STATUS = 3;
        private static final int SYS_PRV_ENABLED = 4;
        private static final int SYS_PERF_ENABLED = 5;
        private ServerStatusResp status;
        public ArrayList subsystems;

        StorageSubsystemTableModel(ArrayList arrayList) {
            this.subsystems = arrayList;
            this.columnNames = this.COL_NAMES;
            this.rowCount = arrayList != null ? arrayList.size() : 0;
        }

        public JLabel getEnabledLabel(boolean bl, boolean bl2) {
            String string = "";
            ImageIcon imageIcon = null;
            if (!bl2) {
                string = GuiUtil.getString("CONFIG_COMMON_STATUS_NOT_SUPPORTED");
                imageIcon = IconFactory.getStateFailedIcon();
            } else if (bl) {
                string = MessageLog.getMessageNoID("GUI0121T");
                imageIcon = IconFactory.getStateUpIcon();
            } else {
                string = GuiUtil.getString("CONFIG_COMMON_STATUS_PREREQ_NOT_MET");
                imageIcon = IconFactory.getStateWarningIcon();
            }
            if (imageIcon != null) {
                imageIcon.setDescription(string);
            }
            return new JLabel(string, imageIcon, 10);
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                GUIStorageSubsystem gUIStorageSubsystem = (GUIStorageSubsystem)this.subsystems.get(n);
                switch (n2) {
                    case 0: {
                        return GUIEntityUtil.getDisplayText(gUIStorageSubsystem.getDeviceId());
                    }
                    case 1: {
                        return GUIEntityUtil.getDisplayText(gUIStorageSubsystem.getUserProvidedName());
                    }
                    case 3: {
                        JLabel jLabel = GUIEntityUtil.getEntityStateLabel(gUIStorageSubsystem);
                        return jLabel;
                    }
                    case 2: {
                        if (gUIStorageSubsystem.getType() == 0) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_ESS");
                        }
                        if (gUIStorageSubsystem.getType() == 1) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_FASTT");
                        }
                        if (gUIStorageSubsystem.getType() == 2) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_DS6000");
                        }
                        if (gUIStorageSubsystem.getType() == 3) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_DS8000");
                        }
                        if (gUIStorageSubsystem.getType() == 4) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_SVC");
                        }
                        if (gUIStorageSubsystem.getType() == 5) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_HDS");
                        }
                        if (gUIStorageSubsystem.getType() == 6) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_EMC");
                        }
                        if (gUIStorageSubsystem.getType() == 7) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_HP");
                        }
                        if (gUIStorageSubsystem.getType() == 8) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_SUN");
                        }
                        if (gUIStorageSubsystem.getType() == 9) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_FUJITSU");
                        }
                        if (gUIStorageSubsystem.getType() == 10) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_HPXP128");
                        }
                        if (gUIStorageSubsystem.getType() == 99) {
                            return GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_OTHER");
                        }
                    }
                    case 4: {
                        JLabel jLabel = this.getEnabledLabel(gUIStorageSubsystem.isProbed(), gUIStorageSubsystem.isVolumeCreationSupported() && gUIStorageSubsystem.isPortAssignmentSupported());
                        return jLabel;
                    }
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }
    }
}

