/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class CompTypeSummary
extends PanelClasses {
    private int[] compArray;
    private long[] fsSpaceArray;
    private long[] diskSpaceArray;
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel compPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop1;
    private GridBagConstraints gbcPlop2;
    private GridBagConstraints gbcPlop3;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;
    private Insets insetD;
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final DecimalFormat decimalFormatter = new DecimalFormat();

    public CompTypeSummary(DashTotalsRow dashTotalsRow) {
        super(dashTotalsRow);
        int n = Constants.OSTYPES.length;
        this.compArray = new int[n];
        this.fsSpaceArray = new long[n];
        this.diskSpaceArray = new long[n];
        DashTotalsRow dashTotalsRow2 = dashTotalsRow;
        while (dashTotalsRow2 != null) {
            short s;
            if (dashTotalsRow2.dtrStatisticType == 5 && (s = dashTotalsRow2.dtrComputerType) < n) {
                this.compArray[s] = dashTotalsRow2.dtrTotalComputers;
                this.fsSpaceArray[s] = dashTotalsRow2.dtrFilesystemCapacity;
                this.diskSpaceArray[s] = dashTotalsRow2.dtrDiskCapacity;
            }
            dashTotalsRow2 = dashTotalsRow2.dtrNext;
        }
    }

    public Component getComponent(Object object, boolean bl) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop1 = new GridBagConstraints();
        this.gbcPlop2 = new GridBagConstraints();
        this.gbcPlop3 = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        if (DashMain.screenWidth <= 800) {
            this.insetA = new Insets(1, 0, 1, 1);
            this.insetB = new Insets(1, 0, 1, 7);
            this.insetC = new Insets(1, 0, 1, 2);
            this.insetD = new Insets(1, 0, 1, 0);
        } else {
            this.insetA = new Insets(1, 0, 3, 9);
            this.insetB = new Insets(1, 0, 3, 9);
            this.insetC = new Insets(1, 0, 3, 5);
            this.insetD = new Insets(1, 0, 3, 0);
        }
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop1.anchor = 17;
        this.gbcPlop1.insets = this.insetB;
        this.gbcPlop2.anchor = 17;
        this.gbcPlop2.insets = this.insetC;
        this.gbcPlop3.anchor = 17;
        this.gbcPlop3.insets = this.insetD;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetD;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.compPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5250L"));
        if (this.compArray == null) {
            this.compPanel.add(this.getLabel("STG5251L"));
        } else {
            BoldLabel boldLabel = this.getLabel("STG1108L");
            BoldLabel boldLabel2 = this.getLabel("STG5253L");
            BoldLabel boldLabel3 = this.getLabel("STG5003L");
            BoldLabel boldLabel4 = this.getLabel("STG1240L");
            BoldLabel boldLabel5 = this.getLabel("STG1162L");
            BoldLabel boldLabel6 = this.getLabel("STG1162L");
            this.addLine(boldLabel, boldLabel2, boldLabel3, boldLabel4);
            this.addLine(new JLabel(" "), new JLabel(" "), boldLabel5, boldLabel6);
            this.addComputer(4, MessageLog.getMessageNoID("STG1024L"));
            this.addComputer(5, MessageLog.getMessageNoID("STG1025L"));
            this.addComputer(20, MessageLog.getMessageNoID("STG1027L"));
            this.addComputer(6, MessageLog.getMessageNoID("STG1026L"));
            this.addComputer(1, MessageLog.getMessageNoID("STG1021L"));
            this.addComputer(3, MessageLog.getMessageNoID("STG1023L"));
            this.addComputer(2, MessageLog.getMessageNoID("STG1022L"));
            this.addComputer(10, MessageLog.getMessageNoID("STG3254L"));
            this.addComputer(9, MessageLog.getMessageNoID("STG5227L"));
            this.addComputer(0, MessageLog.getMessageNoID("STG1020L"));
        }
        GuiUtil.completePanel(this.compPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.compPanel, "Center");
        return this.panel;
    }

    private BoldLabel getLabel(String string) {
        return new BoldLabel(MessageLog.getMessageNoID(string));
    }

    private void addComputer(int n, String string) {
        BoldLabel boldLabel = string == null ? new BoldLabel(MessageLog.getMessageNoID(Constants.OSTYPES[n])) : new BoldLabel(string);
        JLabel jLabel = this.getNumber(this.compArray[n]);
        JLabel jLabel2 = this.getSpace(this.fsSpaceArray[n]);
        JLabel jLabel3 = this.getSpace(this.diskSpaceArray[n]);
        this.addLine(boldLabel, jLabel, jLabel2, jLabel3);
    }

    private void addLine(JLabel jLabel, JLabel jLabel2, JLabel jLabel3, JLabel jLabel4) {
        this.compPanel.add((Component)jLabel, this.gbcIndent);
        this.compPanel.add((Component)jLabel2, this.gbcPlop1);
        this.compPanel.add((Component)jLabel3, this.gbcPlop2);
        this.compPanel.add((Component)jLabel4, this.gbcPlop3);
        this.compPanel.add((Component)new JLabel(" "), this.gbcLast);
    }

    private JLabel getNumber(int n) {
        if (n < 0) {
            return new JLabel("0");
        }
        return new JLabel(decimalFormatter.format(n));
    }

    private JLabel getSpace(long l) {
        if (l <= 0L) {
            return new JLabel(NA);
        }
        return new JLabel(Util.formatBytes(l * 512L));
    }
}

