/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class SystemSummary
extends PanelClasses {
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel summaryPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;
    private static final DecimalFormat decimalFormatter = new DecimalFormat();
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final String IS_DOWN = "STG5254L";
    private static final String ARE_DOWN = "STG5255L";

    public SystemSummary(DashTotalsRow dashTotalsRow) {
        super(dashTotalsRow);
    }

    public Component getComponent(Object object, boolean bl) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        if (DashMain.screenWidth <= 800) {
            this.insetA = new Insets(1, 0, 1, 9);
            this.insetB = new Insets(1, 0, 1, 1);
            this.insetC = new Insets(1, 0, 1, 0);
        } else {
            this.insetA = new Insets(1, 0, 2, 9);
            this.insetB = new Insets(1, 0, 2, 1);
            this.insetC = new Insets(1, 0, 2, 0);
        }
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop.anchor = 17;
        this.gbcPlop.gridwidth = 2;
        this.gbcPlop.insets = this.insetB;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetC;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.summaryPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5238L"));
        BoldLabel boldLabel = this.getLabel("STG2092L");
        BoldLabel boldLabel2 = this.getLabel("STG2005L");
        BoldLabel boldLabel3 = this.getLabel("STG2006L");
        BoldLabel boldLabel4 = this.getLabel("STG1115L");
        BoldLabel boldLabel5 = this.getLabel("STG5235L");
        BoldLabel boldLabel6 = this.getLabel("STG4191L");
        BoldLabel boldLabel7 = this.getLabel("STG4198L");
        BoldLabel boldLabel8 = this.getLabel("STG6059L");
        BoldLabel boldLabel9 = this.getLabel("STG6080L");
        BoldLabel boldLabel10 = this.getLabel("STG5228L");
        BoldLabel boldLabel11 = this.getLabel("STG5229L");
        BoldLabel boldLabel12 = this.getLabel("STG5231L");
        BoldLabel boldLabel13 = this.getLabel("STG5232L");
        JLabel jLabel = this.getSize(SystemSummary.totalsRow.dtrFilesystemCapacity);
        JLabel jLabel2 = this.getSize(SystemSummary.totalsRow.dtrUsedSpace);
        JLabel jLabel3 = this.getSize(SystemSummary.totalsRow.dtrFreeSpace);
        JLabel jLabel4 = this.getSize(SystemSummary.totalsRow.dtrDiskCapacity);
        JLabel jLabel5 = this.getSize(SystemSummary.totalsRow.dtrDiskUnallocated);
        JLabel jLabel6 = this.getSize(SystemSummary.totalsRow.dtrLunCapacity);
        JLabel jLabel7 = this.getSize(SystemSummary.totalsRow.dtrUsableLunCap);
        if (SystemSummary.totalsRow.dtrTotalComputers < 0) {
            SystemSummary.totalsRow.dtrTotalComputers = 0;
        }
        JLabel jLabel8 = this.getNumber(SystemSummary.totalsRow.dtrTotalStorageSubsystems);
        JLabel jLabel9 = this.getNumber(SystemSummary.totalsRow.dtrTotalLUNs);
        JLabel jLabel10 = this.getNumber(SystemSummary.totalsRow.dtrTotalAgents);
        JLabel jLabel11 = this.getAgentsDown();
        JLabel jLabel12 = this.getNumber(SystemSummary.totalsRow.dtrTotalComputers);
        JLabel jLabel13 = this.getNumber(SystemSummary.totalsRow.dtrTotalDisks);
        JLabel jLabel14 = this.getNumber(SystemSummary.totalsRow.dtrTotalFilesystems);
        this.addLine(boldLabel, jLabel);
        this.addLine(boldLabel2, jLabel2);
        this.addLine(boldLabel3, jLabel3);
        this.addLine(boldLabel4, jLabel4);
        this.addLine(boldLabel5, jLabel5);
        if (SystemSummary.totalsRow.dtrTotalStorageSubsystems > 0) {
            this.addLine(boldLabel8, jLabel6);
            this.addLine(boldLabel9, jLabel7);
        }
        if (jLabel11 == null) {
            this.addLine(boldLabel10, jLabel10);
        } else {
            this.gbcPlop.gridwidth = 1;
            this.addLine(boldLabel10, jLabel10, jLabel11);
            this.gbcPlop.gridwidth = 2;
        }
        this.addLine(boldLabel11, jLabel12);
        if (SystemSummary.totalsRow.dtrTotalStorageSubsystems > 0) {
            this.addLine(boldLabel6, jLabel8);
        }
        this.addLine(boldLabel12, jLabel13);
        if (SystemSummary.totalsRow.dtrTotalStorageSubsystems > 0) {
            this.addLine(boldLabel7, jLabel9);
        }
        this.addLine(boldLabel13, jLabel14);
        GuiUtil.completePanel(this.summaryPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.summaryPanel, "Center");
        return this.panel;
    }

    private JLabel getAgentsDown() {
        JLabel jLabel = null;
        if (SystemSummary.totalsRow.dtrTotalAgentsDown > 0) {
            String string = SystemSummary.totalsRow.dtrTotalAgentsDown == 1 ? IS_DOWN : ARE_DOWN;
            String string2 = decimalFormatter.format(SystemSummary.totalsRow.dtrTotalAgentsDown);
            jLabel = new JLabel(" (" + MessageLog.getMessageNoID(string, string2) + ")");
            jLabel.setForeground(Color.red);
            GuiUtil.setAccessibleDescription(jLabel, jLabel.getText());
            jLabel.setFont(jLabel.getFont().deriveFont(3));
        }
        return jLabel;
    }

    private BoldLabel getLabel(String string) {
        return new BoldLabel(MessageLog.getMessageNoID(string));
    }

    private JLabel getSize(long l) {
        if (l <= 0L) {
            return new JLabel(NA);
        }
        return new JLabel(Util.formatBytes(l * 512L));
    }

    private JLabel getNumber(int n) {
        if (n <= 0) {
            return new JLabel(NA);
        }
        return new JLabel(decimalFormatter.format(n));
    }

    private void addLine(JLabel jLabel, JLabel jLabel2) {
        this.addLine(jLabel, jLabel2, null);
    }

    private void addLine(JLabel jLabel, JLabel jLabel2, JLabel jLabel3) {
        this.summaryPanel.add((Component)jLabel, this.gbcIndent);
        this.summaryPanel.add((Component)jLabel2, this.gbcPlop);
        if (jLabel3 != null) {
            this.summaryPanel.add((Component)jLabel3, this.gbcPlop);
        }
        this.summaryPanel.add((Component)new JLabel(" "), this.gbcLast);
    }
}

