/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.common.model;

import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.common.model.DataAccessor;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.request.Response;

public class DiskDataController {
    private static DiskDataController diskDataController = null;

    public static DiskDataController getInstance() {
        if (diskDataController == null) {
            diskDataController = new DiskDataController();
        }
        return diskDataController;
    }

    public static void sendDiskSubsystemJobRequest(GuiRequestor guiRequestor, GUIRequestData gUIRequestData) {
        DataAccessor.sendJobRequest(guiRequestor, "org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler", DeviceRequest.DR_DISK, gUIRequestData);
    }

    public static void sendDiskFabricJobRequest(GuiRequestor guiRequestor, GUIRequestData gUIRequestData) {
        DataAccessor.sendJobRequest(guiRequestor, "org.eclipse.aperi.server.handler.scheduler.FabricActionHandler", DeviceRequest.DR_FABRIC, gUIRequestData);
    }

    public void createVolumes(GuiRequestor guiRequestor, long l, String string, long l2, String[] stringArray) {
        this.createVolumes(guiRequestor, l, string, l2, stringArray, true);
    }

    public void createVolumes(GuiRequestor guiRequestor, long l, String string, long l2, String[] stringArray, boolean bl) {
        GUIRequestData gUIRequestData = new GUIRequestData(0);
        gUIRequestData.setWillWaitForComplete(bl);
        gUIRequestData.addParameter("volume.size", new Long(l));
        gUIRequestData.addParameter("storagepool.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("num.of.volumes", new Long(l2));
        gUIRequestData.addParameter("volume.names", (Serializable)stringArray);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void createVolumesExt(GuiRequestor guiRequestor, long[] lArray, String[] stringArray, String[] stringArray2, HashMap hashMap) {
        this.createVolumesExt(guiRequestor, lArray, stringArray, stringArray2, hashMap, true);
    }

    public void createVolumesExt(GuiRequestor guiRequestor, long[] lArray, String[] stringArray, String[] stringArray2, HashMap hashMap, boolean bl) {
        GUIRequestData gUIRequestData = new GUIRequestData(6);
        gUIRequestData.setWillWaitForComplete(bl);
        gUIRequestData.addParameter("volume.sizes", (Serializable)lArray);
        gUIRequestData.addParameter("storagepool.ids", (Serializable)stringArray);
        gUIRequestData.addParameter("volume.names", (Serializable)stringArray2);
        gUIRequestData.addParameter("volume.crgoal", hashMap);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void createVDisks(GuiRequestor guiRequestor, long l, String string, String[] stringArray, boolean bl, int n, int n2, String[] stringArray2, int n3) {
        this.createVDisks(guiRequestor, l, string, stringArray, bl, n, n2, stringArray2, n3, true);
    }

    public void createVDisks(GuiRequestor guiRequestor, long l, String string, String[] stringArray, boolean bl, int n, int n2, String[] stringArray2, int n3, boolean bl2) {
        GUIRequestData gUIRequestData = new GUIRequestData(1);
        gUIRequestData.setWillWaitForComplete(bl2);
        gUIRequestData.addParameter("vdisk.size", new Long(l));
        gUIRequestData.addParameter("mdiskgroup.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("vdisk.names", (Serializable)stringArray);
        gUIRequestData.addParameter("vdisk.format.oncreate", new Boolean(bl));
        gUIRequestData.addParameter("vdisk.type", new Integer(n));
        gUIRequestData.addParameter("iogroup.id", new Integer(n2));
        gUIRequestData.addParameter("mdisk.ids", (Serializable)stringArray2);
        gUIRequestData.addParameter("num.of.vdisks", new Integer(n3));
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void addMisks(GuiRequestor guiRequestor, String string, String[] stringArray) {
        GUIRequestData gUIRequestData = new GUIRequestData(2);
        gUIRequestData.addParameter("mdiskgroup.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("mdisk.ids", (Serializable)stringArray);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void deleteVolumes(GuiRequestor guiRequestor, String[] stringArray) {
        GUIRequestData gUIRequestData = new GUIRequestData(3);
        gUIRequestData.addParameter("volume.ids", (Serializable)stringArray);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void assignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.assignPorts(guiRequestor, stringArray, stringArray2, stringArray3, -1, null, null, true);
    }

    public void assignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl) {
        this.assignPorts(guiRequestor, stringArray, stringArray2, stringArray3, -1, null, null, bl);
    }

    public void assignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl) {
        this.assignPorts(guiRequestor, stringArray, stringArray2, stringArray3, -1, null, null, bl);
    }

    public void assignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, String string, String[] stringArray4) {
        this.assignPorts(guiRequestor, stringArray, stringArray2, stringArray3, n, string, stringArray4, true);
    }

    public void assignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, String string, String[] stringArray4, boolean bl) {
        GUIRequestData gUIRequestData = new GUIRequestData(4);
        gUIRequestData.setWillWaitForComplete(bl);
        gUIRequestData.addParameter("volume.ids", (Serializable)stringArray);
        gUIRequestData.addParameter("system.ports", (Serializable)stringArray2);
        gUIRequestData.addParameter("host.ports", (Serializable)stringArray3);
        gUIRequestData.addParameter("host.type", new Integer(n));
        gUIRequestData.addParameter("host.type_desc", (Serializable)((Object)string));
        gUIRequestData.addParameter("host.names", (Serializable)stringArray4);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void createVolumesAndAssignPorts(GuiRequestor guiRequestor, long l, String string, long l2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, String string2, String[] stringArray4) {
        GUIRequestData gUIRequestData = new GUIRequestData(7);
        gUIRequestData.addParameter("volume.size", new Long(l));
        gUIRequestData.addParameter("storagepool.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("num.of.volumes", new Long(l2));
        gUIRequestData.addParameter("volume.names", (Serializable)stringArray);
        gUIRequestData.addParameter("system.ports", (Serializable)stringArray2);
        gUIRequestData.addParameter("host.ports", (Serializable)stringArray3);
        gUIRequestData.addParameter("host.type", new Integer(n));
        gUIRequestData.addParameter("host.type_desc", (Serializable)((Object)string2));
        gUIRequestData.addParameter("host.names", (Serializable)stringArray4);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void createVolumesExtAndAssignPorts(GuiRequestor guiRequestor, long[] lArray, String[] stringArray, String[] stringArray2, HashMap hashMap, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        GUIRequestData gUIRequestData = new GUIRequestData(8);
        gUIRequestData.addParameter("volume.sizes", (Serializable)lArray);
        gUIRequestData.addParameter("storagepool.ids", (Serializable)stringArray);
        gUIRequestData.addParameter("volume.names", (Serializable)stringArray2);
        gUIRequestData.addParameter("volume.crgoal", hashMap);
        gUIRequestData.addParameter("system.ports", (Serializable)stringArray3);
        gUIRequestData.addParameter("host.ports", (Serializable)stringArray4);
        gUIRequestData.addParameter("host.names", (Serializable)stringArray5);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void createVDisksAndAssignPorts(GuiRequestor guiRequestor, long l, String string, String[] stringArray, boolean bl, int n, int n2, String[] stringArray2, int n3, String[] stringArray3, String[] stringArray4, int n4, String string2, String[] stringArray5) {
        GUIRequestData gUIRequestData = new GUIRequestData(9);
        gUIRequestData.addParameter("vdisk.size", new Long(l));
        gUIRequestData.addParameter("mdiskgroup.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("vdisk.names", (Serializable)stringArray);
        gUIRequestData.addParameter("vdisk.format.oncreate", new Boolean(bl));
        gUIRequestData.addParameter("vdisk.type", new Integer(n));
        gUIRequestData.addParameter("iogroup.id", new Integer(n2));
        gUIRequestData.addParameter("mdisk.ids", (Serializable)stringArray2);
        gUIRequestData.addParameter("num.of.vdisks", new Integer(n3));
        gUIRequestData.addParameter("system.ports", (Serializable)stringArray3);
        gUIRequestData.addParameter("host.ports", (Serializable)stringArray4);
        gUIRequestData.addParameter("host.type", new Integer(n4));
        gUIRequestData.addParameter("host.type_desc", (Serializable)((Object)string2));
        gUIRequestData.addParameter("host.names", (Serializable)stringArray5);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void unassignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2) {
        this.unassignPorts(guiRequestor, stringArray, stringArray2, true);
    }

    public void unassignPorts(GuiRequestor guiRequestor, String[] stringArray, String[] stringArray2, boolean bl) {
        GUIRequestData gUIRequestData = new GUIRequestData(5);
        gUIRequestData.setWillWaitForComplete(bl);
        gUIRequestData.addParameter("volume.ids", (Serializable)stringArray);
        gUIRequestData.addParameter("host.ports", (Serializable)stringArray2);
        DiskDataController.sendDiskSubsystemJobRequest(guiRequestor, gUIRequestData);
    }

    public void createZone(GuiRequestor guiRequestor, String string, String string2, String string3, String[] stringArray) {
        GUIRequestData gUIRequestData = new GUIRequestData(30);
        gUIRequestData.addParameter("fabric.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("zoneset.name", (Serializable)((Object)string2));
        gUIRequestData.addParameter("zone.name", (Serializable)((Object)string3));
        gUIRequestData.addParameter("ports", (Serializable)stringArray);
        DiskDataController.sendDiskFabricJobRequest(guiRequestor, gUIRequestData);
    }

    public void updateZone(GuiRequestor guiRequestor, String string, String string2, String string3, String[] stringArray) {
        GUIRequestData gUIRequestData = new GUIRequestData(31);
        gUIRequestData.addParameter("fabric.id", (Serializable)((Object)string));
        gUIRequestData.addParameter("zoneset.name", (Serializable)((Object)string2));
        gUIRequestData.addParameter("zone.name", (Serializable)((Object)string3));
        gUIRequestData.addParameter("ports", (Serializable)stringArray);
        DiskDataController.sendDiskFabricJobRequest(guiRequestor, gUIRequestData);
    }

    public void releaseFabric(GuiRequestor guiRequestor, String string) {
        GUIRequestData gUIRequestData = new GUIRequestData(32);
        gUIRequestData.addParameter("fabric.id", (Serializable)((Object)string));
        DataAccessor.sendDeviceRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler", DeviceRequest.DR_DISK, gUIRequestData);
    }

    public void rollbackFabricTransaction(GuiRequestor guiRequestor, String string) {
        GUIRequestData gUIRequestData = new GUIRequestData(33);
        gUIRequestData.addParameter("fabric.id", (Serializable)((Object)string));
        DataAccessor.sendDeviceRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler", DeviceRequest.DR_DISK, gUIRequestData);
    }

    public static void test() {
        DiskDataController diskDataController = DiskDataController.getInstance();
        diskDataController.createVolumes(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                int n;
                Response response2;
                if (s <= 4 && (response2 = GuiDeviceJob.getJobStatus(n = ((Integer)response.responseData).intValue(), true)) != null) {
                    AsyncResult asyncResult = (AsyncResult)response2.responseData;
                    AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
                    int n2 = 0;
                    while (n2 < asyncResultArray.length) {
                        VolumeID[] cfr_ignored_0 = (VolumeID[])asyncResultArray[n2].getResults();
                        ++n2;
                    }
                }
            }
        }, 10000000L, "poolAlpha", 5L, null);
    }
}

