/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.common.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.objects.Runs;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.logging.TraceLogger;

public abstract class DiskDbAccessor {
    public static HashMap[] getStorageSubsystemCapabilities(String[] stringArray, String[] stringArray2, LogTraceHelper logTraceHelper) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getStorageSubsystemCapabilities", stringArray[0]);
        }
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            Object[] objectArray = CIMOMSelectorDbHelper.Subsystem.getCimomInformation(n2);
            if (objectArray != null && objectArray.length > 0) {
                Arrays.sort(objectArray);
                int n3 = CIMOMSelectorDbHelper.Subsystem.getCorrespondingCapabilityDataId(((CIMOMSelectorDbHelper.CIMOMInformation)objectArray[0]).getNamespaceId(), n2);
                CapabilityData capabilityData = CIMOMSelectorDbHelper.getCapabilityData(n3);
                hashMapArray[n] = DiskReportingHelper.getAttributes(capabilityData, stringArray2, logTraceHelper);
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getStorageSubsystemCapabilities", hashMapArray);
        }
        return hashMapArray;
    }

    public static HashMap[] getMDisksByMDiskGroup(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getMDisksByMDiskGroup", string);
        }
        String string2 = "select * FROM T_RES_STORAGE_EXTENT where  POOL_ID = " + string + " AND MODE <> 0 ";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    private static Hashtable getMDisksWhereClause(String string, LogTraceHelper logTraceHelper) {
        Class<?> clazz;
        Class<?> clazz2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz3.getName(), "getMDisksWhereClause", string);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        try {
            clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz2, "POOL_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        int n = 2;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo2 = DiskReportingHelper.getColumnInfo(clazz, "MODE", logTraceHelper);
        hashtable.put(columnInfo2, String.valueOf(n));
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz4.getName(), "getMDisksWhereClause", hashtable);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap[] getMDisksBySVC(String string, int n, String[] stringArray, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getMDisksBySVC", String.valueOf(string) + ", " + n);
        }
        Hashtable hashtable = DiskDbAccessor.getMDisksBySVCWhereClause(string, n, logTraceHelper);
        StorageExtent.StorageExtentCursor storageExtentCursor = null;
        Vector<HashMap> vector = new Vector<HashMap>();
        try {
            storageExtentCursor = StorageExtent.getCursor(dBConnection, hashtable, null);
            while (storageExtentCursor.next()) {
                StorageExtent storageExtent = storageExtentCursor.getAttributes();
                HashMap hashMap = DiskReportingHelper.getAttributes(storageExtent, stringArray, logTraceHelper);
                vector.add(hashMap);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (storageExtentCursor != null) {
                    storageExtentCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (Exception exception) {}
        if (storageExtentCursor != null) {
            storageExtentCursor.close();
        }
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getMDisksBySVC", vector);
        }
        return vector.toArray(new HashMap[0]);
    }

    private static Hashtable getMDisksBySVCWhereClause(String string, int n, LogTraceHelper logTraceHelper) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "getMDisksBySVCWhereClause", String.valueOf(string) + "," + n);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, "SUBSYSTEM_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        if (n != -1) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ColumnInfo columnInfo2 = DiskReportingHelper.getColumnInfo(clazz3, "MODE", logTraceHelper);
            hashtable.put(columnInfo2, String.valueOf(n));
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz4.getName(), "getMDisksBySVCWhereClause", hashtable);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap[] getIOGroupsBySVC(String string, String[] stringArray, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getIOGroupsBySVC", string);
        }
        Hashtable hashtable = DiskDbAccessor.getIOGroupsWhereClause(string, logTraceHelper);
        IoGroup.IoGroupCursor ioGroupCursor = null;
        Vector<HashMap> vector = new Vector<HashMap>();
        try {
            ioGroupCursor = IoGroup.getCursor(dBConnection, hashtable, null);
            while (ioGroupCursor.next()) {
                IoGroup ioGroup = ioGroupCursor.getAttributes();
                HashMap hashMap = DiskReportingHelper.getAttributes(ioGroup, stringArray, logTraceHelper);
                vector.add(hashMap);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (ioGroupCursor != null) {
                    ioGroupCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (Exception exception) {}
        if (ioGroupCursor != null) {
            ioGroupCursor.close();
        }
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getIOGroupsBySVC", vector);
        }
        return vector.toArray(new HashMap[0]);
    }

    private static Hashtable getIOGroupsWhereClause(String string, LogTraceHelper logTraceHelper) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "getIOGroupsWhereClause", string);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, "SUBSYSTEM_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz3.getName(), "getIOGroupsWhereClause", hashtable);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getVDiskIdsForByIOGroup(String string, String string2, HashMap hashMap, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException, InvalidParameterException, MissingParameterException, IDParseException {
        String[] stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getVDiskIdsForByIOGroup", String.valueOf(string) + ", " + string2);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Hashtable hashtable = DiskDbAccessor.getVDiskByIOGroupWhereClause(string2, logTraceHelper);
        StorageVolume.StorageVolumeCursor storageVolumeCursor = null;
        try {
            storageVolumeCursor = StorageVolume.getCursor(dBConnection, hashtable, null);
            while (storageVolumeCursor.next()) {
                stringArray = storageVolumeCursor.getAttributes();
                linkedList.add(ExternalKeyConverter.getStorageVolumeKey((StorageVolume)stringArray, string, logTraceHelper));
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (storageVolumeCursor != null) {
                    storageVolumeCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (Exception exception) {}
        if (storageVolumeCursor != null) {
            storageVolumeCursor.close();
        }
        dBConnection.commit();
        stringArray = new String[]{};
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getVDiskIdsForByIOGroup", linkedList);
        }
        return linkedList.toArray(stringArray);
    }

    private static Hashtable getVDiskByIOGroupWhereClause(String string, LogTraceHelper logTraceHelper) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "getVDiskByIOGroupWhereClause", string);
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, "IO_GROUP_ID", logTraceHelper);
        hashtable.put(columnInfo, string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz3.getName(), "getVDiskByIOGroupWhereClause", hashtable);
        }
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int updateSubsystemAttributes(String string, Hashtable hashtable, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "updateSubsystemAttributes", string);
        }
        Hashtable hashtable2 = ExternalKeyConverter.getStorageSubsystemWhereClause(string, logTraceHelper);
        Hashtable hashtable3 = new Hashtable();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashtable3.put(TResStorageSubsystemTable.getColumnInfo(string2), hashtable.get(string2));
        }
        try {
            n = StorageSubsystem.update(dBConnection, hashtable3, hashtable2);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            dBConnection.commit();
            throw throwable;
        }
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "updateSubsystemAttributes", n);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int updateVolumeAttributes(String string, Hashtable hashtable, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "updateVolumeAttributes", string);
        }
        Hashtable hashtable2 = ExternalKeyConverter.getVolumeWhereclause(logTraceHelper, string, dBConnection);
        Hashtable hashtable3 = new Hashtable();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashtable3.put(TResStorageVolumeTable.getColumnInfo(string2), hashtable.get(string2));
        }
        try {
            n = StorageVolume.update(dBConnection, hashtable3, hashtable2);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            dBConnection.commit();
            throw throwable;
        }
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "updateVolumeAttributes", n);
        }
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNumberOfJobs(int n, int n2, LogTraceHelper logTraceHelper, DBConnection dBConnection) throws ServerException, SQLException {
        Class<?> clazz;
        Class<?> clazz2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz3.getName(), "getNumberOfJobs", n + ", " + n2);
        }
        int n3 = 0;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        try {
            clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TRunsTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz2, "SCHEDULE_ID", logTraceHelper);
        hashtable.put(columnInfo, String.valueOf(n));
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.tables.TRunsTable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ColumnInfo columnInfo2 = DiskReportingHelper.getColumnInfo(clazz, "STATUS", logTraceHelper);
        hashtable.put(columnInfo2, String.valueOf(n2));
        Runs.RunsCursor runsCursor = null;
        try {
            runsCursor = Runs.getCursor(dBConnection, hashtable, null);
            while (runsCursor.next()) {
                Runs runs = runsCursor.getAttributes();
                n3 += runs.getNumberJobs();
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (runsCursor != null) {
                    runsCursor.close();
                }
            }
            catch (Exception exception) {}
            dBConnection.commit();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        try {}
        catch (Exception exception) {}
        if (runsCursor != null) {
            runsCursor.close();
        }
        dBConnection.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz4.getName(), "getNumberOfJobs", n3);
        }
        return n3;
    }

    public static HashMap[] getVolumeNamesForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getVolumeNamesForSubsystem", string);
        }
        String string2 = "select DISPLAY_NAME from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = " + string;
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getPort2HostMapping(String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string = "select distinct PORT.NAME AS PORT_WWN, H2P.HOST_URL from   T_VIEW_HOST2PORT H2P, T_RES_PORT PORT where  PORT.PORT_ID = H2P.PORT_ID and HOST_URL is not NULL";
        return DiskDbAccessor.executeQuery(string, stringArray, dBConnection);
    }

    public static HashMap[] getPortsForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getPortsForSubsystem", string);
        }
        String string2 = "select distinct PORT.PORT_ID, PORT.NAME as PORT_WWN, PORT2FABRIC.FABRIC_WWN,  CAST (null as varchar(255)) HOST_URL, CAST (null as varchar(255)) SUBSYSTEM_DISPLAY_TYPE,  PORT.TYPE  from T_RES_PORT PORT LEFT JOIN T_VIEW_ALL_PORTS PORT2FABRIC on PORT.NAME = PORT2FABRIC.PORT_WWN  where PORT.SUBSYSTEM_ID = " + string;
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getHostPortsInFabricForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getHostPortsForSubsystem", string);
        }
        String string2 = "select distinct TVAP.PORT_WWN, TVAP.FABRIC_WWN, TVAP.HOST_URL, PORT.TYPE, TVAP.SUBSYSTEM_DISPLAY_TYPE  from T_VIEW_ALL_PORTS  TVAP , T_RES_PORT PORT where TVAP.FABRIC_WWN in (select distinct FABRIC_WWN from T_VIEW_ALL_PORTS TVAP2 where TVAP2.SUBSYSTEM_ID = " + string + ") " + " and (TVAP.SUBSYSTEM_ID IS NULL or (TVAP.SUBSYSTEM_TYPE = 'SVC' and TVAP.SUBSYSTEM_ID <> " + string + ")) " + " and TVAP.PORT_WWN = PORT.NAME";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getDefinedHostPortsForSubsystem(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getHostPortsForSubsystem", string);
        }
        String string2 = "select distinct PORT.NAME as PORT_WWN, CAST (null as char(16)) FABRIC_WWN, HOST2PORT.HOST_URL as HOST_URL,  CAST (null as varchar(255)) SUBSYSTEM_DISPLAY_TYPE,  PORT.TYPE as TYPE  from  T_RES_PORT PORT, T_VIEW_HOST2PORT HOST2PORT left outer join T_VIEW_HOSTPORT2FABRIC HOSTPORT2FABRIC on HOST2PORT.PORT_ID = HOSTPORT2FABRIC.PORT_ID where PORT.PORT_ID = HOST2PORT.PORT_ID and HOSTPORT2FABRIC.PORT_ID is null";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getMDiskInfoForVDisk(String string, String string2, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string3 = "select T_RES_STORAGE_EXTENT.STORAGE_EXTENT_ID, T_RES_STORAGE_EXTENT.DEVICE_ID, T_RES_STORAGE_EXTENT.NAME, T_RES_STORAGE_EXTENT.ELEMENT_NAME, T_RES_STORAGE_EXTENT.TOTAL_CAPACITY, T_RES_STORAGE_EXTENT.FREE_SPACE, T_RES_STORAGE_EXTENT.BLOCK_SIZE, T_RES_STORAGE_EXTENT.NUM_OF_BLOCKS, T_RES_STORAGE_EXTENT.CONSUMABLE_BLOCKS, T_RES_STORAGE_EXTENT.POOL_ID, T_RES_STORAGE_EXTENT.NATIVE_STATUS, T_RES_STORAGE_EXTENT.SUBSYSTEM_ID,  T_RES_STORAGE_EXTENT.MODE from T_RES_STORAGE_EXTENT AS T_RES_STORAGE_EXTENT, T_RES_STORAGE_VOLUME AS T_RES_STORAGE_VOLUME, T_RES_VOLUME2EXTENT AS T_RES_VOLUME2EXTENT where T_RES_STORAGE_VOLUME.NAME = '" + string + "' " + "and T_RES_STORAGE_VOLUME.SUBSYSTEM_ID = " + string2 + " " + "and T_RES_STORAGE_EXTENT.STORAGE_EXTENT_ID = T_RES_VOLUME2EXTENT.STORAGE_EXTENT_ID AND T_RES_VOLUME2EXTENT.VOLUME_ID = T_RES_STORAGE_VOLUME.SVID";
        return DiskDbAccessor.executeQuery(string3, stringArray, dBConnection);
    }

    public static HashMap[] getTypeForPortFromClientSetting(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string2 = "SELECT DISTINCT T_RES_CLIENT_SETTING_DATA.CLIENT_TYPES, T_RES_CLIENT_SETTING_DATA.ELEMENT_NAME, T_RES_CLIENT_SETTING_DATA.CLIENT_TYPE_DESCRIPTIONS from T_RES_PORT AS T_RES_PORT, T_RES_DATA_PATH AS T_RES_DATA_PATH, T_RES_MASKING_INFO AS T_RES_MASKING_INFO, T_RES_CLIENT_SETTING_DATA AS T_RES_CLIENT_SETTING_DATA where T_RES_CLIENT_SETTING_DATA.SETTING_DATA_ID = T_RES_MASKING_INFO.SETTING_DATA_ID and T_RES_MASKING_INFO.MASKING_INFO_ID = T_RES_DATA_PATH.MASKING_INFO_ID and T_RES_DATA_PATH.INITIATOR_PORT_ID = T_RES_PORT.PORT_ID and T_RES_PORT.NAME = '" + string + "'";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    public static HashMap[] getTypeForPortFromHost(String string, String[] stringArray, DBConnection dBConnection) throws ServerException, SQLException {
        String string2 = "SELECT DISTINCT T_RES_HOST.HOST_URL, T_RES_HOST.OS_TYPE from T_RES_HOST AS T_RES_HOST where T_RES_HOST.HOST_URL = '" + string + "'";
        return DiskDbAccessor.executeQuery(string2, stringArray, dBConnection);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap[] executeQuery(String var0, String[] var1_1, DBConnection var2_2) throws ServerException, SQLException {
        block30: {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry(v0.getName(), "executeQuery", var0);
            }
            var3_3 = new Vector<HashMap[]>();
            var4_4 = null;
            try {
                block27: {
                    try {
                        var4_4 = ComplexQuery.sqlQuery(var2_2, var0, null);
                        block19: while (var4_4.next()) {
                            var5_5 = new HashMap();
                            var6_7 = 0;
                            while (true) {
                                if (var6_7 >= var1_1.length) {
                                    var3_3.add(var5_5);
                                    continue block19;
                                }
                                var7_8 = var1_1[var6_7];
                                var5_5.put(var7_8, var4_4.getObject(var7_8));
                                ++var6_7;
                            }
                        }
                    }
                    catch (Exception var5_6) {
                        var2_2.rollback();
                        if (!TraceLogger.enableTrace) break block27;
                        try {
                            v2 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                        TraceLogger.exception(v2.getName(), "executeQuery", var5_6);
                    }
                }
                var8_11 = null;
            }
            catch (Throwable var9_9) {
                block28: {
                    var8_10 = null;
                    try {
                        if (var4_4 != null) {
                            var4_4.getStatement().close();
                        }
                    }
                    catch (Exception var10_12) {
                        if (!TraceLogger.enableTrace) break block28;
                        try {
                            v4 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
                        }
                        catch (ClassNotFoundException v5) {
                            throw new NoClassDefFoundError(v5.getMessage());
                        }
                        TraceLogger.exception(v4.getName(), "executeQuery", var10_12);
                    }
                }
                var2_2.commit();
                throw var9_9;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 178->194)] { 
lbl60:
            // 1 sources

            if (var4_4 != null) {
                var4_4.getStatement().close();
            }
            break block30;
lbl63:
            // 1 sources

            catch (Exception var10_13) {
                if (!TraceLogger.enableTrace) break block30;
                try {}
                catch (ClassNotFoundException v6) {
                    throw new NoClassDefFoundError(v6.getMessage());
                }
                TraceLogger.exception(Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor").getName(), "executeQuery", var10_13);
            }
        }
        var2_2.commit();
        var5_5 = var3_3.toArray(new HashMap[0]);
        if (TraceLogger.enableTrace) {
            try {
                v7 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException v8) {
                throw new NoClassDefFoundError(v8.getMessage());
            }
            TraceLogger.exit(v7.getName(), "executeQuery", var3_3);
        }
        if (TraceLogger.enableTrace) {
            try {
                v9 = Class.forName("org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor");
            }
            catch (ClassNotFoundException v10) {
                throw new NoClassDefFoundError(v10.getMessage());
            }
            TraceLogger.exit(v9.getName(), "executeQuery", var5_5);
        }
        return var5_5;
    }
}

