/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.volume.VDiskDDI;
import org.eclipse.aperi.request.Response;

public class VDiskDetailsPanel
extends JPanel
implements ActionListener {
    private VDiskDDI theVdDDI;
    private HashMap hmapMDofVD;
    private Vector mdisksForVDisk = new Vector();
    private GUIVDisk vdisk;
    private JLabel lbVdisk;
    private JLabel lbVdiskName;
    private JLabel lbIOGroupID;
    private JLabel lbIOGroupName;
    private JLabel lbStatus;
    private JLabel lbMDiskGroupID;
    private JLabel lbMDiskGroupName;
    private JLabel lbCapacity;
    private JLabel lbType;
    private JLabel lbFormatted;
    private JLabel lbMDiskID;
    private JLabel lbMDiskName;
    private JLabel lbFlashCopyID;
    private JLabel lbFlashCopyName;
    private JLabel lbMMID;
    private JLabel lbMMName;
    private JLabel lbIOTH;
    private JLabel lbPrefNode;
    private JLabel lbMapped;
    private JLabel lbFastWrite;
    private JLabel lbUID;
    private JPanel propPanel = new JPanel();
    private String mdiskids;
    private String mdiskNames;
    Vector portvec = new Vector();

    public VDiskDetailsPanel(VDiskDDI vDiskDDI, GUIVDisk gUIVDisk) {
        this.theVdDDI = vDiskDDI;
        this.vdisk = gUIVDisk;
        this.getMDisksForVDisk(gUIVDisk.getName());
    }

    public JComponent getComponent() {
        this.setLayout(new FlowLayout(0));
        this.propPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_VDISK_ID_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.lbVdisk = new JLabel();
        this.lbVdisk.setText(GUIEntityUtil.getDisplayText(this.vdisk.getName()));
        this.propPanel.add((Component)this.lbVdisk, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_NAME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.lbVdiskName = new JLabel();
        this.lbVdiskName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getDeviceId()));
        this.propPanel.add((Component)this.lbVdiskName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_IOGROUPID_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.lbIOGroupID = new JLabel();
        this.lbIOGroupID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getIoGrpId()));
        this.propPanel.add((Component)this.lbIOGroupID, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_IOGROUPNAME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.lbIOGroupName = new JLabel();
        this.lbIOGroupName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getIoGroupName()));
        this.propPanel.add((Component)this.lbIOGroupName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_STATUS_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.lbStatus = new JLabel();
        if (this.vdisk.getNativeStatus() == 1) {
            this.lbStatus.setText(Util.getString("DISK_ONLINE_LABEL"));
        } else if (this.vdisk.getNativeStatus() == 0) {
            this.lbStatus.setText(Util.getString("DISK_OFFLINE_LABEL"));
        } else if (this.vdisk.getNativeStatus() == 2) {
            this.lbStatus.setText(Util.getString("DISK_DEGRADED_LABEL"));
        } else {
            this.lbStatus.setText(Util.getString("DISK_NA_LABEL"));
        }
        this.propPanel.add((Component)this.lbStatus, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MDISKGROUPNAME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.lbMDiskGroupName = new JLabel();
        this.lbMDiskGroupName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getStoragePoolName()));
        this.propPanel.add((Component)this.lbMDiskGroupName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_CAPACITY_LABEL_MB")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.lbCapacity = new JLabel();
        double d = GUIEntityUtil.convertStorageCapacity(this.vdisk.getCapacity(), 0, 2, 10);
        this.lbCapacity.setText(GUIEntityUtil.getNumberString(new Double(d), 2, Locale.getDefault()));
        this.propPanel.add((Component)this.lbCapacity, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_TYPE_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.lbType = new JLabel();
        if (this.vdisk.getType() == 0) {
            this.lbType.setText(Util.getString("DISK_SEQUENTIAL_LABEL"));
        } else if (this.vdisk.getType() == 1) {
            this.lbType.setText(Util.getString("DISK_STRIPED_LABEL"));
        } else if (this.vdisk.getType() == 3) {
            this.lbType.setText(Util.getString("DISK_IMAGE_LABEL"));
        } else {
            this.lbType.setText(Util.getString("DISK_NA_LABEL"));
        }
        this.propPanel.add((Component)this.lbType, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FORMATTED_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.lbFormatted = new JLabel();
        if (this.vdisk.isFormatted()) {
            this.lbFormatted.setText(Util.getString("DISK_YES_LABEL"));
        } else {
            this.lbFormatted.setText(Util.getString("DISK_NO_LABEL"));
        }
        this.propPanel.add((Component)this.lbFormatted, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MDISKID_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.lbMDiskID = new JLabel();
        this.propPanel.add((Component)this.lbMDiskID, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MDISKNAME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.lbMDiskName = new JLabel();
        this.propPanel.add((Component)this.lbMDiskName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FLASHCOPYID_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        this.lbFlashCopyID = new JLabel();
        this.lbFlashCopyID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getFlashCopyId()));
        this.propPanel.add((Component)this.lbFlashCopyID, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FLASHCOPYNAME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        this.lbFlashCopyName = new JLabel();
        this.lbFlashCopyName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getFlashCopyName()));
        this.propPanel.add((Component)this.lbFlashCopyName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_METROMIRRORID_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        this.lbMMID = new JLabel();
        this.lbMMID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getMetroMirrorId()));
        this.propPanel.add((Component)this.lbMMID, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_METROMIRRORNAME_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        this.lbMMName = new JLabel();
        this.lbMMName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getMetroMirrorName()));
        this.propPanel.add((Component)this.lbMMName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_IOTHROTTLING_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        this.lbIOTH = new JLabel();
        this.lbIOTH.setText(String.valueOf(this.vdisk.getIoThrottling()));
        this.propPanel.add((Component)this.lbIOTH, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_PREFNODE_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        this.lbPrefNode = new JLabel();
        this.lbPrefNode.setText(GUIEntityUtil.getDisplayText(this.vdisk.getPreferredNodeForIO()));
        this.propPanel.add((Component)this.lbPrefNode, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MAPPEDTOAHOST_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        this.lbMapped = new JLabel();
        if (this.vdisk.isAssigned()) {
            this.lbMapped.setText(Util.getString("DISK_YES_LABEL"));
        } else {
            this.lbMapped.setText(Util.getString("DISK_NO_LABEL"));
        }
        this.propPanel.add((Component)this.lbMapped, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FASTWRITE_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        this.lbFastWrite = new JLabel();
        if (this.vdisk.getFastWriteState() == 0) {
            this.lbFastWrite.setText(Util.getString("DISK_FASTWRITE_STATE_EMPTY"));
        } else if (this.vdisk.getFastWriteState() == 1) {
            this.lbFastWrite.setText(Util.getString("DISK_FASTWRITE_STATE_NOTEMPTY"));
        } else if (this.vdisk.getFastWriteState() == 2) {
            this.lbFastWrite.setText(Util.getString("DISK_FASTWRITE_STATE_CORRUPT"));
        }
        this.propPanel.add((Component)this.lbFastWrite, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_UID_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        this.lbUID = new JLabel();
        this.lbUID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getUid()));
        this.propPanel.add((Component)this.lbUID, gridBagConstraints);
        this.add((Component)this.propPanel, "Before");
        return this;
    }

    public void getMDisksForVDisk(String string) {
        DiskDataAccessor diskDataAccessor = DiskDataAccessor.getInstance();
        diskDataAccessor.getMDisksForVDisk(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    GUIMDisk gUIMDisk = null;
                    VDiskDetailsPanel.this.mdiskids = new String();
                    VDiskDetailsPanel.this.mdiskNames = new String();
                    VDiskDetailsPanel.this.hmapMDofVD = (HashMap)response.responseData;
                    String string = new String();
                    int n = -1;
                    VDiskDetailsPanel.this.mdisksForVDisk.removeAllElements();
                    if (VDiskDetailsPanel.this.hmapMDofVD != null) {
                        VDiskDetailsPanel.this.mdisksForVDisk = new Vector(VDiskDetailsPanel.this.hmapMDofVD.values());
                        int n2 = VDiskDetailsPanel.this.mdisksForVDisk.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            gUIMDisk = (GUIMDisk)VDiskDetailsPanel.this.mdisksForVDisk.get(n3);
                            string = gUIMDisk.getId();
                            n = string.indexOf(43);
                            string = string.substring(0, n);
                            VDiskDetailsPanel vDiskDetailsPanel = VDiskDetailsPanel.this;
                            vDiskDetailsPanel.mdiskids = String.valueOf(vDiskDetailsPanel.mdiskids) + string;
                            VDiskDetailsPanel vDiskDetailsPanel2 = VDiskDetailsPanel.this;
                            vDiskDetailsPanel2.mdiskNames = String.valueOf(vDiskDetailsPanel2.mdiskNames) + gUIMDisk.getName();
                            if (n3 + 1 < n2) {
                                VDiskDetailsPanel vDiskDetailsPanel3 = VDiskDetailsPanel.this;
                                vDiskDetailsPanel3.mdiskids = String.valueOf(vDiskDetailsPanel3.mdiskids) + ",";
                                VDiskDetailsPanel vDiskDetailsPanel4 = VDiskDetailsPanel.this;
                                vDiskDetailsPanel4.mdiskNames = String.valueOf(vDiskDetailsPanel4.mdiskNames) + ",";
                            }
                            ++n3;
                        }
                        VDiskDetailsPanel.this.lbMDiskID.setText(GUIEntityUtil.getDisplayText(VDiskDetailsPanel.this.mdiskids));
                        VDiskDetailsPanel.this.lbMDiskName.setText(GUIEntityUtil.getDisplayText(VDiskDetailsPanel.this.mdiskNames));
                    }
                }
            }
        }, this.theVdDDI.subsystem.getId(), string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

