/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.TableCapacityRenderer;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentWizard;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.gui.disk.volume.VolumeTableModel;
import org.eclipse.aperi.request.Response;

public class VolumeListPanel
extends JPanel
implements ActionListener,
TJCTableMouseInterface {
    private JTextField volume_id;
    private JLabel lbmsg;
    private JLabel lbview;
    private JRadioButton radioButArray;
    private JRadioButton radioButHost;
    private String str_poolradio;
    private JComboBox cbvolume;
    private JComboBox cbhost;
    private JButton buttoncreate;
    private JButton buttondelete;
    private JButton buttonHPA;
    private JButton buttonGOa;
    private JButton buttonGOh;
    private JLabel label;
    private ButtonGroup group = new ButtonGroup();
    public VolumeDDI theVolDDI;
    private GUIVolume vol;
    private DiskGuiTable table;
    private VolumeTableModel tableModel;
    private JPanel mainpanel = new JPanel();
    private JPanel filterpanel = new JPanel();
    private boolean dblClick = false;
    private HashMap hmapArrofSS;
    private GUIStoragePool[] arrpool;
    private HashMap hmapHostPortofSS;
    private static final String ACTION_VIEW_DETAILS = Util.getString("DISK_VIEW_DETAILS_LABEL");
    private GridBagConstraints con = new GridBagConstraints();
    private int filtermode = 3;
    private String filtername = "NONE";
    private String strHPnameBr = "( ";
    private String endHPnameBr = " )";
    private String noselect = Util.getString("DISK_COMMON_NO_SELECTION");
    private int width = 0;
    private int height = 0;
    private boolean hostplistavailable = false;
    private static TableCellRenderer capacityRenderer = new TableCapacityRenderer();
    private JDialog wizardDialog = null;
    private CreateVolumeWizard crvol = null;
    private PortAssignmentWizard HPAwiz = null;
    private JPanel tablePanel = GuiUtil.getPanel();
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (VolumeListPanel.this.radioButArray.isSelected()) {
                VolumeListPanel.this.cbvolume.setEnabled(true);
                VolumeListPanel.this.cbhost.setEnabled(false);
                VolumeListPanel.this.buttonGOa.setEnabled(true);
                VolumeListPanel.this.buttonGOh.setEnabled(false);
            } else if (VolumeListPanel.this.radioButHost.isSelected()) {
                if (!VolumeListPanel.this.hostplistavailable) {
                    VolumeListPanel.this.theVolDDI.diskAccessor.getAssignedHostPortsBySubsystem(new GuiRequestor(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleResponse(short s, Response response) {
                            if (s <= 4) {
                                VolumeListPanel.access$7(1.access$0(this.this$1), (HashMap)response.responseData);
                                Collection<V> collection = VolumeListPanel.access$8(1.access$0(this.this$1)).values();
                                VolumeListPanel.access$2(1.access$0(this.this$1)).addItem(VolumeListPanel.access$9(1.access$0(this.this$1)));
                                ArrayList<String> arrayList = new ArrayList<String>();
                                Iterator<V> iterator = collection.iterator();
                                while (iterator.hasNext()) {
                                    GUIPort gUIPort = (GUIPort)iterator.next();
                                    String string = gUIPort.getWwpn();
                                    String string2 = gUIPort.getHostName();
                                    if (string == null || string.equals("null")) continue;
                                    if (string2 != null && string2.trim().length() > 0) {
                                        string = String.valueOf(string) + VolumeListPanel.access$10(1.access$0(this.this$1)) + string2 + VolumeListPanel.access$11(1.access$0(this.this$1));
                                    }
                                    arrayList.add(string);
                                }
                                Collections.sort(arrayList);
                                int n = 0;
                                while (n < arrayList.size()) {
                                    VolumeListPanel.access$2(1.access$0(this.this$1)).addItem(arrayList.get(n));
                                    ++n;
                                }
                            }
                        }
                    }, VolumeListPanel.this.theVolDDI.subsystem.getId());
                }
                VolumeListPanel.this.hostplistavailable = true;
                VolumeListPanel.this.cbhost.setEnabled(true);
                VolumeListPanel.this.buttonGOh.setEnabled(true);
                VolumeListPanel.this.cbvolume.setEnabled(false);
                VolumeListPanel.this.buttonGOa.setEnabled(false);
            }
        }

        static /* synthetic */ VolumeListPanel access$0(1 var0) {
            return var0.VolumeListPanel.this;
        }
    };
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    Component bottomHalf = null;

    public VolumeListPanel(VolumeDDI volumeDDI) {
        this.theVolDDI = volumeDDI;
        this.table = new DiskGuiTable();
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.mainpanel.setLayout(new BorderLayout());
        this.buttoncreate = new JButton(Util.getString("DISK_CREATE_BUTTON"));
        this.buttoncreate.addActionListener(this);
        GuiUtil.setAccessible(this.buttoncreate, this.buttoncreate.getText(), this.buttoncreate.getText());
        this.buttonHPA = new JButton(Util.getString("DISK_HPA_BUTTON"));
        this.buttonHPA.addActionListener(this);
        GuiUtil.setAccessible(this.buttonHPA, this.buttonHPA.getText(), this.buttonHPA.getText());
        this.buttondelete = new JButton(Util.getString("DISK_DELETE_BUTTON"));
        this.buttondelete.addActionListener(this);
        GuiUtil.setAccessible(this.buttondelete, this.buttondelete.getText(), this.buttondelete.getText());
        this.buttondelete.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.buttoncreate);
        jPanel.add(this.buttonHPA);
        jPanel.add(this.buttondelete);
        this.filterpanel.setLayout(new GridBagLayout());
        this.con.anchor = 17;
        this.con.insets = new Insets(3, 3, 3, 3);
        this.theVolDDI.diskAccessor.areVolumeActionsInProgress(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    boolean bl = (Boolean)response.responseData;
                    if (bl) {
                        VolumeListPanel.this.lbmsg.setText(Util.getString("DISK_VOLUME_PROGRESS_LABEL"));
                    } else {
                        VolumeListPanel.this.lbmsg.setText("");
                    }
                }
            }
        }, Integer.toString(this.theVolDDI.subsystem.getInternalId()));
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 4;
        this.lbmsg = new JLabel("");
        this.lbmsg.setForeground(Color.red);
        this.filterpanel.add((Component)this.lbmsg, this.con);
        this.con.insets = new Insets(3, 3, 3, 0);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.lbview = new JLabel(Util.getString("DISK_VOLVW_LABEL"));
        this.filterpanel.add((Component)this.lbview, this.con);
        this.con.gridx = 0;
        this.con.gridy = 2;
        this.con.gridwidth = 1;
        this.str_poolradio = this.theVolDDI.subsystem.getType() == 2 || this.theVolDDI.subsystem.getType() == 3 ? Util.getString("DISK_FILTER_POOL_LABEL") : Util.getString("DISK_FILTER_ARRAY_LABEL");
        this.radioButArray = new JRadioButton(this.str_poolradio, true);
        this.radioButArray.addMouseListener(this.mouseListener);
        GuiUtil.setAccessible(this.radioButArray, this.radioButArray.getText(), this.radioButArray.getText());
        this.filterpanel.add((Component)this.radioButArray, this.con);
        this.group.add(this.radioButArray);
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.gridwidth = 1;
        this.cbvolume = new JComboBox();
        this.cbvolume.setEnabled(true);
        GuiUtil.setAccessible(this.cbvolume, this.radioButArray.getText(), this.radioButArray.getText());
        this.width = 50 * this.cbvolume.getFontMetrics(this.getFont()).charWidth(0) + 15;
        this.height = this.cbvolume.getFontMetrics(this.getFont()).getHeight() + 5;
        this.cbvolume.setMinimumSize(new Dimension(this.width, this.height));
        this.cbvolume.setPreferredSize(new Dimension(this.width, this.height));
        this.cbvolume.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.filterpanel.add((Component)this.cbvolume, this.con);
        this.theVolDDI.diskAccessor.getStoragePoolsBySubsytstem(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    VolumeListPanel.this.hmapArrofSS = (HashMap)response.responseData;
                    Collection collection = VolumeListPanel.this.hmapArrofSS.values();
                    VolumeListPanel.this.arrpool = new GUIStoragePool[collection.size()];
                    VolumeListPanel.this.arrpool = collection.toArray(VolumeListPanel.this.arrpool);
                    VolumeListPanel.this.cbvolume.addItem(VolumeListPanel.this.noselect);
                    boolean bl = false;
                    while (!bl) {
                        bl = true;
                        int n = 0;
                        while (n < VolumeListPanel.this.arrpool.length - 1) {
                            if (VolumeListPanel.this.arrpool[n].getDeviceId().compareTo(VolumeListPanel.this.arrpool[n + 1].getDeviceId()) > 0) {
                                GUIStoragePool gUIStoragePool = VolumeListPanel.this.arrpool[n];
                                ((VolumeListPanel)VolumeListPanel.this).arrpool[n] = VolumeListPanel.this.arrpool[n + 1];
                                ((VolumeListPanel)VolumeListPanel.this).arrpool[n + 1] = gUIStoragePool;
                                bl = false;
                            }
                            ++n;
                        }
                    }
                    Vector<String> vector = new Vector<String>();
                    int n = 0;
                    while (n < VolumeListPanel.this.arrpool.length) {
                        String string = VolumeListPanel.this.arrpool[n].getDeviceId();
                        if (vector.contains(string) || string.length() == 0) {
                            string = String.valueOf(string) + " (" + VolumeListPanel.this.arrpool[n].getInstanceId() + ")";
                        }
                        vector.add(string);
                        VolumeListPanel.this.cbvolume.addItem(string);
                        ++n;
                    }
                }
            }
        }, this.theVolDDI.subsystem.getId());
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.gridwidth = 1;
        this.buttonGOa = new JButton(Util.getString("DISK_GO_BUTTON"));
        this.buttonGOa.addActionListener(this);
        GuiUtil.setAccessible(this.buttonGOa, this.buttonGOa.getText(), this.buttonGOa.getText());
        this.filterpanel.add((Component)this.buttonGOa, this.con);
        this.con.gridx = 0;
        this.con.gridy = 3;
        this.con.gridwidth = 1;
        this.radioButHost = new JRadioButton(Util.getString("DISK_FILTER_HOST_LABEL"));
        this.radioButHost.addMouseListener(this.mouseListener);
        GuiUtil.setAccessible(this.radioButHost, this.radioButHost.getText(), this.radioButHost.getText());
        this.filterpanel.add((Component)this.radioButHost, this.con);
        this.group.add(this.radioButHost);
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 1;
        this.cbhost = new JComboBox();
        this.cbhost.setEnabled(false);
        GuiUtil.setAccessible(this.cbhost, this.radioButHost.getText(), this.radioButHost.getText());
        this.cbhost.setMinimumSize(new Dimension(this.width, this.height));
        this.cbhost.setPreferredSize(new Dimension(this.width, this.height));
        this.cbhost.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.filterpanel.add((Component)this.cbhost, this.con);
        this.hostplistavailable = false;
        this.con.gridx = 2;
        this.con.gridy = 3;
        this.con.gridwidth = 1;
        this.buttonGOh = new JButton(Util.getString("DISK_GO_BUTTON"));
        this.buttonGOh.addActionListener(this);
        this.buttonGOh.setEnabled(false);
        GuiUtil.setAccessible(this.buttonGOh, this.buttonGOh.getText(), this.buttonGOh.getText());
        this.filterpanel.add((Component)this.buttonGOh, this.con);
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(String.valueOf(Util.getString("DISK_VOLUMES_LABEL")) + " " + "(" + this.theVolDDI.subsystem.getName() + "):"));
        this.theVolDDI.getVolumes(this.filtername, this.filtermode);
        this.add((Component)this.mainpanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.filterpanel, "West");
        this.mainpanel.add((Component)jPanel2, "North");
        this.mainpanel.add((Component)this.tablePanel, "Center");
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        Object object = null;
        String string = null;
        object = actionEvent.getSource();
        string = actionEvent.getActionCommand();
        if (actionEvent == null) {
            return;
        }
        if (object == null) {
            return;
        }
        if (object == this.buttondelete) {
            this.doDelete();
        } else if (object == this.buttoncreate) {
            this.openCreateWizard(this.theVolDDI.subsystem);
        } else if (object == this.buttonHPA) {
            this.openWizardHPA(this.theVolDDI.subsystem);
        } else if (object == this.buttonGOa) {
            int n = this.cbvolume.getSelectedIndex();
            String string2 = n == 0 ? this.noselect : this.arrpool[n - 1].getName();
            if (string2 == this.noselect) {
                this.filtermode = 3;
                this.filtername = "NONE";
            } else {
                this.filtername = this.arrpool[n - 1].getId();
                this.filtermode = 1;
            }
            this.theVolDDI.getVolumes(this.filtername, this.filtermode);
        } else if (object == this.buttonGOh) {
            String string3;
            int n = this.cbhost.getSelectedIndex();
            if (n == 0) {
                string3 = this.noselect;
            } else {
                string3 = (String)this.cbhost.getItemAt(n);
                int n2 = string3.indexOf(this.strHPnameBr);
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
            }
            if (string3 == this.noselect) {
                this.filtermode = 3;
                this.filtername = "NONE";
            } else {
                this.filtername = string3;
                this.filtermode = 2;
            }
            this.theVolDDI.getVolumes(this.filtername, this.filtermode);
        } else if (string == ACTION_VIEW_DETAILS && (nArray = this.table.getSelectedRows()).length > 0) {
            this.theVolDDI.showDetails(nArray[0]);
        }
    }

    public void doDelete() {
        int n = this.table.getNumRows();
        if (n != 0) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length > 0) {
                this.vol = this.theVolDDI.getRowDataAt(nArray[0]);
                if (!this.theVolDDI.subsystem.isVolumeDeletionSupported()) {
                    String string = Util.getString("DMSG_DISK_VOLUME_BELONGS_ESS2105", this.vol.getDeviceId());
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, Util.getString("DISK_DELETE_LABEL"), 0);
                } else {
                    this.theVolDDI.diskAccessor.getPortAssignments(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                            if (s <= 4) {
                                HashMap hashMap = (HashMap)response.responseData;
                                if (!hashMap.isEmpty()) {
                                    String[] stringArray = new String[]{VolumeListPanel.this.vol.getDeviceId()};
                                    String string = Util.getString("DMSG_DISK_VOLUME_EXISTING_ASSIGNMENTS", stringArray);
                                    JOptionPane.showMessageDialog(VolumeListPanel.this.guiMain.getFrame(), string, Util.getString("DISK_DELETE_LABEL"), 0);
                                } else {
                                    String[] stringArray = new String[]{VolumeListPanel.this.vol.getDeviceId()};
                                    int n = JOptionPane.showConfirmDialog(VolumeListPanel.this.guiMain.getFrame(), Util.getString("DISK_REALLY_DELETE_LABEL", stringArray), Util.getString("DISK_DELETE_LABEL"), 1);
                                    switch (n) {
                                        case 1: {
                                            break;
                                        }
                                        case 2: {
                                            break;
                                        }
                                        case 0: {
                                            DiskDataController.getInstance().deleteVolumes(new GuiRequestor(this){
                                                final /* synthetic */ 5 this$1;
                                                {
                                                    this.this$1 = var1_1;
                                                }

                                                public void handleResponse(short s, Response response) {
                                                    GuiUtil.triggerJobChange((short)107);
                                                    if (s <= 4) {
                                                        AsyncResult[] asyncResultArray;
                                                        AsyncResult asyncResult;
                                                        int n = (Integer)response.responseData;
                                                        Response response2 = GuiDeviceJob.getJobStatus(n, true);
                                                        GuiUtil.triggerJobChange((short)107);
                                                        if (response2 != null && (asyncResult = (AsyncResult)response2.responseData) != null && (asyncResultArray = asyncResult.getSubJobResults()) != null && asyncResultArray.length == 1) {
                                                            Exception exception = asyncResultArray[0].getReturnException();
                                                            if (exception != null) {
                                                                String string = exception.getMessage();
                                                                if (exception instanceof SRMRuntimeException) {
                                                                    string = ((SRMRuntimeException)exception).getLocalizedMessage();
                                                                }
                                                                if (string != null) {
                                                                    JOptionPane.showMessageDialog(VolumeListPanel.access$19(5.access$0(this.this$1)).getFrame(), string, Util.getString("DISK_DELETE_LABEL"), 0);
                                                                }
                                                            }
                                                            VolumeID[] cfr_ignored_0 = (VolumeID[])asyncResultArray[0].getResults();
                                                            5.access$0(this.this$1).theVolDDI.getVolumes(VolumeListPanel.access$20(5.access$0(this.this$1)), VolumeListPanel.access$21(5.access$0(this.this$1)));
                                                        }
                                                    }
                                                }
                                            }, new String[]{VolumeListPanel.this.vol.getId()});
                                        }
                                    }
                                }
                            }
                        }

                        static /* synthetic */ VolumeListPanel access$0(5 var0) {
                            return var0.VolumeListPanel.this;
                        }
                    }, this.theVolDDI.subsystem.getId(), this.vol.getId());
                }
            }
        } else {
            String string = Util.getString("DMSG_DISK_NO_RESOURCE");
            JOptionPane.showMessageDialog(this, string, Util.getString("DISK_DELETE_LABEL"), 0);
        }
    }

    public void openCreateWizard(GUIStorageSubsystem gUIStorageSubsystem) {
        this.crvol = new CreateVolumeWizard(gUIStorageSubsystem);
        this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_CREATE_VOLUMES_WIZARD_LABEL", gUIStorageSubsystem.getDeviceId()), true);
        this.wizardDialog.getContentPane().add(this.crvol);
        this.wizardDialog.setResizable(false);
        this.wizardDialog.pack();
        GuiUtil.centerDialog(this.wizardDialog);
        this.wizardDialog.setDefaultCloseOperation(0);
        this.wizardDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                VolumeListPanel.this.crvol.cancel();
            }
        });
        this.wizardDialog.show();
    }

    public void openWizardHPA(GUIStorageSubsystem gUIStorageSubsystem) {
        int n = this.table.getNumRows();
        if (n != 0) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length > 0) {
                this.vol = this.theVolDDI.getRowDataAt(nArray[0]);
                this.HPAwiz = new PortAssignmentWizard(gUIStorageSubsystem, this.vol);
                this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_HPA_WIZARD_LABEL", gUIStorageSubsystem.getDeviceId()), true);
                this.wizardDialog.getContentPane().add(this.HPAwiz);
                this.wizardDialog.setResizable(false);
                this.wizardDialog.pack();
                GuiUtil.centerDialog(this.wizardDialog);
                this.wizardDialog.setDefaultCloseOperation(0);
                this.wizardDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        VolumeListPanel.this.HPAwiz.cancel();
                    }
                });
                this.wizardDialog.show();
            }
        } else {
            String string = Util.getString("DMSG_DISK_NO_RESOURCE");
            JOptionPane.showMessageDialog(this, string, Util.getString("DISK_HPA_WIZARD_LABEL"), 0);
        }
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (n < 0 || n2 < 0) {
            return;
        }
        int n5 = this.table.getPointedRow(n4);
        this.table.setSelectedRows(n5, n5);
        this.selectionChanged(true);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(Util.getString("DISK_VIEW_DETAILS_LABEL"));
        jMenuItem.setActionCommand(ACTION_VIEW_DETAILS);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(true);
        jPopupMenu.show(component, n3, n4);
        jPopupMenu.requestFocus();
    }

    public void selectionChanged(boolean bl) {
        if (this.capabilities.isDiskAdmin() && this.theVolDDI.subsystem.isVolumeCreationSupported() && this.theVolDDI.subsystem.getCapabilityData() != null && this.theVolDDI.subsystem.isDetectable()) {
            this.buttoncreate.setEnabled(true);
        } else {
            this.buttoncreate.setEnabled(false);
        }
        if (this.table.getSelectedRows().length <= 0) {
            this.buttondelete.setEnabled(false);
            this.buttonHPA.setEnabled(false);
            return;
        }
        if (this.theVolDDI.getRowCount() != 0) {
            if (this.capabilities.isDiskAdmin() && this.theVolDDI.subsystem.isVolumeDeletionSupported() && this.theVolDDI.subsystem.getCapabilityData() != null && this.theVolDDI.subsystem.isDetectable()) {
                this.buttondelete.setEnabled(true);
            } else {
                this.buttondelete.setEnabled(false);
            }
            if (this.capabilities.isDiskAdmin() && this.theVolDDI.subsystem.isPortAssignmentSupported() && this.theVolDDI.subsystem.getCapabilityData() != null && this.theVolDDI.subsystem.isDetectable()) {
                this.buttonHPA.setEnabled(true);
            } else {
                this.buttonHPA.setEnabled(false);
            }
        } else {
            this.buttondelete.setEnabled(false);
            this.buttonHPA.setEnabled(false);
        }
    }

    public void doubleClick(int n, int n2) {
        this.dblClick = true;
        this.theVolDDI.showDetails(n);
    }

    public void showDefaultChart(int n) {
    }

    public void buildtable() {
        Class<?> clazz;
        this.table = new DiskGuiTable();
        this.tableModel = new VolumeTableModel(this.theVolDDI);
        this.table.setMouseListener(this);
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.setSelectionPolicy(0);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        try {
            clazz = Class.forName("java.lang.Double");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz, capacityRenderer);
        this.table.updateUI();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        if (this.table == this.bottomHalf) {
            return;
        }
        if (this.bottomHalf != null) {
            this.tablePanel.remove(this.bottomHalf);
        }
        this.bottomHalf = this.table;
        this.tablePanel.add((Component)this.table, gridBagConstraints);
        if (this.theVolDDI.panel != null) {
            this.theVolDDI.show();
        }
    }

    static /* synthetic */ void access$7(VolumeListPanel volumeListPanel, HashMap hashMap) {
        volumeListPanel.hmapHostPortofSS = hashMap;
    }

    static /* synthetic */ HashMap access$8(VolumeListPanel volumeListPanel) {
        return volumeListPanel.hmapHostPortofSS;
    }

    static /* synthetic */ String access$10(VolumeListPanel volumeListPanel) {
        return volumeListPanel.strHPnameBr;
    }

    static /* synthetic */ String access$11(VolumeListPanel volumeListPanel) {
        return volumeListPanel.endHPnameBr;
    }

    static /* synthetic */ String access$20(VolumeListPanel volumeListPanel) {
        return volumeListPanel.filtername;
    }

    static /* synthetic */ int access$21(VolumeListPanel volumeListPanel) {
        return volumeListPanel.filtermode;
    }
}

