/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.IconFactory;

public class FabricGuiUtil {
    public static String FHELP_ZC_FABRICS = "bta_dlg_zonecontrol_fabricstab";
    public static String FHELP_ZC_ZONING = "bta_dlg_zonecontrol_zoningtab";
    public static String FHELP_ZC_DEFINITION = "bta_dlg_zonecontrol_definitiontab";
    public static String FHELP_ZC_ZWIZ1 = "bta_dlg_zonecontrol_createzonewiz1";
    public static String FHELP_ZC_ZWIZ2 = "bta_dlg_zonecontrol_createzonewiz2";
    public static String FHELP_ZC_ZWIZ3 = "bta_dlg_zonecontrol_createzonewiz3";
    public static String FHELP_ZC_ZSWIZ1 = "bta_dlg_zonecontrol_createzonesetwiz1";
    public static String FHELP_ZC_ZSWIZ2 = "bta_dlg_zonecontrol_createzonesetwiz2";
    public static String FHELP_AGENT_INBAND = "adm_dlg_agents_inband";
    public static String FHELP_AGENT_OUTBAND = "adm_dlg_agents_outband";
    public static String FHELP_AGENT_OUTBAND_ADD = "adm_dlg_agents_addoutband";
    public static String FHELP_AGENT_OUTBAND_OPTIONS = "adm_dlg_dsc_outbandoptions";
    public static String FHELP_REPORTS_PORTCONN = "tpc_dlg_systemreports_fabric_portconnections";
    public static String FHELP_REPORTS_SANASSETS = "tpc_dlg_systemreports_fabric_san_assets";
    public static String FHELP_ALERTLOG_TAPE = "tpc_dlg_alerting_alertlog_tapelibs";
    public static String FHELP_ALERTLOG_SWITCH = "tpc_dlg_alerting_alertlog_switch";
    public static String FHELP_ALERTLOG_FABRIC = "tpc_dlg_alerting_alertlog_fabricgroups";
    public static String FHELP_ALERTLOG_ENDPOINT = "tpc_dlg_alerting_alertlog_endpoints";
    public static String FHELP_ALERT_FABRIC = "bta_dlg_alerting_fabricalerts";
    public static String FHELP_ALERT_SELECT = "bta_dlg_alerting_selectionlisttab";
    public static String FHELP_ALERT_SWITCH = "bta_dlg_alerting_switchalerts";
    public static String FHELP_ALERT_ENDPOINT = "bta_dlg_alerting_endpointalerts";
    public static String FHELP_GROUPS_FABRIC = "bta_dlg_fabric_monitoring_creategroup";
    public static String FHELP_JOBS_FABRIC = "bta_ovw_fabric_monitoring";
    private static ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.xmsg.FabricGuiResources", Locale.getDefault());
    public static final int DISPLAY_ICON_BRIDGE = 100;
    public static final int DISPLAY_ICON_DISK = 101;
    public static final int DISPLAY_ICON_ESS = 102;
    public static final int DISPLAY_ICON_NAS = 103;
    public static final int DISPLAY_ICON_SERVER = 104;
    public static final int DISPLAY_ICON_SUBSYSTEM = 105;
    public static final int DISPLAY_ICON_SVC = 106;
    public static final int DISPLAY_ICON_SWITCH = 107;
    public static final int DISPLAY_ICON_TAPE = 108;
    public static final int DISPLAY_ICON_UNKNOWN = 109;

    public static String getString(String string) {
        String string2 = null;
        try {
            string2 = FabricGuiUtil.cleanStrings(rb.getString(string));
        }
        catch (Exception exception) {
            string2 = String.valueOf(string) + " Unavailable";
            System.out.println("FabricGUI_utils::getResourceString() -- " + string + " not found in resource bundle.");
        }
        return string2;
    }

    public static String cleanStrings(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\f\r\t");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = String.valueOf(string2) + " " + stringTokenizer.nextToken();
            }
            return string2;
        }
        return string;
    }

    public static Object getStatusString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = FabricGuiUtil.getString("FabricStatusNormal");
                break;
            }
            case 1: {
                string = FabricGuiUtil.getString("FabricStatusWarning");
                break;
            }
            case 2: {
                string = FabricGuiUtil.getString("FabricStatusCritical");
                break;
            }
            case 99: {
                string = "";
                break;
            }
            default: {
                string = FabricGuiUtil.getString("FabricStatusUnknown");
            }
        }
        return string;
    }

    public static JLabel getConsolidatedStateLabel(int n) {
        String string = "";
        ImageIcon imageIcon = null;
        switch (n) {
            case 0: {
                string = FabricGuiUtil.getString("FabricStatusNormal");
                imageIcon = IconFactory.getStateUpIcon();
                break;
            }
            case 1: {
                string = FabricGuiUtil.getString("FabricStatusWarning");
                imageIcon = IconFactory.getStateWarningIcon();
                break;
            }
            case 2: {
                string = FabricGuiUtil.getString("FabricStatusMissing");
                imageIcon = IconFactory.getStateFailedIcon();
                break;
            }
            default: {
                string = FabricGuiUtil.getString("FabricStatusUnknown");
                imageIcon = IconFactory.getStateUreachableIcon();
            }
        }
        if (imageIcon != null) {
            imageIcon.setDescription(string);
        }
        return new JLabel(string, imageIcon, 10);
    }

    public static JLabel getDetectableStateLabel(int n) {
        String string = "";
        ImageIcon imageIcon = null;
        switch (n) {
            case 0: {
                string = FabricGuiUtil.getString("FabricStatusMissing");
                imageIcon = IconFactory.getStateFailedIcon();
                break;
            }
            case 1: {
                string = FabricGuiUtil.getString("FabricStatusNormal");
                imageIcon = IconFactory.getStateUpIcon();
                break;
            }
            default: {
                string = FabricGuiUtil.getString("FabricStatusUnknown");
                imageIcon = IconFactory.getStateUreachableIcon();
            }
        }
        if (imageIcon != null) {
            imageIcon.setDescription(string);
        }
        return new JLabel(string, imageIcon, 10);
    }

    public static JLabel getZoningEnabledLabel(int n) {
        String string = "";
        ImageIcon imageIcon = null;
        switch (n) {
            case 0: {
                string = FabricGuiUtil.getString("FabricLabel_No");
                imageIcon = IconFactory.getStateDownIcon();
                break;
            }
            case 1: {
                string = FabricGuiUtil.getString("FabricLabel_Yes");
                imageIcon = IconFactory.getStateUpIcon();
                break;
            }
            default: {
                string = FabricGuiUtil.getString("FabricLabel_No");
                imageIcon = IconFactory.getStateDownIcon();
            }
        }
        if (imageIcon != null) {
            imageIcon.setDescription(string);
        }
        return new JLabel(string, imageIcon, 10);
    }

    public static String getDetectableStatusString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = FabricGuiUtil.getString("FabricStatusMissing");
                break;
            }
            case 1: {
                string = FabricGuiUtil.getString("FabricStatusNormal");
                break;
            }
            default: {
                string = FabricGuiUtil.getString("FabricStatusUnknown");
            }
        }
        return string;
    }

    public static boolean isSwitchPort(String string) {
        return string.equalsIgnoreCase("12") || string.equalsIgnoreCase("15") || string.equalsIgnoreCase("16") || string.equalsIgnoreCase("14") || string.equalsIgnoreCase("17") || string.equalsIgnoreCase("18") || string.equalsIgnoreCase("18001") || string.equalsIgnoreCase("17001") || string.equalsIgnoreCase("6") || string.equalsIgnoreCase("17002") || string.equalsIgnoreCase("17016") || string.equalsIgnoreCase("18006") || string.equalsIgnoreCase("18007");
    }

    public static boolean isSwitchPort(int n) {
        return n == 12 || n == 15 || n == 16 || n == 14 || n == 17 || n == 18 || n == 18001 || n == 17001 || n == 6 || n == 17002 || n == 17016 || n == 18006 || n == 18007;
    }

    public static String getPortTypeString(int n) {
        String string;
        if (FabricGuiUtil.isSwitchPort(n)) {
            string = FabricGuiUtil.getString("FabricDetails_switch");
        } else {
            switch (n) {
                case 100: {
                    string = FabricGuiUtil.getString("FabricDetails_IconBridge");
                    break;
                }
                case 101: {
                    string = FabricGuiUtil.getString("FabricDetails_IconDisk");
                    break;
                }
                case 102: {
                    string = FabricGuiUtil.getString("FabricDetails_IconESS");
                    break;
                }
                case 103: {
                    string = FabricGuiUtil.getString("FabricDetails_IconNAS");
                    break;
                }
                case 104: {
                    string = FabricGuiUtil.getString("FabricDetails_IconServer");
                    break;
                }
                case 105: {
                    string = FabricGuiUtil.getString("FabricDetails_IconSubsystem");
                    break;
                }
                case 106: {
                    string = FabricGuiUtil.getString("FabricDetails_IconSVC");
                    break;
                }
                case 107: {
                    string = FabricGuiUtil.getString("FabricDetails_IconSwitch");
                    break;
                }
                case 108: {
                    string = FabricGuiUtil.getString("FabricDetails_IconTape");
                    break;
                }
                case 109: {
                    string = FabricGuiUtil.getString("FabricDetails_IconUnknown");
                    break;
                }
                case 99: {
                    string = "";
                    break;
                }
                default: {
                    string = FabricGuiUtil.getString("FabricDetails_IconUnknown");
                }
            }
        }
        return string;
    }

    public static String getNodeTypeString(int n) {
        switch (n) {
            case 1: {
                return FabricGuiUtil.getString("FabricDetails_Unknown");
            }
            case 2: {
                return FabricGuiUtil.getString("FabricDetails_other");
            }
            case 3: {
                return FabricGuiUtil.getString("FabricDetails_bridge");
            }
            case 4: {
                return FabricGuiUtil.getString("FabricDetails_Converter");
            }
            case 5: {
                return FabricGuiUtil.getString("FabricDetails_hub");
            }
            case 6: {
                return FabricGuiUtil.getString("FabricDetails_HBA");
            }
            case 7: {
                return FabricGuiUtil.getString("FabricDetails_switch");
            }
            case 8: {
                return FabricGuiUtil.getString("FabricDetails_StorageDevice");
            }
            case 9: {
                return FabricGuiUtil.getString("FabricDetails_host");
            }
            case 10: {
                return FabricGuiUtil.getString("FabricDetails_StorageSubsystem");
            }
            case 11: {
                return FabricGuiUtil.getString("FabricDetails_Module");
            }
            case 12: {
                return FabricGuiUtil.getString("FabricDetails_StorageDriver");
            }
            case 13: {
                return FabricGuiUtil.getString("FabricDetails_StorageAccessDevice");
            }
            case 14: {
                return FabricGuiUtil.getString("FabricDetails_SoftwareProxyAgent");
            }
            case 15: {
                return FabricGuiUtil.getString("FabricDetails_Reserved");
            }
            case 16: {
                return FabricGuiUtil.getString("FabricDetails_Shark");
            }
            case 17: {
                return FabricGuiUtil.getString("FabricDetails_Lodestone");
            }
            case 18: {
                return FabricGuiUtil.getString("FabricDetails_DS6000");
            }
            case 19: {
                return FabricGuiUtil.getString("FabricDetails_DS8000");
            }
            case 100: {
                return FabricGuiUtil.getString("FabricDetails_IconBridge");
            }
            case 101: {
                return FabricGuiUtil.getString("FabricDetails_IconDisk");
            }
            case 102: {
                return FabricGuiUtil.getString("FabricDetails_IconESS");
            }
            case 103: {
                return FabricGuiUtil.getString("FabricDetails_IconNAS");
            }
            case 104: {
                return FabricGuiUtil.getString("FabricDetails_IconServer");
            }
            case 105: {
                return FabricGuiUtil.getString("FabricDetails_IconSubsystem");
            }
            case 106: {
                return FabricGuiUtil.getString("FabricDetails_IconSVC");
            }
            case 107: {
                return FabricGuiUtil.getString("FabricDetails_IconSwitch");
            }
            case 108: {
                return FabricGuiUtil.getString("FabricDetails_IconTape");
            }
            case 109: {
                return FabricGuiUtil.getString("FabricDetails_IconUnknown");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getNodeTypeString(String string) {
        int n = Integer.parseInt(string);
        switch (n) {
            case 1: {
                return FabricGuiUtil.getString("FabricDetails_Unknown");
            }
            case 2: {
                return FabricGuiUtil.getString("FabricDetails_other");
            }
            case 3: {
                return FabricGuiUtil.getString("FabricDetails_bridge");
            }
            case 4: {
                return FabricGuiUtil.getString("FabricDetails_Converter");
            }
            case 5: {
                return FabricGuiUtil.getString("FabricDetails_hub");
            }
            case 6: {
                return FabricGuiUtil.getString("FabricDetails_HBA");
            }
            case 7: {
                return FabricGuiUtil.getString("FabricDetails_switch");
            }
            case 8: {
                return FabricGuiUtil.getString("FabricDetails_StorageDevice");
            }
            case 9: {
                return FabricGuiUtil.getString("FabricDetails_host");
            }
            case 10: {
                return FabricGuiUtil.getString("FabricDetails_StorageSubsystem");
            }
            case 11: {
                return FabricGuiUtil.getString("FabricDetails_Module");
            }
            case 12: {
                return FabricGuiUtil.getString("FabricDetails_StorageDriver");
            }
            case 13: {
                return FabricGuiUtil.getString("FabricDetails_StorageAccessDevice");
            }
            case 14: {
                return FabricGuiUtil.getString("FabricDetails_SoftwareProxyAgent");
            }
            case 15: {
                return FabricGuiUtil.getString("FabricDetails_Reserved");
            }
            case 16: {
                return FabricGuiUtil.getString("FabricDetails_Shark");
            }
            case 17: {
                return FabricGuiUtil.getString("FabricDetails_Lodestone");
            }
            case 18: {
                return FabricGuiUtil.getString("FabricDetails_DS6000");
            }
            case 19: {
                return FabricGuiUtil.getString("FabricDetails_DS8000");
            }
            case 100: {
                return FabricGuiUtil.getString("FabricDetails_IconBridge");
            }
            case 101: {
                return FabricGuiUtil.getString("FabricDetails_IconDisk");
            }
            case 102: {
                return FabricGuiUtil.getString("FabricDetails_IconESS");
            }
            case 103: {
                return FabricGuiUtil.getString("FabricDetails_IconNAS");
            }
            case 104: {
                return FabricGuiUtil.getString("FabricDetails_IconServer");
            }
            case 105: {
                return FabricGuiUtil.getString("FabricDetails_IconSubsystem");
            }
            case 106: {
                return FabricGuiUtil.getString("FabricDetails_IconSVC");
            }
            case 107: {
                return FabricGuiUtil.getString("FabricDetails_IconSwitch");
            }
            case 108: {
                return FabricGuiUtil.getString("FabricDetails_IconTape");
            }
            case 109: {
                return FabricGuiUtil.getString("FabricDetails_IconUnknown");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getPeTypeString(int n) {
        if (n <= 30 || n >= 100) {
            return FabricGuiUtil.getNodeTypeString(n);
        }
        switch (n) {
            case 31: {
                return FabricGuiUtil.getString("FabricDetails_disk");
            }
            case 32: {
                return FabricGuiUtil.getString("FabricDetails_tape");
            }
            case 33: {
                return FabricGuiUtil.getString("FabricDetails_printer");
            }
            case 34: {
                return FabricGuiUtil.getString("FabricDetails_ExternalController");
            }
            case 35: {
                return FabricGuiUtil.getString("FabricDetails_Worm");
            }
            case 36: {
                return FabricGuiUtil.getString("FabricDetails_CdRom");
            }
            case 37: {
                return FabricGuiUtil.getString("FabricDetails_PeripheralScanner");
            }
            case 38: {
                return FabricGuiUtil.getString("FabricDetails_OpticalDisk");
            }
            case 39: {
                return FabricGuiUtil.getString("FabricDetails_MediaChangers");
            }
            case 40: {
                return FabricGuiUtil.getString("FabricDetails_OtherPeripheral");
            }
            case 41: {
                return FabricGuiUtil.getString("FabricDetails_SmartEnclosure");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getPeTypeString(String string) {
        int n = Integer.parseInt(string);
        if (n <= 30 || n >= 100) {
            return FabricGuiUtil.getNodeTypeString(string);
        }
        switch (n) {
            case 31: {
                return FabricGuiUtil.getString("FabricDetails_disk");
            }
            case 32: {
                return FabricGuiUtil.getString("FabricDetails_tape");
            }
            case 33: {
                return FabricGuiUtil.getString("FabricDetails_printer");
            }
            case 34: {
                return FabricGuiUtil.getString("FabricDetails_ExternalController");
            }
            case 35: {
                return FabricGuiUtil.getString("FabricDetails_Worm");
            }
            case 36: {
                return FabricGuiUtil.getString("FabricDetails_CdRom");
            }
            case 37: {
                return FabricGuiUtil.getString("FabricDetails_PeripheralScanner");
            }
            case 38: {
                return FabricGuiUtil.getString("FabricDetails_OpticalDisk");
            }
            case 39: {
                return FabricGuiUtil.getString("FabricDetails_MediaChangers");
            }
            case 40: {
                return FabricGuiUtil.getString("FabricDetails_OtherPeripheral");
            }
            case 41: {
                return FabricGuiUtil.getString("FabricDetails_SmartEnclosure");
            }
        }
        return Util.getString("FabricDetails_Unknown");
    }

    public static String getInbandFabricAgentStatusString(int n) {
        switch (n) {
            case 1: {
                return FabricGuiUtil.getString("FabricAgent_Active");
            }
            case 0: {
                return FabricGuiUtil.getString("FabricAgent_Inactive");
            }
        }
        return FabricGuiUtil.getString("FabricAgent_Unknown");
    }

    public static String getIconTypeString(int n) {
        String string;
        if (FabricGuiUtil.isSwitchPort(n)) {
            string = Util.getString("TOPO_LABEL_ENTITY_SWITCH");
        } else {
            switch (n) {
                case 100: {
                    string = FabricGuiUtil.getString("FabricDetails_bridge");
                    break;
                }
                case 101: {
                    string = Util.getString("TOPO_LABEL_ENTITY_DISK");
                    break;
                }
                case 103: {
                    string = FabricGuiUtil.getString("FabricDetails_IconNAS");
                    break;
                }
                case 104: {
                    string = Util.getString("TOPO_LABEL_ENTITY_COMPUTER");
                    break;
                }
                case 105: {
                    string = Util.getString("TOPO_LABEL_ENTITY_SUBSYSTEM");
                    break;
                }
                case 107: {
                    string = Util.getString("TOPO_LABEL_ENTITY_SWITCH");
                    break;
                }
                case 108: {
                    string = Util.getString("TOPO_LABEL_ENTITY_TAPELIBRARY");
                    break;
                }
                case 109: {
                    string = Util.getString("TOPO_LABEL_ENTITY_OTHER");
                    break;
                }
                default: {
                    string = Util.getString("TOPO_LABEL_ENTITY_OTHER");
                }
            }
        }
        return string;
    }
}

