/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.library;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.tape.common.TapeConstants;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.TapeDataAccessor;
import org.eclipse.aperi.gui.tape.frames.FramesDDI;
import org.eclipse.aperi.gui.tape.library.LibraryDetailsPanel;
import org.eclipse.aperi.gui.tape.library.LibraryListPanel;
import org.eclipse.aperi.gui.tape.library.LibraryPanel;
import org.eclipse.aperi.request.Response;

public class LibraryDDI
extends DataDisplayInfo
implements ActionListener {
    public LibraryPanel mainPanel;
    GUILibrary oLibrary;
    private boolean closing;
    private boolean initialized;
    private Vector library = new Vector();
    private int libraryInternalId = -1;
    private GUILibrary singleLibrary = null;
    private Vector changedDetailsPanels = new Vector();
    private HashMap hmapAllss;
    private HashMap hmapForDetails;
    TapeDataAccessor tapeAccessor = TapeDataAccessor.getInstance();
    TapeDataAccessor tapeDetailAccessor = TapeDataAccessor.getInstance();

    public LibraryDDI() {
        this.setDescription(Util.getString("TAPE_LIBRARIES_LABEL"));
        this.displayInScrollPane = true;
    }

    public LibraryDDI(int n) {
        this.libraryInternalId = n;
        this.setDescription(Util.getString("TAPE_DETAILS_LABEL"));
        this.displayInScrollPane = true;
    }

    public String getHelpID() {
        Component component = this.mainPanel.tabs.getSelectedComponent();
        if (component instanceof LibraryListPanel) {
            return TapeConstants.TAPE_LIBRARY_HELP;
        }
        if (component instanceof LibraryDetailsPanel) {
            return TapeConstants.TAPE_LIBRARY_DETAILS_HELP;
        }
        return "welcome_gettingstarted";
    }

    public Vector getLibrary() {
        return this.library;
    }

    public GUILibrary getSingleLibrary() {
        return this.singleLibrary;
    }

    public int getLibraryInternalId() {
        return this.libraryInternalId;
    }

    public void reDisplay() {
        if (this.panel == null || this.library.isEmpty()) {
            this.getData();
        } else {
            this.show();
            guiMain.setSaveActionEnabled(false, false);
        }
        guiMain.addSaveActionListener(this);
    }

    public void getData() {
        this.library.removeAllElements();
        this.singleLibrary = null;
        this.tapeAccessor.getAllTapeLibraries(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    LibraryDDI.this.hmapAllss = (HashMap)response.responseData;
                    LibraryDDI.this.library = new Vector(LibraryDDI.this.hmapAllss.values());
                    if (LibraryDDI.this.libraryInternalId != -1) {
                        Iterator iterator = LibraryDDI.this.library.iterator();
                        while (iterator.hasNext()) {
                            GUILibrary gUILibrary = (GUILibrary)iterator.next();
                            if (gUILibrary.getInternalId() != LibraryDDI.this.libraryInternalId) continue;
                            LibraryDDI.this.singleLibrary = gUILibrary;
                            break;
                        }
                    }
                    if (LibraryDDI.this.mainPanel == null) {
                        LibraryDDI.this.mainPanel = new LibraryPanel(LibraryDDI.this);
                    } else {
                        LibraryDDI.this.mainPanel.refreshPanel();
                    }
                    LibraryDDI.this.panel = LibraryDDI.this.mainPanel.getComponent();
                    LibraryDDI.this.show();
                }
            }
        });
    }

    void showDetails(int n) {
        GUILibrary gUILibrary = (GUILibrary)this.library.elementAt(n);
        FramesDDI framesDDI = new FramesDDI(gUILibrary);
        if (this.mainPanel == null) {
            this.mainPanel = new LibraryPanel(this);
        }
        framesDDI.reDisplayDetail(this.mainPanel);
    }

    public void panelToBeNulled() {
        this.mainPanel = null;
    }

    public void gettingFocus() {
        this.changesPending();
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        this.changedDetailsPanels.removeAllElements();
        if (this.mainPanel == null) {
            return false;
        }
        Iterator iterator = this.mainPanel.getAllTabs().iterator();
        while (iterator.hasNext()) {
            LibraryDetailsPanel libraryDetailsPanel = (LibraryDetailsPanel)iterator.next();
            if (!libraryDetailsPanel.hasChanged()) continue;
            this.changedDetailsPanels.addElement(libraryDetailsPanel);
        }
        return !this.changedDetailsPanels.isEmpty();
    }

    public void saveAndClose() {
        Iterator iterator = this.changedDetailsPanels.iterator();
        while (iterator.hasNext()) {
            LibraryDetailsPanel libraryDetailsPanel = (LibraryDetailsPanel)iterator.next();
            libraryDetailsPanel.saveAll(false);
        }
        this.remove();
    }
}

