/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.border.CompoundBorder;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroupTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoNode;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoContainerWithTitle
extends AbstractJTopoNode {
    protected TitlePanel titlePanel;
    protected ContainerPanel containerPanel;

    protected AbstractJTopoContainerWithTitle() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoContainerWithTitle(ITopoNodeModel iTopoNodeModel, boolean bl) {
        super(iTopoNodeModel, bl);
        iTopoNodeModel = (ITopoNodeModel)this.widgetModel;
        this.titlePanel = new TitlePanel(iTopoNodeModel);
        this.containerPanel = this.createContainerPanel(iTopoNodeModel);
        this.initState();
    }

    private void initState() {
        this.titlePanel.setLogicalParent(this);
        this.containerPanel.setLogicalParent(this);
        this.add(this.titlePanel);
        this.add(this.containerPanel);
    }

    public void resetState() {
        super.resetState();
        this.titlePanel.resetState();
        this.containerPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas abstractJTopoCanvas, String string) {
        super.setSessionModel(abstractJTopoCanvas, string);
        this.titlePanel.setSessionModel(abstractJTopoCanvas, string);
        this.containerPanel.setSessionModel(abstractJTopoCanvas, string);
    }

    public void setDataModel(GraphEntity graphEntity) {
        super.setDataModel(graphEntity);
        this.titlePanel.setDataModel(graphEntity);
        this.containerPanel.setDataModel(graphEntity);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public ContainerPanel getContainerPanel() {
        return this.containerPanel;
    }

    public void modelChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.modelChanged();
        this.containerPanel.modelChanged();
    }

    public void selectionChanged() {
        this.titlePanel.selectionChanged();
        this.containerPanel.selectionChanged();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.highlightChanged();
        this.containerPanel.highlightChanged();
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        CompoundBorder compoundBorder = null;
        compoundBorder = iTopoEntityModel.isHighlighted() ? TopoResource.BORDER_CONTAINERHIGHLIGHTED : TopoResource.BORDER_CONTAINERUNHIGHLIGHTED;
        this.setBorder(compoundBorder);
    }

    protected Point getConnectingPoint() {
        Point point = this.titlePanel.getConnectingPoint();
        Point point2 = new Point(this.getX() + point.x, this.getY() + point.y);
        return point2;
    }

    public Vector getEntities() {
        return this.containerPanel.getEntities();
    }

    public boolean isContainEntity(AbstractJTopoEntity abstractJTopoEntity) {
        return this.containerPanel.isContainEntity(abstractJTopoEntity);
    }

    public void addEntity(AbstractJTopoEntity abstractJTopoEntity) {
        this.containerPanel.addEntity(abstractJTopoEntity);
    }

    public void removeEntity(AbstractJTopoEntity abstractJTopoEntity) {
        this.containerPanel.removeEntity(abstractJTopoEntity);
    }

    public void removeAllEntities() {
        this.containerPanel.removeAllEntities();
    }

    public void setOverlayHealthEnabled(boolean bl) {
        this.titlePanel.setOverlayHealthEnabled(bl);
        this.containerPanel.setOverlayHealthEnabled(bl);
    }

    public void setOverlayPerfEnabled(boolean bl) {
        this.titlePanel.setOverlayPerfEnabled(bl);
        this.containerPanel.setOverlayPerfEnabled(bl);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
        this.titlePanel.setArrange(arrangeRecord);
        this.containerPanel.setArrange(arrangeRecord);
    }

    protected ContainerPanel createContainerPanel(ITopoUnitModel iTopoUnitModel) {
        return new ContainerPanel(iTopoUnitModel);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class TitlePanel
    extends AbstractJTopoGroupTitle {
        public TitlePanel(ITopoNodeModel iTopoNodeModel) {
            super(iTopoNodeModel, false);
        }

        protected void reattach() {
        }
    }

    protected class ContainerPanel
    extends AbstractJTopoContainer {
        public ContainerPanel(ITopoUnitModel iTopoUnitModel) {
            super(iTopoUnitModel, false);
        }

        protected void reattach() {
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            int n = 0;
            int n2 = 0;
            Dimension dimension2 = AbstractJTopoContainerWithTitle.this.titlePanel.getPreferredSize();
            n2 += dimension2.height;
            dimension2 = AbstractJTopoContainerWithTitle.this.containerPanel.getPreferredSize();
            n = dimension2.width > (n += dimension2.width) ? dimension2.width : n;
            dimension.width += n;
            dimension.height += (n2 += dimension2.height);
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            Dimension dimension = AbstractJTopoContainerWithTitle.this.titlePanel.getPreferredSize();
            Rectangle rectangle = new Rectangle();
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = container.getWidth() - insets.left - insets.right;
            rectangle.height = dimension.height;
            AbstractJTopoContainerWithTitle.this.titlePanel.setBounds(rectangle);
            dimension = AbstractJTopoContainerWithTitle.this.containerPanel.getPreferredSize();
            rectangle = new Rectangle();
            rectangle.x = n;
            rectangle.y = n2 += AbstractJTopoContainerWithTitle.this.titlePanel.getHeight();
            rectangle.width = AbstractJTopoContainerWithTitle.this.titlePanel.getWidth();
            rectangle.height = dimension.height;
            AbstractJTopoContainerWithTitle.this.containerPanel.setBounds(rectangle);
        }
    }
}

