/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoTitle
extends AbstractJTopoIcon {
    protected static final int TITLE_HEIGHT = 22;
    protected static final int GAP5 = 5;

    protected AbstractJTopoTitle() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoTitle(ITopoNodeModel iTopoNodeModel, boolean bl) {
        super(iTopoNodeModel, bl);
        this.initState();
    }

    private void initState() {
        this.labelMode = 1;
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected void modelChanged_setSelection() {
        super.modelChanged_setSelection();
        ITopoNodeModel iTopoNodeModel = (ITopoNodeModel)this.widgetModel;
        Color color = null;
        color = iTopoNodeModel.isSelected() ? TopoResource.COLOR_SELECTED : TopoResource.COLOR_UNSELECTED;
        this.setBackground(color);
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        this.handleMouseClick_regular(mouseEvent);
    }

    protected void layoutItself() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.focusEntity == null) {
            return;
        }
        graphics.setFont(TopoResource.FONT_PLAIN);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.strLabel != null) {
            n = fontMetrics.stringWidth(this.strLabel);
            n2 = fontMetrics.getHeight();
            n3 = fontMetrics.getAscent();
        }
        Insets insets = this.getInsets();
        int n4 = insets.left + insets.right;
        int n5 = insets.top + insets.bottom;
        n4 += 10;
        if (this.iconHealth != null) {
            n4 += this.iconHealth.getIconWidth() + 3;
        }
        if (this.iconPerf != null) {
            n4 += this.iconPerf.getIconWidth() + 3;
        }
        n4 += 6;
        n4 += this.iconType.getIconWidth() + 3;
        n4 = this.labelMode == 0 ? (n4 += this.maxLabelWidth_compact) : (this.labelMode == 1 ? (n4 += n < this.maxLabelWidth_relax ? n : this.maxLabelWidth_relax) : (n4 += n));
        if (this.iconPin != null) {
            n4 += 3 + this.iconPin.getIconWidth();
        }
        this.preferredSizeD = new Dimension(n4, n5 += 22);
        n4 = this.getWidth();
        n5 = this.getHeight();
        if (n4 != 0 && n5 != 0) {
            int n6;
            int n7 = insets.left + 5;
            int n8 = insets.top;
            int n9 = n4 - insets.left - insets.right - 10;
            if (this.iconHealth != null) {
                n9 -= this.iconHealth.getIconWidth() + 3;
            }
            if (this.iconPerf != null) {
                n9 -= this.iconPerf.getIconWidth() + 3;
            }
            n9 -= 6;
            n9 -= this.iconType.getIconWidth() + 3;
            if (this.iconPin != null) {
                n9 -= 3 + this.iconPin.getIconWidth();
            }
            int n10 = n9;
            n7 += (n9 -= n) > 0 ? n9 / 2 : 0;
            if (this.iconHealth != null) {
                n6 = (n5 - insets.top - insets.bottom - this.iconHealth.getIconHeight()) / 2;
                n6 = n6 > 0 ? n6 : 0;
                this.iconHealthR.setBounds(n7, n8 + n6, this.iconHealth.getIconWidth(), this.iconHealth.getIconHeight());
                n7 += this.iconHealth.getIconWidth() + 3;
            } else {
                this.iconHealthR.setBounds(0, 0, 0, 0);
            }
            if (this.iconPerf != null) {
                n6 = (n5 - insets.top - insets.bottom - this.iconPerf.getIconHeight()) / 2;
                n6 = n6 > 0 ? n6 : 0;
                this.iconPerfR.setBounds(n7, n8 + n6, this.iconPerf.getIconWidth(), this.iconPerf.getIconHeight());
                n7 += this.iconPerf.getIconWidth() + 3;
            } else {
                this.iconPerfR.setBounds(0, 0, 0, 0);
            }
            n6 = (n5 - insets.top - insets.bottom - this.iconType.getIconHeight()) / 2;
            n6 = n6 > 0 ? n6 : 0;
            this.iconTypeR.setBounds(n7 += 3, n8 + n6, this.iconType.getIconWidth(), this.iconType.getIconHeight());
            n7 += this.iconType.getIconWidth() + 3;
            if (this.strLabel != null) {
                n6 = (n5 - insets.top - insets.bottom - n2) / 2;
                n6 = n6 > 0 ? n6 : 0;
                int n11 = n9 > 0 ? n : n10;
                this.strLabelP.setLocation(n7, n8 + n6 + n3);
                this.strLabelR.setBounds(n7, n8 + n6, n11, n2);
                n7 += n11 + 3;
                if (n9 < 0) {
                    this.clippedStrLabel = "";
                    int n12 = 0;
                    while (n12 < this.strLabel.length()) {
                        String string = String.valueOf(this.strLabel.substring(0, n12)) + "...";
                        int n13 = fontMetrics.stringWidth(string);
                        if (n13 <= n10) {
                            this.clippedStrLabel = string;
                            ++n12;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.clippedStrLabel = this.strLabel;
                }
            } else {
                this.strLabelR.setBounds(0, 0, 0, 0);
            }
            n7 += 3;
            if (this.iconPin != null) {
                n6 = (n5 - insets.top - insets.bottom - this.iconPin.getIconHeight()) / 2;
                n6 = n6 > 0 ? n6 : 0;
                this.iconPinR.setBounds(n7, n8 + n6, this.iconPin.getIconWidth(), this.iconPin.getIconHeight());
            } else {
                this.iconPinR.setBounds(0, 0, 0, 0);
            }
        }
    }
}

