/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Database;

public class DBConnPoolDataSource
implements ConnectionPoolDataSource {
    private static Pool pool = null;
    private static DBConnPoolDataSource ds = null;
    private static boolean initialized = false;
    private static int nextLeasedCountLevel = 25;

    private DBConnPoolDataSource() {
    }

    public static synchronized void initialize(String string, String string2, String string3, String string4, String string5, int n) {
        AutoIdentifier.initialize();
        pool = new Pool(string, string2, string3, string4, string5, n);
        if (!initialized) {
            initialized = true;
        } else {
            Exception exception = new Exception("Multiple invocations of DBConnPoolDataSource.initialize() detected");
            DBConnection.debugPrintException(exception);
        }
    }

    public static synchronized void initialize(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        AutoIdentifier.initialize();
        pool = new Pool(string, string2, string3, string4, string5, string6, n);
        if (!initialized) {
            initialized = true;
        } else {
            Exception exception = new Exception("Multiple invocations of DBConnPoolDataSource.initialize() detected");
            DBConnection.debugPrintException(exception);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static synchronized DBConnPoolDataSource getInstance() {
        if (ds == null) {
            ds = new DBConnPoolDataSource();
        }
        return ds;
    }

    public static synchronized void closeInstance() throws SQLException {
        pool.shutdown();
        AutoIdentifier.shutdown();
        ds = null;
        pool = null;
    }

    public static void returnConnection(DBConnection dBConnection) throws SQLException {
        pool.add(dBConnection);
    }

    public static int connectionCount() {
        return pool.getConnectionCount();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        DBConnection dBConnection = null;
        if (ds == null || pool == null) {
            throw new SQLException("No connection pool exists");
        }
        try {
            dBConnection = pool.remove();
            dBConnection.clear();
            dBConnection.setAutoCommit(false);
            if (dBConnection.getTransactionIsolation() != DBConnPoolDataSource.pool.level) {
                dBConnection.setTransactionIsolation(DBConnPoolDataSource.pool.level);
            }
        }
        catch (SQLException sQLException) {
            DBConnection.debugPrintException(sQLException);
            pool.printLeasedConnections();
            throw sQLException;
        }
        return dBConnection;
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        throw new SQLException("The method getPooledConnection(user, password) is not implemented");
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    public void setLoginTimeout(int n) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public static void printLeasedConnections() {
        pool.printLeasedConnections();
    }

    public static void printLeasedConnections(PrintWriter printWriter) {
        pool.printLeasedConnections(printWriter);
    }

    public static synchronized void printLeasedConnectionsWithStatements(PrintWriter printWriter) {
        pool.printLeasedConnectionsWithStatements(printWriter);
    }

    private static class Pool {
        private int maxConn;
        private Database db;
        private LinkedList queue = new LinkedList();
        private Hashtable leasedConnH = new Hashtable();
        public int connectionCount = 0;
        private String schema;
        public int level = 2;

        public Pool(String string, String string2, String string3, String string4, String string5, int n) {
            this.maxConn = n;
            this.db = new Database(string2, string4, string5);
            this.db.setDriver(string);
            this.schema = string3;
        }

        public Pool(String string, String string2, String string3, String string4, String string5, String string6, int n) {
            this.maxConn = n;
            this.db = new Database(string3, string5, string6);
            Database.setDriverJar(string);
            this.db.setDriver(string2);
            this.schema = string4;
        }

        public synchronized void shutdown() throws SQLException {
            SQLException sQLException = null;
            Enumeration enumeration = this.leasedConnH.keys();
            while (enumeration.hasMoreElements()) {
                DBConnection dBConnection = (DBConnection)enumeration.nextElement();
                try {
                    dBConnection.commit();
                    dBConnection.closeReal();
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                }
            }
            int n = this.queue.size();
            int n2 = 0;
            while (n2 < n) {
                DBConnection dBConnection = (DBConnection)this.queue.removeFirst();
                try {
                    dBConnection.closeReal();
                }
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                }
                ++n2;
            }
            this.connectionCount = 0;
            if (sQLException != null) {
                throw sQLException;
            }
        }

        public synchronized void add(DBConnection dBConnection) throws SQLException {
            Object v = this.leasedConnH.remove(dBConnection);
            if (v != null) {
                if (this.queue.size() < this.maxConn) {
                    this.queue.addLast(dBConnection);
                } else {
                    dBConnection.closeReal();
                }
                --this.connectionCount;
            } else {
                DBConnection.debugPrintException(new Exception("Connection is being closed multiple times"));
                throw new SQLException("Connection is being closed multiple times");
            }
        }

        public synchronized DBConnection remove() throws SQLException {
            DBConnection dBConnection = null;
            boolean bl = true;
            do {
                if (this.queue.size() == 0) {
                    dBConnection = this.db.getConnection();
                    dBConnection.setSchema(this.schema);
                    this.level = dBConnection.getTransactionIsolation();
                } else {
                    dBConnection = (DBConnection)((DBConnection)this.queue.removeLast()).clone();
                }
                try {
                    CurrentTime.initialize(dBConnection);
                    bl = true;
                }
                catch (SQLException sQLException) {
                    DBConnection.debugPrintExceptions("Stale connection encountered =  " + dBConnection.getConnection().toString(), null);
                    bl = false;
                }
            } while (!bl);
            if (dBConnection != null) {
                ++this.connectionCount;
                this.leasedConnH.put(dBConnection, new Exception("Leased " + dBConnection));
            }
            return dBConnection;
        }

        public synchronized int getConnectionCount() {
            return this.connectionCount;
        }

        public synchronized int getLeasedConnectionCount() {
            return this.leasedConnH.size();
        }

        public synchronized void printLeasedConnections() {
            DBConnection.checkTraceFileSize();
            DBConnection.debugPrintExceptions("Leased connection count is " + this.getLeasedConnectionCount(), this.leasedConnH.elements());
        }

        public synchronized void printLeasedConnections(PrintWriter printWriter) {
            DBConnection.checkTraceFileSize();
            DBConnection.debugPrintExceptions(printWriter, "Leased connection count is " + this.getLeasedConnectionCount(), this.leasedConnH.elements());
        }

        public synchronized void printLeasedConnectionsWithStatements(PrintWriter printWriter) {
            DBConnection.debugPrintln(printWriter, "Leased connection count is " + this.getLeasedConnectionCount());
            Enumeration enumeration = this.leasedConnH.keys();
            while (enumeration.hasMoreElements()) {
                DBConnection dBConnection = (DBConnection)enumeration.nextElement();
                DBConnection.debugPrintException(printWriter, (Exception)this.leasedConnH.get(dBConnection));
                dBConnection.printActiveTransaction(printWriter);
                dBConnection.printOpenStatements(printWriter);
            }
        }
    }
}

