/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_TapeLibraryToDBMapper
extends DBAttributeMapper {
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sELEMENTNAME = "elementname";
    public static final String sPRIMARYOWNERNAME = "primaryownername";
    public static final String sPRIMARYOWNERCONTACT = "primaryownercontact";
    public static final String sDETECTABLE = "detectable";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sCONSOLIDATEDSTATUS = "consolidatedstatus";
    public static final String sPROPAGATEDSTATUS = "propagatedstatus";
    public static final String sDESCRIPTION = "description";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sACCESSINFO = "accessinfo";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_ComputerSystem";
        String string2 = "1.1.0";
        String string3 = null;
        String string4 = null;
        String string5 = Dedicated.getValue(Dedicated.MEDIA_LIBRARY);
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4, string5);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMIS11CIM_TapeLibraryToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion(sNAMEFORMAT, "SMISName_Format");
        ColumnInfo columnInfo = TapeLibrary.getColumnInfo("NAME_FORMAT");
        columnInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(sNAMEFORMAT, new MapperInfo(columnInfo));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(TapeLibrary.getColumnInfo("ELEMENT_NAME")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(TapeLibrary.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sDESCRIPTION, new MapperInfo(TapeLibrary.getColumnInfo("DESCRIPTION")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(TapeLibrary.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sPRIMARYOWNERNAME, new MapperInfo(TapeLibrary.getColumnInfo("PRIMARY_OWNER_NAME")));
        this.m_htAttribToMapperInfo.put(sPRIMARYOWNERCONTACT, new MapperInfo(TapeLibrary.getColumnInfo("PRIMARY_OWNER_CONTACT")));
        this.m_htAttribToMapperInfo.put(sDETECTABLE, new MapperInfo(TapeLibrary.getColumnInfo("DETECTABLE")));
        this.m_htAttribToMapperInfo.put(sCONSOLIDATEDSTATUS, new MapperInfo(TapeLibrary.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sPROPAGATEDSTATUS, new MapperInfo(TapeLibrary.getColumnInfo("PROPAGATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(TapeLibrary.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sACCESSINFO, new MapperInfo(TapeLibrary.getColumnInfo("ACCESS_INFO")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")));
        ColumnInfo columnInfo2 = TapeLibrary.getColumnInfo("NAME");
        columnInfo2.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo2);
        ColumnInfo columnInfo3 = TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID");
        columnInfo3.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo3);
        this.m_htAttribToMapperInfo.put(sNAME, mapperInfo);
    }

    public String toString() {
        return this.getClass().toString();
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string2 = (String)hashtable.get(sOPERATIONALSTATUS);
        if (string2 != null) {
            object = SMIS11CIM_TapeLibraryToDBMapper.processArrayvalues(string2);
            if ((string2 = DBConstants.convertOperationalstatusArrayToBitValue((Vector)object)) != null) {
                hashtable.put(sOPERATIONALSTATUS, string2);
            } else {
                hashtable.remove(sOPERATIONALSTATUS);
            }
            string2 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object);
            if (string2 != null) {
                hashtable.put("CONSOLIDATED_STATUS".toLowerCase(), string2);
            }
        }
        if ((hashtable.get(sDISPLAYNAME) == null || ((String)hashtable.get(sDISPLAYNAME)).length() == 0) && (object = (String)hashtable.get(sNAME)) != null) {
            hashtable.put(sDISPLAYNAME, object);
        }
        if (hashtable.get(sACCESSINFO) != null && ((String)hashtable.get(sACCESSINFO)).length() > 0 && !((String)hashtable.get(sACCESSINFO)).toLowerCase().startsWith("http")) {
            object = "http://" + (String)hashtable.get(sACCESSINFO);
            hashtable.put(sACCESSINFO, object);
        }
        if ((object = (String)hashtable.get(sNAMEFORMAT)) != null) {
            hashtable.put("nameformat2", object);
        }
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        Hashtable hashtable2 = mapperResult.getAllRows();
        String string3 = (String)((Hashtable)hashtable2.get("T_RES_TAPE_LIBRARY")).get(TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"));
        hashtable.put("libraryid", string3);
        SMISCimkeyTapeLibraryToDBMapper sMISCimkeyTapeLibraryToDBMapper = new SMISCimkeyTapeLibraryToDBMapper();
        MapperResult mapperResult2 = sMISCimkeyTapeLibraryToDBMapper.persist(dBConnection, hashtable, string);
        MapperResult mapperResult3 = mapperResult.addMapperResult(mapperResult2);
        mapperResult3.addKeyReference("ref_toplevelsystem_id", TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"));
        mapperResult3.addKeyReference("ref_toplevelsystem_name", TapeLibrary.getColumnInfo("NAME"));
        mapperResult3.addKeyReference("ref_toplevelsystem_nameformat", TapeLibrary.getColumnInfo("NAME_FORMAT"));
        mapperResult3.addKeyReference("ref_tape_library_id", TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"));
        try {
            mapperResult3.addKeyReference("ref_toplevelsystem_cimom2namespaceid", CimkeyTapeLibrary.getColumnInfo("CIM_NAMESPACE_ID"));
        }
        catch (Exception exception) {
            this.logInfo(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Library Mapper called w/o cimom2namespace creation - Firmware mapping!");
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult3);
        return mapperResult3;
    }

    private class SMISCimkeyTapeLibraryToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeyTapeLibraryToDBMapper() {
            ColumnInfo columnInfo = CimkeyTapeLibrary.getColumnInfo("NAME");
            columnInfo.setIsPrimaryKey();
            MapperInfo mapperInfo = new MapperInfo(columnInfo);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeLibraryToDBMapper.sNAME, mapperInfo);
            ColumnInfo columnInfo2 = CimkeyTapeLibrary.getColumnInfo("TAPE_LIBRARY_ID");
            columnInfo2.setIsPrimaryKey();
            MapperInfo mapperInfo2 = new MapperInfo(columnInfo2);
            ColumnInfo columnInfo3 = CimkeyTapeLibrary.getColumnInfo("CIMKEY_TAPE_LIBRARY_ID");
            columnInfo3.setAutoGenerated();
            mapperInfo2.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put("libraryid", mapperInfo2);
            this.m_dataConverter.addSimpleDataConversion("nameformat2", "SMISName_Format");
            this.m_htAttribToMapperInfo.put("nameformat2", new MapperInfo(CimkeyTapeLibrary.getColumnInfo("NAME_FORMAT")));
            ColumnInfo columnInfo4 = CimkeyTapeLibrary.getColumnInfo("CIM_NAMESPACE_ID");
            columnInfo4.setIsPrimaryKey();
            MapperInfo mapperInfo3 = new MapperInfo(columnInfo4);
            mapperInfo3.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", mapperInfo3);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeLibraryToDBMapper.sCREATIONCLASSNAME, new MapperInfo(CimkeyTapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")));
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
            new Hashtable();
            String string2 = (String)hashtable.get("ref_serviceurl");
            if (string2 != null) {
                RegisteredCimom registeredCimom = new RegisteredCimom();
                registeredCimom.setServiceUrl(string2);
                boolean bl = registeredCimom.retrieve(dBConnection);
                if (bl) {
                    int n = registeredCimom.getRegCimomId();
                    string2 = (String)hashtable.get("ref_namespace");
                    if (string2 != null) {
                        Cimom2namespace cimom2namespace = new Cimom2namespace();
                        cimom2namespace.setCimomId(n);
                        cimom2namespace.setNamespace(string2);
                        bl = cimom2namespace.retrieve(dBConnection);
                        if (bl) {
                            hashtable.put("cimnamespaceid", new String(String.valueOf(cimom2namespace.getCimNamespaceId())));
                            MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
                            return mapperResult;
                        }
                    }
                }
            }
            MapperResult mapperResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
            return mapperResult;
        }
    }
}

