/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_PhysicalPackageToDBMapper;

public class SMISIBMTSESS_PhysicalPackageToDBMapper
extends SMISCIM_PhysicalPackageToDBMapper {
    public static final String sDAPAIR = "dapair";
    public static final String sLOCATION = "location";
    public static final String sDISKGROUPNUMBER = "diskgroupnumber";
    public static final String sRANKID = "rankid";
    public static final String sLOOP = "loop";
    public static final String sTag = "tag";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "IBMTSESS_PhysicalPackage";
        String string2 = "1.0.2";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.0.3";
        DBAttributeMapper.RegistrationData registrationData2 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData, registrationData2};
    }

    public SMISIBMTSESS_PhysicalPackageToDBMapper() {
        this.m_htAttribToMapperInfo.put("otheridentifyinginfo", new MapperInfo(DiskGroup.getColumnInfo("RAID_LEVEL")));
        this.m_htAttribToMapperInfo.put("name_array", new MapperInfo(DiskGroup.getColumnInfo("ARRAY")));
        this.m_htAttribToMapperInfo.put("ddmcap", new MapperInfo(DiskGroup.getColumnInfo("DDM_CAP")));
        this.m_htAttribToMapperInfo.put("ddmspeed", new MapperInfo(DiskGroup.getColumnInfo("DDM_SPEED")));
        this.m_htAttribToMapperInfo.put(sDAPAIR, new MapperInfo(DiskGroup.getColumnInfo("DA_PAIR_ID")));
        this.m_htAttribToMapperInfo.put(sDISKGROUPNUMBER, new MapperInfo(DiskGroup.getColumnInfo("DISK_GROUP_NUMBER")));
        this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(DiskGroup.getColumnInfo("STORAGE_EXTENT_ID")));
        this.m_htAttribToMapperInfo.put("ref_numofdatadisks", new MapperInfo(DiskGroup.getColumnInfo("WIDTH")));
        this.m_htAttribToMapperInfo.put("numofdatadisks", new MapperInfo(DiskGroup.getColumnInfo("WIDTH")));
        this.m_htAttribToMapperInfo.put("DEVICE_ADAPTER1".toLowerCase(), new MapperInfo(DiskGroup.getColumnInfo("DEVICE_ADAPTER1")));
        this.m_htAttribToMapperInfo.put("DEVICE_ADAPTER2".toLowerCase(), new MapperInfo(DiskGroup.getColumnInfo("DEVICE_ADAPTER2")));
        this.m_htAttribToMapperInfo.put(sLOOP, new MapperInfo(DiskGroup.getColumnInfo("LOOP")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2;
        String string3;
        Object object2;
        String string4;
        String string5;
        String string6;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string7 = (String)hashtable.get(sLOCATION);
        if (string7 != null) {
            try {
                string6 = string7.substring(string7.indexOf("Adapter Pair") + 13, string7.indexOf(",")).trim();
                string5 = string7.substring(string7.indexOf("(loop)") + 6).trim();
                string4 = string5.substring(0, string5.indexOf(",")).trim();
                if (string6 != null && string6.length() > 0) {
                    hashtable.put(sDAPAIR, string6);
                }
                if (string4 != null && string4.length() > 0) {
                    hashtable.put(sLOOP, string4);
                }
            }
            catch (Exception exception) {
                this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not extract disk group name or dapair from location");
            }
        }
        string6 = (String)hashtable.get(sDISKGROUPNUMBER);
        string5 = (String)hashtable.get("ref_toplevelsystem_name");
        if (string6 == null && string5 != null) {
            if (string5.startsWith("2107") || string5.startsWith("1750")) {
                string4 = (String)hashtable.get(sTag);
                if (string4 != null) {
                    object2 = string4.substring(string4.indexOf("-") + 1, string4.length());
                    hashtable.put(sDISKGROUPNUMBER, object2);
                } else {
                    this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not set DISKGROUPNUMBER - tag is empty!");
                }
            } else if (string5.startsWith("2105")) {
                string4 = (String)hashtable.get(sTag);
                if (string4 != null) {
                    object2 = string4.substring(string4.indexOf("dg") + 2, string4.length());
                    hashtable.put(sDISKGROUPNUMBER, object2);
                } else {
                    this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not set DISKGROUPNUMBER - tag is empty!");
                }
            } else {
                this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not set DISKGROUPNUMBER - unknown ESS/DS Model");
            }
        }
        if ((string4 = (String)hashtable.get("deviceadapters")) != null && (object2 = SMISIBMTSESS_PhysicalPackageToDBMapper.processArrayvalues(string4)) != null && ((Vector)object2).size() > 0) {
            string3 = (String)((Vector)object2).elementAt(0);
            if (string3 != null && string3.length() > 0) {
                hashtable.put("DEVICE_ADAPTER1".toLowerCase(), string3);
            }
            if (((Vector)object2).size() > 1 && (string2 = (String)((Vector)object2).elementAt(1)) != null && string2.length() > 0) {
                hashtable.put("DEVICE_ADAPTER2".toLowerCase(), string2);
            }
        }
        if ((object2 = (String)hashtable.get("name")) != null) {
            hashtable.put("name_array", object2);
        }
        string3 = (String)hashtable.get(sRANKID);
        string2 = (String)hashtable.get("ref_storageextent_id");
        String string8 = (String)hashtable.get("ref_toplevelsystem_id");
        if (string3 != null && string3.startsWith("rank") && string2 != null && string8 != null) {
            object = new Hashtable();
            Vector<String> vector = new Vector<String>();
            vector.add("DEVICE_ID");
            ((Hashtable)object).put(TResStorageExtentTable.getColumnInfo("STORAGE_EXTENT_ID"), string2);
            DBResultSet dBResultSet = DBQueryAssistant.performRetrieve(TResStorageExtentTable.getTablename(), dBConnection, (Hashtable)object, vector);
            if (dBResultSet.next()) {
                StorageExtent storageExtent = new StorageExtent();
                storageExtent.setDeviceId(dBResultSet.getString("DEVICE_ID"));
                storageExtent.setSubsystemId(Integer.parseInt(string8));
                storageExtent.setRankId(string3);
                storageExtent.update(dBConnection);
                dBResultSet.closeAll();
            }
        }
        object = super.persist(dBConnection, hashtable, string);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", object);
        return object;
    }

    public static void main(String[] stringArray) {
        String string = "Adapter Pair 1, Port (loop) X, and Disk Group 2";
        String string2 = string.substring(string.indexOf("(loop)") + 6, string.length()).trim();
        String string3 = string2.substring(0, string2.indexOf(",")).trim();
        System.out.println(string3);
        String string4 = "2105.3434545-dg76";
        String string5 = string4.substring(string4.indexOf("dg") + 2, string4.length());
        System.out.println(string5);
    }
}

